/*
 * Decompiled with CFR 0.152.
 */
package management.test.cli;

import hydra.Log;

public class VerifyDescribeMemberOutput {
    final String LIT_NAME = "Name        :";
    final String LIT_ID = "Id          :";
    final String LIT_HOST = "Host        :";
    final String LIT_PID = "PID         :";
    final String LIT_GROUP = "Groups      :";
    final String LIT_USED_HEAP = "Used Heap   :";
    final String LIT_MAX_HEAP = "Max Heap    :";
    final String LIT_WORKING_DIR = "Working Dir :";
    final String LIT_LOG_FILE = "Log file    :";
    final String LIT_LOCATORS = "Locators    :";
    private String memberInfo;
    private String outputText;
    private String expHostName;
    private String expMemberName;
    private String expPID;
    private String expThing1;
    private String expThing2;
    private String expID;

    protected VerifyDescribeMemberOutput(String memberInfo, String outputText) {
        Log.getLogWriter().info("VerifyDescribeMemberOutput: memberInfo=" + memberInfo);
        Log.getLogWriter().info("VerifyDescribeMemberOutput: outputText=" + outputText);
        String trimmedMemberInfo = memberInfo.substring("GemFire:type=Member,member=".length());
        Log.getLogWriter().info("VerifyDescribeMemberOutput: trimmedMemberInfo=" + trimmedMemberInfo);
        this.memberInfo = trimmedMemberInfo;
        this.outputText = outputText;
        this.parseMemberInfo();
    }

    private void parseMemberInfo() {
        Log.getLogWriter().info("parseMemberInfo: memberInfo=" + this.memberInfo);
        int expStart = 0;
        int expEnd = this.memberInfo.indexOf("(", expStart);
        this.expHostName = this.memberInfo.substring(expStart, expEnd) + ".gemstone.com";
        Log.getLogWriter().info("parseMemberInfo: expHostName=|" + this.expHostName + "|");
        expStart = expEnd + 1;
        String temp = this.memberInfo.substring(expStart, this.memberInfo.indexOf(")", expStart));
        Log.getLogWriter().info("parseMemberInfo: temp=|" + temp + "|");
        expEnd = temp.lastIndexOf("-");
        this.expMemberName = temp.substring(0, expEnd);
        Log.getLogWriter().info("parseMemberInfo: expMemberName=|" + this.expMemberName + "|");
        expStart = this.memberInfo.indexOf(this.expMemberName) + this.expMemberName.length() + 1;
        expEnd = this.memberInfo.indexOf(")", expStart);
        this.expPID = this.memberInfo.substring(expStart, expEnd);
        Log.getLogWriter().info("parseMemberInfo: expPID=|" + this.expPID + "|");
        expStart = this.memberInfo.indexOf("<", expEnd);
        expEnd = this.memberInfo.indexOf(">", expStart) + 1;
        this.expThing1 = this.memberInfo.substring(expStart, expEnd);
        Log.getLogWriter().info("parseMemberInfo: expThing1=|" + this.expThing1 + "|");
        expStart = this.memberInfo.indexOf("-", expEnd) + 1;
        this.expThing2 = this.memberInfo.substring(expStart);
        Log.getLogWriter().info("parseMemberInfo: expThing2=|" + this.expThing2 + "|");
        this.expID = new StringBuffer(this.expHostName).append("(").append(this.expMemberName).append(":").append(this.expPID).append(")").append(this.expThing1).append(":").append(this.expThing2).toString();
        Log.getLogWriter().info("parseMemberInfo: expID=|" + this.expID + "|");
    }

    protected boolean validate() throws StringIndexOutOfBoundsException {
        Log.getLogWriter().info("validate: memberInfo=" + this.memberInfo);
        Log.getLogWriter().info("validate: outputText=" + this.outputText);
        boolean validHost = this.validateHost();
        Log.getLogWriter().info("validate: validHost=" + validHost);
        boolean validName = this.validateName();
        Log.getLogWriter().info("validate: validName=" + validName);
        return validHost && validName;
    }

    private boolean validateHost() {
        int start = this.outputText.indexOf("Host        :") + 1;
        Log.getLogWriter().info("validateHost: start=" + start);
        int end = this.outputText.indexOf("\n", start);
        Log.getLogWriter().info("validateHost: end=" + end);
        String actHost = this.outputText.substring(start + "Host        :".length(), end);
        Log.getLogWriter().info("validateHost: actHost=|" + actHost + "|");
        return this.expHostName.equals(actHost);
    }

    private boolean validateName() {
        int start = this.outputText.indexOf("Name        :") + 1;
        Log.getLogWriter().info("validateName: start=" + start);
        int end = this.outputText.indexOf("\n", start);
        Log.getLogWriter().info("validateName: end=" + end);
        String actName = this.outputText.substring(start + "Name        :".length(), end);
        Log.getLogWriter().info("validateName: actName=|" + actName + "|");
        return this.expMemberName.equals(actName);
    }
}

