/*
 * Decompiled with CFR 0.152.
 */
package management.test.cli;

import hydra.Log;
import java.util.Arrays;
import management.test.cli.ResultValidator;
import org.springframework.util.StringUtils;

public class ResultValidatorHelper {
    public static ResultValidator shouldNotHaveValidator(final String arg) {
        return new ResultValidator(){

            @Override
            public ResultValidator.Status validate(String output) {
                Log.getLogWriter().fine("Validating command output for not having :" + arg);
                if (output.indexOf(arg) > 0) {
                    return ResultValidator.Status.ERROR;
                }
                return ResultValidator.Status.SUCCESS;
            }

            @Override
            public String getMessage() {
                return "Command output should not have any occurance of " + arg;
            }
        };
    }

    public static ResultValidator noOfTimesOccuranceValidator(final int occurance, final String arg) {
        return new ResultValidator(){
            int count = 0;

            @Override
            public ResultValidator.Status validate(String output) {
                Log.getLogWriter().info("Validating command output for having :" + arg + " " + occurance + " times...");
                this.count = StringUtils.countOccurrencesOf((String)output, (String)arg);
                if (this.count != occurance) {
                    return ResultValidator.Status.ERROR;
                }
                return ResultValidator.Status.SUCCESS;
            }

            @Override
            public String getMessage() {
                return "We were expecting " + occurance + " occurance of " + arg + " in command output but we got it " + this.count + " times.";
            }
        };
    }

    public static ResultValidator onlyOneOccuranceValidator(final String ... args) {
        return new ResultValidator(){
            private String failedString;
            int count = 0;

            @Override
            public ResultValidator.Status validate(String output) {
                Log.getLogWriter().info("Validating command output for having :" + Arrays.toString(args) + " only once...");
                for (String arg : args) {
                    this.count = StringUtils.countOccurrencesOf((String)output, (String)arg);
                    if (this.count == 1) continue;
                    this.failedString = arg;
                    return ResultValidator.Status.ERROR;
                }
                return ResultValidator.Status.SUCCESS;
            }

            @Override
            public String getMessage() {
                return "We were expecting " + this.failedString + " to occur only once and we got it " + this.count + " times.";
            }
        };
    }

    public static ResultValidator noOfLinesValidatorForTabularOutut(int expectedNoOfLines) {
        return ResultValidatorHelper.noOfLinesValidator(expectedNoOfLines, 2);
    }

    public static ResultValidator noOfLinesValidator(int expectedNoOfLines) {
        return ResultValidatorHelper.noOfLinesValidator(expectedNoOfLines, 0);
    }

    public static ResultValidator noOfLinesValidator(final int expectedNoOfLines, final int ignoreLineCount) {
        return new ResultValidator(){
            int count = 0;

            @Override
            public ResultValidator.Status validate(String output) {
                Log.getLogWriter().info("Validating command output for " + expectedNoOfLines + " no of lines..");
                String[] lines = output.split("\n");
                this.count = lines.length - ignoreLineCount;
                if (this.count != expectedNoOfLines) {
                    return ResultValidator.Status.ERROR;
                }
                return ResultValidator.Status.SUCCESS;
            }

            @Override
            public String getMessage() {
                return "We were expecting " + expectedNoOfLines + " lines but we got " + this.count + ".";
            }
        };
    }

    public static ResultValidator verifyLine(final char separator, final String ... args) {
        return new ResultValidator(){

            @Override
            public ResultValidator.Status validate(String output) {
                Log.getLogWriter().fine("Validating command output for line :" + Arrays.toString(args) + "...");
                StringBuilder sb = new StringBuilder();
                for (String arg : args) {
                    sb.append(arg).append(separator);
                }
                sb.deleteCharAt(sb.length() - 1);
                String toMatchString = sb.toString();
                toMatchString = toMatchString.replaceAll("( )+", "");
                output = output.replaceAll("( )+", "");
                Log.getLogWriter().info(output);
                Log.getLogWriter().info(toMatchString);
                int index = output.indexOf(toMatchString);
                if (index < 0) {
                    return ResultValidator.Status.ERROR;
                }
                return ResultValidator.Status.SUCCESS;
            }

            @Override
            public String getMessage() {
                return "We were expecting " + Arrays.toString(args) + " but we did not get anything of that sort in the command output.";
            }
        };
    }

    public static ResultValidator verifyLineForDescribe(String ... args) {
        return ResultValidatorHelper.verifyLine(':', args);
    }

    public static ResultValidator verifyLineForTabularData(String ... args) {
        return ResultValidatorHelper.verifyLine('|', args);
    }

    public static ResultValidator shouldNotHaveValidatorWithIgnoreCase(final String ... args) {
        return new ResultValidator(){
            private String failedString;

            @Override
            public ResultValidator.Status validate(String output) {
                output = output.toLowerCase();
                Log.getLogWriter().fine("Validating command output for not having :" + Arrays.toString(args));
                for (String arg : args) {
                    if (output.indexOf(arg.toLowerCase()) <= 0) continue;
                    this.failedString = arg;
                    return ResultValidator.Status.ERROR;
                }
                return ResultValidator.Status.SUCCESS;
            }

            @Override
            public String getMessage() {
                return "Command output should not have any occurance of " + this.failedString + ".";
            }
        };
    }
}

