/*
 * Decompiled with CFR 0.152.
 */
package management.operations.ops.jmx;

import java.util.List;
import javax.management.AttributeList;
import javax.management.ObjectName;
import management.operations.ops.JMXOperations;
import management.operations.ops.jmx.AbstractTestMBean;
import management.util.HydraUtil;

public class DistributedRegionTestMBean
extends AbstractTestMBean<DistributedRegionTestMBean> {
    public DistributedRegionTestMBean(List<String> attrs, List<Object[]> ops, String ton, String[] tests) {
        super(attrs, ops, DistributedRegionTestMBean.class, ton, tests);
    }

    @Override
    public String getType() {
        return gemfireDefinedMBeanTypes[10];
    }

    public void checkRegionStatistics(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling checkRegionStatistics");
        String[] attributes = new String[]{"GetsRate", "PutsRate", "CreatesRate", "DestroyRate", "PutAllRate", "PutLocalRate", "PutRemoteRate", "PutRemoteLatency", "PutRemoteAvgLatency", "DiskReadsRate", "DiskWritesRate", "CacheWriterCallsAvgLatency", "CacheListenerCallsAvgLatency", "LruEvictionRate", "LruDestroyRate"};
        String url = ops.selectManagingNode();
        AttributeList attrList = (AttributeList)ops.getAttributes(url, targetMbean, attributes);
        HydraUtil.logInfo("checkRegionStatistics " + HydraUtil.ObjectToString(attrList));
        HydraUtil.logInfo(prefix + " Completed checkRegionStatistics test successfully");
    }

    public void checkRegionRuntimeAttributes(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling checkRegionRuntimeAttributes");
        String[] attributes = new String[]{"MemberCount", "Members", "LastModifiedTime", "LastAccessedTime", "MissCount", "HitCount", "HitRatio", "SystemRegionEntryCount", "TotalEntriesOnlyOnDisk", "TotalDiskEntriesInVM"};
        String url = ops.selectManagingNode();
        AttributeList attrList = (AttributeList)ops.getAttributes(url, targetMbean, attributes);
        HydraUtil.logInfo("checkRegionRuntimeAttributes " + HydraUtil.ObjectToString(attrList));
        HydraUtil.logInfo(prefix + " Completed checkRegionRuntimeAttributes test successfully");
    }

    public void checkRegionConfigAttributes(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling checkRegionConfigAttributes");
        String[] attributes = new String[]{"Name", "RegionType", "FullPath", "ParentRegion"};
        String url = ops.selectManagingNode();
        AttributeList attrList = (AttributeList)ops.getAttributes(url, targetMbean, attributes);
        HydraUtil.logInfo("checkRegionConfigAttributes " + HydraUtil.ObjectToString(attrList));
        HydraUtil.logInfo(prefix + " Completed checkRegionConfigAttributes test successfully");
    }

    @Override
    public void doValidation(JMXOperations ops) {
    }

    static {
        prefix = "DistributedRegionTestMBean : ";
    }
}

