/*
 * Decompiled with CFR 0.152.
 */
package management.operations.ops.jmx;

import java.util.List;
import javax.management.AttributeList;
import javax.management.ObjectName;
import management.operations.ops.JMXOperations;
import management.operations.ops.jmx.AbstractTestMBean;
import management.util.HydraUtil;

public class DiskStoreTestMBean
extends AbstractTestMBean<DiskStoreTestMBean> {
    public DiskStoreTestMBean(List<String> attrs, List<Object[]> ops, String ton, String[] tests) {
        super(attrs, ops, DiskStoreTestMBean.class, ton, tests);
    }

    @Override
    public String getType() {
        return gemfireDefinedMBeanTypes[4];
    }

    public void checkDiskConfig(JMXOperations ops, ObjectName targetMbean) {
        String[] attributes = new String[]{"Name", "CompactionThreshold", "MaxOpLogSize", "TimeInterval", "WriteBufferSize", "DiskDirectories"};
        HydraUtil.logInfo(prefix + " Calling checkDiskConfig");
        String url = ops.selectManagingNode();
        AttributeList attrList = (AttributeList)ops.getAttributes(url, targetMbean, attributes);
        HydraUtil.logInfo("checkDiskConfig " + HydraUtil.ObjectToString(attrList));
    }

    public void checkDiskCounters(JMXOperations ops, ObjectName targetMbean) {
        String[] attributes = new String[]{"QueueSize", "TotalBytesOnDisk", "TotalQueueSize", "TotalBackupInProgress", "TotalRecoveriesInProgress"};
        HydraUtil.logInfo(prefix + " Calling checkDiskCounters");
        String url = ops.selectManagingNode();
        AttributeList attrList = (AttributeList)ops.getAttributes(url, targetMbean, attributes);
        HydraUtil.logInfo("checkDiskCounters " + HydraUtil.ObjectToString(attrList));
    }

    public void checkDiskStatistics(JMXOperations ops, ObjectName targetMbean) {
        String[] attributes = new String[]{"DiskReadsRate", "DiskWritesRate", "DiskReadsAvgLatency", "DiskWritesAvgLatency", "FlushTimeAvgLatency"};
        HydraUtil.logInfo(prefix + " Calling checkDiskStatistics");
        String url = ops.selectManagingNode();
        AttributeList attrList = (AttributeList)ops.getAttributes(url, targetMbean, attributes);
        HydraUtil.logInfo("checkDiskStatistics " + HydraUtil.ObjectToString(attrList));
    }

    public void forceRoll(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling forceRoll");
        String url = ops.selectManagingNode();
        this.callJmxOperation(url, ops, this.buildOperationArray("forceRoll", null, null, null), targetMbean);
        HydraUtil.logInfo(prefix + " Completed forceRoll test successfully");
    }

    public void forceCompaction(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling forceCompaction");
        String url = ops.selectManagingNode();
        this.callJmxOperation(url, ops, this.buildOperationArray("forceCompaction", null, null, null), targetMbean);
        HydraUtil.logInfo(prefix + " Completed forceCompaction test successfully");
    }

    public void flush(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling flush");
        String url = ops.selectManagingNode();
        this.callJmxOperation(url, ops, this.buildOperationArray("flush", null, null, null), targetMbean);
        HydraUtil.logInfo(prefix + " Completed flush test successfully");
    }

    @Override
    public void doValidation(JMXOperations ops) {
        HydraUtil.logInfo(prefix + " Calling doValidation");
        HydraUtil.logInfo(prefix + " Completed doValidation successfully");
    }

    static {
        prefix = "DiskStoreTestMBean : ";
    }
}

