/*
 * Decompiled with CFR 0.152.
 */
package management.operations.ops.jmx;

import com.gemstone.gemfire.management.ClientHealthStatus;
import com.gemstone.gemfire.management.ServerLoadData;
import hydra.ClientVmInfo;
import hydra.TestConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.management.AttributeList;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import management.jmx.JMXPrms;
import management.operations.ops.JMXOperations;
import management.operations.ops.jmx.AbstractTestMBean;
import management.test.jmx.JMXTest;
import management.util.HydraUtil;
import management.util.ManagementUtil;
import util.StopStartPrms;
import util.StopStartVMs;
import util.TestException;

public class CacheServerTestMBean
extends AbstractTestMBean<CacheServerTestMBean> {
    private static final long serialVersionUID = 1L;
    public static final String MEAN_EXIT = "MEAN_EXIT";
    public static final String MEAN_KILL = "MEAN_KILL";
    public static final String NICE_EXIT = "NICE_EXIT";
    public static final String NICE_KILL = "NICE_KILL";

    public CacheServerTestMBean(List<String> attrs, List<Object[]> ops, String ton, String[] tests) {
        super(attrs, ops, CacheServerTestMBean.class, ton, tests);
    }

    public void startAndStopCacheServer(JMXOperations ops, ObjectName targetMbean) {
        block4: {
            HydraUtil.logInfo(prefix + " Calling startAndStopCacheServer");
            String url = ops.selectManagingNode();
            boolean isRunning = (Boolean)ops.getAttribute(url, targetMbean, "Running");
            if (isRunning) {
                this.callJmxOperation(url, ops, this.buildOperationArray("stop", null, null, null), targetMbean);
                this.addCacheServerStoppedNotificationExp();
                HydraUtil.sleepForReplicationJMX();
                MBeanServerConnection server = ops.getMBeanConnection(url);
                try {
                    boolean mbeanExists = ManagementUtil.checkIfMBeanExists(server, targetMbean);
                    HydraUtil.logInfo("Mbean Exists : " + mbeanExists);
                    if (mbeanExists) {
                        throw new TestException("CacheServer stop operation failed. CacheServer is still running");
                    }
                    break block4;
                }
                catch (IOException e) {
                    throw new TestException("error trying to connect member " + url, e);
                }
            }
            HydraUtil.logInfo("No CacheServer running.... that means mbean still exists...");
            throw new TestException("CacheServer MBean is present " + targetMbean + " but is not running");
        }
        HydraUtil.logInfo(prefix + " Completed startAndStopCacheServer test successfully");
    }

    public void startAndStopCacheServerWtihConfigCheck(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling startAndStopCacheServerWtihConfigCheck");
        String[] attributes = new String[]{"BindAddress", "Capacity", "DiskStoreName", "EvictionPolicy", "HostNameForClients", "LoadPollInterval", "MaxConnections", "MaximumMessageCount", "MaximumTimeBetweenPings", "MaxThreads", "MessageTimeToLive", "Port", "SocketBufferSize"};
        String url = ops.selectManagingNode();
        AttributeList attrList = (AttributeList)ops.getAttributes(url, targetMbean, attributes);
        HydraUtil.logInfo("CacheServerConfig : " + HydraUtil.ObjectToString(attrList));
        HydraUtil.logInfo(prefix + " Completed startAndStopCacheServerWtihConfigCheck test successfully");
    }

    public void checkCacheServerStatistics(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling checkCacheServerStatistics");
        String[] attributes = new String[]{"GetRequestAvgLatency", "GetRequestRate", "PutRequestAvgLatency", "PutRequestRate", "QueryRequestRate"};
        HydraUtil.logInfo(prefix + " Calling checkCacheServerStatistics");
        String url = ops.selectManagingNode();
        AttributeList attrList = (AttributeList)ops.getAttributes(url, targetMbean, attributes);
        HydraUtil.logInfo("checkCacheServerStatistics " + HydraUtil.ObjectToString(attrList));
        HydraUtil.logInfo(prefix + " Completed checkCacheServerStatistics test successfully");
    }

    public void checkCacheServerRuntimeData(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling checkCacheServerRuntimeData");
        String[] attributes = new String[]{"ConnectionLoad", "ConnectionThreads", "LoadPerConnection", "LoadPerQueue", "QueueLoad", "ThreadQueueSize", "TotalReceivedBytes", "TotalSentBytes"};
        HydraUtil.logInfo(prefix + " Calling checkCacheServerRuntimeData");
        String url = ops.selectManagingNode();
        AttributeList attrList = (AttributeList)ops.getAttributes(url, targetMbean, attributes);
        HydraUtil.logInfo("checkCacheServerRuntimeData " + HydraUtil.ObjectToString(attrList));
        if (!JMXPrms.useGemfireProxies()) {
            CompositeData loadProbe = (CompositeData)this.callJmxOperation(url, ops, this.buildOperationArray("fetchLoadProbe", null, null, null), targetMbean);
            HydraUtil.logInfo("loadProbe " + HydraUtil.ObjectToString(loadProbe));
        } else {
            ServerLoadData loadProbe = (ServerLoadData)this.callJmxOperation(url, ops, this.buildOperationArray("fetchLoadProbe", null, null, null), targetMbean);
            HydraUtil.logInfo("loadProbe " + HydraUtil.ObjectToString(loadProbe));
        }
        HydraUtil.logInfo(prefix + " Completed checkCacheServerRuntimeData test successfully");
    }

    public void checkIndexAttributes(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling checkIndexAttributes");
        String[] attributes = new String[]{"IndexCount", "IndexList", "TotalIndexMaintenanceTime"};
        HydraUtil.logInfo(prefix + " Calling checkIndexAttributes");
        String url = ops.selectManagingNode();
        AttributeList attrList = (AttributeList)ops.getAttributes(url, targetMbean, attributes);
        HydraUtil.logInfo("checkIndexAttributes " + HydraUtil.ObjectToString(attrList));
        HydraUtil.logInfo(prefix + " Completed checkIndexAttributes test successfully");
    }

    public void checkCQAttributes(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling checkCQAttributes");
        String[] attributes = new String[]{"ActiveCQCount", "ContinuousQueryList"};
        HydraUtil.logInfo(prefix + " Calling checkCQAttributes");
        String url = ops.selectManagingNode();
        AttributeList attrList = (AttributeList)ops.getAttributes(url, targetMbean, attributes);
        HydraUtil.logInfo("checkCQAttributes " + HydraUtil.ObjectToString(attrList));
        HydraUtil.logInfo(prefix + " Completed checkCQAttributes test successfully");
    }

    public void checkClientAttributes(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling checkClientAttributes");
        String[] attributes = new String[]{"ClientConnectionCount", "ClientNotificationAvgLatency", "ClientNotificationRate", "CurrentClients", "NumClientNotificationRequests", "TotalConnectionsTimedOut", "TotalFailedConnectionAttempts"};
        HydraUtil.logInfo(prefix + " Calling checkClientAttributes");
        String url = ops.selectManagingNode();
        AttributeList attrList = (AttributeList)ops.getAttributes(url, targetMbean, attributes);
        HydraUtil.logInfo("checkClientAttributes " + HydraUtil.ObjectToString(attrList));
        HydraUtil.logInfo(prefix + " Completed checkClientAttributes test successfully");
    }

    public void fetchClientStats(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling fetchClientStats");
        String url = ops.selectManagingNode();
        String clientId = this.getClientId(ops, url, targetMbean);
        HydraUtil.logInfo(prefix + " Calling fetchClientStats for client " + clientId);
        Object[] params = new Object[]{clientId};
        String[] signature = new String[]{"java.lang.String"};
        if (!JMXPrms.useGemfireProxies()) {
            CompositeData clientStats = (CompositeData)this.callJmxOperation(url, ops, this.buildOperationArray("showClientStats", params, signature, null), targetMbean);
            HydraUtil.logInfo("ClientStats " + HydraUtil.ObjectToString(clientStats));
        } else {
            ClientHealthStatus clientStats = (ClientHealthStatus)this.callJmxOperation(url, ops, this.buildOperationArray("showClientStats", params, signature, null), targetMbean);
            HydraUtil.logInfo("ClientStats " + HydraUtil.ObjectToString(clientStats));
        }
        HydraUtil.logInfo(prefix + " Completed fetchClientStats test successfully");
    }

    private String getClientId(JMXOperations ops, String url, ObjectName targetMbean) {
        String[] clients = (String[])this.callJmxOperation(url, ops, this.buildOperationArray("listClientIds", null, null, null), targetMbean);
        String client = HydraUtil.getRandomElement(clients);
        if ("UNDEFINED".equals(client)) {
            throw new TestException("Could not locate client. Return value is UNDEFINED indicates exception while calling jmx operations");
        }
        return client;
    }

    public void fetchClientIds(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling fetchClientIds");
        String url = ops.selectManagingNode();
        String[] clients = (String[])this.callJmxOperation(url, ops, this.buildOperationArray("listClientIds", null, null, null), targetMbean);
        HydraUtil.logInfo("fetchClientIds " + HydraUtil.ObjectToString(clients));
        HydraUtil.logInfo(prefix + " Completed fetchClientIds test successfully");
    }

    public void closeContinuousQuery(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling closeContinuousQuery");
        String url = ops.selectManagingNode();
        String[] list = (String[])ops.getAttribute(url, targetMbean, "ContinuousQueryList");
        String queryToClose = HydraUtil.getRandomElement(list);
        if (queryToClose != null) {
            HydraUtil.logInfo(prefix + " Calling closeContinuousQuery with Query=" + queryToClose);
            Object[] params = new Object[]{queryToClose};
            String[] signature = new String[]{"java.lang.String"};
            this.callJmxOperation(url, ops, this.buildOperationArray("closeContinuousQuery", params, signature, null), targetMbean);
        }
        HydraUtil.logInfo(prefix + " Completed closeContinuousQuery test successfully");
    }

    public void closeAllContinuousQuery(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling closeAllContinuousQuery");
        String url = ops.selectManagingNode();
        Object[] params = new Object[]{JMXTest.queryRegion};
        String[] signature = new String[]{"java.lang.String"};
        this.callJmxOperation(url, ops, this.buildOperationArray("closeAllContinuousQuery", params, signature, null), targetMbean);
        HydraUtil.sleepForReplicationJMX();
        long count = (Long)ops.getAttribute(url, targetMbean, "ActiveCQCount");
        String[] list = (String[])ops.getAttribute(url, targetMbean, "ContinuousQueryList");
        HydraUtil.logInfo("Query count after close " + count);
        HydraUtil.logInfo("Query list after close " + HydraUtil.ObjectToString(list));
        HydraUtil.logInfo(prefix + " Completed closeAllContinuousQuery test successfully");
    }

    public void stopContinuousQuery(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling stopContinuousQuery");
        String url = ops.selectManagingNode();
        String[] list = (String[])ops.getAttribute(url, targetMbean, "ContinuousQueryList");
        String queryToStop = HydraUtil.getRandomElement(list);
        if (queryToStop != null) {
            HydraUtil.logInfo(prefix + " Calling stopContinuousQuery with Query=" + queryToStop);
            Object[] params = new Object[]{queryToStop};
            String[] signature = new String[]{"java.lang.String"};
            this.callJmxOperation(url, ops, this.buildOperationArray("stopContinuousQuery", params, signature, null), targetMbean);
        }
        HydraUtil.logInfo(prefix + " Completed stopContinuousQuery test successfully");
    }

    public void executeContinuousQuery(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling executeContinuousQuery");
        String url = ops.selectManagingNode();
        String[] list = (String[])ops.getAttribute(url, targetMbean, "ContinuousQueryList");
        String queryToExec = HydraUtil.getRandomElement(list);
        if (queryToExec != null) {
            HydraUtil.logInfo(prefix + " Calling executeContinuousQuery with Query=" + queryToExec);
            Object[] params = new Object[]{queryToExec};
            String[] signature = new String[]{"java.lang.String"};
            this.callJmxOperation(url, ops, this.buildOperationArray("executeContinuousQuery", params, signature, null), targetMbean);
        }
        HydraUtil.logInfo(prefix + " Completed executeContinuousQuery test successfully");
    }

    public void removeIndex(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling removeIndex");
        String url = ops.selectManagingNode();
        String[] list = (String[])ops.getAttribute(url, targetMbean, "IndexList");
        String indexToRemove = HydraUtil.getRandomElement(list);
        if (indexToRemove != null) {
            HydraUtil.logInfo(prefix + " Calling removeIndex with Query=" + indexToRemove);
            Object[] params = new Object[]{indexToRemove};
            String[] signature = new String[]{"java.lang.String"};
            this.callJmxOperation(url, ops, this.buildOperationArray("removeIndex", params, signature, null), targetMbean);
            HydraUtil.sleepForReplicationJMX();
            list = (String[])ops.getAttribute(url, targetMbean, "IndexList");
            HydraUtil.logInfo("removeIndex operation failed. IndexList still contains " + indexToRemove);
        }
        HydraUtil.logInfo(prefix + " Completed removeIndex test successfully");
    }

    public void doClientHA(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling doClientHA");
        String url = ops.selectManagingNode();
        String[] list = (String[])this.callJmxOperation(url, ops, this.buildOperationArray("listClientIds", null, null, null), targetMbean);
        if (list != null && list.length > 0) {
            int clients = 1 + HydraUtil.getnextRandomInt(list.length);
            HydraUtil.logInfo("Number of connected clients " + list.length + " Restarting " + clients + " clients");
            List vmList = StopStartVMs.getAllVMs();
            ArrayList<ClientVmInfo> selectedVmList = new ArrayList<ClientVmInfo>();
            ArrayList<String> stopModeList = new ArrayList<String>();
            ArrayList<String> clientIdsGoingDown = new ArrayList<String>();
            for (int i = 0; i < clients; ++i) {
                String selectedClient = list[i];
                for (ClientVmInfo cInfo : vmList) {
                    String clientName = cInfo.getClientName();
                    String gemfireName = clientName.replace("edge", "gemfire");
                    HydraUtil.logFine("clientName : " + clientName + " gemfireName = " + gemfireName + " name returned by mbean : " + selectedClient);
                    if (!selectedClient.contains(gemfireName)) continue;
                    clientIdsGoingDown.add(selectedClient);
                    selectedVmList.add(cInfo);
                    stopModeList.add(TestConfig.tab().stringAt(StopStartPrms.stopModes));
                }
            }
            HydraUtil.logInfo("CliendIds not expected after shutdown : " + HydraUtil.ObjectToString(clientIdsGoingDown));
            this.addClientNotifExpectations(targetMbean, selectedVmList, stopModeList, clientIdsGoingDown);
            StopStartVMs.stopVMs(selectedVmList, stopModeList);
            HydraUtil.logInfo(clients + " clients were Shutdown");
            HydraUtil.sleepForReplicationJMX();
            String[] oldClients = list;
            list = (String[])this.callJmxOperation(url, ops, this.buildOperationArray("listClientIds", null, null, null), targetMbean);
            HydraUtil.logInfo("CliendIds after shutdown : " + HydraUtil.ObjectToString(list));
            if (list != null) {
                int diff = oldClients.length - list.length;
                ArrayList<String> diffList = new ArrayList<String>();
                for (String cId : clientIdsGoingDown) {
                    for (String c : list) {
                        if (!c.equals(cId)) continue;
                        diffList.add(c);
                    }
                }
                if (diff != clients) {
                    throw new TestException("Client list shows " + list.length + " clients expected " + (oldClients.length - clients) + " diff : " + diffList);
                }
                if (diffList.size() > 0) {
                    throw new TestException("Client list shows " + list.length + " clients expected " + (oldClients.length - clients) + " diff : " + diffList);
                }
            }
            StopStartVMs.startVMs(selectedVmList);
            HydraUtil.logInfo("Restart VMS : " + HydraUtil.ObjectToString(clientIdsGoingDown));
        }
        HydraUtil.logInfo(prefix + " Completed doClientHA test successfully");
    }

    private void addClientNotifExpectations(ObjectName targetMbean, List<ClientVmInfo> selectedVmList, List<String> stopModeList, List<String> clientIdsGoingDown) {
        CacheServerTestMBean.addCacheServerNotifListener(targetMbean, null);
        int i = 0;
        for (ClientVmInfo info : selectedVmList) {
            String mode = stopModeList.get(i);
            String clientId = clientIdsGoingDown.get(i);
            HydraUtil.logInfo("client " + clientId + " is going down with mode " + mode);
            if (mode.equals(MEAN_KILL)) {
                this.addClientCrashedNotificationExp(targetMbean, clientId);
            } else if (mode.contains(NICE_EXIT) || mode.equals(NICE_KILL)) {
                this.addClientLeftNotificationExp(targetMbean, clientId);
            }
            ++i;
        }
    }

    @Override
    public String getType() {
        return gemfireDefinedMBeanTypes[1];
    }

    @Override
    public void doValidation(JMXOperations ops) {
    }

    static {
        prefix = "CacheServerTestMBean : ";
    }
}

