/*
 * Decompiled with CFR 0.152.
 */
package management.operations.ops.cli.executors;

import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.ExpirationAction;
import com.gemstone.gemfire.cache.LoaderHelper;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.management.cli.Result;
import com.gemstone.gemfire.management.internal.cli.dto.Key1;
import com.gemstone.gemfire.management.internal.cli.dto.Value1;
import com.gemstone.gemfire.management.internal.cli.result.CommandResult;
import com.gemstone.gemfire.management.internal.cli.result.TabularResultData;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import management.cli.TestableGfsh;
import management.operations.OperationsBlackboard;
import management.operations.events.impl.RegionEvents;
import management.operations.ops.cli.TestCommand;
import management.operations.ops.cli.TestCommandInstance;
import management.operations.ops.cli.executors.AbstractTestCommandExecutor;
import management.test.cli.CLITest;
import management.test.federation.FederationBlackboard;
import management.util.HydraUtil;
import management.util.ManagementUtil;
import util.TestException;

public class CreateRegionExecutor
extends AbstractTestCommandExecutor {
    private static final String LISTENER_CLASS = "management.operations.ops.cli.executors.CreateRegionExecutor$CRETestCacheListener";
    private static final String LOADER_CLASS = "management.operations.ops.cli.executors.CreateRegionExecutor$CRETestCacheLoader";
    private static final String WRITER_CLASS = "management.operations.ops.cli.executors.CreateRegionExecutor$CRETestCacheWriter";
    private String regionPath = null;
    private String group = null;
    private boolean skipIfExists = true;
    private static String regionPattern = "GemFire:service=Region,name=?1,type=Member,member=?2";
    private static String distrRgionPattern = "GemFire:service=Region,name=?1,type=Distributed";
    private static final String[] expirationActions = new String[]{ExpirationAction.INVALIDATE.toString(), ExpirationAction.LOCAL_INVALIDATE.toString(), ExpirationAction.DESTROY.toString(), ExpirationAction.LOCAL_DESTROY.toString()};

    @Override
    protected void fillArgument(TestCommandInstance instance, String name) {
    }

    private void addArgument(TestCommandInstance instance, String name) {
    }

    @Override
    public Object executeAndVerify(TestCommandInstance instance) {
        TestableGfsh gfsh = CLITest.getTestableShell();
        if (!gfsh.isConnectedAndReady()) {
            CLITest.connectGfshToManagerNode();
        }
        Object[] object = TestableGfsh.execAndLogCommand(gfsh, instance.toString(), CLITest.getGfshOutputFile(), false);
        Map map = (Map)object[0];
        CommandResult result = null;
        Collection values = map.values();
        boolean testValidationSucceeded = true;
        for (Object r : values) {
            if (!(r instanceof CommandResult)) continue;
            result = (CommandResult)r;
            if (!result.getStatus().equals((Object)Result.Status.OK)) {
                this.addFailure(" Command return status is *NOT* OK. Command execution has failed");
                testValidationSucceeded = false;
                continue;
            }
            HydraUtil.logInfo("Completed exeuction of <" + instance + "> successfully");
        }
        this.verifyGemfire(gfsh, object);
        testValidationSucceeded = (Boolean)this.verifyJMX(gfsh, object);
        this.verifyCommand(gfsh, object);
        if (testValidationSucceeded) {
            RegionEvents e = new RegionEvents();
            e.regionAdded(this.regionPath);
            e.exportToBlackBoard(OperationsBlackboard.getBB());
        }
        this.regionPath = null;
        this.group = null;
        return object;
    }

    private String getRegionShortCutForMode(String mode) {
        RegionShortcut[] r = RegionShortcut.values();
        if (mode.contains("override-disk")) {
            r = this.filterOnlyDiskShortCuts(r);
        } else if (mode.contains("expiration")) {
            r = this.filterProxyShortCuts(r);
        } else if (mode.contains("override-pr")) {
            r = this.filterPRShortCuts(r);
        }
        r = this.removeHDFSShortCuts(r);
        RegionShortcut selected = HydraUtil.getRandomElement(r);
        return selected.name();
    }

    protected String getAlreadyExistingRegionForMode(String mode) {
        List<String> regionList = RegionEvents.getAllRegions();
        if (mode.contains("override-disk")) {
            regionList = this.filterOnlyDiskRegions(regionList);
        } else if (mode.contains("skip-if-exists")) {
            regionList = this.filterOnlyHydraTemplateRegions(regionList);
        } else if (mode.contains("override-pr")) {
            if (mode.contains("colocated-with")) {
                return "/TestPartition_1";
            }
            regionList = this.filterOnlyPartitionedRegions(regionList);
        }
        return HydraUtil.getRandomElement(regionList);
    }

    private List<String> filterOnlyDiskRegions(List<String> regionList) {
        ArrayList<String> list = new ArrayList<String>();
        for (String rs : regionList) {
            if (!rs.contains("override-disk") && !rs.contains("Persistent")) continue;
            list.add(rs);
        }
        HydraUtil.logInfo("Filtered only disk regions : " + list);
        return list;
    }

    private List<String> filterOnlyHydraTemplateRegions(List<String> regionList) {
        ArrayList<String> list = new ArrayList<String>();
        for (String rs : regionList) {
            if (!rs.contains("Test")) continue;
            list.add(rs);
        }
        HydraUtil.logInfo("Filtered only disk regions : " + list);
        return list;
    }

    private List<String> filterOnlyPartitionedRegions(List<String> regionList) {
        ArrayList<String> list = new ArrayList<String>();
        for (String rs : regionList) {
            if (!rs.contains("Partition") && !rs.contains("override-pr")) continue;
            list.add(rs);
        }
        return list;
    }

    private RegionShortcut[] removeHDFSShortCuts(RegionShortcut[] r) {
        ArrayList<RegionShortcut> list = new ArrayList<RegionShortcut>();
        for (RegionShortcut rs : r) {
            if (rs.name().contains("_HDFS_")) continue;
            list.add(rs);
        }
        RegionShortcut[] array = new RegionShortcut[list.size()];
        HydraUtil.logInfo("Removed HDFS shortcuts : " + list);
        return list.toArray(array);
    }

    private RegionShortcut[] filterOnlyDiskShortCuts(RegionShortcut[] r) {
        ArrayList<RegionShortcut> list = new ArrayList<RegionShortcut>();
        for (RegionShortcut rs : r) {
            if (!rs.name().contains("PERSISTENT") && !rs.name().contains("OVERFLOW")) continue;
            list.add(rs);
        }
        RegionShortcut[] array = new RegionShortcut[list.size()];
        HydraUtil.logInfo("Filtered only disk shortcuts : " + list);
        return list.toArray(array);
    }

    private RegionShortcut[] filterPRShortCuts(RegionShortcut[] r) {
        ArrayList<RegionShortcut> list = new ArrayList<RegionShortcut>();
        for (RegionShortcut rs : r) {
            if (!rs.name().contains("PARTITION") || rs.name().contains("PROXY")) continue;
            list.add(rs);
        }
        RegionShortcut[] array = new RegionShortcut[list.size()];
        HydraUtil.logInfo("Filtered only PR shortcuts : " + list);
        return list.toArray(array);
    }

    private RegionShortcut[] filterProxyShortCuts(RegionShortcut[] r) {
        ArrayList<RegionShortcut> list = new ArrayList<RegionShortcut>();
        for (RegionShortcut rs : r) {
            if (rs.name().contains("PROXY")) continue;
            list.add(rs);
        }
        RegionShortcut[] array = new RegionShortcut[list.size()];
        HydraUtil.logInfo("Filtered PROXY shortcuts : " + list);
        return list.toArray(array);
    }

    @Override
    protected void fillOption(TestCommandInstance instance, TestCommand.CommandOption op) {
    }

    @Override
    public Object verifyJMX(TestableGfsh gfsh, Object object) {
        HydraUtil.logInfo("Sleeping for replication");
        HydraUtil.sleepForReplicationJMX();
        HydraUtil.logInfo("Checking mbeans for region " + this.regionPath + " Executor " + this);
        try {
            Object[] outputs = (Object[])object;
            Map commandOutput = (Map)outputs[0];
            List<String> memmberIds = this.getFailedMemberIdsFromOutput(commandOutput);
            boolean jmxMBeansCreated = CreateRegionExecutor.checkMBean(this.regionPath, this.group, memmberIds);
            if (!jmxMBeansCreated) {
                this.addFailure("Cant find mbeans for regionPath " + this.regionPath + " group=" + this.group);
            }
            return jmxMBeansCreated;
        }
        catch (MalformedObjectNameException e) {
            throw new TestException("Error checking regionMBeans", e);
        }
        catch (InstanceNotFoundException e) {
            throw new TestException("Error checking regionMBeans", e);
        }
        catch (AttributeNotFoundException e) {
            throw new TestException("Error checking regionMBeans", e);
        }
        catch (MalformedURLException e) {
            throw new TestException("Error checking regionMBeans", e);
        }
        catch (NullPointerException e) {
            throw new TestException("Error checking regionMBeans", e);
        }
        catch (MBeanException e) {
            throw new TestException("Error checking regionMBeans", e);
        }
        catch (ReflectionException e) {
            throw new TestException("Error checking regionMBeans", e);
        }
        catch (IOException e) {
            throw new TestException("Error checking regionMBeans", e);
        }
    }

    private List<String> getFailedMemberIdsFromOutput(Map<String, Object> commandOutput) {
        ArrayList<String> memberIds = new ArrayList<String>();
        for (Object obj : commandOutput.values()) {
            CommandResult result = (CommandResult)obj;
            if (!result.getType().equals("table")) continue;
            TabularResultData table = (TabularResultData)result.getResultData();
            List statuses = table.retrieveAllValues("Status");
            List members = table.retrieveAllValues("Member");
            for (int i = 0; i < statuses.size(); ++i) {
                String status = (String)statuses.get(i);
                String member = (String)members.get(i);
                if (status.contains("ERROR")) {
                    memberIds.add(member);
                    HydraUtil.logFine("Command failed on member " + member);
                    continue;
                }
                HydraUtil.logFine("Command Succeeded on member " + member + " for validation");
            }
        }
        return memberIds;
    }

    public static boolean checkMBean(String regionName, String group, List<String> memmberIds) throws MalformedURLException, IOException, MalformedObjectNameException, NullPointerException, InstanceNotFoundException, AttributeNotFoundException, MBeanException, ReflectionException {
        boolean regionMBeansExist = true;
        Collection<String> urls = FederationBlackboard.getBB().getManagingNodes();
        if (regionName.contains("-")) {
            regionName = "\"" + regionName + "\"";
        }
        ObjectName distributedRegionMBean = new ObjectName(distrRgionPattern.replace("?1", regionName));
        String regionMBean1 = regionPattern.replace("?1", regionName);
        HydraUtil.logInfo("Checking for JMX MBean for region : " + regionName);
        for (String url : urls) {
            MBeanServerConnection connection = ManagementUtil.connectToUrl(url);
            HydraUtil.logInfo("Checking DistrRegionMBean on url " + url);
            boolean distrFound = ManagementUtil.checkIfMBeanExists(connection, distributedRegionMBean);
            if (!distrFound) {
                HydraUtil.logInfo("DistributedRegionMBean " + distributedRegionMBean + " is not found on url " + url);
                regionMBeansExist = false;
            }
            Set<String> members = ManagementUtil.getMembersForGroup(connection, group);
            HydraUtil.logInfo("Member for group(" + group + ") : " + HydraUtil.ObjectToString(members));
            if (memmberIds != null && memmberIds.size() > 0) {
                for (String m : memmberIds) {
                    if (!members.contains(m)) continue;
                    HydraUtil.logFine("Removing member as command could not created region on member " + m);
                    members.remove(m);
                }
            }
            for (String member : members) {
                ObjectName regionMBean = new ObjectName(regionMBean1.replace("?2", member));
                if (!ManagementUtil.checkIfMBeanExists(connection, regionMBean)) {
                    HydraUtil.logInfo("RegionMBean " + regionMBean + " is not found on url " + url);
                    return false;
                }
                HydraUtil.logInfo("RegionMBean " + regionMBean + " is FOUND on url " + url);
            }
            HydraUtil.logInfo("Checked for memebers : " + members + " Result : " + regionMBeansExist);
        }
        return regionMBeansExist;
    }

    @Override
    protected void fillMandatoryOption(TestCommandInstance instance, String name) {
        String mode;
        HydraUtil.logFine("fillMandatoryOption : mode(" + instance.getMode() + ") # " + name);
        if ("group".equals(name)) {
            this.group = this.getGroup();
            instance.addOption(name, this.group);
        } else if ("skip-if-exists".equals(name)) {
            instance.addOption(name, "true");
            this.skipIfExists = true;
        } else if ("template-region".equals(name)) {
            String regionName = this.getAlreadyExistingRegionForMode(instance.getMode());
            instance.addOption(name, regionName);
        } else if ("type".equals(name)) {
            String shortcut = this.getRegionShortCutForMode(instance.getMode());
            instance.addOption(name, shortcut);
            if (shortcut.contains("PERSISTENT") || shortcut.contains("OVERFLOW")) {
                instance.addOption("disk-store", this.getDiskStore());
            }
        } else if ("name".equals(name)) {
            mode = instance.getMode();
            if (mode.contains("skip-if-exists")) {
                this.regionPath = this.getAlreadyExistingRegion();
                instance.addOption(name, this.regionPath);
            } else {
                this.regionPath = this.getNewRegion(mode);
                instance.addOption(name, this.regionPath);
            }
            HydraUtil.logFine("Region Name for new command " + this.regionPath + " Executor " + this);
        }
        mode = instance.getMode();
        if (mode.contains("override-disk")) {
            if ("disk-store".equals(name)) {
                instance.addOption(name, this.getDiskStore());
            } else if ("enable-synchronous-disk".equals(name)) {
                instance.addOption(name, "" + HydraUtil.getRandomBoolean());
            } else if ("enable-statistics".equals(name)) {
                instance.addOption(name, "true");
            }
        } else if (mode.contains("override-key-value-constraint")) {
            if ("key-constraint".equals(name)) {
                instance.addOption(name, Key1.class.getCanonicalName());
            } else if ("value-constraint".equals(name)) {
                instance.addOption(name, Value1.class.getCanonicalName());
            }
        } else if (mode.contains("override-expiration")) {
            if ("entry-idle-time-expiration".equals(name)) {
                instance.addOption(name, HydraUtil.getnextRandomInt(60));
            } else if ("entry-idle-time-expiration-action".equals(name)) {
                instance.addOption(name, this.getExpiryAction());
            } else if ("entry-time-to-live-expiration".equals(name)) {
                instance.addOption(name, HydraUtil.getnextRandomInt(60));
            } else if ("entry-time-to-live-expiration-action".equals(name)) {
                instance.addOption(name, this.getExpiryAction());
            } else if ("enable-statistics".equals(name)) {
                instance.addOption(name, "true");
            }
        } else if (mode.contains("region-override-region-expiration")) {
            if ("region-idle-time-expiration".equals(name)) {
                instance.addOption(name, HydraUtil.getnextRandomInt(60));
            } else if ("region-idle-time-expiration-action".equals(name)) {
                instance.addOption(name, this.getExpiryAction());
            } else if ("region-time-to-live-expiration".equals(name)) {
                instance.addOption(name, HydraUtil.getnextRandomInt(60));
            } else if ("region-time-to-live-expiration-action".equals(name)) {
                instance.addOption(name, this.getExpiryAction());
            } else if ("enable-statistics".equals(name)) {
                instance.addOption(name, "true");
            }
        } else if (mode.contains("override-conflation")) {
            if ("enable-async-conflation".equals(name)) {
                instance.addOption(name, "true");
            } else if ("enable-subscription-conflation".equals(name)) {
                instance.addOption(name, "true");
            }
        } else if (mode.contains("override-listeners")) {
            if ("cache-listener".equals(name)) {
                instance.addOption(name, LISTENER_CLASS);
            } else if ("cache-loader".equals(name)) {
                instance.addOption(name, LOADER_CLASS);
            } else if ("cache-writer".equals(name)) {
                instance.addOption(name, WRITER_CLASS);
            }
        } else if (mode.contains("override-concurrency-enabled")) {
            if ("enable-concurrency-checks".equals(name)) {
                instance.addOption(name, "true");
            }
        } else if (mode.contains("override-concurrency-level")) {
            if ("concurrency-level".equals(name)) {
                instance.addOption(name, "" + HydraUtil.getnextNonZeroRandomInt(100));
            }
        } else if (mode.contains("override-cloning-enabled")) {
            if ("enable-cloning".equals(name)) {
                instance.addOption(name, "true");
            }
        } else if (mode.contains("override-pr")) {
            if ("local-max-memory".equals(name)) {
                instance.addOption(name, HydraUtil.getnextRandomInt(1024));
            } else if ("recovery-delay".equals(name)) {
                instance.addOption(name, HydraUtil.getnextRandomInt(5000));
            } else if ("redundant-copies".equals(name)) {
                if (mode.contains("from-other")) {
                    instance.addOption(name, 1);
                } else {
                    int copies = HydraUtil.getnextRandomInt(4);
                    if (copies == 0) {
                        copies = 1;
                    }
                    instance.addOption(name, copies);
                }
            } else if ("startup-recovery-delay".equals(name)) {
                instance.addOption(name, HydraUtil.getnextRandomInt(5000));
            } else if ("total-max-memory".equals(name)) {
                int numMemebers = FederationBlackboard.getBB().getMemberNames().size();
                instance.addOption(name, HydraUtil.getnextRandomInt(1024) * numMemebers);
            } else if ("total-num-buckets".equals(name)) {
                if (mode.contains("from-other")) {
                    instance.addOption(name, 20);
                } else {
                    instance.addOption(name, HydraUtil.getnextRandomInt(1024));
                }
            }
        } else if (mode.contains("pr-colocated-with") && "colocated-with".equals(name)) {
            instance.addOption(name, this.getPrColocatedRootRegion());
        }
    }

    private Object getExpiryAction() {
        return HydraUtil.getRandomElement(expirationActions);
    }

    public static class CRETestCacheListener
    implements CacheListener {
        public void close() {
            HydraUtil.logInfo(this.getClass().getName() + " : CLOSED");
        }

        public void afterCreate(EntryEvent event) {
            HydraUtil.logInfo(this.getClass().getName() + " : afterCreate : " + event.getKey());
        }

        public void afterUpdate(EntryEvent event) {
            HydraUtil.logInfo(this.getClass().getName() + " : afterUpdate : " + event.getKey());
        }

        public void afterInvalidate(EntryEvent event) {
            HydraUtil.logInfo(this.getClass().getName() + " : afterInvalidate : " + event.getKey());
        }

        public void afterDestroy(EntryEvent event) {
            HydraUtil.logInfo(this.getClass().getName() + " : afterDestroy : " + event.getKey());
        }

        public void afterRegionInvalidate(RegionEvent event) {
            HydraUtil.logInfo(this.getClass().getName() + " : afterRegionInvalidate : " + event.getRegion().getFullPath());
        }

        public void afterRegionDestroy(RegionEvent event) {
            HydraUtil.logInfo(this.getClass().getName() + " : afterRegionDestroy : " + event.getRegion().getFullPath());
        }

        public void afterRegionClear(RegionEvent event) {
            HydraUtil.logInfo(this.getClass().getName() + " : afterRegionClear : " + event.getRegion().getFullPath());
        }

        public void afterRegionCreate(RegionEvent event) {
            HydraUtil.logInfo(this.getClass().getName() + " : afterRegionCreate : " + event.getRegion().getFullPath());
        }

        public void afterRegionLive(RegionEvent event) {
            HydraUtil.logInfo(this.getClass().getName() + " : afterRegionLive : " + event.getRegion().getFullPath());
        }
    }

    public static class CRETestCacheWriter
    implements CacheWriter {
        public void close() {
            HydraUtil.logInfo(this.getClass().getName() + " : CLOSED");
        }

        public void beforeUpdate(EntryEvent event) throws CacheWriterException {
            HydraUtil.logInfo(this.getClass().getName() + " : beforeUpdate : " + event.getKey());
        }

        public void beforeCreate(EntryEvent event) throws CacheWriterException {
            HydraUtil.logInfo(this.getClass().getName() + " : beforeCreate : " + event.getKey());
        }

        public void beforeDestroy(EntryEvent event) throws CacheWriterException {
            HydraUtil.logInfo(this.getClass().getName() + " : beforeDestroy : " + event.getKey());
        }

        public void beforeRegionDestroy(RegionEvent event) throws CacheWriterException {
            HydraUtil.logInfo(this.getClass().getName() + " : beforeRegionDestroy : " + event.getRegion().getFullPath());
        }

        public void beforeRegionClear(RegionEvent event) throws CacheWriterException {
            HydraUtil.logInfo(this.getClass().getName() + " : beforeRegionClear : " + event.getRegion().getFullPath());
        }
    }

    public static class CRETestCacheLoader
    implements CacheLoader {
        public void close() {
            HydraUtil.logInfo(this.getClass().getName() + " : CLOSED");
        }

        public Object load(LoaderHelper helper) throws CacheLoaderException {
            HydraUtil.logInfo(this.getClass().getName() + " : load for Key " + helper.getKey());
            return null;
        }
    }
}

