/*
 * Decompiled with CFR 0.152.
 */
package management.operations.ops.cli;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import management.operations.ops.cli.TestCommand;
import management.util.HydraUtil;
import util.TestException;

public class TestCommandInstance
implements Serializable {
    private static final String SPACE = " ";
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String OPTION_PREFIX = "--";
    private static final String OPTION_VALUE_ASSIGN = "=";
    static transient Random random = new Random();
    public TestCommand testCommand;
    private Map<String, Object> options = new HashMap<String, Object>();
    private Map<String, Object> mandatoryOptions = new HashMap<String, Object>();
    private List<String> arguments = new ArrayList<String>();
    private String mode;

    public static String getRandomSepartor() {
        return SPACE;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.testCommand.command).append(TestCommandInstance.getRandomSepartor());
        for (String argument : this.arguments) {
            sb.append(argument).append(TestCommandInstance.getRandomSepartor());
        }
        for (String mandatoryOption : this.mandatoryOptions.keySet()) {
            sb.append(OPTION_PREFIX).append(mandatoryOption).append(OPTION_VALUE_ASSIGN).append(this.mandatoryOptions.get(mandatoryOption).toString()).append(TestCommandInstance.getRandomSepartor());
        }
        for (String option : this.options.keySet()) {
            sb.append(OPTION_PREFIX).append(option).append(OPTION_VALUE_ASSIGN).append(this.options.get(option).toString()).append(TestCommandInstance.getRandomSepartor());
        }
        return sb.toString();
    }

    public void addOption(String optionName, Object value) {
        HydraUtil.logFine("Adding option : " + optionName + " with value : " + value);
        this.options.put(optionName, value);
    }

    public void addMandatoryOption(String optionName, Object value) {
        HydraUtil.logFine("Adding Moption : " + optionName + " with value : " + value);
        this.mandatoryOptions.put(optionName, value);
    }

    public void addArgument(String optionName) {
        throw new TestException("Arguments are deprecated. See 46096");
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }
}

