/*
 * Decompiled with CFR 0.152.
 */
package management.operations.ops;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.RegionFunctionContext;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import hydra.HydraVector;
import hydra.Log;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import management.cli.CLIBlackboard;
import management.operations.OperationPrms;
import management.operations.OperationsBlackboard;
import management.operations.events.FunctionOperationEvents;
import management.operations.ops.EntryOperations;
import management.util.HydraUtil;
import management.util.ManagementUtil;
import util.TestException;
import util.TestHelper;

public class FunctionOperations {
    public static final int FUNCTION_OP_REGISTER_NEW_FUNCTION = 0;
    public static final int FUNCTION_OP_UNREGISTER_FUNCTION = 2;
    public static final int FUNCTION_OP_EXECUTE_REGISTERED_FUNCTION = 3;
    public static final String FUNCTION_OP_REGISTER = "register";
    public static final String FUNCTION_OP_UNREGISTER = "unregister";
    public static final String FUNCTION_OP_EXEC = "exec";
    public static final String FUNCTION_TYPE_SLEEP = "sleepFunction";
    public static final String FUNCTION_TYPE_REGION = "regionFunction";
    public static final String FUNCTION_TYPE_FIRENFORGET = "fireNforget";
    private FunctionOperationEvents opRecorder = null;
    private Region region = null;
    private Cache cache = null;
    protected static String opPrefix = "FunctionOperations: ";

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public FunctionOperations() {
        this.opRecorder = OperationsBlackboard.getBB();
    }

    public FunctionOperations(Region r) {
        this.opRecorder = OperationsBlackboard.getBB();
        this.region = r;
    }

    public FunctionOperations(FunctionOperationEvents recorder) {
        this.opRecorder = recorder;
    }

    public FunctionOperations(Region r, FunctionOperationEvents recorder) {
        this.opRecorder = recorder;
        this.region = r;
    }

    public void registerFunction() {
        HydraVector vector = TestConfig.tab().vecAt(OperationPrms.functionRegisterList);
        int functionNum = TestConfig.tab().getRandGen().nextInt(vector.size() - 1);
        int index = 0;
        String kind = null;
        for (String k : vector) {
            if (index == functionNum) {
                kind = k;
            }
            ++index;
        }
        if (kind == null) {
            throw new TestException("Unkown kind " + kind);
        }
        this._registerFunction(kind);
    }

    public void registerFunction(String type) {
        this._registerFunction(type);
    }

    private void _registerFunction(String givenKind) {
        String functionRegistered = null;
        if (FUNCTION_TYPE_SLEEP.equals(givenKind)) {
            long delay = TestConfig.tab().getRandGen().nextLong(TestConfig.tab().intAt(OperationPrms.functionSleepDelay, 10000));
            String id = OperationsBlackboard.getBB().getNextSleepFunctionId();
            SleepFunction func = new SleepFunction(delay, id);
            FunctionService.registerFunction((Function)func);
            functionRegistered = id;
        } else if (FUNCTION_TYPE_REGION.equals(givenKind)) {
            RegionFunctionOp rFunc = new RegionFunctionOp();
            if (!FunctionService.isRegistered((String)rFunc.getId())) {
                FunctionService.registerFunction((Function)rFunc);
                functionRegistered = rFunc.getId();
            }
        } else {
            GenericFunctionOp rFunc = new GenericFunctionOp(givenKind);
            if (!FunctionService.isRegistered((String)rFunc.getId())) {
                FunctionService.registerFunction((Function)rFunc);
                functionRegistered = rFunc.getId();
            }
        }
        this.opRecorder.functionRegistered(functionRegistered);
    }

    public void doFunctionOperation() {
        String opStr = TestConfig.tab().stringAt(OperationPrms.functionOps);
        int op = -1;
        if (FUNCTION_OP_EXEC.equals(opStr)) {
            op = 3;
        } else if (FUNCTION_OP_REGISTER.equals(opStr)) {
            op = 0;
        } else if (FUNCTION_OP_UNREGISTER.equals(opStr)) {
            op = 2;
        }
        switch (op) {
            case 3: {
                this.executeFunction();
                break;
            }
            case 0: {
                this.registerFunction();
                break;
            }
            case 2: {
                this.unRegisterFunction();
                break;
            }
            default: {
                HydraUtil.logInfo(opPrefix + "Unknown operation code " + op);
            }
        }
    }

    private void unRegisterFunction() {
        int currentRegisteredFunctions = OperationsBlackboard.getBB().getSleepFunctionCounter();
        int randomFunction = TestConfig.tab().getRandGen().nextInt(currentRegisteredFunctions);
        FunctionService.unregisterFunction((String)("SLEEP_" + randomFunction));
        this.opRecorder.functionUnregistered("SLEEP_" + randomFunction);
    }

    public List<String> registerFunctions() {
        HydraVector vector = TestConfig.tab().vecAt(OperationPrms.functionRegisterList);
        ArrayList<String> functionList = new ArrayList<String>();
        for (String str : vector) {
            if (FUNCTION_TYPE_SLEEP.equals(str)) {
                long delay = TestConfig.tab().getRandGen().nextLong(TestConfig.tab().intAt(OperationPrms.functionSleepDelay, 10000));
                String id = OperationsBlackboard.getBB().getNextSleepFunctionId();
                SleepFunction func = new SleepFunction(delay, id);
                FunctionService.registerFunction((Function)func);
                functionList.add(id);
                continue;
            }
            if (FUNCTION_TYPE_REGION.equals(str)) {
                RegionFunctionOp rFunc = new RegionFunctionOp();
                if (FunctionService.isRegistered((String)rFunc.getId())) continue;
                FunctionService.registerFunction((Function)rFunc);
                functionList.add(rFunc.getId());
                continue;
            }
            GenericFunctionOp rFunc = new GenericFunctionOp(str);
            if (FunctionService.isRegistered((String)rFunc.getId())) continue;
            FunctionService.registerFunction((Function)rFunc);
            functionList.add(rFunc.getId());
        }
        for (String id : functionList) {
            this.opRecorder.functionRegistered(id);
        }
        return functionList;
    }

    private void executeFunction() {
        String function = this.getFunction();
        if (FUNCTION_TYPE_SLEEP.equals(function)) {
            this.execSleep();
        } else if (FUNCTION_TYPE_REGION.equals(function)) {
            this.execRegion();
        } else if (FUNCTION_TYPE_FIRENFORGET.equals(function)) {
            this.execFireNForget();
        }
    }

    private Execution getExecutionObject() {
        DistributedSystem ds = this.cache.getDistributedSystem();
        InternalDistributedMember localVM = ((InternalDistributedSystem)ds).getDistributionManager().getDistributionManagerId();
        if (this.region == null) {
            return FunctionService.onMembers((DistributedSystem)ds);
        }
        return FunctionService.onRegion((Region)this.region);
    }

    private void execFireNForget() {
        FireAndForgetFunction ffFunction = null;
        ArrayList<Integer> argumentList = new ArrayList<Integer>();
        Execution dataSet = this.getExecutionObject();
        argumentList.add(RemoteTestModule.getCurrentThread().getThreadId());
        try {
            HydraUtil.logInfo(opPrefix + "Starting execution of ffFunction " + ffFunction.getId());
            ResultCollector drc = dataSet.withArgs(argumentList).execute((Function)new FunctionAdapter(){

                public String getId() {
                    return "" + ((Object)((Object)this)).hashCode();
                }

                public void execute(FunctionContext context) {
                    Log.getLogWriter().info(opPrefix + "Invoking fire and forget onMembers() function");
                    ArrayList<File> list = new ArrayList<File>();
                    DistributionConfig dc = InternalDistributedSystem.getAnyInstance().getConfig();
                    list.add(dc.getCacheXmlFile());
                    Log.getLogWriter().info(opPrefix + "Updating the BB list");
                }
            });
            this.opRecorder.functionExecuted("FIRENFORGET", null);
            HydraUtil.logInfo(opPrefix + "Finished execution of ffFunction " + ffFunction.getId());
        }
        catch (Exception e) {
            HydraUtil.logInfo(opPrefix + "Error running function " + e.getMessage());
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    private void execRegion() {
        RegionFunctionOp regionFunction = new RegionFunctionOp();
        ArrayList<Integer> argumentList = new ArrayList<Integer>();
        Execution dataSet = this.getExecutionObject();
        argumentList.add(RemoteTestModule.getCurrentThread().getThreadId());
        try {
            HydraUtil.logInfo(opPrefix + "Starting execution of regionFunction " + regionFunction.getId());
            ResultCollector drc = dataSet.withArgs(argumentList).execute(regionFunction.getId());
            HydraUtil.logInfo(opPrefix + "Finished execution of regionFunction " + regionFunction.getId());
            Object result = drc.getResult();
            this.opRecorder.functionExecuted(regionFunction.getId(), result);
        }
        catch (Exception e) {
            HydraUtil.logInfo("Error running function " + e.getMessage());
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    private void execSleep() {
        SleepFunction sleepFunction = null;
        ArrayList<Integer> argumentList = new ArrayList<Integer>();
        boolean flag = false;
        while (!flag) {
            int currentRegisteredFunctions = OperationsBlackboard.getBB().getSleepFunctionCounter();
            int randomFunction = TestConfig.tab().getRandGen().nextInt(currentRegisteredFunctions);
            if (!FunctionService.isRegistered((String)("SLEEP_" + randomFunction))) continue;
            flag = true;
            sleepFunction = (SleepFunction)FunctionService.getFunction((String)("SLEEP_" + randomFunction));
        }
        Execution dataSet = this.getExecutionObject();
        argumentList.add(RemoteTestModule.getCurrentThread().getThreadId());
        try {
            HydraUtil.logInfo(opPrefix + "Starting execution of sleepFunction " + sleepFunction.getId());
            ResultCollector drc = dataSet.withArgs(argumentList).execute(sleepFunction.getId());
            HydraUtil.logInfo(opPrefix + "Finished execution of sleepFunction " + sleepFunction.getId());
            Object result = drc.getResult();
            this.opRecorder.functionExecuted(sleepFunction.getId(), result);
        }
        catch (Exception e) {
            HydraUtil.logInfo("Error running function " + e.getMessage());
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    private String getFunction() {
        return TestConfig.tab().stringAt(OperationPrms.functionList);
    }

    public FunctionOperationEvents getOperationRecorder() {
        return this.opRecorder;
    }

    public static class CustomResultCollector
    implements ResultCollector {
        private ArrayList resultList = new ArrayList();

        public void addResult(DistributedMember memberID, Object result) {
            this.resultList.add(result);
        }

        public void endResults() {
        }

        public Object getResult() throws FunctionException {
            CLIBlackboard.getBB().addToList("FUNCTION_EXEC_RESULTCOLLECTOR", RemoteTestModule.getMyClientName());
            return this.resultList;
        }

        public Object getResult(long timeout, TimeUnit unit) throws FunctionException {
            return this.resultList;
        }

        public void clearResults() {
            this.resultList.clear();
        }
    }

    public static class GenericFunctionOp
    extends FunctionAdapter {
        private String functionId = null;

        public GenericFunctionOp(String str) {
            this.functionId = str;
        }

        public void execute(FunctionContext context) {
            String arg = null;
            Object arguments = context.getArguments();
            if (arguments != null && arguments instanceof String) {
                arg = (String)arguments;
            }
            String array = ManagementUtil.getMemberID();
            CLIBlackboard.getBB().addToList("FUNCTION_EXEC_LIST", array);
            context.getResultSender().lastResult((Object)(this.functionId + "-" + RemoteTestModule.getMyClientName()));
            HydraUtil.logInfo("Executed function " + this.functionId + " on member " + RemoteTestModule.getMyClientName());
        }

        public String getId() {
            return this.functionId;
        }

        public boolean hasResult() {
            return true;
        }

        public boolean optimizeForWrite() {
            return true;
        }

        public void init(Properties props) {
        }

        public boolean isHA() {
            return true;
        }
    }

    public static class RegionFunctionOp
    extends FunctionAdapter {
        public void execute(FunctionContext context) {
            ArrayList arguments = (ArrayList)context.getArguments();
            String operation = "functionExecOp";
            Object initiatingThreadID = arguments.get(1);
            String aStr = opPrefix + "In execute with context " + context + " with operation " + operation + " initiated in hydra thread thr_" + initiatingThreadID + "_";
            for (int i = 2; i < arguments.size(); ++i) {
                aStr = aStr + " additional arg: " + arguments.get(i);
            }
            HydraUtil.logInfo(aStr);
            boolean isRegionContext = context instanceof RegionFunctionContext;
            boolean isPartitionedRegionContext = false;
            RegionFunctionContext regionContext = null;
            if (isRegionContext) {
                regionContext = (RegionFunctionContext)context;
                isPartitionedRegionContext = PartitionRegionHelper.isPartitionedRegion((Region)regionContext.getDataSet());
            }
            Log.getLogWriter().info(opPrefix + "isPartitionedRegionContext: " + isPartitionedRegionContext);
            Region region = null;
            PartitionedRegion pRegion = null;
            if (isPartitionedRegionContext) {
                pRegion = (PartitionedRegion)regionContext.getDataSet();
                region = pRegion;
            } else {
                region = regionContext.getDataSet();
            }
            EntryOperations eOps = new EntryOperations(region);
            eOps.doEntryOperation();
        }

        public String getId() {
            return ((Object)((Object)this)).getClass().getName();
        }

        public boolean hasResult() {
            return true;
        }

        public boolean optimizeForWrite() {
            return true;
        }

        public void init(Properties props) {
        }

        public boolean isHA() {
            return true;
        }
    }

    public static class SleepFunction
    extends FunctionAdapter {
        private long delay = 0L;
        private String functionId = null;

        public SleepFunction(long delay, String id) {
            this.delay = delay;
            this.functionId = id;
        }

        public void execute(FunctionContext context) {
            HydraUtil.logInfo("Executing sleep function " + this.functionId + " sleeping for " + this.delay);
            long l1 = System.currentTimeMillis();
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            long l2 = System.currentTimeMillis();
            HydraUtil.logInfo("Completed Function Execution" + this.functionId + " in " + (l2 - l1) + " ms");
            context.getResultSender().lastResult((Object)(l2 - l1));
        }

        public String getId() {
            return this.functionId;
        }
    }

    public static class FireAndForgetFunction
    extends FunctionAdapter {
        private String functionId = null;
        private Callable runnable = null;

        public FireAndForgetFunction(String id, Callable r) {
            this.functionId = id;
            this.runnable = r;
        }

        public void execute(FunctionContext context) {
            HydraUtil.logInfo("Executing sleep function " + this.functionId);
            Object returnValue = null;
            try {
                returnValue = this.runnable.call();
                context.getResultSender().lastResult(returnValue);
            }
            catch (Exception e) {
                context.getResultSender().sendException((Throwable)e);
            }
            HydraUtil.logInfo("Completed Function Execution" + this.functionId);
        }

        public String getId() {
            return this.functionId;
        }
    }
}

