/*
 * Decompiled with CFR 0.152.
 */
package management.operations.ops;

import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.TimeoutException;
import hydra.DistributedConnectionMgr;
import hydra.Log;
import hydra.ProcessMgr;
import hydra.TestConfig;
import java.util.Iterator;
import java.util.Set;
import management.operations.OperationPrms;
import management.operations.OperationsBlackboard;
import management.operations.RegionKeyValueConfig;
import management.operations.events.EntryOperationEvents;
import management.util.HydraUtil;
import management.util.RegionUtil;
import util.RandomValues;
import util.TestException;
import util.TestHelper;

public class EntryOperations {
    protected static final int ADD_OPERATION = 1;
    protected static final int UPDATE_OPERATION = 2;
    protected static final int INVALIDATE_OPERATION = 3;
    protected static final int DESTROY_OPERATION = 4;
    protected static final int READ_OPERATION = 5;
    protected static final int LOCAL_INVALIDATE_OPERATION = 6;
    protected static final int LOCAL_DESTROY_OPERATION = 7;
    protected static final int REGION_CLOSE_OPERATION = 8;
    protected static final int CLEAR_OPERATION = 9;
    protected static final int PUT_IF_ABSENT_OPERATION = 10;
    protected static final int REMOVE_OPERATION = 11;
    protected static final int REPLACE_OPERATION = 12;
    protected static final String createCallbackPrefix = "Create event originated in pid ";
    protected static final String updateCallbackPrefix = "Update event originated in pid ";
    protected static final String invalidateCallbackPrefix = "Invalidate event originated in pid ";
    protected static final String destroyCallbackPrefix = "Destroy event originated in pid ";
    protected static final String regionInvalidateCallbackPrefix = "Region invalidate event originated in pid ";
    protected static final String regionDestroyCallbackPrefix = "Region destroy event originated in pid ";
    protected static final String memberIdString = " memberId=";
    protected static final String VmIDStr = "VmId_";
    protected int lowerThreshold = TestConfig.tab().intAt(OperationPrms.lowerThreshold, -1);
    protected int upperThreshold = TestConfig.tab().intAt(OperationPrms.upperThreshold, Integer.MAX_VALUE);
    protected RandomValues randomValues = new RandomValues();
    protected EntryOperationEvents operationRecorder = null;
    protected String opPrefix = "EntryOperations:";
    protected Region region;
    protected RegionKeyValueConfig keyValueConfig;

    public void setKeyValueConfig(RegionKeyValueConfig keyValueConfig) {
        this.keyValueConfig = keyValueConfig;
    }

    public EntryOperations(Region region) {
        this.operationRecorder = OperationsBlackboard.getBB();
        this.region = region;
    }

    public EntryOperations(Region r, EntryOperationEvents op) {
        this.region = r;
        this.operationRecorder = op;
    }

    public int getOperationMaintainSize() {
        int whichOp = this.getOperation(OperationPrms.entryOperations);
        int size = this.region.size();
        if (size >= this.upperThreshold) {
            whichOp = this.getOperation(OperationPrms.upperThresholdOperations);
        } else if (size <= this.lowerThreshold) {
            whichOp = this.getOperation(OperationPrms.lowerThresholdOperations);
        }
        return whichOp;
    }

    public int getOperation(Long whichPrm) {
        int op = 0;
        String operation = TestConfig.tab().stringAt(whichPrm);
        if ("add".equals(operation)) {
            op = 1;
        } else if ("update".equals(operation)) {
            op = 2;
        } else if ("invalidate".equals(operation)) {
            op = 3;
        } else if ("destroy".equals(operation)) {
            op = 4;
        } else if ("read".equals(operation)) {
            op = 5;
        } else if ("localInvalidate".equals(operation)) {
            op = 6;
        } else if ("localDestroy".equals(operation)) {
            op = 7;
        } else if ("putIfAbsent".equals(operation)) {
            op = 10;
        } else if ("remove".equals(operation)) {
            op = 11;
        } else if ("replace".equals(operation)) {
            op = 12;
        } else {
            throw new TestException("Unknown entry operation: " + operation);
        }
        return op;
    }

    public void add() {
        int op = 1;
        try {
            if (!this.opAllowed(op)) {
                throw new TestException("op " + this.opCodeToOpName(op) + " not allowed for region " + this.region.getFullPath());
            }
            String callback = this.getCallback();
            this.addObject(callback);
        }
        catch (Exception e) {
            this.handleException("Exception during " + this.opCodeToOpName(op), e, this.region);
        }
    }

    public void putIfAbsent() {
        int op = 10;
        try {
            if (!this.opAllowed(op)) {
                throw new TestException("op " + this.opCodeToOpName(op) + " not allowed for region " + this.region.getFullPath());
            }
            String callback = this.getCallback();
            this.putIfAbsent(callback);
        }
        catch (Exception e) {
            this.handleException("Exception during " + this.opCodeToOpName(op), e, this.region);
        }
    }

    public void update() {
        int op = 2;
        try {
            if (!this.opAllowed(op)) {
                throw new TestException("op " + this.opCodeToOpName(op) + " not allowed for region " + this.region.getFullPath());
            }
            String callback = this.getCallback();
            this.updateObject(callback);
        }
        catch (Exception e) {
            this.handleException("Exception during " + this.opCodeToOpName(op), e, this.region);
        }
    }

    public void replace() {
        int op = 12;
        try {
            if (!this.opAllowed(op)) {
                throw new TestException("op " + this.opCodeToOpName(op) + " not allowed for region " + this.region.getFullPath());
            }
            String callback = this.getCallback();
            this.replace(callback);
        }
        catch (Exception e) {
            this.handleException("Exception during " + this.opCodeToOpName(op), e, this.region);
        }
    }

    public void read() {
        int op = 5;
        try {
            if (!this.opAllowed(op)) {
                throw new TestException("op " + this.opCodeToOpName(op) + " not allowed for region " + this.region.getFullPath());
            }
            String callback = this.getCallback();
            this.readObject(callback);
        }
        catch (Exception e) {
            this.handleException("Exception during " + this.opCodeToOpName(op), e, this.region);
        }
    }

    public void invalidateLocal() {
        int op = 6;
        try {
            if (!this.opAllowed(op)) {
                throw new TestException("op " + this.opCodeToOpName(op) + " not allowed for region " + this.region.getFullPath());
            }
            String callback = this.getCallback();
            this.invalidateLocalObject(callback);
        }
        catch (Exception e) {
            this.handleException("Exception during " + this.opCodeToOpName(op), e, this.region);
        }
    }

    public void invalidate() {
        int op = 3;
        try {
            if (!this.opAllowed(op)) {
                throw new TestException("op " + this.opCodeToOpName(op) + " not allowed for region " + this.region.getFullPath());
            }
            String callback = this.getCallback();
            this.invalidateLocalObject(callback);
        }
        catch (Exception e) {
            this.handleException("Exception during " + this.opCodeToOpName(op), e, this.region);
        }
    }

    public void destroyLocal() {
        int op = 7;
        try {
            if (!this.opAllowed(op)) {
                throw new TestException("op " + this.opCodeToOpName(op) + " not allowed for region " + this.region.getFullPath());
            }
            String callback = this.getCallback();
            this.destroyLocalObject(callback);
        }
        catch (Exception e) {
            this.handleException("Exception during " + this.opCodeToOpName(op), e, this.region);
        }
    }

    public void destroy() {
        int op = 4;
        try {
            if (!this.opAllowed(op)) {
                throw new TestException("op " + this.opCodeToOpName(op) + " not allowed for region " + this.region.getFullPath());
            }
            String callback = this.getCallback();
            this.destroyObject(callback);
        }
        catch (Exception e) {
            this.handleException("Exception during " + this.opCodeToOpName(op), e, this.region);
        }
    }

    public void remove() {
        int op = 11;
        try {
            if (!this.opAllowed(op)) {
                throw new TestException("op " + this.opCodeToOpName(op) + " not allowed for region " + this.region.getFullPath());
            }
            String callback = this.getCallback();
            this.remove(callback);
        }
        catch (Exception e) {
            this.handleException("Exception during " + this.opCodeToOpName(op), e, this.region);
        }
    }

    protected void addObject(Object callback) {
        String key = (String)this.keyValueConfig.getNextKey();
        HydraUtil.logInfo(this.opPrefix + " Adding object in region named : " + this.region.getName() + " key=" + key + " callback " + callback);
        Object value = this.getObjectToAdd(key);
        this.region.create((Object)key, value, callback);
        RegionUtil.checkRegionKeyExistsValueExists(this.region, key, value);
        this.operationRecorder.entryAdded(this.region.getName(), key, value);
    }

    private void putIfAbsent(Object callback) {
        String key = this.getKeyWithProbability_25();
        HydraUtil.logInfo(this.opPrefix + " putting object IfAbsent in region named : " + this.region.getName() + " key=" + key + " callback " + callback);
        Object value = this.getObjectToAdd(key);
        this.region.putIfAbsent((Object)key, value);
        RegionUtil.checkRegionKeyExists(this.region, key);
        this.operationRecorder.entryPutIfAbsent(this.region.getName(), key, value);
    }

    private void updateObject(Object callback) {
        Set set = this.region.keys();
        Iterator iter = set.iterator();
        if (!iter.hasNext()) {
            Log.getLogWriter().info("updateObject: No names in region");
            return;
        }
        String key = (String)iter.next();
        HydraUtil.logInfo(this.opPrefix + " Updating object in region named : " + this.region.getName() + " key=" + key + " callback " + callback);
        Object value = this.getUpdateObject(key);
        Object oldValue = this.region.put((Object)key, value, callback);
        RegionUtil.checkRegionKeyExistsValueExists(this.region, key, value);
        this.operationRecorder.entryUpdated(this.region.getName(), key, value);
    }

    private void replace(Object callback) {
        String key = (String)this.keyValueConfig.getNextKey();
        Object value = this.getUpdateObject(key);
        HydraUtil.logInfo(this.opPrefix + " Replacing object in region named : " + this.region.getName() + " key=" + key + " callback " + callback);
        Object replaced = this.region.replace((Object)key, value);
        if (replaced != null) {
            RegionUtil.checkRegionKeyExistsValueExists(this.region, key, value);
        }
        this.operationRecorder.entryReplaced(this.region.getName(), key, value);
    }

    private void readObject(Object callback) {
        String name = this.getExistingKey();
        if (name == null) {
            Log.getLogWriter().info("readObject: No Key in region");
            return;
        }
        HydraUtil.logInfo(this.opPrefix + " Reading object in region named : " + this.region.getName() + " key=" + name + " callback " + callback);
        try {
            Object object = this.region.get((Object)name);
            Log.getLogWriter().info("readObject: got value for name " + name + ": " + TestHelper.toString(object));
            this.operationRecorder.entryRead(this.region.getName(), name);
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    private void invalidateLocalObject(Object callback) {
        String name = this.getExistingKey();
        if (name == null) {
            Log.getLogWriter().info("invalidateLocal: No Key in region");
            return;
        }
        HydraUtil.logInfo(this.opPrefix + " invalidateLocal object in region named : " + this.region.getName() + " key=" + name + " callback " + callback);
        try {
            this.region.localInvalidate((Object)name);
            RegionUtil.checkRegionValueDoesNotExists(this.region, name);
            this.operationRecorder.entryInvalidatedLocal(this.region.getName(), name);
        }
        catch (EntryNotFoundException e) {
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
        }
    }

    private void invalidateObject(Object callback) {
        String key = this.getExistingKey();
        if (key == null) {
            Log.getLogWriter().info("invalidate: No Key in region");
            return;
        }
        HydraUtil.logInfo(this.opPrefix + " invalidate object in region named : " + this.region.getName() + " key=" + key + " callback " + callback);
        try {
            this.region.invalidate((Object)key);
            RegionUtil.checkRegionValueDoesNotExists(this.region, key);
            this.operationRecorder.entryInvalidated(this.region.getName(), key);
        }
        catch (EntryNotFoundException e) {
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
        }
    }

    private void destroyLocalObject(Object callback) {
        String key = this.getExistingKey();
        if (key == null) {
            Log.getLogWriter().info("destroyLocal: No Key in region");
            return;
        }
        HydraUtil.logInfo(this.opPrefix + " destroying locally object in region named : " + this.region.getName() + " key=" + key + " callback " + callback);
        try {
            this.region.localDestroy((Object)key);
            RegionUtil.checkRegionKeyDoesNotExistsValueDoesNotExists(this.region, key);
            this.operationRecorder.entryDestroyedLocal(this.region.getName(), key);
        }
        catch (EntryNotFoundException e) {
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
        }
    }

    private void destroyObject(Object callback) {
        String key = this.getExistingKey();
        if (key == null) {
            Log.getLogWriter().info("destroy: No Key in region");
            return;
        }
        HydraUtil.logInfo(this.opPrefix + " destroying object in region named : " + this.region.getName() + " key=" + key + " callback " + callback);
        try {
            this.region.destroy((Object)key);
            RegionUtil.checkRegionKeyDoesNotExistsValueDoesNotExists(this.region, key);
            this.operationRecorder.entryDestroyed(this.region.getName(), key);
        }
        catch (EntryNotFoundException e) {
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
        }
    }

    private void remove(Object callback) {
        String key = this.getExistingKey();
        if (key == null) {
            Log.getLogWriter().info("remove: No Key in region");
            return;
        }
        HydraUtil.logInfo(this.opPrefix + " Removing object in region named : " + this.region.getName() + " key=" + key + " callback " + callback);
        try {
            this.region.remove((Object)key);
            RegionUtil.checkRegionKeyDoesNotExistsValueDoesNotExists(this.region, key);
            this.operationRecorder.entryRemoved(this.region.getName(), key);
        }
        catch (EntryNotFoundException e) {
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
        }
    }

    protected void doOp(int op, Object callback) {
        switch (op) {
            case 1: {
                this.addObject(callback);
                break;
            }
            case 3: {
                this.invalidateObject(callback);
                break;
            }
            case 4: {
                this.destroyObject(callback);
                break;
            }
            case 2: {
                this.updateObject(callback);
                break;
            }
            case 5: {
                this.readObject(callback);
                break;
            }
            case 6: {
                this.invalidateLocalObject(callback);
                break;
            }
            case 7: {
                this.destroyLocalObject(callback);
                break;
            }
            case 10: {
                this.putIfAbsent(callback);
                break;
            }
            case 11: {
                this.remove(callback);
                break;
            }
            case 12: {
                this.replace(callback);
                break;
            }
            default: {
                throw new TestException("Unknown operation " + op);
            }
        }
    }

    private String getCallback() {
        String memberId = null;
        if (DistributedConnectionMgr.getConnection() != null) {
            memberId = DistributedConnectionMgr.getConnection().getDistributedMember().toString();
        }
        String callback = createCallbackPrefix + ProcessMgr.getProcessId() + memberIdString + memberId;
        return callback;
    }

    public void doEntryOperation() {
        String callback = this.getCallback();
        int op = this.getOperationMaintainSize();
        try {
            if (this.opAllowed(op)) {
                this.doOp(op, callback);
            }
        }
        catch (RegionDestroyedException e) {
            if (HydraUtil.isConcurrentTest()) {
                HydraUtil.logInfo("Region " + this.region.getFullPath() + " is destroyed. Expected. Continuing the test ");
            }
            throw new TestException("RegionDestroyedException ", e);
        }
        catch (Exception e) {
            throw new TestException("Unknown Exception ", e);
        }
    }

    protected boolean opAllowed(int op) {
        RegionAttributes rAttr = this.region.getAttributes();
        return !rAttr.getDataPolicy().equals(DataPolicy.REPLICATE) || op != 6 && op != 7;
    }

    protected Object getObjectToAdd(String name) {
        return this.keyValueConfig.getValueForKey(name);
    }

    protected Object getUpdateObject(String name) {
        return this.keyValueConfig.getUpdatedValueForKey(this.region, name);
    }

    public String getKeyWithProbability_25() {
        Iterator it;
        Set aSet;
        String name = null;
        int randInt = TestConfig.tab().getRandGen().nextInt(1, 100);
        if (randInt <= 25 && (aSet = this.region.keySet()).size() > 0 && (it = aSet.iterator()).hasNext()) {
            name = (String)it.next();
        }
        if (name == null) {
            name = (String)this.keyValueConfig.getNextKey();
        }
        return name;
    }

    public String getExistingKey() {
        return (String)this.keyValueConfig.getUsedKey(this.region);
    }

    private void handleException(String string, Exception e, Region r) {
        if (HydraUtil.isConcurrentTest() && e instanceof RegionDestroyedException) {
            HydraUtil.logInfo(string + " RegionDestroy expected during concurrent test. Contnuing test ");
        }
        if (!(e instanceof RegionDestroyedException) || r.getAttributes().getScope().equals(Scope.LOCAL)) {
            throw new TestException(string, e);
        }
        HydraUtil.logInfo(string + " Region is already destroyed probably due to remote destroy, continuing with test");
    }

    private String opCodeToOpName(int op) {
        switch (op) {
            case 1: {
                return "add";
            }
            case 2: {
                return "update";
            }
            case 3: {
                return "invalidate";
            }
            case 4: {
                return "destroy";
            }
            case 5: {
                return "read";
            }
            case 6: {
                return "invalidateLocal";
            }
            case 7: {
                return "destroyLocal";
            }
            case 8: {
                return "close";
            }
            case 9: {
                return "clear";
            }
            case 10: {
                return "putIfAbsent";
            }
            case 11: {
                return "remove";
            }
            case 12: {
                return "replace";
            }
        }
        return "unknown";
    }
}

