/*
 * Decompiled with CFR 0.152.
 */
package management.operations.ops;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.query.CqAttributes;
import com.gemstone.gemfire.cache.query.CqAttributesFactory;
import com.gemstone.gemfire.cache.query.CqException;
import com.gemstone.gemfire.cache.query.CqExistsException;
import com.gemstone.gemfire.cache.query.CqListener;
import com.gemstone.gemfire.cache.query.CqQuery;
import com.gemstone.gemfire.cache.query.Index;
import com.gemstone.gemfire.cache.query.IndexExistsException;
import com.gemstone.gemfire.cache.query.IndexInvalidException;
import com.gemstone.gemfire.cache.query.IndexNameConflictException;
import com.gemstone.gemfire.cache.query.QueryInvalidException;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.RegionNotFoundException;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import management.operations.MgmtCqListener;
import management.operations.OperationPrms;
import management.operations.RegionKeyValueConfig;
import management.operations.events.CQAndIndexOperationEvents;
import management.util.HydraUtil;
import util.TestException;
import util.TestHelper;

public class CQAndIndexOperations {
    public static final int CQINDEXOP_CREATE_INDEX = 1;
    public static final int CQINDEXOP_REMOVE_INDEX = 2;
    public static final int CQINDEXOP_CREATE_CQ = 3;
    public static final int CQINDEXOP_STOP_CQ = 4;
    public static final String CQINDEX_CREATE_INDEX = "createIndex";
    public static final String CQINDEX_REMOVE_INDEX = "removeIndex";
    public static final String CQINDEX_CREATE_CQ = "createCq";
    public static final String CQINDEX_STOP_CQ = "stopCq";
    protected static String opPrefix = "CQIndexOperations: ";
    protected Region region = null;
    protected RegionKeyValueConfig config = null;
    protected CQAndIndexOperationEvents operationRecorder = null;
    private static String[] operatorArray = new String[]{"=", "<", ">", ">=", "<=", "<>"};

    public CQAndIndexOperations(Region region, RegionKeyValueConfig config, CQAndIndexOperationEvents op) {
        this.config = config;
        this.region = region;
        this.operationRecorder = op;
    }

    public void doCqIndexOperation() {
        String opStr = TestConfig.tab().stringAt(OperationPrms.cqIndexOps);
        int op = -1;
        if (CQINDEX_CREATE_INDEX.equals(opStr)) {
            op = 1;
        } else if (CQINDEX_REMOVE_INDEX.equals(opStr)) {
            op = 2;
        } else if (CQINDEX_CREATE_CQ.equals(opStr)) {
            op = 3;
        } else if (CQINDEX_STOP_CQ.equals(opStr)) {
            op = 4;
        }
        switch (op) {
            case 1: {
                this._createIndex();
                break;
            }
            case 2: {
                this.removeIndex();
                break;
            }
            case 3: {
                this._createCq();
                break;
            }
            case 4: {
                this.stopCq();
                break;
            }
            default: {
                HydraUtil.logInfo(opPrefix + "Unknown operation code " + op);
            }
        }
    }

    public String createCq() {
        return this._createCq();
    }

    public void removeIndex(String name) {
        QueryService queryService = this.region.getCache().getQueryService();
        Index index = queryService.getIndex(this.region, name);
        if (index == null) {
            throw new TestException("Index named " + name + " not found");
        }
        this._removeIndex(index);
    }

    public String createIndex() {
        return this._createIndex();
    }

    public void stopCq(String name) {
        QueryService queryService = this.region.getCache().getQueryService();
        CqQuery query = queryService.getCq(name);
        if (query == null) {
            throw new TestException("CqQuery named " + name + " not found");
        }
        this._stopCq(query);
    }

    private void stopCq() {
        QueryService queryService = this.region.getCache().getQueryService();
        try {
            CqQuery[] queries = queryService.getCqs(this.region.getName());
            if (queries != null) {
                int randomNum = TestConfig.tab().getRandGen().nextInt(queries.length - 1);
                CqQuery query = queries[randomNum];
                this._stopCq(query);
            } else {
                HydraUtil.logInfo("No queries found for region " + this.region.getName());
            }
        }
        catch (CqException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    private void _stopCq(CqQuery query) {
        try {
            query.stop();
            HydraUtil.logInfo(opPrefix + " stopped cq named " + query.getName());
            this.operationRecorder.cqStopped(query.getName(), query.getQueryString());
        }
        catch (CqException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    private String _createCq() {
        QueryService queryService = this.region.getCache().getQueryService();
        StringBuilder queryString = new StringBuilder("select * from " + this.region.getFullPath() + "  where ");
        List<String> columnNames = this.config.getValueColumns();
        String column = columnNames.get(TestConfig.tab().getRandGen().nextInt(columnNames.size() - 1));
        String operator = operatorArray[TestConfig.tab().getRandGen().nextInt(operatorArray.length - 1)];
        Integer randomValue = TestConfig.tab().getRandGen().nextInt(this.config.getMaxKeySize());
        queryString.append(column);
        queryString.append(" ").append(operator);
        queryString.append(" ").append(randomValue);
        CqAttributesFactory attributesf = new CqAttributesFactory();
        attributesf.addCqListener((CqListener)new MgmtCqListener());
        CqAttributes cqAttr = attributesf.create();
        String operatorName = "";
        if ("=".equals(operator)) {
            operatorName = "EQUALS";
        } else if (">".equals(operator)) {
            operatorName = "GRTHAN";
        } else if ("<".equals(operator)) {
            operatorName = "LESSTHAN";
        } else if (">=".equals(operator)) {
            operatorName = "GRTHANOREQ";
        } else if ("<=".equals(operator)) {
            operatorName = "LESSTHANOREQ";
        } else if ("<>".equals(operator)) {
            operatorName = "NOTEQUALS";
        }
        String name = "cq_" + this.region.getName() + "_" + column + "_" + operatorName + "_" + randomValue;
        try {
            queryService.newCq(name, queryString.toString(), cqAttr);
            HydraUtil.logInfo(opPrefix + " created cq named " + name + " with string <" + queryString.toString() + ">");
            this.operationRecorder.cqCreated(name, queryString.toString(), null);
            return name;
        }
        catch (QueryInvalidException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (CqExistsException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (CqException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    private void removeIndex() {
        QueryService queryService = this.region.getCache().getQueryService();
        Collection indexes = queryService.getIndexes(this.region);
        if (indexes != null && indexes.size() > 0) {
            int randomNum = TestConfig.tab().getRandGen().nextInt(0, indexes.size() - 1);
            Index index = (Index)indexes.toArray()[randomNum];
            this._removeIndex(index);
        } else {
            HydraUtil.logInfo("No indexes found for region " + this.region.getName());
        }
    }

    private void _removeIndex(Index index) {
        QueryService queryService = this.region.getCache().getQueryService();
        try {
            queryService.removeIndex(index);
            HydraUtil.logInfo(opPrefix + " removed index named " + index.getName());
            this.operationRecorder.indexRemoved(index.getName());
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    private String _createIndex() {
        QueryService queryService = this.region.getCache().getQueryService();
        ArrayList indexes = queryService.getIndexes(this.region);
        if (indexes == null) {
            indexes = new ArrayList();
        }
        List<String> columnNames = this.config.getValueColumns();
        ArrayList<String> indexList = new ArrayList<String>();
        for (String s : columnNames) {
            boolean flagFound = false;
            for (Index x : indexes) {
                if (!x.getName().equals("indexForColumn" + s + "ForRegion" + this.region.getName())) continue;
                flagFound = true;
            }
            if (flagFound) continue;
            indexList.add(s);
        }
        if (indexList.size() != 0) {
            int randomNum = TestConfig.tab().getRandGen().nextInt(0, indexList.size() - 1);
            String selected = (String)indexList.get(randomNum);
            String indexName = "indexForColumn" + selected + "ForRegion" + this.region.getName();
            try {
                queryService.createIndex(indexName, selected, this.region.getFullPath());
                HydraUtil.logInfo(opPrefix + " created index named " + indexName + " on column " + selected + " for region " + this.region.getName());
                this.operationRecorder.indexCreated(indexName, selected, this.region.getFullPath());
                return indexName;
            }
            catch (RegionNotFoundException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (IndexInvalidException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (IndexNameConflictException e) {
                HydraUtil.logInfo("Index named indexForColumn" + selected + " already exists");
            }
            catch (IndexExistsException e) {
                HydraUtil.logInfo("Index named indexForColumn" + selected + " already exists");
            }
            catch (UnsupportedOperationException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        } else {
            HydraUtil.logInfo("All properties have been used up. New index can not be created.. skipping the iteration.");
            return null;
        }
        return null;
    }

    protected String fromClause() {
        return this.region.getFullPath();
    }
}

