/*
 * Decompiled with CFR 0.152.
 */
package management.operations;

import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.TimeoutException;
import hydra.Log;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import management.operations.OperationPrms;
import management.operations.RegionKeyValueConfig;
import objects.ObjectHelper;
import util.BaseValueHolder;
import util.NameFactory;
import util.RandomValues;
import util.TestException;
import util.TestHelper;
import util.ValueHolder;

public class DefaultRegionKeyValueConfig
implements RegionKeyValueConfig {
    protected RandomValues randomValues = new RandomValues();

    @Override
    public List<String> getValueColumns() {
        String type = OperationPrms.getObjectType();
        if ("valueHolder".equals(type)) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("myVersion");
            list.add("myValue");
            list.add("extraObject");
            list.add("modVal");
            return list;
        }
        return null;
    }

    @Override
    public Object getNextKey() {
        return NameFactory.getNextPositiveObjectName();
    }

    @Override
    public Object getValueForKey(Object key) {
        String type = OperationPrms.getObjectType();
        if ("valueHolder".equals(type)) {
            ValueHolder anObj = new ValueHolder(key, this.randomValues);
            return anObj;
        }
        int index = -1;
        String name = (String)key;
        String[] array = name.split("_");
        index = Integer.parseInt(array[1]);
        Object typedObject = ObjectHelper.createObject(type, index);
        return typedObject;
    }

    @Override
    public Object getUpdatedValueForKey(Region region, Object key) {
        String type = OperationPrms.getObjectType();
        if ("valueHolder".equals(type)) {
            ValueHolder anObj = null;
            BaseValueHolder newObj = null;
            try {
                anObj = (ValueHolder)region.get(key);
            }
            catch (CacheLoaderException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (TimeoutException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            newObj = anObj == null ? new ValueHolder(key, this.randomValues) : anObj.getAlternateValueHolder(this.randomValues);
            return newObj;
        }
        Object val = ObjectHelper.createObject(type, 0);
        return val;
    }

    @Override
    public Object getUsedKey(Region region) {
        Set set = region.keys();
        if (set.size() == 0) {
            Log.getLogWriter().info("getExistingKey: No names in region");
            return null;
        }
        long maxNames = NameFactory.getPositiveNameCounter();
        if (maxNames <= 0L) {
            Log.getLogWriter().info("getExistingKey: max positive name counter is " + maxNames);
            return null;
        }
        String name = NameFactory.getObjectNameForCounter(TestConfig.tab().getRandGen().nextInt(1, (int)maxNames));
        return name;
    }

    @Override
    public int getMaxKeySize() {
        return 0;
    }
}

