/*
 * Decompiled with CFR 0.152.
 */
package management.cli;

import com.gemstone.gemfire.management.cli.Result;
import com.gemstone.gemfire.management.internal.cli.GfshParser;
import com.gemstone.gemfire.management.internal.cli.result.CommandResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import management.cli.TestableGfsh;
import management.util.HydraUtil;

public class CommandOutputValidator {
    private static final String[] EXCEPTION = new String[]{"Exception", "EXCEPTION", "exception"};
    private static final String[] ERROR = new String[]{"error", "Error", "ERROR"};
    private static final String[] NULL = new String[]{"null", "Null", "NULL"};
    private CommandResult result;
    private TestableGfsh shell;
    private String command;
    private String presentationStr;
    int expectedRows = -1;
    int expectedColumns = -1;
    StringValidator stringValidator = null;
    public static int EXPECT_ERRORSTRING_INOUTPUT = 2;
    public static int EXPECT_EXCEPTIONSTRING_INOUTPUT = 4;
    public static int EXPECT_NULLTRING_INOUTPUT = 8;
    public static int DEFAULT = 1;

    public CommandOutputValidator(TestableGfsh shell, Object[] output) {
        this(shell, output, DEFAULT);
    }

    public CommandOutputValidator(TestableGfsh shell, Object[] output, int errorStrings) {
        this.shell = shell;
        Map completorOutput = (Map)output[1];
        Map commandOutput = (Map)output[0];
        this.presentationStr = (String)output[2];
        HydraUtil.logInfo("Command Output : " + commandOutput);
        for (Object key : commandOutput.keySet()) {
            Object value = commandOutput.get(key);
            if (!(value instanceof CommandResult)) continue;
            this.result = (CommandResult)value;
            this.command = (String)key;
            HydraUtil.logInfo("Adding validator for command : " + this.command);
        }
        this.stringValidator = new StringValidator(errorStrings);
    }

    public CommandOutputValidator addUnExpectedErrorString(String str) {
        this.stringValidator.dontExpectString(str);
        return this;
    }

    public CommandOutputValidator addExpectedString(String str) {
        this.stringValidator.expectString(str);
        return this;
    }

    public CommandOutputValidatorResult validate() {
        CommandOutputValidatorResult validationResult = new CommandOutputValidatorResult();
        validationResult.command = this.command;
        validationResult.result = true;
        List<String> stringerrors = this.stringValidator.validate(this.presentationStr);
        if (stringerrors.size() > 0) {
            validationResult.result = false;
            validationResult.errorStrings.addAll(stringerrors);
        }
        if (!this.result.getStatus().equals((Object)Result.Status.OK)) {
            validationResult.result = false;
            validationResult.errorStrings.add("Result status is not OK : " + this.result.getStatus());
        }
        return validationResult;
    }

    private void checkStrings(List<String> stringPatterns, CommandOutputValidatorResult validationResult, boolean patternExpected) {
        int violations = 0;
        for (String s : stringPatterns) {
            if (patternExpected) {
                if (this.presentationStr.contains(s)) continue;
                validationResult.errorStrings.add(s);
                ++violations;
                continue;
            }
            if (!this.presentationStr.contains(s)) continue;
            validationResult.errorStrings.add(s);
            ++violations;
        }
        if (violations > 0) {
            validationResult.result = false;
        }
    }

    public static void main(String[] args) {
        StringValidator validator = new StringValidator(DEFAULT);
        String[] patterns = new String[]{"Command executed successfully", "Command {0} executed successfully", "Command {0} executed successfully in {1} ms.", "Cannot create directory - {0}"};
        String[] messages = new String[]{"Command executed successfully", "Command netstat executed successfully", "Command netstat executed successfully in 3214324 ms.", "\n\n\n  s;kg;lfdsg Cannot create directory - mydirectory \n\n skgf \n", "\n\t\tn Exception \n\tError \n  Null \n"};
        validator.expectString(patterns[0]);
        System.out.println("Match for(" + patterns[0] + ") : true) : " + validator.validate(messages[0]));
        System.out.println();
        validator = new StringValidator(DEFAULT);
        validator.expectString(patterns[1]);
        System.out.println("Match for(" + patterns[1] + ") : true) : " + validator.validate(messages[1]));
        System.out.println();
        validator = new StringValidator(DEFAULT);
        validator.expectString(patterns[2]);
        System.out.println("Match for(" + patterns[2] + ") : true) : " + validator.validate(messages[2]));
        System.out.println();
        validator = new StringValidator(DEFAULT);
        validator.dontExpectString(patterns[3]);
        System.out.println("Match for(" + patterns[3] + ") : true) : " + validator.validate(messages[3]));
        System.out.println();
        validator = new StringValidator(DEFAULT);
        System.out.println("Match for(default) : true) : " + validator.validate(messages[4]));
        System.out.println();
        validator = new StringValidator(EXPECT_ERRORSTRING_INOUTPUT);
        System.out.println("Match for(allow error) : true) : " + validator.validate(messages[4]));
        System.out.println();
        validator = new StringValidator(EXPECT_EXCEPTIONSTRING_INOUTPUT);
        System.out.println("Match for(allow exception) : true) : " + validator.validate(messages[4]));
        System.out.println();
        validator = new StringValidator(EXPECT_NULLTRING_INOUTPUT);
        System.out.println("Match for(allow null) : true) : " + validator.validate(messages[4]));
        System.out.println();
        validator = new StringValidator(EXPECT_NULLTRING_INOUTPUT | EXPECT_EXCEPTIONSTRING_INOUTPUT);
        System.out.println("Match for(allow null, exception) : true) : " + validator.validate(messages[4]));
        System.out.println();
        validator = new StringValidator(EXPECT_NULLTRING_INOUTPUT | EXPECT_EXCEPTIONSTRING_INOUTPUT | EXPECT_ERRORSTRING_INOUTPUT);
        System.out.println("Match for(allow null, exception,error) : true) : " + validator.validate(messages[4]));
    }

    public static class StringValidator {
        private static final String[] EXCEPTION = new String[]{"Exception", "EXCEPTION", "exception"};
        private static final String[] ERROR = new String[]{"error", "Error", "ERROR"};
        private static final String[] NULL = new String[]{"null", "Null", "NULL"};
        private List<StringPattern> patternList = new ArrayList<StringPattern>();
        public String matchAgainst = null;

        public static boolean configured(int option, int specification) {
            int result = specification & (option & 0xFFFFFFFF);
            return result == specification;
        }

        public StringValidator(int strings) {
            boolean allowExceptionStrings = false;
            boolean allowErrorStrings = false;
            boolean allowNullStrings = false;
            if (StringValidator.configured(strings, DEFAULT)) {
                allowExceptionStrings = false;
                allowErrorStrings = false;
                allowNullStrings = false;
            } else {
                if (StringValidator.configured(strings, EXPECT_ERRORSTRING_INOUTPUT)) {
                    allowErrorStrings = true;
                }
                if (StringValidator.configured(strings, EXPECT_EXCEPTIONSTRING_INOUTPUT)) {
                    allowExceptionStrings = true;
                }
                if (StringValidator.configured(strings, EXPECT_NULLTRING_INOUTPUT)) {
                    allowNullStrings = true;
                }
            }
            if (!allowExceptionStrings) {
                for (String s : EXCEPTION) {
                    this.dontExpectString(s);
                }
            }
            if (!allowErrorStrings) {
                for (String s : ERROR) {
                    this.dontExpectString(s);
                }
            }
            if (!allowNullStrings) {
                for (String s : NULL) {
                    this.dontExpectString(s);
                }
            }
        }

        public StringValidator expectString(String s) {
            this.patternList.add(new StringPattern(s, true));
            return this;
        }

        public StringValidator dontExpectString(String s) {
            this.patternList.add(new StringPattern(s, false));
            return this;
        }

        public List<String> validate(String output) {
            ArrayList<String> list = new ArrayList<String>();
            for (StringPattern p : this.patternList) {
                if (p.expected) {
                    if (!StringPattern.contains(p.patternString, output)) {
                        System.out.println("For expected string <" + p.patternString + "> : adding for " + output);
                        list.add(p.originalString);
                    }
                }
                if (p.expected) continue;
                if (!StringPattern.contains(p.patternString, output)) continue;
                list.add(p.originalString);
            }
            return list;
        }
    }

    public static class StringPattern {
        public boolean expected;
        public String originalString;
        public String patternString;
        public boolean isRegex;

        public StringPattern(String str, boolean expected) {
            this.expected = expected;
            String finalPattern = null;
            if (str.contains("{0}")) {
                finalPattern = str.replace("{0}", "\\w+");
                this.isRegex = true;
            }
            if (str.contains("{1}")) {
                finalPattern = finalPattern.replace("{1}", "\\w+");
                this.isRegex = true;
            }
            if (str.contains("{2}")) {
                finalPattern = finalPattern.replace("{2}", "\\w+");
                this.isRegex = true;
            }
            if (finalPattern == null) {
                finalPattern = str;
                this.isRegex = false;
            }
            this.patternString = finalPattern;
            this.originalString = str;
        }

        static boolean match(String template, String s) {
            Pattern memberPattern = Pattern.compile(template);
            Matcher match = memberPattern.matcher(s);
            return match.find();
        }

        static boolean contains(String template, String s) {
            String[] a = s.split(template);
            return a.length == 0 || a.length == 2;
        }
    }

    public static class CommandOutputValidatorResult {
        public List<String> errorStrings = new ArrayList<String>();
        public boolean result;
        public String command;

        public String getExceptionMessage() {
            StringBuilder sb = new StringBuilder();
            sb.append("Command output validation failed for command <" + this.command + ">").append(GfshParser.LINE_SEPARATOR);
            sb.append("ErrorStrings : ").append(GfshParser.LINE_SEPARATOR);
            int i = 0;
            for (String s : this.errorStrings) {
                sb.append("\t").append(i++).append("#. ").append(s).append(GfshParser.LINE_SEPARATOR);
            }
            return sb.toString();
        }
    }
}

