/*
 * Decompiled with CFR 0.152.
 */
package koch;

import hydra.HydraRuntimeException;
import hydra.HydraThreadLocal;
import koch.KochPrms;
import koch.MCache;

public class BareTest {
    protected static HydraThreadLocal localcache = new HydraThreadLocal();

    public void loadResults(MCache cache) {
        int size = KochPrms.getObjSize();
        int type = KochPrms.getObjType();
        int n = KochPrms.getNumObjsToDo();
        long start = System.currentTimeMillis();
        switch (type) {
            case 0: {
                byte[] myBytes = new byte[size];
                for (int i = 0; i < n; ++i) {
                    cache.putItem(String.valueOf(i), myBytes);
                }
                break;
            }
            case 1: {
                for (int i = 0; i < n; ++i) {
                    cache.putItem(String.valueOf(i), String.valueOf(i));
                }
                break;
            }
            default: {
                throw new HydraRuntimeException("Should not happen");
            }
        }
        long end = System.currentTimeMillis();
        long total = end - start;
        System.out.println(" To load: " + n + " into cache took " + total + " millis " + total / (long)n + " apiece");
    }

    public void readResults(MCache cache) {
        int type = KochPrms.getObjType();
        int n = KochPrms.getNumObjsToDo();
        long start = System.currentTimeMillis();
        switch (type) {
            case 0: {
                int i;
                for (i = 0; i < n; ++i) {
                    byte[] byArray = (byte[])cache.getItem(String.valueOf(i));
                }
                break;
            }
            case 1: {
                int i;
                for (i = 0; i < n; ++i) {
                    String str = (String)cache.getItem(String.valueOf(i));
                    if (str.equals(String.valueOf(i))) continue;
                    throw new HydraRuntimeException("Bad value: " + str);
                }
                break;
            }
            default: {
                throw new HydraRuntimeException("Should not happen");
            }
        }
        long end = System.currentTimeMillis();
        long total = end - start;
        System.out.println(" To read : " + n + " from cache took " + total + " millis " + total / (long)n + " apiece");
    }

    public static void opencacheTask() {
        localcache.set(new MCache());
    }

    public static void loadcacheTask() {
        BareTest test = new BareTest();
        test.loadResults((MCache)localcache.get());
    }

    public static void readcacheTask() {
        BareTest test = new BareTest();
        test.readResults((MCache)localcache.get());
    }

    public static void closecacheTask() {
        MCache cache = (MCache)localcache.get();
        cache.closeCache();
        localcache.set(null);
    }
}

