/*
 * Decompiled with CFR 0.152.
 */
package jta;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.TransactionListener;
import com.gemstone.gemfire.cache.TransactionWriter;
import hydra.CacheHelper;
import hydra.ConfigPrms;
import hydra.Log;
import hydra.RegionHelper;
import hydra.TestConfig;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import javax.naming.Context;
import javax.sql.DataSource;
import javax.transaction.RollbackException;
import javax.transaction.UserTransaction;
import jta.JTAUtil;
import jta.JtaBB;
import jta.JtaCacheTestUtil;
import jta.JtaPrms;
import util.TestException;
import util.TestHelper;

public class JtaDataSourceHydraTest {
    private static final int PUT_OPERATION = 1;
    private static final int GET_OPERATION = 2;
    private static final int UPDATE_OPERATION = 3;

    public static void startTask() {
        try {
            Cache cache = CacheHelper.createCacheFromXml(JtaPrms.getCacheXmlFile());
            JTAUtil.createTable("JtaDataSourceTest");
            JTAUtil.listTableData("JtaDataSourceTest");
            Log.getLogWriter().info("Created table ");
            CacheHelper.closeCache();
        }
        catch (Exception e) {
            throw new TestException("Error in Cache Initialization in StartTask " + TestHelper.getStackTrace(e));
        }
    }

    public static synchronized void initTask() {
        Cache cache = CacheHelper.getCache();
        if (cache == null) {
            try {
                TransactionWriter txWriter;
                cache = CacheHelper.createCacheFromXml(JtaPrms.getCacheXmlFile());
                TransactionListener txListener = JtaPrms.getTxListener();
                if (txListener != null) {
                    cache.getCacheTransactionManager().setListener(txListener);
                    Log.getLogWriter().info("Installed TransactionListener " + txListener);
                }
                if ((txWriter = JtaPrms.getTxWriter()) != null) {
                    cache.getCacheTransactionManager().setWriter(txWriter);
                    Log.getLogWriter().info("Installed TransactionWriter " + txWriter);
                }
            }
            catch (Exception e) {
                throw new TestException("Error in Cache Initialization in initTask " + TestHelper.getStackTrace(e));
            }
        }
        JtaCacheTestUtil.createRootRegions();
    }

    public static void testTask() {
        UserTransaction utx = null;
        try {
            Cache cache = CacheHelper.getCache();
            Context ctx = cache.getJNDIContext();
            utx = (UserTransaction)ctx.lookup("java:/UserTransaction");
            Log.getLogWriter().info("Starting Transaction ");
            utx.begin();
            new JtaDataSourceHydraTest().doRandomOperation();
            utx.commit();
            Log.getLogWriter().info("Committed Transaction ");
        }
        catch (RollbackException re) {
            Log.getLogWriter().info("Transaction did not commit successfully, rolled back ", (Throwable)re);
        }
        catch (Exception e) {
            if (utx != null) {
                try {
                    utx.rollback();
                    Log.getLogWriter().info("explicitly Rolledback Transaction ");
                }
                catch (Exception e1) {
                    throw new TestException("Error in Transaction on rollback in testTask " + TestHelper.getStackTrace(e1));
                }
            }
            throw new TestException("Error in testTask " + TestHelper.getStackTrace(e));
        }
    }

    public static void testCacheAndDBTask() {
        UserTransaction utx = null;
        try {
            Cache cache = CacheHelper.getCache();
            Context ctx = cache.getJNDIContext();
            utx = (UserTransaction)ctx.lookup("java:/UserTransaction");
            Log.getLogWriter().info("Starting Transaction ");
            utx.begin();
            new JtaDataSourceHydraTest().doRandomCacheAndDBOperation();
            utx.commit();
            Log.getLogWriter().info("Committed Transaction ");
        }
        catch (RollbackException re) {
            Log.getLogWriter().info("Transaction did not commit successfully, rolled back ", (Throwable)re);
        }
        catch (Exception e) {
            if (utx != null) {
                try {
                    utx.rollback();
                    Log.getLogWriter().info("Explicitly Rolledback Transaction ");
                }
                catch (Exception e1) {
                    throw new TestException("Error in Transaction on rollback in testTask " + TestHelper.getStackTrace(e1));
                }
            }
            throw new TestException("Error in testTask " + TestHelper.getStackTrace(e));
        }
    }

    public static void closeTask() {
        JtaBB.getBB().printSharedCounters();
    }

    public static void endTask() {
        Cache cache = CacheHelper.getCache();
        try {
            if (cache == null) {
                cache = CacheHelper.createCacheFromXml(JtaPrms.getCacheXmlFile());
            }
            JTAUtil.listTableData("JtaDataSourceTest");
            JTAUtil.destroyTable("JtaDataSourceTest");
            Log.getLogWriter().info("Destroyed table ");
        }
        catch (Exception e) {
            throw new TestException("Error in endTask " + TestHelper.getStackTrace(e));
        }
    }

    private void doRandomOperation() throws Exception {
        Context ctx = CacheHelper.getCache().getJNDIContext();
        DataSource ds = null;
        try {
            ds = (DataSource)ctx.lookup("java:/XAPooledDataSource");
        }
        catch (Exception e) {
            Log.getLogWriter().info("Failed to get DataSource, The Exception is " + e);
            throw e;
        }
        int total = TestConfig.tab().intAt(JtaPrms.numberOfEvents);
        block7: for (int count = 0; count < total; ++count) {
            int whichOp = JtaCacheTestUtil.getRandomOperation(JtaPrms.entryOperations);
            switch (whichOp) {
                case 1: {
                    this.doPutOperation(ds);
                    continue block7;
                }
                case 2: {
                    this.doGetOperation(ds);
                    continue block7;
                }
                case 3: {
                    this.doUpdateOperation(ds);
                    continue block7;
                }
                default: {
                    throw new TestException("Unknown operation " + whichOp);
                }
            }
        }
    }

    private void doRandomCacheAndDBOperation() throws Exception {
        Cache cache = CacheHelper.getCache();
        Context ctx = cache.getJNDIContext();
        String regionName = RegionHelper.getRegionDescription(ConfigPrms.getRegionConfig()).getRegionName();
        Region region = RegionHelper.getRegion(regionName);
        DataSource ds = null;
        try {
            ds = (DataSource)ctx.lookup("java:/XAPooledDataSource");
        }
        catch (Exception e) {
            Log.getLogWriter().info("Failed to get DataSource, The Exception is " + e);
            throw e;
        }
        int total = TestConfig.tab().intAt(JtaPrms.numberOfEvents);
        block6: for (int count = 0; count < total; ++count) {
            int whichOp = JtaCacheTestUtil.getRandomOperation(JtaPrms.entryOperations);
            switch (whichOp) {
                case 1: {
                    new JtaCacheTestUtil().doPutOperation(region);
                    continue block6;
                }
                case 3: {
                    this.doUpdateOperation(ds);
                    continue block6;
                }
                default: {
                    throw new TestException("Unknown operation " + whichOp);
                }
            }
        }
    }

    private void doUpdateOperation(DataSource ds) throws SQLException {
        Connection conn = null;
        Statement sm = null;
        ResultSet rs = null;
        try {
            conn = ds.getConnection();
            sm = conn.createStatement();
            int i = new Random().nextInt(1000);
            String newName = "" + new Random().nextLong();
            String sql = "update JtaDataSourceTest set name = '" + newName + "' where id = " + i;
            sm.execute(sql);
            Log.getLogWriter().info("doUpdateOperation: " + sql);
            JtaBB.incrementCounter("DoUpdateOperation", JtaBB.NUM_UPDATE);
        }
        catch (SQLException e) {
            Log.getLogWriter().info("Failed in doUpdateOperation, The exception is " + e);
            throw e;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (sm != null) {
                    sm.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                Log.getLogWriter().info("Failed in doUpdateOperation");
                throw e1;
            }
            rs = null;
            sm = null;
            conn = null;
        }
    }

    private void doGetOperation(DataSource ds) throws SQLException {
        Connection conn = null;
        Statement sm = null;
        ResultSet rs = null;
        try {
            conn = ds.getConnection();
            sm = conn.createStatement();
            int i = new Random().nextInt(1000);
            String sql = "select name from JtaDataSourceTest where id = " + i;
            rs = sm.executeQuery(sql);
            if (rs.next()) {
                Log.getLogWriter().info("Got value for id " + i + " as " + rs.getString(1));
            }
            JtaBB.incrementCounter("DoGetOperation", JtaBB.NUM_GET);
        }
        catch (SQLException e) {
            Log.getLogWriter().info("doGetOperation failed ");
            throw e;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (sm != null) {
                    sm.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                Log.getLogWriter().info("doGetOperation failed, The Exception is  " + e1);
                throw e1;
            }
            rs = null;
            sm = null;
            conn = null;
        }
    }

    private void doPutOperation(DataSource ds) {
        JtaBB.incrementCounter("DoPutOperation", JtaBB.NUM_CREATE);
    }
}

