/*
 * Decompiled with CFR 0.152.
 */
package jta;

import com.gemstone.gemfire.cache.TransactionEvent;
import com.gemstone.gemfire.cache.TransactionListener;
import hydra.Log;
import hydra.RemoteTestModule;
import hydra.blackboard.SharedMap;
import java.sql.Connection;
import jta.GemFireTxCallback;
import jta.JtaBB;
import util.AbstractListener;
import util.TestException;
import util.TestHelper;

public class GemFireTxListener
extends AbstractListener
implements TransactionListener {
    public void afterCommit(TransactionEvent event) {
        this.logTxEvent("afterCommit", event);
        try {
            Connection conn = GemFireTxCallback.getDBConnection();
            Log.getLogWriter().info("COMMITTING database tx ...");
            conn.commit();
            Log.getLogWriter().info("COMMITTED database tx.");
        }
        catch (Exception e) {
            this.throwException("afterCommit() caught " + e);
        }
    }

    public void afterRollback(TransactionEvent event) {
        this.logTxEvent("afterRollback", event);
        try {
            Connection conn = GemFireTxCallback.getDBConnection();
            Log.getLogWriter().info("ROLLING BACK database tx ...");
            conn.rollback();
            Log.getLogWriter().info("ROLLED BACK database tx.");
        }
        catch (Exception e) {
            this.throwException("afterRollback() caught " + e);
        }
    }

    public void afterFailedCommit(TransactionEvent event) {
        this.logTxEvent("afterFailedCommit", event);
        try {
            Connection conn = GemFireTxCallback.getDBConnection();
            Log.getLogWriter().info("ROLLING BACK database tx ...");
            conn.rollback();
            Log.getLogWriter().info("ROLLED BACK database tx.");
        }
        catch (Exception e) {
            this.throwException("afterFailedCommit() caught " + e);
        }
    }

    public void close() {
        Log.getLogWriter().info("TxListener: close()");
    }

    protected void throwException(String errStr) {
        StringBuffer qualifiedErrStr = new StringBuffer();
        qualifiedErrStr.append("Exception reported in " + RemoteTestModule.getMyClientName() + "\n");
        qualifiedErrStr.append(errStr);
        errStr = qualifiedErrStr.toString();
        SharedMap aMap = JtaBB.getBB().getSharedMap();
        aMap.put(TestHelper.EVENT_ERROR_KEY, errStr + " " + TestHelper.getStackTrace());
        Log.getLogWriter().info(errStr);
        throw new TestException(errStr);
    }
}

