/*
 * Decompiled with CFR 0.152.
 */
package hydratest.version.upgrade;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.internal.GemFireVersion;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.ClientVmMgr;
import hydra.ClientVmNotFoundException;
import hydra.ConfigPrms;
import hydra.Log;
import hydra.MasterController;
import hydratest.version.upgrade.UpgradePrms;

public class UpgradeClient {
    public static void openCacheTask() {
        CacheHelper.createCache(ConfigPrms.getCacheConfig());
        String bridgeConfig = ConfigPrms.getBridgeConfig();
        if (bridgeConfig != null) {
            BridgeHelper.startBridgeServer(bridgeConfig);
        }
    }

    public static void reportCacheTask() {
        Cache c = CacheHelper.getCache();
        String s = "UPGRADE: GemFire Version " + GemFireVersion.getGemFireVersion();
        Log.getLogWriter().info(s);
    }

    public static void bounceTask() throws ClientVmNotFoundException {
        MasterController.sleepForMs(UpgradePrms.getSleepSec() * 1000);
        ClientVmMgr.stopAsync("Killing self at version: " + GemFireVersion.getGemFireVersion(), -20, -30);
    }

    public static void closeCacheTask() {
        CacheHelper.closeCache();
    }
}

