/*
 * Decompiled with CFR 0.152.
 */
package hydratest.security;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.distributed.DistributedSystem;
import hydra.BasePrms;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.ConfigPrms;
import hydra.DistributedSystemHelper;
import hydra.EnvHelper;
import hydra.FileUtil;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.RegionHelper;
import hydra.RemoteTestModule;
import hydratest.security.ClientPrms;
import hydratest.security.PeerPrms;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public class SecurityTestClient {
    private static Region TheRegion;

    public static void connectTask() {
        DistributedSystem d = DistributedSystemHelper.connect();
        Properties p = DistributedSystemHelper.getDistributedSystem().getSecurityProperties();
        String s = "Connected with security properties: " + p;
        Log.getLogWriter().info(s);
        d.getLogWriter().info(s);
        d.getSecurityLogWriter().info(s);
    }

    public static synchronized void openCacheTask() {
        if (TheRegion == null) {
            String cacheConfig = ConfigPrms.getCacheConfig();
            String regionConfig = ConfigPrms.getRegionConfig();
            String bridgeConfig = ConfigPrms.getBridgeConfig();
            Cache cache = CacheHelper.createCache(cacheConfig);
            TheRegion = RegionHelper.createRegion(regionConfig);
            if (bridgeConfig != null) {
                BridgeHelper.startBridgeServer(bridgeConfig);
            }
        }
    }

    public static synchronized void closeCacheTask() {
        if (TheRegion != null) {
            BridgeHelper.stopBridgeServer();
            CacheHelper.closeCache();
            TheRegion = null;
        }
    }

    public static void putTask() {
        for (int i = 0; i < 10000; ++i) {
            TheRegion.put((Object)("key" + i), (Object)("value" + i));
        }
    }

    public static void checkClientPropertiesTask() {
        Properties p = DistributedSystemHelper.getDistributedSystem().getSecurityProperties();
        Log.getLogWriter().info("Using security properties: " + p);
        Long key = ClientPrms.clientNoDefaultNoSetNoTask;
        String val = p.getProperty("security-client-no-default-no-set-no-task");
        SecurityTestClient.checkProperty(key, val, "Client");
        key = ClientPrms.clientHasDefaultNoSetNoTask;
        val = p.getProperty("security-client-has-default-no-set-no-task");
        SecurityTestClient.checkProperty(key, val, "Client");
        key = ClientPrms.clientNoDefaultHasSetNoTask;
        val = p.getProperty("security-client-no-default-has-set-no-task");
        SecurityTestClient.checkProperty(key, val, "Client");
        key = ClientPrms.clientHasDefaultHasSetNoTask;
        val = p.getProperty("security-client-has-default-has-set-no-task");
        SecurityTestClient.checkProperty(key, val, "Client");
        key = ClientPrms.clientNoDefaultNoSetHasTask;
        val = p.getProperty("security-client-no-default-no-set-has-task");
        SecurityTestClient.checkProperty(key, val, "Client");
        key = ClientPrms.clientNoDefaultHasSetHasTask;
        val = p.getProperty("security-client-no-default-has-set-has-task");
        SecurityTestClient.checkProperty(key, val, "Client");
        key = ClientPrms.clientHasDefaultNoSetHasTask;
        val = p.getProperty("security-client-has-default-no-set-has-task");
        SecurityTestClient.checkProperty(key, val, "Client");
        key = ClientPrms.clientHasDefaultHasSetHasTask;
        val = p.getProperty("security-client-has-default-has-set-has-task");
        SecurityTestClient.checkProperty(key, val, "Client");
    }

    public static void checkPeerPropertiesTask() {
        Properties p = DistributedSystemHelper.getDistributedSystem().getSecurityProperties();
        Log.getLogWriter().info("Using security properties: " + p);
        Long key = PeerPrms.peerNoDefaultNoSetNoTask;
        String val = p.getProperty("security-peer-no-default-no-set-no-task");
        SecurityTestClient.checkProperty(key, val, "Peer");
        key = PeerPrms.peerHasDefaultNoSetNoTask;
        val = p.getProperty("security-peer-has-default-no-set-no-task");
        SecurityTestClient.checkProperty(key, val, "Peer");
        key = PeerPrms.peerNoDefaultHasSetNoTask;
        val = p.getProperty("security-peer-no-default-has-set-no-task");
        SecurityTestClient.checkProperty(key, val, "Peer");
        key = PeerPrms.peerHasDefaultHasSetNoTask;
        val = p.getProperty("security-peer-has-default-has-set-no-task");
        SecurityTestClient.checkProperty(key, val, "Peer");
        key = PeerPrms.peerNoDefaultNoSetHasTask;
        val = p.getProperty("security-peer-no-default-no-set-has-task");
        SecurityTestClient.checkProperty(key, val, "Peer");
        key = PeerPrms.peerNoDefaultHasSetHasTask;
        val = p.getProperty("security-peer-no-default-has-set-has-task");
        SecurityTestClient.checkProperty(key, val, "Peer");
        key = PeerPrms.peerHasDefaultNoSetHasTask;
        val = p.getProperty("security-peer-has-default-no-set-has-task");
        SecurityTestClient.checkProperty(key, val, "Peer");
        key = PeerPrms.peerHasDefaultHasSetHasTask;
        val = p.getProperty("security-peer-has-default-has-set-has-task");
        SecurityTestClient.checkProperty(key, val, "Peer");
    }

    private static void checkProperty(Long key, String actualVal, String prefix) {
        String name = BasePrms.nameForKey(key);
        String expectedVal = name.indexOf("HasTask") != -1 ? prefix + "TaskVal" : (name.indexOf("HasSet") != -1 ? prefix + "SetVal" : (name.indexOf("HasDefault") != -1 ? prefix + "DefaultVal" : ""));
        if (actualVal == null || !actualVal.equals(expectedVal)) {
            String s = name + " got value: " + actualVal + ", expected: " + expectedVal;
            throw new HydraRuntimeException(s);
        }
    }

    public static void validatePathTask() throws IOException {
        Properties p = DistributedSystemHelper.getDistributedSystem().getSecurityProperties();
        String path = p.getProperty("security-path");
        String expectedPath = System.getProperty("JTESTS") + File.separator + "hydratest" + File.separator + "security" + File.separator + RemoteTestModule.getCurrentThread().getThreadGroupName() + ".txt";
        SecurityTestClient.validatePath(path, expectedPath);
        path = p.getProperty("security-authz-xml-uri");
        expectedPath = EnvHelper.expandEnvVars("$JTESTS/hydratest/security/defaultAuthorization.xml");
        SecurityTestClient.validatePath(path, expectedPath);
    }

    private static void validatePath(String path, String expectedPath) {
        if (path == null) {
            String s = "Path is null";
            throw new HydraRuntimeException(s);
        }
        if (path.length() == 0) {
            String s = "Path is not set";
            throw new HydraRuntimeException(s);
        }
        if (!FileUtil.isAbsoluteFilename(path)) {
            String s = "Path is not absolute: " + path;
            throw new HydraRuntimeException(s);
        }
        Log.getLogWriter().info("Actual path is: " + path);
        Log.getLogWriter().info("Expected path: " + expectedPath);
        if (!path.equals(expectedPath)) {
            String s = "Got path value: " + path + ", expected: " + expectedPath;
            throw new HydraRuntimeException(s);
        }
    }
}

