/*
 * Decompiled with CFR 0.152.
 */
package hydra.training;

import com.gemstone.gemfire.SystemFailure;
import hydra.Log;
import hydra.training.Client;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import util.TestException;

public class Server
extends Thread {
    private static final int SHUTDOWN_HEADER = 43;
    protected static Throwable serverError = null;
    private int port;
    protected List clientConnections = Collections.synchronizedList(new LinkedList());

    public Server(int port) {
        super(new ThreadGroup("Server threads"){

            @Override
            public void uncaughtException(Thread thread, Throwable ex) {
                if (ex instanceof VirtualMachineError) {
                    SystemFailure.setFailure((Error)((VirtualMachineError)ex));
                }
                String s = "Uncaught exception in thread " + thread;
                Log.getLogWriter().severe(s, ex);
                serverError = ex;
            }
        }, "Server thread");
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        ServerSocket server = null;
        try {
            server = new ServerSocket(this.port, 5);
        }
        catch (IOException ex) {
            if (this.isInterrupted()) {
                return;
            }
            serverError = ex;
            String s = "While accepting connection";
            Log.getLogWriter().severe(s, (Throwable)ex);
            return;
        }
        finally {
            if (server != null) {
                try {
                    server.close();
                }
                catch (IOException ex) {
                    Log.getLogWriter().severe("Can't close ServerSocket", (Throwable)ex);
                }
            }
        }
    }

    public void close() throws IOException, InterruptedException {
        Client client = new Client(){

            @Override
            protected int getHeaderInt() {
                return 43;
            }
        };
        client.connect(this.port);
        this.join();
        while (!this.clientConnections.isEmpty()) {
            ClientConnection conn = (ClientConnection)this.clientConnections.remove(0);
            conn.interrupt();
            conn.join();
        }
        if (serverError != null) {
            String s = "Error in server";
            throw new TestException(s, serverError);
        }
    }

    @Override
    public String toString() {
        return "Server " + this.port + " with " + this.clientConnections.size() + " clients";
    }

    class ClientConnection
    extends Thread {
        private final Socket socket;

        ClientConnection(Socket socket) {
            super("Client connection to " + socket);
            this.socket = socket;
            Server.this.clientConnections.add(this);
        }

        @Override
        public void run() {
            try {
                DataOutputStream dos = new DataOutputStream(this.socket.getOutputStream());
                for (int i = 0; i < 1000; ++i) {
                    dos.writeInt(i);
                }
                dos.flush();
                dos.close();
            }
            catch (IOException ex) {
                if (this.isInterrupted()) {
                    return;
                }
                serverError = ex;
                String s = "While communicating with client " + this.socket;
                Log.getLogWriter().severe(s, (Throwable)ex);
            }
            finally {
                Server.this.clientConnections.remove(this);
            }
        }
    }
}

