/*
 * Decompiled with CFR 0.152.
 */
package hydra.timeserver;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.NanoTimer;
import hydra.HostHelper;
import hydra.Log;
import hydra.timeserver.TimeRequest;
import hydra.timeserver.TimeResponse;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

public class TimeServer
extends Thread {
    private final String host = HostHelper.getCanonicalHostName();
    private final int port = AvailablePort.getRandomAvailablePort((int)1);
    protected final DatagramSocket socket = new DatagramSocket(this.port);

    public TimeServer() throws IOException {
        this("TimeServer");
    }

    public TimeServer(String name) throws IOException {
        super(name);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public String toString() {
        return this.host + ":" + this.port + "(" + this.socket + ")";
    }

    @Override
    public void run() {
        for (int i = 0; i < 20000; ++i) {
            NanoTimer.getTime();
        }
        try {
            while (true) {
                byte[] buf = new byte[32];
                DatagramPacket packet = new DatagramPacket(buf, buf.length);
                this.socket.receive(packet);
                if (SystemFailure.getFailure() != null) {
                    DatagramSocket s = this.socket;
                    if (s != null) {
                        s.close();
                    }
                    SystemFailure.checkFailure();
                }
                InetAddress address = packet.getAddress();
                int srcport = packet.getPort();
                TimeRequest request = TimeRequest.fromByteArray(packet.getData());
                long time = request.isNanoTime() ? NanoTimer.getTime() : System.currentTimeMillis();
                TimeResponse response = new TimeResponse(request.getPacketId(), time);
                buf = response.toByteArray();
                packet = new DatagramPacket(buf, buf.length, address, srcport);
                this.socket.send(packet);
            }
        }
        catch (IOException e) {
            Log.getLogWriter().error("Error in time server", (Throwable)e);
            this.socket.close();
            return;
        }
    }
}

