/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.FileUtil;
import hydra.HostAgent;
import hydra.HostHelper;
import hydra.HostPrms;
import hydra.HydraInternalException;
import hydra.HydraRuntimeException;
import hydra.HydraTimeoutException;
import hydra.Log;
import hydra.Platform;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;

public class WindowsPlatform
extends Platform {
    private static final String LINE_SEP = System.getProperty("line.separator");
    private static final String IMAGE_NAME_FIELD = "Image Name:";
    private static final String SPACE_REGEX = " +";
    private static final int EXISTS_TIMEOUT_SEC = 600;
    private static final int EXISTS_RETRY_ATTEMPTS = 2;
    private static final int EXISTS_RETRY_SLEEP_MS = 1000;
    private static final String COMMAND_PATH = "";
    private static final String TASKLIST = "tasklist.exe";
    private static final String TASKKILL = "taskkill.exe";
    private static final String SYSTEM_INFO = "systeminfo.exe";
    private static final String NETSTAT = "netstat.exe";
    private static final String CACLS = "cacls.exe";
    private static final String ICACLS = "icacls.exe";

    private static void loadTestLibrary() {
        StringBuffer libraryName = new StringBuffer("gemfiretest");
        if (WindowsPlatform.is64Bit()) {
            libraryName.append("64");
        }
        if (Boolean.getBoolean("gemfire.debug")) {
            libraryName.append("_g");
        }
        String library = System.mapLibraryName(libraryName.toString());
        String libraryPath = null;
        try {
            try {
                URL libraryURL = HostAgent.class.getResource("/lib/" + library);
                if (libraryURL == null) {
                    throw new UnsatisfiedLinkError("Didnt find library on the classpath");
                }
                libraryPath = URLDecoder.decode(libraryURL.getFile(), "UTF-8");
                if (libraryPath.charAt(0) == '/' && libraryPath.charAt(2) == ':') {
                    libraryPath = libraryPath.substring(1);
                }
            }
            catch (UnsupportedEncodingException uee) {
                throw new RuntimeException(uee);
            }
            System.load(libraryPath);
        }
        catch (UnsatisfiedLinkError ule) {
            try {
                System.loadLibrary(library);
            }
            catch (UnsatisfiedLinkError ule2) {
                String str = "Failed to load native test library. Check your PATH variable. details: " + ule + "more details: " + ule2;
                throw new HydraRuntimeException(str);
            }
        }
    }

    private static boolean is64Bit() {
        int bits = Integer.getInteger("sun.arch.data.model", 0);
        if (bits == 64) {
            return true;
        }
        if (bits == 32) {
            return false;
        }
        System.out.println("sun.arch.data.model did not match the expected 32 or 64, it was instead " + bits + "\nDefaulting to 32 bit.");
        return false;
    }

    @Override
    protected int bgexecInternal(String[] cmdarray, String workdir, String logfile) throws IOException {
        int result;
        String trace = System.getProperty("com.gemstone.gemfire.internal.OSProcess.trace");
        if (trace != null && trace.length() > 0) {
            for (int i = 0; i < cmdarray.length; ++i) {
                System.out.println("cmdarray[" + i + "] = " + cmdarray[i]);
            }
            System.out.println("workdir=" + workdir);
            System.out.println("logfile=" + logfile);
        }
        if ((result = WindowsPlatform._bgexecInternal(cmdarray, workdir, logfile)) != -1 && trace != null && trace.length() > 0) {
            System.out.println("bgexec child pid is: " + result);
        }
        return result;
    }

    private static native int _bgexecInternal(String[] var0, String var1, String var2) throws IOException;

    private static native boolean nativeExists(int var0);

    private static native boolean nativeKill(int var0);

    @Override
    protected boolean exists(int pid) {
        this.checkPid(pid);
        return WindowsPlatform.nativeExists(pid);
    }

    @Override
    protected void shutdown(int pid) {
        this.checkPid(pid);
        boolean killed = WindowsPlatform.nativeKill(pid);
        if (!killed) {
            String s = "Failed to complete shutdown command to " + pid;
            throw new HydraRuntimeException(s);
        }
    }

    @Override
    protected void kill(int pid) {
        this.checkPid(pid);
        boolean killed = WindowsPlatform.nativeKill(pid);
        if (!killed) {
            String s = "Failed to complete kill command to " + pid;
            throw new HydraRuntimeException(s);
        }
    }

    @Override
    protected void printStacks(int pid) {
        this.checkPid(pid);
        String cmd = this.getPrintStacksCommand(pid);
        try {
            this.fgexec(cmd, 300);
        }
        catch (HydraRuntimeException e) {
            Log.getLogWriter().warning("Failed to issue print stacks command to " + pid + "\n" + this.getStackTrace((Throwable)((Object)e)));
        }
        catch (HydraTimeoutException e) {
            Log.getLogWriter().warning("Failed to issue print stacks command to " + pid + "\n" + this.getStackTrace((Throwable)((Object)e)));
        }
    }

    @Override
    protected void dumpHeap(int pid, String userDir, String options) {
        this.checkPid(pid);
        String[] cmd = this.getDumpHeapCommand(pid, userDir, options);
        if (cmd != null) {
            try {
                this.fgexec(cmd, new String[1], null);
            }
            catch (IOException e) {
                Log.getLogWriter().severe(this.getStackTrace(e));
            }
        }
    }

    @Override
    protected String getNetworkStatistics(int maxWaitSec) {
        return this.fgexec("netstat.exe -an", maxWaitSec);
    }

    @Override
    protected String getShutdownCommand(int pid) {
        this.checkPid(pid);
        return "taskkill.exe /F /PID " + pid;
    }

    @Override
    protected String getKillCommand(int pid) {
        this.checkPid(pid);
        return "taskkill.exe /F /PID " + pid;
    }

    @Override
    protected String getDumpLocksCommand(int pid) {
        return null;
    }

    @Override
    protected String getPrintStacksCommand(int pid) {
        this.checkPid(pid);
        String cmd = System.getProperty("JTESTS") + "\\sendsigbreak\\";
        cmd = cmd + (WindowsPlatform.is64Bit() ? "sendsigbreak64.exe" : "sendsigbreak.exe");
        cmd = cmd + " " + pid;
        return cmd;
    }

    @Override
    protected String[] getDumpHeapCommand(int pid, String userDir, String options) {
        this.checkPid(pid);
        String[] cmd = null;
        if (HostPrms.getJavaVendor().equals("Sun")) {
            cmd = new String[3];
            String dir = userDir == null ? System.getProperty("user.dir") : userDir;
            String fn = dir + "\\java_" + HostHelper.getLocalHost() + "_" + pid + ".hprof";
            cmd[0] = System.getProperty("java.home") + "\\..\\bin\\jmap.exe";
            cmd[1] = options == null ? "-dump:live,format=b" : options;
            cmd[1] = cmd[1] + ",file=" + fn;
            cmd[2] = String.valueOf(pid);
        }
        return cmd;
    }

    @Override
    protected String getNetcontrolCommand(String target, int op) {
        String cmd = "ipseccmd.exe";
        if (!FileUtil.exists(cmd)) {
            String s = cmd + " not found, please work with I.S. to install";
            throw new HydraRuntimeException(s);
        }
        switch (op) {
            case 0: {
                return cmd + " -f [" + target + "=0]";
            }
            case 1: {
                return cmd + " -f (" + target + "=0) ";
            }
            case 2: {
                return cmd + " -u";
            }
            case 3: {
                return cmd + " show filters";
            }
        }
        String s = "Should not happen";
        throw new HydraInternalException(s);
    }

    @Override
    protected void restartNTP() {
        Log.getLogWriter().info("Skipping NTP restart on Windows");
    }

    @Override
    protected String getFileExtension() {
        return ".bat";
    }

    @Override
    protected String getScriptHeader() {
        return COMMAND_PATH;
    }

    @Override
    protected String getCommentPrefix() {
        return "@rem ";
    }

    @Override
    protected void setExecutePermission(String fn) {
        if (System.getProperty("os.name").contains("XP")) {
            this.fgexec("cacls.exe " + fn + " /E /C /G Everyone:F", 600);
        } else {
            this.fgexec("icacls.exe " + fn + " /grant Everyone:F /C", 600);
        }
    }

    @Override
    protected void setReadPermission(String dir) {
        if (System.getProperty("os.name").contains("XP")) {
            this.fgexec("cacls.exe " + dir + " /E /C /T /G Everyone:F", 600);
        } else {
            this.fgexec("icacls.exe " + dir + " /grant Everyone:F /C /T", 600);
        }
    }

    @Override
    protected String getProcessStatus(int maxWaitSec) {
        String cmd = "cmd.exe /c tasklist.exe /V";
        return this.fgexec(cmd, maxWaitSec);
    }

    @Override
    protected String getMemoryStatus(int maxWaitSec) {
        String cmd = "cmd.exe /c systeminfo.exe";
        return this.fgexec(cmd, maxWaitSec);
    }

    static {
        if (System.getProperty("os.name").contains("Windows")) {
            WindowsPlatform.loadTestLibrary();
        }
    }
}

