/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.HydraTimeoutException;
import hydra.MethExecutorResult;
import hydra.SchedulingOrder;
import java.io.Serializable;

public class TestTaskResult
implements Serializable {
    protected Object result;
    protected long elapsedTime;
    protected boolean errorStatus = false;
    protected String errorString;

    public TestTaskResult(MethExecutorResult actualResult, long elapsedTime) {
        this.initialize(actualResult, elapsedTime);
    }

    protected TestTaskResult(long elapsedTime) {
        this.elapsedTime = elapsedTime;
    }

    private void initialize(MethExecutorResult result, long elapsedTime) {
        Object o = result.getResult();
        if (result.exceptionOccurred()) {
            Throwable t = result.getException();
            if (t instanceof SchedulingOrder) {
                this.setResult(t);
            } else if (t instanceof HydraTimeoutException) {
                this.setResult(t);
                this.setErrorStatus(true);
                this.setErrorString("HANG " + result.getExceptionClassName() + ": " + result.getExceptionMessage() + "\n\n" + result.getStackTrace());
            } else {
                this.setResult(o);
                this.setErrorStatus(true);
                this.setErrorString("ERROR " + result.getExceptionClassName() + ": " + result.getExceptionMessage() + "\n\n" + result.getStackTrace());
            }
        } else if (o == null) {
            this.setResult("void");
        } else {
            this.setResult(o);
        }
        this.setElapsedTime(elapsedTime);
    }

    public Object getResult() {
        return this.result;
    }

    public void setResult(Object anObj) {
        this.result = anObj;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public void setElapsedTime(long aLong) {
        this.elapsedTime = aLong;
    }

    public boolean getErrorStatus() {
        return this.errorStatus;
    }

    private void setErrorStatus(boolean aBool) {
        this.errorStatus = aBool;
    }

    public String getErrorString() {
        return this.errorString;
    }

    public void setErrorString(String aString) {
        this.errorString = aString;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(100);
        buf.append(this.result);
        if (this.errorStatus) {
            buf.append("\n");
            if (this.errorString != null) {
                buf.append(this.errorString);
            }
        }
        return buf.toString();
    }
}

