/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.internal.AvailablePort;
import hydra.AdminDescription;
import hydra.AgentDescription;
import hydra.AsyncEventQueueDescription;
import hydra.BasePrms;
import hydra.BridgeDescription;
import hydra.CacheDescription;
import hydra.ClientCacheDescription;
import hydra.ClientDescription;
import hydra.ClientMapper;
import hydra.ClientRecord;
import hydra.ClientRegionDescription;
import hydra.ClientVmRecord;
import hydra.ConfigHashtable;
import hydra.DiskStoreDescription;
import hydra.FileUtil;
import hydra.FixedPartitionDescription;
import hydra.GatewayDescription;
import hydra.GatewayHubDescription;
import hydra.GatewayReceiverDescription;
import hydra.GatewaySenderDescription;
import hydra.GemFireDescription;
import hydra.GemFirePrms;
import hydra.HDFSStoreDescription;
import hydra.HadoopDescription;
import hydra.HostAgentDescription;
import hydra.HostDescription;
import hydra.HostHelper;
import hydra.HydraConfigException;
import hydra.HydraInternalException;
import hydra.HydraRuntimeException;
import hydra.HydraThreadGroup;
import hydra.HydraThreadSubgroup;
import hydra.HydraVector;
import hydra.HypericServerInstallDescription;
import hydra.JDKVersionDescription;
import hydra.JProbeDescription;
import hydra.Log;
import hydra.MasterDescription;
import hydra.PartitionDescription;
import hydra.PoolDescription;
import hydra.Prms;
import hydra.ProductVersionHelper;
import hydra.RegionDescription;
import hydra.RemoteTestModule;
import hydra.ResourceManagerDescription;
import hydra.RmiRegistryHelper;
import hydra.SSLDescription;
import hydra.SecurityDescription;
import hydra.TestTask;
import hydra.VersionDescription;
import hydra.VmDescription;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;

public class TestConfig
implements Serializable {
    private static transient TestConfig singleton = null;
    private static transient TestConfig hasingleton = null;
    private String TestName;
    private String TestUser;
    private String BuildVersion;
    private String BuildDate;
    private String SourceRepository;
    private String SourceRevision;
    private String SourceDate;
    private String BuildJDK;
    private String RuntimeJDK;
    private String JavaVMName;
    private Vector UnitTests;
    private Vector StartTasks;
    private Vector InitTasks;
    private Vector StaticInitTasks;
    private Vector DynamicInitTasks;
    private Vector Tasks;
    private Vector CloseTasks;
    private Vector StaticCloseTasks;
    private Vector DynamicCloseTasks;
    private Vector EndTasks;
    private MasterDescription TheMasterDescription;
    private SortedMap HostDescriptions = new TreeMap();
    private SortedMap<String, HostDescription> HadoopHostDescriptions = new TreeMap<String, HostDescription>();
    private SortedMap<String, HadoopDescription> HadoopDescriptions = new TreeMap<String, HadoopDescription>();
    private SortedMap<String, GemFireDescription> GemFireDescriptions = new TreeMap<String, GemFireDescription>();
    private SortedMap<String, JDKVersionDescription> JDKVersionDescriptions = new TreeMap<String, JDKVersionDescription>();
    private SortedMap<String, VersionDescription> VersionDescriptions = new TreeMap<String, VersionDescription>();
    private SortedMap AdminDescriptions = new TreeMap();
    private SortedMap AgentDescriptions = new TreeMap();
    private SortedMap VmDescriptions = new TreeMap();
    private SortedMap<String, HostAgentDescription> HostAgentDescriptions = new TreeMap<String, HostAgentDescription>();
    private SortedMap PoolDescriptions = new TreeMap();
    private SortedMap DiskStoreDescriptions = new TreeMap();
    private SortedMap<String, HDFSStoreDescription> HDFSStoreDescriptions = new TreeMap<String, HDFSStoreDescription>();
    private SortedMap CacheDescriptions = new TreeMap();
    private SortedMap ResourceManagerDescriptions = new TreeMap();
    private SortedMap RegionDescriptions = new TreeMap();
    private SortedMap FixedPartitionDescriptions = new TreeMap();
    private SortedMap PartitionDescriptions = new TreeMap();
    private SortedMap SecurityDescriptions = new TreeMap();
    private SortedMap SSLDescriptions = new TreeMap();
    private SortedMap BridgeDescriptions = new TreeMap();
    private SortedMap GatewayReceiverDescriptions = new TreeMap();
    private SortedMap GatewaySenderDescriptions = new TreeMap();
    private SortedMap<String, AsyncEventQueueDescription> AsyncEventQueueDescriptions = new TreeMap<String, AsyncEventQueueDescription>();
    private SortedMap GatewayHubDescriptions = new TreeMap();
    private SortedMap GatewayDescriptions = new TreeMap();
    private SortedMap<String, ClientDescription> ClientDescriptions = new TreeMap<String, ClientDescription>();
    private SortedMap JProbeDescriptions = new TreeMap();
    private SortedMap HypericServerInstallDescriptions = new TreeMap();
    private SortedMap<String, ClientCacheDescription> ClientCacheDescriptions = new TreeMap<String, ClientCacheDescription>();
    private SortedMap<String, ClientRegionDescription> ClientRegionDescriptions = new TreeMap<String, ClientRegionDescription>();
    private SortedMap SystemProperties = new TreeMap();
    private Hashtable ThreadGroups = new Hashtable();
    private ConfigHashtable Parameters = new ConfigHashtable();
    private List<String> ClassNames = new ArrayList<String>();

    public static TestConfig create() {
        if (singleton != null) {
            throw new HydraRuntimeException("TestConfig has already been created");
        }
        singleton = new TestConfig();
        return singleton;
    }

    protected static void destroy() {
        singleton = null;
    }

    public static synchronized TestConfig getHostAgentInstance() {
        if (hasingleton == null) {
            String config = TestConfig.getTestConfigFilename("hostagentConfig.obj");
            if (config == null) {
                Log.getLogWriter().info("Deserializing hostagent test configuration via master...");
                try {
                    hasingleton = RmiRegistryHelper.lookupMaster().getHostAgentTestConfig();
                }
                catch (RemoteException e) {
                    String s = "Unable to access master to get hostagent test configuration";
                    throw new HydraRuntimeException(s, e);
                }
            } else {
                Log.getLogWriter().info("Deserializing hostagent test configuration...");
                hasingleton = (TestConfig)FileUtil.deserialize(config);
            }
        }
        return hasingleton;
    }

    protected static TestConfig getHostAgentInstanceFromMaster() {
        String config = TestConfig.getTestConfigFilename("hostagentConfig.obj");
        Log.getLogWriter().info("Deserializing hostagent test configuration...");
        return (TestConfig)FileUtil.deserialize(config);
    }

    public static synchronized TestConfig getInstance() {
        if (singleton == null) {
            String config = TestConfig.getTestConfigFilename("testConfig.obj");
            if (config == null) {
                Log.getLogWriter().info("Deserializing test configuration via master...");
                try {
                    singleton = RmiRegistryHelper.lookupMaster().getTestConfig();
                }
                catch (RemoteException e) {
                    String s = "Unable to access master to get test configuration";
                    throw new HydraRuntimeException(s, e);
                }
            } else {
                Log.getLogWriter().info("Deserializing test configuration...");
                singleton = (TestConfig)FileUtil.deserialize(config);
            }
        }
        return singleton;
    }

    protected static TestConfig getInstanceFromMaster() {
        String config = TestConfig.getTestConfigFilename("testConfig.obj");
        Log.getLogWriter().info("Deserializing test configuration...");
        return (TestConfig)FileUtil.deserialize(config);
    }

    private static String getTestConfigFilename(String fn) {
        String config = System.getProperty("user.dir") + File.separator + fn;
        if (FileUtil.exists(config)) {
            return config;
        }
        String testDir = System.getProperty("test.dir");
        if (testDir != null && FileUtil.exists(config = testDir + File.separator + fn)) {
            return config;
        }
        return null;
    }

    public void configure() {
        HostDescription.configure(this);
        HadoopDescription.configure(this);
        HostAgentDescription.configure(this);
        JProbeDescription.configure(this);
        SSLDescription.configure(this);
        SecurityDescription.configure(this);
        GemFireDescription.configure(this);
        AdminDescription.configure(this);
        AgentDescription.configure(this);
        VmDescription.configure(this);
        JDKVersionDescription.configure(this);
        VersionDescription.configure(this);
        ClientDescription.configure(this);
        DiskStoreDescription.configure(this);
        HDFSStoreDescription.configure(this);
        BridgeDescription.configure(this);
        PoolDescription.configure(this);
        FixedPartitionDescription.configure(this);
        PartitionDescription.configure(this);
        GatewayReceiverDescription.configure(this);
        GatewaySenderDescription.configure(this);
        AsyncEventQueueDescription.configure(this);
        RegionDescription.configure(this);
        ClientRegionDescription.configure(this);
        ResourceManagerDescription.configure(this);
        CacheDescription.configure(this);
        ClientCacheDescription.configure(this);
        GatewayDescription.configure(this);
        GatewayHubDescription.configure(this);
        HypericServerInstallDescription.configure(this);
    }

    public void share() {
        String userDir = this.getMasterDescription().getVmDescription().getHostDescription().getUserDir();
        String config = userDir + "/testConfig.obj";
        FileUtil.serialize(singleton, config);
        String latest = userDir + "/latest.prop";
        String content = singleton.toString();
        content = content.replace('\\', '/');
        FileUtil.writeToFile(latest, content);
        this.log().info(singleton.toString());
        hasingleton = new TestConfig();
        hasingleton.setClassNames(singleton.getClassNames());
        hasingleton.setParameters(singleton.getParameters());
        hasingleton.setMasterDescription(singleton.getMasterDescription());
        hasingleton.setHostAgentDescriptions(singleton.getHostAgentDescriptions());
        hasingleton.setHostDescriptions(singleton.getHostDescriptions());
        hasingleton.setHadoopHostDescriptions(singleton.getHadoopHostDescriptions());
        String haconfig = userDir + "/hostagentConfig.obj";
        FileUtil.serialize(hasingleton, haconfig);
        this.log().info("HostAgentInstance: " + hasingleton.toString());
    }

    public static ConfigHashtable tab() {
        return TestConfig.getInstance().getParameters();
    }

    public static ConfigHashtable tasktab() {
        try {
            return RemoteTestModule.getCurrentThread().getCurrentTask().getTaskAttributes();
        }
        catch (NullPointerException e) {
            return TestConfig.tab();
        }
    }

    public String getTestName() {
        return this.TestName;
    }

    protected void setTestName(String testName) {
        this.TestName = testName;
    }

    public String getTestUser() {
        return this.TestUser;
    }

    protected void setTestUser(String testUser) {
        this.TestUser = testUser;
    }

    public MasterDescription getMasterDescription() {
        return this.TheMasterDescription;
    }

    protected void setMasterDescription(MasterDescription md) {
        if (this.TheMasterDescription == null) {
            this.TheMasterDescription = md;
        }
    }

    public Vector getUnitTests() {
        return this.UnitTests;
    }

    protected void addUnitTest(TestTask task) {
        if (this.UnitTests == null) {
            this.UnitTests = new Vector();
        }
        this.UnitTests.add(task);
    }

    public Vector getStartTasks() {
        return this.StartTasks;
    }

    protected void addStartTask(TestTask task) {
        if (this.StartTasks == null) {
            this.StartTasks = new Vector();
        }
        this.StartTasks.add(task);
    }

    public Vector getInitTasks() {
        return this.StaticInitTasks;
    }

    protected void addInitTask(TestTask task) {
        if (this.InitTasks == null) {
            this.InitTasks = new Vector();
        }
        this.InitTasks.add(task);
    }

    private void addStaticInitTask(TestTask task) {
        if (this.StaticInitTasks == null) {
            this.StaticInitTasks = new Vector();
        }
        this.StaticInitTasks.add(task);
    }

    public Vector getDynamicInitTasksClone() {
        Vector<Object> clone = null;
        if (this.DynamicInitTasks != null) {
            for (TestTask tt : this.DynamicInitTasks) {
                if (clone == null) {
                    clone = new Vector<Object>();
                }
                clone.add(tt.clone());
            }
        }
        return clone;
    }

    private void addDynamicInitTask(TestTask task) {
        if (this.DynamicInitTasks == null) {
            this.DynamicInitTasks = new Vector();
        }
        this.DynamicInitTasks.add(task);
    }

    public Vector getTasks() {
        return this.Tasks;
    }

    protected TestTask getTask(int type, int index) {
        switch (type) {
            case 0: {
                return (TestTask)this.StartTasks.elementAt(index);
            }
            case 1: {
                return (TestTask)this.StaticInitTasks.elementAt(index);
            }
            case 2: {
                return (TestTask)this.DynamicInitTasks.elementAt(index);
            }
            case 3: {
                return (TestTask)this.Tasks.elementAt(index);
            }
            case 4: {
                return (TestTask)this.DynamicCloseTasks.elementAt(index);
            }
            case 5: {
                return (TestTask)this.StaticCloseTasks.elementAt(index);
            }
            case 6: {
                return (TestTask)this.EndTasks.elementAt(index);
            }
        }
        throw new HydraInternalException("Invalid task type: " + type);
    }

    protected void addTask(TestTask task) {
        if (this.Tasks == null) {
            this.Tasks = new Vector();
        }
        this.Tasks.add(task);
    }

    public Vector getCloseTasks() {
        return this.StaticCloseTasks;
    }

    protected void addCloseTask(TestTask task) {
        if (this.CloseTasks == null) {
            this.CloseTasks = new Vector();
        }
        this.CloseTasks.add(task);
    }

    protected void addStaticCloseTask(TestTask task) {
        if (this.StaticCloseTasks == null) {
            this.StaticCloseTasks = new Vector();
        }
        this.StaticCloseTasks.add(task);
    }

    public Vector getDynamicCloseTasksClone() {
        Vector<Object> clone = null;
        if (this.DynamicCloseTasks != null) {
            for (TestTask tt : this.DynamicCloseTasks) {
                if (clone == null) {
                    clone = new Vector<Object>();
                }
                clone.add(tt.clone());
            }
        }
        return clone;
    }

    protected void addDynamicCloseTask(TestTask task) {
        if (this.DynamicCloseTasks == null) {
            this.DynamicCloseTasks = new Vector();
        }
        this.DynamicCloseTasks.add(task);
    }

    public Vector getEndTasks() {
        return this.EndTasks;
    }

    protected void addEndTask(TestTask task) {
        if (this.EndTasks == null) {
            this.EndTasks = new Vector();
        }
        this.EndTasks.add(task);
    }

    public Hashtable getThreadGroups() {
        return this.ThreadGroups;
    }

    public HydraThreadGroup getThreadGroup(String name) {
        return (HydraThreadGroup)this.ThreadGroups.get(name);
    }

    protected void addThreadGroup(HydraThreadGroup group) {
        String name = group.getName();
        if (this.ThreadGroups.get(name) != null) {
            throw new HydraConfigException("Thread group " + name + " already exists");
        }
        this.ThreadGroups.put(name, group);
    }

    public SortedMap<String, HostDescription> getHostDescriptions() {
        return this.HostDescriptions;
    }

    private void setHostDescriptions(SortedMap<String, HostDescription> m) {
        this.HostDescriptions = m;
    }

    public HostDescription getHostDescription(String name) {
        return (HostDescription)this.HostDescriptions.get(name);
    }

    public Vector getHostNames() {
        Vector<String> names = new Vector<String>();
        for (HostDescription hd : this.HostDescriptions.values()) {
            names.add(hd.getName());
        }
        return names.size() == 0 ? null : names;
    }

    public Vector getPhysicalHosts() {
        Vector<String> hosts = new Vector<String>();
        for (HostDescription hd : this.HostDescriptions.values()) {
            hosts.add(hd.getHostName());
        }
        return hosts.size() == 0 ? null : hosts;
    }

    public Vector getPhysicalHostsIncludingHadoop() {
        Vector<String> hosts = this.getPhysicalHosts();
        if (hosts == null) {
            hosts = new Vector<String>();
        }
        for (HadoopDescription hdd : this.HadoopDescriptions.values()) {
            for (String host : hdd.getNameNodeHosts()) {
                if (hosts.contains(host)) continue;
                hosts.add(host);
            }
            for (String host : hdd.getDataNodeHosts()) {
                if (hosts.contains(host)) continue;
                hosts.add(host);
            }
        }
        return hosts.size() == 0 ? null : hosts;
    }

    protected HostDescription getAnyPhysicalHostDescription(String host) {
        for (HostDescription hd : this.HadoopHostDescriptions.values()) {
            if (!HostHelper.compareHosts(hd.getHostName(), host)) continue;
            return hd;
        }
        for (HostDescription hd : this.HostDescriptions.values()) {
            if (!HostHelper.compareHosts(hd.getHostName(), host)) continue;
            return hd;
        }
        String s = "No matching host description found for " + host + " in " + this.getPhysicalHosts();
        throw new HydraRuntimeException(s);
    }

    protected void addHostDescription(HostDescription hd) {
        String name = hd.getName();
        if (this.HostDescriptions.containsKey(name)) {
            throw new HydraConfigException("Host description " + name + " already exists");
        }
        this.HostDescriptions.put(name, hd);
    }

    public SortedMap<String, HostDescription> getHadoopHostDescriptions() {
        return this.HadoopHostDescriptions;
    }

    private void setHadoopHostDescriptions(SortedMap<String, HostDescription> m) {
        this.HadoopHostDescriptions = m;
    }

    public HostDescription getHadoopHostDescription(String name) {
        return (HostDescription)this.HadoopHostDescriptions.get(name);
    }

    protected void addHadoopHostDescription(HostDescription hd) {
        String name = hd.getName();
        if (this.HadoopHostDescriptions.containsKey(name)) {
            throw new HydraConfigException("Hadoop host description " + name + " already exists");
        }
        this.HadoopHostDescriptions.put(name, hd);
    }

    protected HostDescription getHadoopHostDescriptionForPhysicalHost(String host) {
        for (HostDescription hd : this.HadoopHostDescriptions.values()) {
            if (!hd.getHostName().equals(host)) continue;
            return hd;
        }
        String s = "No Hadoop HostDescription found for physical host: " + host;
        throw new HydraRuntimeException(s);
    }

    protected Vector getHadoopPhysicalHosts() {
        Vector<String> hosts = new Vector<String>();
        for (HostDescription hd : this.HadoopHostDescriptions.values()) {
            hosts.add(hd.getHostName());
        }
        return hosts.size() == 0 ? null : hosts;
    }

    public SortedMap<String, HadoopDescription> getHadoopDescriptions() {
        return this.HadoopDescriptions;
    }

    private void setHadoopDescriptions(SortedMap<String, HadoopDescription> m) {
        this.HadoopDescriptions = m;
    }

    public HadoopDescription getHadoopDescription(String name) {
        return (HadoopDescription)this.HadoopDescriptions.get(name);
    }

    protected void addHadoopDescription(HadoopDescription hd) {
        String name = hd.getName();
        if (this.HostDescriptions.containsKey(name)) {
            throw new HydraConfigException("Hadoop description " + name + " already exists");
        }
        this.HadoopDescriptions.put(name, hd);
    }

    public Map<String, GemFireDescription> getGemFireDescriptions() {
        return this.GemFireDescriptions;
    }

    public GemFireDescription getGemFireDescription(String name) {
        return (GemFireDescription)this.GemFireDescriptions.get(name);
    }

    protected void addGemFireDescription(GemFireDescription gfd) {
        String name = gfd.getName();
        if (this.GemFireDescriptions.containsKey(name)) {
            throw new HydraConfigException("GemFire description " + name + " already exists");
        }
        this.GemFireDescriptions.put(name, gfd);
    }

    public Map<String, JDKVersionDescription> getJDKVersionDescriptions() {
        return this.JDKVersionDescriptions;
    }

    public JDKVersionDescription getJDKVersionDescription(String name) {
        return (JDKVersionDescription)this.JDKVersionDescriptions.get(name);
    }

    protected void addJDKVersionDescription(JDKVersionDescription jvd) {
        String name = jvd.getName();
        if (this.JDKVersionDescriptions.containsKey(name)) {
            String s = "JDK Version description " + name + " already exists";
            throw new HydraConfigException(s);
        }
        this.JDKVersionDescriptions.put(name, jvd);
    }

    public Map<String, VersionDescription> getVersionDescriptions() {
        return this.VersionDescriptions;
    }

    public VersionDescription getVersionDescription(String name) {
        return (VersionDescription)this.VersionDescriptions.get(name);
    }

    protected void addVersionDescription(VersionDescription vd) {
        String name = vd.getName();
        if (this.VersionDescriptions.containsKey(name)) {
            String s = "Version description " + name + " already exists";
            throw new HydraConfigException(s);
        }
        this.VersionDescriptions.put(name, vd);
    }

    public Map getAdminDescriptions() {
        return this.AdminDescriptions;
    }

    public AdminDescription getAdminDescription(String name) {
        return (AdminDescription)this.AdminDescriptions.get(name);
    }

    protected void addAdminDescription(AdminDescription ad) {
        String name = ad.getName();
        if (this.AdminDescriptions.containsKey(name)) {
            throw new HydraConfigException("Admin description " + name + " already exists");
        }
        this.AdminDescriptions.put(name, ad);
    }

    public Map getAgentDescriptions() {
        return this.AgentDescriptions;
    }

    public AgentDescription getAgentDescription(String name) {
        return (AgentDescription)this.AgentDescriptions.get(name);
    }

    protected void addAgentDescription(AgentDescription ad) {
        String name = ad.getName();
        if (this.AgentDescriptions.containsKey(name)) {
            throw new HydraConfigException("Agent description " + name + " already exists");
        }
        this.AgentDescriptions.put(name, ad);
    }

    public Map getVmDescriptions() {
        return this.VmDescriptions;
    }

    public VmDescription getVmDescription(String name) {
        return (VmDescription)this.VmDescriptions.get(name);
    }

    protected void addVmDescription(VmDescription vmd) {
        String name = vmd.getName();
        if (this.VmDescriptions.containsKey(name)) {
            throw new HydraConfigException("VM description " + name + " already exists");
        }
        this.VmDescriptions.put(name, vmd);
    }

    public SortedMap<String, HostAgentDescription> getHostAgentDescriptions() {
        return this.HostAgentDescriptions;
    }

    private void setHostAgentDescriptions(SortedMap m) {
        this.HostAgentDescriptions = m;
    }

    public HostAgentDescription getHostAgentDescription(String name) {
        return (HostAgentDescription)this.HostAgentDescriptions.get(name);
    }

    protected void addHostAgentDescription(HostAgentDescription had) {
        String name = had.getName();
        if (this.HostAgentDescriptions.containsKey(name)) {
            throw new HydraConfigException("Hostagent description " + name + " already exists");
        }
        this.HostAgentDescriptions.put(name, had);
    }

    public Map getBridgeDescriptions() {
        return this.BridgeDescriptions;
    }

    public BridgeDescription getBridgeDescription(String name) {
        return (BridgeDescription)this.BridgeDescriptions.get(name);
    }

    protected void addBridgeDescription(BridgeDescription bd) {
        String name = bd.getName();
        if (this.BridgeDescriptions.containsKey(name)) {
            throw new HydraConfigException("Bridge description " + name + " already exists");
        }
        this.BridgeDescriptions.put(name, bd);
    }

    public Map getPoolDescriptions() {
        return this.PoolDescriptions;
    }

    public PoolDescription getPoolDescription(String name) {
        return (PoolDescription)this.PoolDescriptions.get(name);
    }

    protected void addPoolDescription(PoolDescription pd) {
        String name = pd.getName();
        if (this.PoolDescriptions.containsKey(name)) {
            throw new HydraConfigException("Pool description " + name + " already exists");
        }
        this.PoolDescriptions.put(name, pd);
    }

    public Map getDiskStoreDescriptions() {
        return this.DiskStoreDescriptions;
    }

    public DiskStoreDescription getDiskStoreDescription(String name) {
        return (DiskStoreDescription)this.DiskStoreDescriptions.get(name);
    }

    protected void addDiskStoreDescription(DiskStoreDescription dsd) {
        String name = dsd.getName();
        if (this.DiskStoreDescriptions.containsKey(name)) {
            throw new HydraConfigException("Disk store description " + name + " already exists");
        }
        this.DiskStoreDescriptions.put(name, dsd);
    }

    public Map getHDFSStoreDescriptions() {
        return this.HDFSStoreDescriptions;
    }

    public HDFSStoreDescription getHDFSStoreDescription(String name) {
        return (HDFSStoreDescription)this.HDFSStoreDescriptions.get(name);
    }

    protected void addHDFSStoreDescription(HDFSStoreDescription hsd) {
        String name = hsd.getName();
        if (this.HDFSStoreDescriptions.containsKey(name)) {
            throw new HydraConfigException("HDFS store description " + name + " already exists");
        }
        this.HDFSStoreDescriptions.put(name, hsd);
    }

    public Map getCacheDescriptions() {
        return this.CacheDescriptions;
    }

    public CacheDescription getCacheDescription(String name) {
        return (CacheDescription)this.CacheDescriptions.get(name);
    }

    protected void addCacheDescription(CacheDescription cd) {
        String name = cd.getName();
        if (this.CacheDescriptions.containsKey(name)) {
            throw new HydraConfigException("Cache description " + name + " already exists");
        }
        this.CacheDescriptions.put(name, cd);
    }

    public Map<String, ClientCacheDescription> getClientCacheDescriptions() {
        return this.ClientCacheDescriptions;
    }

    public ClientCacheDescription getClientCacheDescription(String name) {
        return (ClientCacheDescription)this.ClientCacheDescriptions.get(name);
    }

    protected void addClientCacheDescription(ClientCacheDescription ccd) {
        String name = ccd.getName();
        if (this.ClientCacheDescriptions.containsKey(name)) {
            String s = "Client cache description " + name + " already exists";
            throw new HydraConfigException(s);
        }
        this.ClientCacheDescriptions.put(name, ccd);
    }

    public Map getResourceManagerDescriptions() {
        return this.ResourceManagerDescriptions;
    }

    public ResourceManagerDescription getResourceManagerDescription(String name) {
        return (ResourceManagerDescription)this.ResourceManagerDescriptions.get(name);
    }

    protected void addResourceManagerDescription(ResourceManagerDescription rmd) {
        String name = rmd.getName();
        if (this.ResourceManagerDescriptions.containsKey(name)) {
            throw new HydraConfigException("Resource manager description " + name + " already exists");
        }
        this.ResourceManagerDescriptions.put(name, rmd);
    }

    public Map getRegionDescriptions() {
        return this.RegionDescriptions;
    }

    public RegionDescription getRegionDescription(String name) {
        return (RegionDescription)this.RegionDescriptions.get(name);
    }

    protected void addRegionDescription(RegionDescription rd) {
        String name = rd.getName();
        if (this.RegionDescriptions.containsKey(name)) {
            throw new HydraConfigException("Region description " + name + " already exists");
        }
        this.RegionDescriptions.put(name, rd);
    }

    public Map<String, ClientRegionDescription> getClientRegionDescriptions() {
        return this.ClientRegionDescriptions;
    }

    public ClientRegionDescription getClientRegionDescription(String name) {
        return (ClientRegionDescription)this.ClientRegionDescriptions.get(name);
    }

    protected void addClientRegionDescription(ClientRegionDescription crd) {
        String name = crd.getName();
        if (this.ClientRegionDescriptions.containsKey(name)) {
            String s = "Client region description " + name + " already exists";
            throw new HydraConfigException(s);
        }
        this.ClientRegionDescriptions.put(name, crd);
    }

    public Map getFixedPartitionDescriptions() {
        return this.FixedPartitionDescriptions;
    }

    public FixedPartitionDescription getFixedPartitionDescription(String name) {
        return (FixedPartitionDescription)this.FixedPartitionDescriptions.get(name);
    }

    protected void addFixedPartitionDescription(FixedPartitionDescription fpd) {
        String name = fpd.getName();
        if (this.FixedPartitionDescriptions.containsKey(name)) {
            throw new HydraConfigException("Partition description " + name + " already exists");
        }
        this.FixedPartitionDescriptions.put(name, fpd);
    }

    public Map getPartitionDescriptions() {
        return this.PartitionDescriptions;
    }

    public PartitionDescription getPartitionDescription(String name) {
        return (PartitionDescription)this.PartitionDescriptions.get(name);
    }

    protected void addPartitionDescription(PartitionDescription pd) {
        String name = pd.getName();
        if (this.PartitionDescriptions.containsKey(name)) {
            throw new HydraConfigException("Partition description " + name + " already exists");
        }
        this.PartitionDescriptions.put(name, pd);
    }

    public Map getSecurityDescriptions() {
        return this.SecurityDescriptions;
    }

    public SecurityDescription getSecurityDescription(String name) {
        return (SecurityDescription)this.SecurityDescriptions.get(name);
    }

    protected void addSecurityDescription(SecurityDescription sd) {
        String name = sd.getName();
        if (this.SecurityDescriptions.containsKey(name)) {
            throw new HydraConfigException("Security description " + name + " already exists");
        }
        this.SecurityDescriptions.put(name, sd);
    }

    public Map getSSLDescriptions() {
        return this.SSLDescriptions;
    }

    public SSLDescription getSSLDescription(String name) {
        return (SSLDescription)this.SSLDescriptions.get(name);
    }

    protected void addSSLDescription(SSLDescription sd) {
        String name = sd.getName();
        if (this.SSLDescriptions.containsKey(name)) {
            throw new HydraConfigException("SSL description " + name + " already exists");
        }
        this.SSLDescriptions.put(name, sd);
    }

    public Map getGatewayReceiverDescriptions() {
        return this.GatewayReceiverDescriptions;
    }

    public GatewayReceiverDescription getGatewayReceiverDescription(String name) {
        return (GatewayReceiverDescription)this.GatewayReceiverDescriptions.get(name);
    }

    protected void addGatewayReceiverDescription(GatewayReceiverDescription grd) {
        String name = grd.getName();
        if (this.GatewayReceiverDescriptions.containsKey(name)) {
            throw new HydraConfigException("Gateway receiver description " + name + " already exists");
        }
        this.GatewayReceiverDescriptions.put(name, grd);
    }

    public Map getGatewaySenderDescriptions() {
        return this.GatewaySenderDescriptions;
    }

    public GatewaySenderDescription getGatewaySenderDescription(String name) {
        return (GatewaySenderDescription)this.GatewaySenderDescriptions.get(name);
    }

    protected void addGatewaySenderDescription(GatewaySenderDescription gsd) {
        String name = gsd.getName();
        if (this.GatewaySenderDescriptions.containsKey(name)) {
            throw new HydraConfigException("Gateway sender description " + name + " already exists");
        }
        this.GatewaySenderDescriptions.put(name, gsd);
    }

    public Map<String, AsyncEventQueueDescription> getAsyncEventQueueDescriptions() {
        return this.AsyncEventQueueDescriptions;
    }

    public AsyncEventQueueDescription getAsyncEventQueueDescription(String name) {
        return (AsyncEventQueueDescription)this.AsyncEventQueueDescriptions.get(name);
    }

    protected void addAsyncEventQueueDescription(AsyncEventQueueDescription aeqd) {
        String name = aeqd.getName();
        if (this.AsyncEventQueueDescriptions.containsKey(name)) {
            throw new HydraConfigException("Async event queue description " + name + " already exists");
        }
        this.AsyncEventQueueDescriptions.put(name, aeqd);
    }

    public Map getGatewayHubDescriptions() {
        return this.GatewayHubDescriptions;
    }

    public GatewayHubDescription getGatewayHubDescription(String name) {
        return (GatewayHubDescription)this.GatewayHubDescriptions.get(name);
    }

    protected void addGatewayHubDescription(GatewayHubDescription ghd) {
        String name = ghd.getName();
        if (this.GatewayHubDescriptions.containsKey(name)) {
            throw new HydraConfigException("Gateway hub description " + name + " already exists");
        }
        this.GatewayHubDescriptions.put(name, ghd);
    }

    public Map getGatewayDescriptions() {
        return this.GatewayDescriptions;
    }

    public GatewayDescription getGatewayDescription(String name) {
        return (GatewayDescription)this.GatewayDescriptions.get(name);
    }

    protected void addGatewayDescription(GatewayDescription gd) {
        String name = gd.getName();
        if (this.GatewayDescriptions.containsKey(name)) {
            throw new HydraConfigException("Gateway description " + name + " already exists");
        }
        this.GatewayDescriptions.put(name, gd);
    }

    public Map<String, ClientDescription> getClientDescriptions() {
        return this.ClientDescriptions;
    }

    public ClientDescription getClientDescription(String name) {
        return (ClientDescription)this.ClientDescriptions.get(name);
    }

    public Vector getClientNames() {
        Vector<String> names = new Vector<String>();
        for (ClientDescription cd : this.ClientDescriptions.values()) {
            names.add(cd.getName());
        }
        return names.size() == 0 ? null : names;
    }

    protected void addClientDescription(ClientDescription cd) {
        String name = cd.getName();
        if (this.ClientDescriptions.containsKey(name)) {
            throw new HydraConfigException("Client description " + name + " already exists");
        }
        this.ClientDescriptions.put(name, cd);
    }

    public int getTotalVMs() {
        int totalVMs = 0;
        for (ClientDescription cd : this.ClientDescriptions.values()) {
            totalVMs += cd.getVmQuantity();
        }
        return totalVMs;
    }

    public int getTotalThreads() {
        int totalThreads = 0;
        for (ClientDescription cd : this.ClientDescriptions.values()) {
            totalThreads += cd.getVmQuantity() * cd.getVmThreads();
        }
        return totalThreads;
    }

    public Map getJProbeDescriptions() {
        return this.JProbeDescriptions;
    }

    public JProbeDescription getJProbeDescription(String name) {
        return (JProbeDescription)this.JProbeDescriptions.get(name);
    }

    protected void addJProbeDescription(JProbeDescription jpd) {
        String name = jpd.getName();
        if (this.JProbeDescriptions.containsKey(name)) {
            throw new HydraConfigException("JProbe description " + name + " already exists");
        }
        this.JProbeDescriptions.put(name, jpd);
    }

    public Map getHypericServerInstallDescriptions() {
        return this.HypericServerInstallDescriptions;
    }

    public HypericServerInstallDescription getHypericServerInstallDescription(String name) {
        return (HypericServerInstallDescription)this.HypericServerInstallDescriptions.get(name);
    }

    protected void addHypericServerInstallDescription(HypericServerInstallDescription hqd) {
        String name = hqd.getName();
        if (this.HypericServerInstallDescriptions.containsKey(name)) {
            throw new HydraConfigException("HypericServerInstall description " + name + " already exists");
        }
        this.HypericServerInstallDescriptions.put(name, hqd);
    }

    public Map getSystemProperties() {
        return this.SystemProperties;
    }

    public String getSystemProperty(String key) {
        return (String)this.SystemProperties.get(key);
    }

    protected void addSystemProperty(String key, String val) {
        String existingVal = (String)this.SystemProperties.get(key);
        if (existingVal == null) {
            this.SystemProperties.put(key, val);
        } else if (!existingVal.equals(val)) {
            throw new HydraConfigException("System property " + key + " already exists with value " + existingVal + ", cannot reset it to " + val);
        }
    }

    public ConfigHashtable getParameters() {
        return this.Parameters;
    }

    private void setParameters(ConfigHashtable p) {
        this.Parameters = p;
    }

    protected void addParameter(Long key, Object value) {
        this.Parameters.put(key, value);
    }

    protected void addToParameter(Long key, Object value) {
        HydraVector w;
        if (key == Prms.testDescription) {
            String val = (String)this.Parameters.get(key, "");
            this.Parameters.put(key, val + " " + value);
            return;
        }
        if (key == Prms.testRequirement) {
            String val = (String)this.Parameters.get(key, "");
            this.Parameters.put(key, val + " " + value);
            return;
        }
        if (key == Prms.testTopology) {
            String val = (String)this.Parameters.get(key, "");
            this.Parameters.put(key, val + " " + value);
            return;
        }
        HydraVector v = this.Parameters.vecAt(key, null);
        HydraVector hydraVector = w = value instanceof HydraVector ? (HydraVector)value : new HydraVector(value);
        if (v == null) {
            this.Parameters.put(key, value);
        } else {
            this.Parameters.put(key, this.combine(v, w));
        }
    }

    private HydraVector combine(HydraVector v, HydraVector w) {
        Object v0 = v.elementAt(0);
        Object w0 = w.elementAt(0);
        if (v0 instanceof HydraVector && w0 instanceof HydraVector) {
            this.expandVecs(v, w);
            return this.combineVecs(v, w);
        }
        if (v0 instanceof HydraVector) {
            HydraVector x = new HydraVector((Object)w);
            this.expandVecs(v, x);
            return this.combineVecs(v, x);
        }
        if (w0 instanceof HydraVector) {
            HydraVector x = new HydraVector((Object)v);
            this.expandVecs(x, w);
            return this.combineVecs(x, w);
        }
        HydraVector x = new HydraVector();
        x.addAll(v);
        x.addAll(w);
        return x;
    }

    private void expandVecs(HydraVector v, HydraVector w) {
        if (v.size() < w.size()) {
            this.expandVec(v, w.size());
        } else if (v.size() > w.size()) {
            this.expandVec(w, v.size());
        }
    }

    private void expandVec(HydraVector v, int size) {
        Object last = v.elementAt(v.size() - 1);
        for (int i = v.size(); i < size; ++i) {
            v.addElement(last);
        }
    }

    private HydraVector combineVecs(HydraVector v, HydraVector w) {
        HydraVector x = new HydraVector();
        for (int i = 0; i < v.size(); ++i) {
            HydraVector vv = (HydraVector)v.elementAt(i);
            HydraVector ww = (HydraVector)w.elementAt(i);
            HydraVector tt = new HydraVector();
            tt.addAll(vv);
            tt.addAll(ww);
            x.add(tt);
        }
        return x;
    }

    public List<String> getClassNames() {
        return this.ClassNames;
    }

    public List<String> getClassNames(String prefix) {
        ArrayList<String> classnames = null;
        for (String classname : this.ClassNames) {
            if (!classname.startsWith(prefix)) continue;
            if (classnames == null) {
                classnames = new ArrayList<String>();
            }
            classnames.add(classname);
        }
        return classnames;
    }

    private void setClassNames(List<String> v) {
        this.ClassNames = v;
    }

    protected void addClassName(String name) {
        if (!this.ClassNames.contains(name)) {
            this.ClassNames.add(name);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        SortedMap map = this.toSortedMap();
        for (String key : map.keySet()) {
            Object val = map.get(key);
            buf.append(key + "=" + val + "\n");
        }
        return buf.toString();
    }

    public SortedMap toSortedMap() {
        Iterator<Object> i;
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("TestName", this.TestName);
        map.put("TestUser", this.TestUser);
        map.put("build.version", this.BuildVersion);
        map.put("build.date", this.BuildDate);
        map.put("source.repository", this.SourceRepository);
        map.put("source.revision", this.SourceRevision);
        map.put("source.date", this.SourceDate);
        map.put("build.jdk", this.BuildJDK);
        map.put("runtime.jdk", this.RuntimeJDK);
        map.put("java.vm.name", this.JavaVMName);
        for (String key : this.SystemProperties.keySet()) {
            map.put("hydra.SystemProperties-" + key, (String)this.SystemProperties.get(key));
        }
        if (this.TheMasterDescription != null) {
            map.putAll(this.TheMasterDescription.toSortedMap());
        }
        if (this.UnitTests != null) {
            i = this.UnitTests.iterator();
            while (i.hasNext()) {
                map.putAll(((TestTask)i.next()).toSortedMap());
            }
        }
        if (this.StartTasks != null) {
            i = this.StartTasks.iterator();
            while (i.hasNext()) {
                map.putAll(((TestTask)i.next()).toSortedMap());
            }
        }
        if (this.InitTasks != null) {
            i = this.InitTasks.iterator();
            while (i.hasNext()) {
                map.putAll(((TestTask)i.next()).toSortedMap());
            }
        }
        if (this.Tasks != null) {
            i = this.Tasks.iterator();
            while (i.hasNext()) {
                map.putAll(((TestTask)i.next()).toSortedMap());
            }
        }
        if (this.CloseTasks != null) {
            i = this.CloseTasks.iterator();
            while (i.hasNext()) {
                map.putAll(((TestTask)i.next()).toSortedMap());
            }
        }
        if (this.EndTasks != null) {
            i = this.EndTasks.iterator();
            while (i.hasNext()) {
                map.putAll(((TestTask)i.next()).toSortedMap());
            }
        }
        if (this.ThreadGroups.size() != 0) {
            i = this.ThreadGroups.values().iterator();
            while (i.hasNext()) {
                map.putAll(((HydraThreadGroup)i.next()).toSortedMap());
            }
        }
        if (this.HostDescriptions.size() != 0) {
            i = this.HostDescriptions.values().iterator();
            while (i.hasNext()) {
                map.putAll(((HostDescription)i.next()).toSortedMap());
            }
        }
        if (this.HadoopHostDescriptions.size() != 0) {
            i = this.HadoopHostDescriptions.values().iterator();
            while (i.hasNext()) {
                map.putAll(((HostDescription)i.next()).toSortedMap());
            }
        }
        if (this.HadoopDescriptions.size() != 0) {
            i = this.HadoopDescriptions.values().iterator();
            while (i.hasNext()) {
                map.putAll(((HadoopDescription)i.next()).toSortedMap());
            }
        }
        if (this.GemFireDescriptions.size() != 0) {
            i = this.GemFireDescriptions.values().iterator();
            while (i.hasNext()) {
                map.putAll(((GemFireDescription)i.next()).toSortedMap());
            }
        }
        if (this.JDKVersionDescriptions.size() != 0) {
            for (JDKVersionDescription jvd : this.JDKVersionDescriptions.values()) {
                map.putAll(jvd.toSortedMap());
            }
        }
        if (this.VersionDescriptions.size() != 0) {
            for (VersionDescription vd : this.VersionDescriptions.values()) {
                map.putAll(vd.toSortedMap());
            }
        }
        if (this.AdminDescriptions.size() != 0) {
            i = this.AdminDescriptions.values().iterator();
            while (i.hasNext()) {
                map.putAll(((AdminDescription)i.next()).toSortedMap());
            }
        }
        if (this.AgentDescriptions.size() != 0) {
            i = this.AgentDescriptions.values().iterator();
            while (i.hasNext()) {
                map.putAll(((AgentDescription)i.next()).toSortedMap());
            }
        }
        if (this.JProbeDescriptions.size() != 0) {
            i = this.JProbeDescriptions.values().iterator();
            while (i.hasNext()) {
                map.putAll(((JProbeDescription)i.next()).toSortedMap());
            }
        }
        if (this.VmDescriptions.size() != 0) {
            i = this.VmDescriptions.values().iterator();
            while (i.hasNext()) {
                map.putAll(((VmDescription)i.next()).toSortedMap());
            }
        }
        if (this.HostAgentDescriptions.size() != 0) {
            i = this.HostAgentDescriptions.values().iterator();
            while (i.hasNext()) {
                map.putAll(((HostAgentDescription)i.next()).toSortedMap());
            }
        }
        if (this.ClientDescriptions.size() != 0) {
            for (ClientDescription cd : this.ClientDescriptions.values()) {
                map.putAll(cd.toSortedMap());
            }
        }
        if (this.BridgeDescriptions.size() != 0) {
            i = this.BridgeDescriptions.values().iterator();
            while (i.hasNext()) {
                map.putAll(((BridgeDescription)i.next()).toSortedMap());
            }
        }
        if (this.PoolDescriptions.size() != 0) {
            i = this.PoolDescriptions.values().iterator();
            while (i.hasNext()) {
                map.putAll(((PoolDescription)i.next()).toSortedMap());
            }
        }
        if (this.DiskStoreDescriptions.size() != 0) {
            i = this.DiskStoreDescriptions.values().iterator();
            while (i.hasNext()) {
                map.putAll(((DiskStoreDescription)i.next()).toSortedMap());
            }
        }
        if (this.HDFSStoreDescriptions.size() != 0) {
            i = this.HDFSStoreDescriptions.values().iterator();
            while (i.hasNext()) {
                map.putAll(((HDFSStoreDescription)i.next()).toSortedMap());
            }
        }
        if (this.CacheDescriptions.size() != 0) {
            i = this.CacheDescriptions.values().iterator();
            while (i.hasNext()) {
                map.putAll(((CacheDescription)i.next()).toSortedMap());
            }
        }
        if (this.ClientCacheDescriptions.size() != 0) {
            for (ClientCacheDescription ccd : this.ClientCacheDescriptions.values()) {
                map.putAll(ccd.toSortedMap());
            }
        }
        if (this.ResourceManagerDescriptions.size() != 0) {
            i = this.ResourceManagerDescriptions.values().iterator();
            while (i.hasNext()) {
                map.putAll(((ResourceManagerDescription)i.next()).toSortedMap());
            }
        }
        if (this.RegionDescriptions.size() != 0) {
            i = this.RegionDescriptions.values().iterator();
            while (i.hasNext()) {
                map.putAll(((RegionDescription)i.next()).toSortedMap());
            }
        }
        if (this.ClientRegionDescriptions.size() != 0) {
            for (ClientRegionDescription crd : this.ClientRegionDescriptions.values()) {
                map.putAll(crd.toSortedMap());
            }
        }
        if (this.FixedPartitionDescriptions.size() != 0) {
            i = this.FixedPartitionDescriptions.values().iterator();
            while (i.hasNext()) {
                map.putAll(((FixedPartitionDescription)i.next()).toSortedMap());
            }
        }
        if (this.PartitionDescriptions.size() != 0) {
            i = this.PartitionDescriptions.values().iterator();
            while (i.hasNext()) {
                map.putAll(((PartitionDescription)i.next()).toSortedMap());
            }
        }
        if (this.SecurityDescriptions.size() != 0) {
            i = this.SecurityDescriptions.values().iterator();
            while (i.hasNext()) {
                map.putAll(((SecurityDescription)i.next()).toSortedMap());
            }
        }
        if (this.SSLDescriptions.size() != 0) {
            i = this.SSLDescriptions.values().iterator();
            while (i.hasNext()) {
                map.putAll(((SSLDescription)i.next()).toSortedMap());
            }
        }
        if (this.GatewayReceiverDescriptions.size() != 0) {
            i = this.GatewayReceiverDescriptions.values().iterator();
            while (i.hasNext()) {
                map.putAll(((GatewayReceiverDescription)i.next()).toSortedMap());
            }
        }
        if (this.GatewaySenderDescriptions.size() != 0) {
            i = this.GatewaySenderDescriptions.values().iterator();
            while (i.hasNext()) {
                map.putAll(((GatewaySenderDescription)i.next()).toSortedMap());
            }
        }
        if (this.AsyncEventQueueDescriptions.size() != 0) {
            for (AsyncEventQueueDescription aeqd : this.AsyncEventQueueDescriptions.values()) {
                map.putAll(aeqd.toSortedMap());
            }
        }
        if (this.GatewayHubDescriptions.size() != 0) {
            i = this.GatewayHubDescriptions.values().iterator();
            while (i.hasNext()) {
                map.putAll(((GatewayHubDescription)i.next()).toSortedMap());
            }
        }
        if (this.GatewayDescriptions.size() != 0) {
            i = this.GatewayDescriptions.values().iterator();
            while (i.hasNext()) {
                map.putAll(((GatewayDescription)i.next()).toSortedMap());
            }
        }
        if (this.HypericServerInstallDescriptions.size() != 0) {
            i = this.HypericServerInstallDescriptions.values().iterator();
            while (i.hasNext()) {
                map.putAll(((HypericServerInstallDescription)i.next()).toSortedMap());
            }
        }
        if (this.Parameters.size() != 0) {
            map.putAll(this.Parameters.toSortedMap());
        }
        return map;
    }

    protected void postprocess() {
        this.setBuildInfo();
        if (this.UnitTests != null) {
            this.setThreadGroupsForUnitTests(this.UnitTests);
            this.setThreadGroups(this.InitTasks);
            Vector tasks = new Vector();
            if (this.InitTasks != null) {
                tasks.addAll(this.InitTasks);
            }
            tasks.addAll(this.UnitTests);
            this.postprocessThreadGroups(tasks);
            this.postprocessUnitTests(this.UnitTests, this.InitTasks);
        } else {
            if (this.ClientDescriptions.size() == 0) {
                throw new HydraConfigException("No clients specified");
            }
            Vector tasks = new Vector();
            if (this.InitTasks != null) {
                tasks.addAll(this.InitTasks);
            }
            if (this.Tasks != null) {
                tasks.addAll(this.Tasks);
            }
            if (this.CloseTasks != null) {
                tasks.addAll(this.CloseTasks);
            }
            this.setThreadGroups(tasks);
            Map vms = this.postprocessThreadGroups(tasks);
            this.postprocessStartAndEndTasks(this.StartTasks);
            this.postprocessInitTasks(this.InitTasks);
            this.postprocessComplexTasks(this.Tasks, vms);
            this.postprocessCloseTasks(this.CloseTasks);
            this.postprocessStartAndEndTasks(this.EndTasks);
            this.checkForZeroTotalThreads(tasks);
        }
        this.postprocessGemFireDescriptions();
        this.TheMasterDescription.postprocess();
    }

    protected long getRandomSeed() {
        return this.Parameters.longAt(Prms.randomSeed, -1L);
    }

    protected long generateRandomSeed() {
        return System.currentTimeMillis();
    }

    public void setRandomSeed(Long randomSeed) {
        this.Parameters.put(Prms.randomSeed, randomSeed);
        this.log().severe("Random seed is " + randomSeed);
    }

    public static Properties getGemFireProductVersion() {
        String fn = "com/gemstone/gemfire/internal/GemFireVersion.properties";
        try {
            return FileUtil.getPropertiesFromResource(fn);
        }
        catch (IOException e) {
            String s = "Unable to find GemFire product version";
            throw new HydraRuntimeException(s, e);
        }
    }

    private void setBuildInfo() {
        this.RuntimeJDK = System.getProperty("java.version");
        this.JavaVMName = System.getProperty("java.vm.name");
        Properties p = ProductVersionHelper.getInfo();
        if (p != null) {
            this.BuildVersion = p.getProperty("Product-Version") + " " + p.getProperty("Build-Id") + " " + p.getProperty("Build-Date") + " javac " + p.getProperty("Build-Java-Version");
            this.BuildDate = p.getProperty("Build-Date");
            this.SourceRepository = p.getProperty("Source-Repository");
            this.SourceRevision = p.getProperty("Source-Revision");
            this.SourceDate = p.getProperty("Source-Date");
            this.BuildJDK = p.getProperty("Build-Java-Version");
        }
    }

    private void postprocessUnitTests(Vector tests, Vector tasks) {
        this.setTaskIndex(tests);
        this.checkReceiverSelector(tests);
        this.postprocessInitTasks(tasks);
    }

    private void postprocessStartAndEndTasks(Vector tasks) {
        if (tasks == null) {
            return;
        }
        this.setTaskIndex(tasks);
        this.setClientNames(tasks);
        this.checkReceiverSelector(tasks);
    }

    private void postprocessInitTasks(Vector tasks) {
        if (tasks == null) {
            return;
        }
        this.setRunMode(tasks);
        block5: for (TestTask tt : this.InitTasks) {
            switch (tt.getRunMode()) {
                case 0: {
                    this.addStaticInitTask((TestTask)tt.clone());
                    this.addDynamicInitTask(tt);
                    tt.setTaskType(2);
                    continue block5;
                }
                case 1: {
                    this.addStaticInitTask(tt);
                    continue block5;
                }
                case 2: {
                    this.addDynamicInitTask(tt);
                    tt.setTaskType(2);
                    continue block5;
                }
            }
            throw new HydraInternalException("run mode not set");
        }
        if (this.StaticInitTasks != null) {
            this.setTaskIndex(this.StaticInitTasks);
        }
        if (this.DynamicInitTasks != null) {
            this.setTaskIndex(this.DynamicInitTasks);
        }
        this.checkReceiverSelector(tasks);
    }

    private void postprocessCloseTasks(Vector tasks) {
        if (tasks == null) {
            return;
        }
        this.setRunMode(tasks);
        block5: for (TestTask tt : this.CloseTasks) {
            switch (tt.getRunMode()) {
                case 0: {
                    this.addStaticCloseTask((TestTask)tt.clone());
                    this.addDynamicCloseTask(tt);
                    tt.setTaskType(4);
                    continue block5;
                }
                case 1: {
                    this.addStaticCloseTask(tt);
                    continue block5;
                }
                case 2: {
                    this.addDynamicCloseTask(tt);
                    tt.setTaskType(4);
                    continue block5;
                }
            }
            throw new HydraInternalException("run mode not set");
        }
        if (this.StaticCloseTasks != null) {
            this.setTaskIndex(this.StaticCloseTasks);
        }
        if (this.DynamicCloseTasks != null) {
            this.setTaskIndex(this.DynamicCloseTasks);
        }
        this.checkReceiverSelector(tasks);
    }

    private void postprocessComplexTasks(Vector tasks, Map vms) {
        if (tasks == null) {
            return;
        }
        this.setTaskIndex(tasks);
        this.setMaxTimesToRun(tasks);
        this.setMaxThreads(tasks);
        this.setStartInterval(tasks);
        this.setEndInterval(tasks);
        this.setWeight(tasks);
        this.checkReceiverSelector(tasks);
        this.setNumClients(tasks, vms);
    }

    private void setNumClients(Vector tasks, Map vms) {
        for (TestTask task : tasks) {
            this.setNumClients(task, vms);
        }
    }

    private void setNumClients(TestTask task, Map vms) {
        if (vms == null) {
            return;
        }
        int numClients = 0;
        for (ClientVmRecord vm : vms.values()) {
            for (ClientRecord client : vm.getClients().values()) {
                if (!task.usesThreadGroup(client.getThreadGroupName())) continue;
                ++numClients;
            }
        }
        task.setNumClients(numClients);
    }

    private void checkReceiverSelector(Vector tasks) {
        if (this.Parameters.booleanAt(Prms.checkTaskMethodsExist)) {
            for (TestTask task : tasks) {
                this.checkReceiverSelector(task);
            }
        }
    }

    private void checkReceiverSelector(TestTask task) {
        String receiver = task.getReceiver();
        String selector = task.getSelector();
        this.checkReceiverSelector(receiver, selector, "Task " + task);
    }

    protected void checkReceiverSelector(String receiver, String selector, String id) {
        Class<?> cls;
        try {
            cls = Class.forName(receiver);
        }
        catch (NoClassDefFoundError e) {
            throw new HydraConfigException("Class " + receiver + " not found for " + id, e);
        }
        catch (ClassNotFoundException e) {
            throw new HydraConfigException("Class " + receiver + " not found for " + id, e);
        }
        Method[] methods = cls.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(selector) || methods[i].getParameterTypes().length != 0 || !Modifier.isPublic(methods[i].getModifiers()) || !Modifier.isStatic(methods[i].getModifiers())) continue;
            return;
        }
        throw new HydraConfigException("No public static no-argument method " + selector + " found for " + id);
    }

    protected void checkForZeroTotalThreads(Vector tasks) {
        for (TestTask task : tasks) {
            if (task.getTotalThreads() != 0) continue;
            String s = "Task has no threads in its threadgroups: " + task;
            throw new HydraConfigException(s);
        }
    }

    private void setTaskIndex(Vector tasks) {
        for (int i = 0; i < tasks.size(); ++i) {
            TestTask task = (TestTask)tasks.elementAt(i);
            task.setTaskIndex(i);
        }
    }

    private void setClientNames(Vector tasks) {
        for (int i = 0; i < tasks.size(); ++i) {
            TestTask task = (TestTask)tasks.elementAt(i);
            Vector names = task.getClientNames();
            if (names == null) {
                task.setClientNames(this.getClientNames());
                continue;
            }
            for (String name : names) {
                if (this.getClientDescription(name) != null) continue;
                throw new HydraConfigException("Illegal client name (" + name + ") in task: " + task);
            }
        }
    }

    private void setRunMode(Vector tasks) {
        for (int i = 0; i < tasks.size(); ++i) {
            TestTask task = (TestTask)tasks.elementAt(i);
            int n = task.getRunMode();
            if (n != -1) continue;
            task.setRunMode(1);
        }
    }

    private void setMaxTimesToRun(Vector tasks) {
        for (int i = 0; i < tasks.size(); ++i) {
            TestTask task = (TestTask)tasks.elementAt(i);
            int n = task.getMaxTimesToRun();
            if (n == -1) {
                task.setMaxTimesToRun(9999999);
                continue;
            }
            if (n > 0) continue;
            throw new HydraConfigException("Illegal value for maxTimesToRun (" + n + ") in task: " + task);
        }
    }

    private void setMaxThreads(Vector tasks) {
        for (int i = 0; i < tasks.size(); ++i) {
            TestTask task = (TestTask)tasks.elementAt(i);
            int n = task.getMaxThreads();
            if (n == -1) {
                task.setMaxThreads(9999999);
                continue;
            }
            if (n > 0) continue;
            throw new HydraConfigException("Illegal value for maxThreads (" + n + ") in task: " + task);
        }
    }

    private void setWeight(Vector tasks) {
        for (int i = 0; i < tasks.size(); ++i) {
            TestTask task = (TestTask)tasks.elementAt(i);
            Map groups = task.getThreadGroups();
            int n = task.getWeight();
            if (n == -1) {
                for (HydraThreadGroup group : groups.values()) {
                    if (group.usesCustomWeights() == null) {
                        group.usesCustomWeights(Boolean.FALSE);
                        continue;
                    }
                    if (!group.usesCustomWeights().booleanValue()) continue;
                    throw new HydraConfigException("Either all tasks or none using thread group " + group.getName() + " must use weights");
                }
                task.setWeight(1);
                continue;
            }
            if (n > 0) {
                for (HydraThreadGroup group : groups.values()) {
                    if (group.usesCustomWeights() == null) {
                        group.usesCustomWeights(Boolean.TRUE);
                        continue;
                    }
                    if (group.usesCustomWeights().booleanValue()) continue;
                    throw new HydraConfigException("Either all tasks or none using thread group " + group.getName() + " must use weights");
                }
                continue;
            }
            throw new HydraConfigException("Illegal value for weight (" + n + ") in task: " + task);
        }
    }

    private void setStartInterval(Vector tasks) {
        for (int i = 0; i < tasks.size(); ++i) {
            TestTask task = (TestTask)tasks.elementAt(i);
            int n = task.getStartInterval();
            if (n == -1) {
                task.setStartInterval(0);
                continue;
            }
            if (n > 0) continue;
            throw new HydraConfigException("Illegal value for startInterval (" + n + ") in task: " + task);
        }
    }

    private void setEndInterval(Vector tasks) {
        for (int i = 0; i < tasks.size(); ++i) {
            TestTask task = (TestTask)tasks.elementAt(i);
            int n = task.getEndInterval();
            if (n == -1) {
                task.setEndInterval(0);
                continue;
            }
            if (n > 0) continue;
            throw new HydraConfigException("Illegal value for endInterval (" + n + ") in task: " + task);
        }
    }

    private void setThreadGroupsForUnitTests(Vector tasks) {
        if (tasks == null) {
            return;
        }
        for (int i = 0; i < tasks.size(); ++i) {
            TestTask task = (TestTask)tasks.elementAt(i);
            HydraThreadGroup tg = this.getDefaultThreadGroup();
            task.addThreadGroupName(tg.getName());
            task.addThreadGroup(tg);
        }
    }

    private void setThreadGroups(Vector tasks) {
        Vector names;
        TestTask task;
        int i;
        if (tasks == null) {
            return;
        }
        for (i = 0; i < tasks.size(); ++i) {
            task = (TestTask)tasks.elementAt(i);
            names = task.getThreadGroupNames();
            if (names == null) continue;
            for (String name : names) {
                HydraThreadGroup tg = this.getThreadGroup(name);
                if (tg == null) {
                    if (name.equalsIgnoreCase("default")) {
                        tg = this.getDefaultThreadGroup();
                    } else {
                        throw new HydraConfigException("Thread group (" + name + ") not found for task: " + task);
                    }
                }
                task.addThreadGroup(tg);
            }
        }
        for (i = 0; i < tasks.size(); ++i) {
            task = (TestTask)tasks.elementAt(i);
            if (task.getThreadGroupNames() != null || task.getTaskType() != 3) continue;
            HydraThreadGroup tg = this.getDefaultThreadGroup();
            task.addThreadGroupName(tg.getName());
            task.addThreadGroup(tg);
        }
        for (i = 0; i < tasks.size(); ++i) {
            task = (TestTask)tasks.elementAt(i);
            names = task.getThreadGroupNames();
            if (task.getThreadGroupNames() != null || task.getTaskType() != 1 && task.getTaskType() != 5) continue;
            if (this.getThreadGroups().size() == 0) {
                this.getDefaultThreadGroup();
            }
            for (HydraThreadGroup tg : this.getThreadGroups().values()) {
                task.addThreadGroupName(tg.getName());
                task.addThreadGroup(tg);
            }
        }
    }

    private HydraThreadGroup getDefaultThreadGroup() {
        String name = "default";
        HydraThreadGroup tg = this.getThreadGroup(name);
        if (tg == null) {
            tg = new HydraThreadGroup(name);
            HydraThreadSubgroup tsg = new HydraThreadSubgroup(name);
            tsg.setTotalVMs(0);
            tsg.setTotalThreads(0);
            tsg.setClientNames(null);
            tg.addSubgroup(tsg);
            this.addThreadGroup(tg);
        }
        return tg;
    }

    private Map postprocessThreadGroups(Vector tasks) {
        String s;
        if (this.ThreadGroups.size() == 0) {
            return null;
        }
        Enumeration names = this.ThreadGroups.keys();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            boolean used = false;
            for (int i = 0; i < tasks.size(); ++i) {
                TestTask task = (TestTask)tasks.elementAt(i);
                if (!task.getThreadGroupNames().contains(name)) continue;
                used = true;
                break;
            }
            if (used) continue;
            this.ThreadGroups.remove(name);
        }
        if (this.ThreadGroups.size() == 0) {
            return null;
        }
        for (HydraThreadGroup tg : this.ThreadGroups.values()) {
            for (HydraThreadSubgroup tsg : tg.getSubgroups()) {
                Vector clientNames = tsg.getClientNames();
                if (clientNames == null) continue;
                for (Object clientName : clientNames) {
                    if (this.getClientDescription((String)clientName) != null) continue;
                    throw new HydraConfigException("Thread group specifies non-existent client name (" + (String)clientName + "): " + tg);
                }
            }
        }
        HydraThreadGroup defaultGroup = (HydraThreadGroup)this.ThreadGroups.get("default");
        if (defaultGroup != null) {
            int defaultThreads = this.getTotalThreads();
            for (HydraThreadGroup tg : this.ThreadGroups.values()) {
                if (tg.getName() == "default") continue;
                defaultThreads -= tg.getTotalThreads();
            }
            HydraThreadSubgroup subgroup = defaultGroup.getSubgroup(0);
            subgroup.setTotalThreads(defaultThreads);
        }
        int usedThreads = 0;
        for (HydraThreadGroup tg : this.ThreadGroups.values()) {
            usedThreads += tg.getTotalThreads();
        }
        int totalThreads = this.getTotalThreads();
        if (usedThreads < totalThreads) {
            s = totalThreads + " total threads are configured using hydra.ClientPrms, but only " + usedThreads + " are required by the THREADGROUPs used by INITTASKs, TASKs, and CLOSETASKs: " + this.ThreadGroups.keySet() + ".  Excess threads are not allowed when the \"" + "default" + "\" threadgroup is not used.";
            throw new HydraConfigException(s);
        }
        if (usedThreads > totalThreads) {
            s = totalThreads + " total threads are configured using hydra.ClientPrms, but " + usedThreads + " are required by the THREADGROUPs used by INITTASKs, TASKs, and CLOSETASKs: " + this.ThreadGroups.keySet() + ".";
            throw new HydraConfigException(s);
        }
        HashMap<Integer, ClientVmRecord> vms = new HashMap<Integer, ClientVmRecord>();
        int vmid = 1;
        int tid = 1;
        for (ClientDescription cd : this.ClientDescriptions.values()) {
            if (this.log().finestEnabled()) {
                this.log().finest("Doing dummy client mapping with name=" + cd.getName() + " vms=" + cd.getVmQuantity() + " threads=" + cd.getVmThreads());
            }
            for (int j = 0; j < cd.getVmQuantity(); ++j) {
                ClientVmRecord vm = new ClientVmRecord(vmid, tid, cd);
                for (int threads = 0; threads < cd.getVmThreads(); ++threads) {
                    ClientRecord client = new ClientRecord(tid, vm);
                    vm.addClient(client);
                    ++tid;
                }
                vms.put(new Integer(vmid), vm);
                ++vmid;
            }
        }
        ClientMapper mapper = new ClientMapper(this.ThreadGroups);
        mapper.mapClients(vms);
        if (this.log().fineEnabled()) {
            this.log().fine(mapper.getMappingAsString(vms));
        }
        return vms;
    }

    private void postprocessGemFireDescriptions() {
        Map<String, GemFireDescription> gfds = this.getGemFireDescriptions();
        TreeMap<String, Integer> dsMcastPorts = new TreeMap<String, Integer>();
        if (gfds.size() != 0) {
            String dsName;
            for (GemFireDescription gfd : gfds.values()) {
                if (!gfd.getEnableMcast().booleanValue() || dsMcastPorts.containsKey(dsName = gfd.getDistributedSystem())) continue;
                InetAddress addr = null;
                try {
                    addr = InetAddress.getByName(gfd.getMcastAddress());
                }
                catch (UnknownHostException e) {
                    String s = "Unable to get address for: " + gfd.getMcastAddress();
                    throw new HydraRuntimeException(s, e);
                }
                int port = gfd.getMcastPort();
                if (port != 0) {
                    if (!AvailablePort.isPortAvailable((int)port, (int)1, (InetAddress)addr)) {
                        this.log().error("The port specified: " + port + " is already in use!  Test results will be invalid");
                    }
                } else {
                    port = AvailablePort.getRandomAvailablePort((int)1, (InetAddress)addr);
                }
                this.log().info("assigning mcast port: " + port + " to distributed system: " + dsName);
                dsMcastPorts.put(dsName, new Integer(port));
                if (gfd.getUseLocator().booleanValue()) continue;
                String data = "multicast:" + dsName + ":" + gfd.getMcastAddress() + ":" + port;
                FileUtil.appendToFile("discovery.dat", data + "\n");
            }
            for (GemFireDescription gfd : gfds.values()) {
                dsName = gfd.getDistributedSystem();
                if (!dsMcastPorts.containsKey(dsName)) continue;
                if (gfd.getEnableMcast().booleanValue()) {
                    gfd.setMcastPort((Integer)dsMcastPorts.get(dsName));
                    continue;
                }
                String s = BasePrms.nameForKey(GemFirePrms.names) + "=" + gfd.getName() + " is part of a multicast distributed system but it sets " + BasePrms.nameForKey(GemFirePrms.enableMcast) + "=" + gfd.getEnableMcast() + ".";
                throw new HydraConfigException(s);
            }
        }
    }

    private LogWriter log() {
        return Log.getLogWriter();
    }
}

