/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.BasePrms;
import hydra.HydraConfigException;
import hydra.HydraVector;
import hydra.Log;
import hydra.StatMonitor;
import hydra.TestConfig;
import java.util.Vector;

public class StatMonitorPrms
extends BasePrms {
    public static Long sampleRateMs;
    public static final int DEFAULT_SAMPLE_RATE_MS = 60000;
    public static Long conditions;
    public static Long archiveStats;
    public static Long verbose;

    public static int getSampleRateMs(TestConfig tc) {
        Long key = sampleRateMs;
        int val = tc.getParameters().intAt(key, 60000);
        if (val < 1000) {
            String s = "Illegal value for " + StatMonitorPrms.nameForKey(key) + ": " + val;
            throw new HydraConfigException(s);
        }
        return val;
    }

    public static Vector getConditions(TestConfig tc) {
        String str;
        Long key = conditions;
        HydraVector val = tc.getParameters().vecAt(key, null);
        if (val == null) {
            return null;
        }
        if (val.size() == 1 && (str = (String)val.get(0)).equalsIgnoreCase("none")) {
            return null;
        }
        int i = 0;
        Vector<HydraVector> vals = null;
        do {
            if ((val = tc.getParameters().vecAt(key, i, null)) != null) {
                if (vals == null) {
                    vals = new Vector<HydraVector>();
                }
                vals.add(val);
            }
            ++i;
        } while (val != null);
        try {
            return StatMonitor.parseConditions(vals);
        }
        catch (HydraConfigException e) {
            String s = "Illegal value for " + StatMonitorPrms.nameForKey(key);
            throw new HydraConfigException(s, (Exception)((Object)e));
        }
    }

    public static boolean archiveStats(TestConfig tc) {
        Long key = archiveStats;
        return tc.getParameters().booleanAt(key, false);
    }

    public static boolean verbose(TestConfig tc) {
        Long key = verbose;
        return tc.getParameters().booleanAt(key, false);
    }

    public static void main(String[] args) {
        Log.createLogWriter("hostagentprms", "info");
        StatMonitorPrms.dumpKeys();
    }

    static {
        StatMonitorPrms.setValues(StatMonitorPrms.class);
    }
}

