/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.BaseTaskScheduler;
import hydra.ClientRecord;
import hydra.ClientVmRecord;
import hydra.TestTask;
import java.util.Vector;

public abstract class SimpleTaskScheduler
extends BaseTaskScheduler {
    public SimpleTaskScheduler(String name, Vector tasks, String purpose) {
        super(name, tasks, purpose);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean schedule(ClientRecord client, TestTask task, long now) {
        if (task.usesThreadGroup(client.getThreadGroupName()) && !task.receivedStopSchedulingTaskOnClientOrder(client)) {
            ClientVmRecord vm;
            ClientVmRecord clientVmRecord = vm = client.vm();
            synchronized (clientVmRecord) {
                if (vm.isLive()) {
                    ClientRecord clientRecord = client;
                    synchronized (clientRecord) {
                        client.setBusy(true);
                        client.setTask(task);
                        client.setStartTime(now);
                        TestTask testTask = task;
                        synchronized (testTask) {
                            task.incrementNumTimesInUse();
                        }
                        this.assignTask(client, task);
                    }
                }
            }
            return true;
        }
        return false;
    }

    protected boolean terminateScheduling(Vector clients, TestTask task, int count, long now) {
        return this.receivedStopSchedulingTaskOnClientOrder(task, clients) || this.terminateScheduling(count, now);
    }

    protected boolean terminateScheduling(ClientRecord client, TestTask task, int count, long now) {
        return this.receivedStopSchedulingTaskOnClientOrder(task, client) || this.terminateScheduling(count, now);
    }

    private boolean terminateScheduling(int count, long now) {
        if (!(this.hadFatalTaskErrorAndHaltOrder() || this.hadStatMonitorError() || this.hadDynamicActionError() || this.hadDynamicActionHang() || this.exceededMaxResultWaitSec(now))) {
            if (count == 0) {
                this.printSchedulingReport(now);
                this.pauseScheduling();
            }
            return false;
        }
        return true;
    }

    private boolean receivedStopSchedulingTaskOnClientOrder(TestTask task, Vector clients) {
        for (ClientRecord client : clients) {
            if (task.receivedStopSchedulingTaskOnClientOrder(client)) continue;
            return false;
        }
        return true;
    }

    private boolean receivedStopSchedulingTaskOnClientOrder(TestTask task, ClientRecord client) {
        return task.receivedStopSchedulingTaskOnClientOrder(client);
    }
}

