/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.internal.cache.PartitionAttributesImpl;
import hydra.BasePrms;
import hydra.DiskStoreHelper;
import hydra.HDFSStoreHelper;
import hydra.HydraInternalException;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.PoolHelper;
import hydra.RegionDescription;
import hydra.RegionPrms;
import hydra.TestConfig;
import java.util.TreeSet;

public class RegionHelper {
    private static final String NO_EVICTION = "algorithm=none";
    private static final String DEFAULT_EVICTION_FOR_HDFS_PREFIX = "algorithm=lru-heap-percentage; action=overflow-to-disk; sizer=com.gemstone.gemfire.internal.size.SizeClassOnceObjectSizer";
    private static LogWriter log;

    public static synchronized Region createRegion(String regionConfig) {
        String regionName = RegionHelper.getRegionDescription(regionConfig).getRegionName();
        return RegionHelper.createRegion(regionName, regionConfig);
    }

    public static synchronized Region createRegion(String regionName, String regionConfig) {
        AttributesFactory factory = RegionHelper.getAttributesFactory(regionName, regionConfig);
        return RegionHelper.createRegion(regionName, factory);
    }

    public static synchronized Region createRegion(String regionName, AttributesFactory factory) {
        RegionAttributes attributes = RegionHelper.getRegionAttributes(factory);
        return RegionHelper.createRegion(regionName, attributes);
    }

    public static synchronized Region createRegion(String regionName, RegionAttributes attributes) {
        if (regionName == null) {
            throw new IllegalArgumentException("regionName cannot be null");
        }
        if (attributes == null) {
            throw new IllegalArgumentException("attributes cannot be null");
        }
        Cache cache = CacheFactory.getAnyInstance();
        Region region = cache.getRegion(regionName);
        if (region == null) {
            String poolConfig;
            String hdfsStoreConfig;
            RegionHelper.log("Creating region named: " + regionName + " with attributes " + RegionHelper.regionAttributesToString(attributes));
            String diskStoreConfig = attributes.getDiskStoreName();
            if (diskStoreConfig != null) {
                DiskStoreHelper.createDiskStore(diskStoreConfig);
            }
            if ((hdfsStoreConfig = attributes.getHDFSStoreName()) != null) {
                HDFSStoreHelper.createHDFSStore(hdfsStoreConfig);
            }
            if ((poolConfig = attributes.getPoolName()) != null) {
                PoolHelper.createPool(poolConfig);
            }
            try {
                region = cache.createRegion(regionName, attributes);
            }
            catch (RegionExistsException e) {
                throw new HydraInternalException("Should not happen", (Exception)((Object)e));
            }
            RegionHelper.log("Created region named: " + regionName + " with attributes:" + RegionHelper.regionAttributesToString(region.getAttributes()));
        } else {
            String results;
            if (attributes.getPartitionAttributes() != null) {
                try {
                    ((PartitionAttributesImpl)attributes.getPartitionAttributes()).computeLocalMaxMemory();
                }
                catch (NoSuchMethodError e) {
                    RegionHelper.log("Skipping com.gemstone.gemfire.internal.cache.PartitionAttributesImpl.computeLocalMaxMemory() for GemFireXD 1.0 since the method does not exist there");
                }
            }
            if ((results = RegionHelper.compareRegionAttributes(regionName, attributes, region.getAttributes())) != null) {
                String s = "Region " + regionName + " already exists with different attributes: " + results;
                throw new HydraRuntimeException(s);
            }
        }
        return region;
    }

    public static synchronized Region getRegion(String regionName) {
        if (regionName == null) {
            throw new IllegalArgumentException("regionName cannot be null");
        }
        return CacheFactory.getAnyInstance().getRegion(regionName);
    }

    public static RegionAttributes getRegionAttributes(String regionName, String regionConfig) {
        RegionHelper.log("Configuring region attributes for region named " + regionName + " with config: " + regionConfig);
        RegionAttributes ratts = RegionHelper.getAttributesFactory(regionName, regionConfig).create();
        RegionHelper.log("Created region attributes: " + RegionHelper.regionAttributesToString(ratts));
        return ratts;
    }

    public static RegionAttributes getRegionAttributes(String regionConfig) {
        RegionHelper.log("Creating region attributes for config: " + regionConfig);
        RegionAttributes ratts = RegionHelper.getAttributesFactory(regionConfig).create();
        RegionHelper.log("Created region attributes: " + RegionHelper.regionAttributesToString(ratts));
        return ratts;
    }

    public static RegionAttributes getRegionAttributes(AttributesFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("factory cannot be null");
        }
        return factory.create();
    }

    public static String regionAttributesToString(RegionAttributes attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException("attributes cannot be null");
        }
        return RegionDescription.regionAttributesToString(attributes);
    }

    private static synchronized String compareRegionAttributes(String regionName, RegionAttributes datts, RegionAttributes eatts) {
        String epart;
        EvictionAttributes eevict;
        TreeSet eaeqids;
        String existing;
        String desired = RegionHelper.regionAttributesToString(datts);
        if (desired.equals(existing = RegionHelper.regionAttributesToString(eatts))) {
            return null;
        }
        if (!datts.getDataPolicy().withHDFS() || !eatts.getDataPolicy().withHDFS()) {
            return "\n  DESIRED = " + desired + "\n  EXISTING = " + existing;
        }
        TreeSet daeqids = new TreeSet(datts.getAsyncEventQueueIds());
        if (!daeqids.equals(eaeqids = new TreeSet(eatts.getAsyncEventQueueIds()))) {
            TreeSet<String> removed = null;
            for (String eaeqid : eaeqids) {
                if (!eaeqid.startsWith("GEMFIRE_HDFS_BUCKETSORTED_QUEUE")) continue;
                eaeqids.remove(eaeqid);
                if (removed == null) {
                    removed = new TreeSet<String>();
                }
                removed.add(eaeqid);
            }
            if (!daeqids.equals(eaeqids)) {
                String err = "asyncEventQueueIds do not match";
                if (removed != null) {
                    err = err + " in spite of accounting for HDFS side effects: " + removed;
                }
                return err + "\n  DESIRED = " + desired + "\n  EXISTING = " + existing;
            }
        }
        String dstore = datts.getDiskStoreName();
        String estore = eatts.getDiskStoreName();
        if (dstore != null && !dstore.equals(estore)) {
            String err = "disk store names do not match in spite of accounting for HDFS side effects";
            return err + "\n  DESIRED = " + desired + "\n  EXISTING = " + existing;
        }
        EvictionAttributes devict = datts.getEvictionAttributes();
        if (!(devict.equals((Object)(eevict = eatts.getEvictionAttributes())) || devict.toString().trim().equals(NO_EVICTION) && eevict.toString().trim().startsWith(DEFAULT_EVICTION_FOR_HDFS_PREFIX))) {
            String err = "evictionAttributes do not match in spite of accounting for HDFS side effects: algorithm=lru-heap-percentage; action=overflow-to-disk; sizer=com.gemstone.gemfire.internal.size.SizeClassOnceObjectSizer";
            return err + "\n  DESIRED = " + desired + "\n  EXISTING = " + existing;
        }
        String dpart = RegionDescription.regionAttributesToStringPartial(datts);
        if (!dpart.equals(epart = RegionDescription.regionAttributesToStringPartial(eatts))) {
            return "\n  DESIRED = " + desired + "\n  EXISTING = " + existing;
        }
        return null;
    }

    public static AttributesFactory getAttributesFactory(String regionName, String regionConfig) {
        RegionDescription rd = RegionHelper.getRegionDescription(regionConfig);
        AttributesFactory factory = new AttributesFactory();
        RegionHelper.log("Configuring attributes factory for region named " + regionName + " with config: " + regionConfig);
        rd.configure(regionName, factory, true);
        RegionHelper.log("Configured attributes factory: " + factory);
        return factory;
    }

    public static AttributesFactory getAttributesFactory(String regionConfig) {
        RegionDescription rd = RegionHelper.getRegionDescription(regionConfig);
        AttributesFactory factory = new AttributesFactory();
        RegionHelper.log("Configuring attributes factory for region config: " + regionConfig);
        rd.configure(rd.getRegionName(), factory, true);
        RegionHelper.log("Configured attributes factory: " + factory);
        return factory;
    }

    public static RegionDescription getRegionDescription(String regionConfig) {
        if (regionConfig == null) {
            throw new IllegalArgumentException("regionConfig cannot be null");
        }
        RegionHelper.log("Looking up region config: " + regionConfig);
        RegionDescription rd = TestConfig.getInstance().getRegionDescription(regionConfig);
        if (rd == null) {
            String s = regionConfig + " not found in " + BasePrms.nameForKey(RegionPrms.names);
            throw new HydraRuntimeException(s);
        }
        RegionHelper.log("Looked up region config:\n" + rd);
        return rd;
    }

    private static synchronized void log(String s) {
        if (log == null) {
            log = Log.getLogWriter();
        }
        if (log.infoEnabled()) {
            log.info(s);
        }
    }
}

