/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.CustomExpiry;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAlgorithm;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.ExpirationAction;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.InterestPolicy;
import com.gemstone.gemfire.cache.LossAction;
import com.gemstone.gemfire.cache.MembershipAttributes;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.ResumptionAction;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.SubscriptionAttributes;
import com.gemstone.gemfire.cache.util.ObjectSizer;
import com.gemstone.gemfire.compression.Compressor;
import hydra.AbstractDescription;
import hydra.AsyncEventQueueDescription;
import hydra.AsyncEventQueuePrms;
import hydra.BasePrms;
import hydra.ConfigHashtable;
import hydra.DiskStoreDescription;
import hydra.DiskStorePrms;
import hydra.GatewaySenderDescription;
import hydra.GatewaySenderHelper;
import hydra.GatewaySenderPrms;
import hydra.HDFSStoreDescription;
import hydra.HDFSStorePrms;
import hydra.HydraConfigException;
import hydra.HydraInternalException;
import hydra.HydraRuntimeException;
import hydra.HydraVector;
import hydra.PartitionDescription;
import hydra.PartitionPrms;
import hydra.PoolDescription;
import hydra.PoolPrms;
import hydra.RegionPrms;
import hydra.TestConfig;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;

public class RegionDescription
extends AbstractDescription
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String PARTITION = "PARTITION";
    private static Map cacheListenerInstanceMaps = new HashMap();
    private static Map cacheLoaderInstances = new HashMap();
    private static Map cacheWriterInstances = new HashMap();
    private static Map compressorInstances = new HashMap();
    private String name;
    private List<AsyncEventQueueDescription> asyncEventQueueDescriptions;
    private List<String> asyncEventQueueNames;
    private List cacheListeners;
    private Boolean cacheListenersSingleton;
    private String cacheLoader;
    private Boolean cacheLoaderSingleton;
    private String cacheWriter;
    private Boolean cacheWriterSingleton;
    private Boolean cloningEnabled;
    private String compressor;
    private Boolean compressorSingleton;
    private Boolean concurrencyChecksEnabled;
    private Integer concurrencyLevel;
    private String customEntryIdleTimeout;
    private String customEntryTimeToLive;
    private DataPolicy dataPolicy;
    private DiskStoreDescription diskStoreDescription;
    private String diskStoreName;
    private Boolean diskSynchronous;
    private Boolean enableAsyncConflation;
    private Boolean enableGateway;
    private Boolean enableOffHeapMemory;
    private Boolean enableSubscriptionConflation;
    private ExpirationAttributes entryIdleTimeout;
    private ExpirationAttributes entryTimeToLive;
    private EvictionAttributes evictionAttributes;
    private List<GatewaySenderDescription> gatewaySenderDescriptions;
    private List<String> gatewaySenderNames;
    private HDFSStoreDescription hdfsStoreDescription;
    private String hdfsStoreName;
    private Boolean hdfsWriteOnly;
    private Boolean ignoreJTA;
    private Boolean indexMaintenanceSynchronous;
    private Integer initialCapacity;
    private SubscriptionAttributes interestPolicy;
    private Class keyConstraint;
    private Float loadFactor;
    private Boolean lockGrantor;
    private MembershipAttributes membershipAttributes;
    private Boolean multicastEnabled;
    private PartitionDescription partitionDescription;
    private String partitionDescriptionName;
    private PoolDescription poolDescription;
    private String poolDescriptionName;
    private ExpirationAttributes regionIdleTimeout;
    private String regionName;
    private ExpirationAttributes regionTimeToLive;
    private Scope scope;
    private Boolean statisticsEnabled;
    private Class valueConstraint;
    private static final int NONE = 0;
    private static final int LRU_ENTRY = 1;
    private static final int LRU_HEAP = 2;
    private static final int LRU_MEMORY = 3;

    public String getName() {
        return this.name;
    }

    private void setName(String str) {
        this.name = str;
    }

    public List<AsyncEventQueueDescription> getAsyncEventQueueDescriptions() {
        return this.asyncEventQueueDescriptions;
    }

    private void setAsyncEventQueueDescriptions(List<AsyncEventQueueDescription> aeqds) {
        this.asyncEventQueueDescriptions = aeqds;
    }

    public List<String> getAsyncEventQueueNames() {
        return this.asyncEventQueueNames;
    }

    private void setAsyncEventQueueNames(List<String> strs) {
        this.asyncEventQueueNames = strs;
    }

    private List getCacheListeners() {
        return this.cacheListeners;
    }

    private void setCacheListeners(List classnames) {
        this.cacheListeners = classnames;
    }

    private Boolean getCacheListenersSingleton() {
        return this.cacheListenersSingleton;
    }

    private void setCacheListenersSingleton(Boolean bool) {
        this.cacheListenersSingleton = bool;
    }

    private String getCacheLoader() {
        return this.cacheLoader;
    }

    private void setCacheLoader(String s) {
        this.cacheLoader = s;
    }

    private Boolean getCacheLoaderSingleton() {
        return this.cacheLoaderSingleton;
    }

    private void setCacheLoaderSingleton(Boolean bool) {
        this.cacheLoaderSingleton = bool;
    }

    private String getCacheWriter() {
        return this.cacheWriter;
    }

    private void setCacheWriter(String s) {
        this.cacheWriter = s;
    }

    private Boolean getCacheWriterSingleton() {
        return this.cacheWriterSingleton;
    }

    private void setCacheWriterSingleton(Boolean bool) {
        this.cacheWriterSingleton = bool;
    }

    private Boolean getCloningEnabled() {
        return this.cloningEnabled;
    }

    private void setCloningEnabled(Boolean bool) {
        this.cloningEnabled = bool;
    }

    private String getCompressor() {
        return this.compressor;
    }

    private void setCompressor(String str) {
        this.compressor = str;
    }

    private Boolean getCompressorSingleton() {
        return this.compressorSingleton;
    }

    private void setCompressorSingleton(Boolean bool) {
        this.compressorSingleton = bool;
    }

    private Boolean getConcurrencyChecksEnabled() {
        return this.concurrencyChecksEnabled;
    }

    private void setConcurrencyChecksEnabled(Boolean bool) {
        this.concurrencyChecksEnabled = bool;
    }

    private Integer getConcurrencyLevel() {
        return this.concurrencyLevel;
    }

    private void setConcurrencyLevel(Integer i) {
        this.concurrencyLevel = i;
    }

    private String getCustomEntryIdleTimeout() {
        return this.customEntryIdleTimeout;
    }

    private void setCustomEntryIdleTimeout(String str) {
        this.customEntryIdleTimeout = str;
    }

    private String getCustomEntryTimeToLive() {
        return this.customEntryTimeToLive;
    }

    private void setCustomEntryTimeToLive(String str) {
        this.customEntryTimeToLive = str;
    }

    public DataPolicy getDataPolicy() {
        return this.dataPolicy;
    }

    private void setDataPolicy(DataPolicy aDataPolicy) {
        this.dataPolicy = aDataPolicy;
    }

    public String getDiskStoreName() {
        return this.diskStoreName;
    }

    private void setDiskStoreName(String str) {
        this.diskStoreName = str;
    }

    public DiskStoreDescription getDiskStoreDescription() {
        return this.diskStoreDescription;
    }

    private void setDiskStoreDescription(DiskStoreDescription dsd) {
        this.diskStoreDescription = dsd;
    }

    private Boolean getDiskSynchronous() {
        return this.diskSynchronous;
    }

    private void setDiskSynchronous(Boolean bool) {
        this.diskSynchronous = bool;
    }

    private Boolean getEnableAsyncConflation() {
        return this.enableAsyncConflation;
    }

    private void setEnableAsyncConflation(Boolean bool) {
        this.enableAsyncConflation = bool;
    }

    private Boolean getEnableGateway() {
        return this.enableGateway;
    }

    private void setEnableGateway(Boolean bool) {
        this.enableGateway = bool;
    }

    private Boolean getEnableOffHeapMemory() {
        return this.enableOffHeapMemory;
    }

    private void setEnableOffHeapMemory(Boolean bool) {
        this.enableOffHeapMemory = bool;
    }

    private Boolean getEnableSubscriptionConflation() {
        return this.enableSubscriptionConflation;
    }

    private void setEnableSubscriptionConflation(Boolean bool) {
        this.enableSubscriptionConflation = bool;
    }

    private ExpirationAttributes getEntryIdleTimeout() {
        return this.entryIdleTimeout;
    }

    private void setEntryIdleTimeout(ExpirationAttributes attributes) {
        this.entryIdleTimeout = attributes;
    }

    private ExpirationAttributes getEntryTimeToLive() {
        return this.entryTimeToLive;
    }

    private void setEntryTimeToLive(ExpirationAttributes attributes) {
        this.entryTimeToLive = attributes;
    }

    public EvictionAttributes getEvictionAttributes() {
        return this.evictionAttributes;
    }

    private void setEvictionAttributes(EvictionAttributes attributes) {
        this.evictionAttributes = attributes;
    }

    public List<GatewaySenderDescription> getGatewaySenderDescriptions() {
        return this.gatewaySenderDescriptions;
    }

    private void setGatewaySenderDescriptions(List<GatewaySenderDescription> gsds) {
        this.gatewaySenderDescriptions = gsds;
    }

    public List<String> getGatewaySenderNames() {
        return this.gatewaySenderNames;
    }

    private void setGatewaySenderNames(List<String> strs) {
        this.gatewaySenderNames = strs;
    }

    public String getHDFSStoreName() {
        return this.hdfsStoreName;
    }

    private void setHDFSStoreName(String str) {
        this.hdfsStoreName = str;
    }

    public HDFSStoreDescription getHDFSStoreDescription() {
        return this.hdfsStoreDescription;
    }

    private void setHDFSStoreDescription(HDFSStoreDescription hsd) {
        this.hdfsStoreDescription = hsd;
    }

    private Boolean getHDFSWriteOnly() {
        return this.hdfsWriteOnly;
    }

    private void setHDFSWriteOnly(Boolean bool) {
        this.hdfsWriteOnly = bool;
    }

    private Boolean getIgnoreJTA() {
        return this.ignoreJTA;
    }

    private void setIgnoreJTA(Boolean bool) {
        this.ignoreJTA = bool;
    }

    private Boolean getIndexMaintenanceSynchronous() {
        return this.indexMaintenanceSynchronous;
    }

    private void setIndexMaintenanceSynchronous(Boolean bool) {
        this.indexMaintenanceSynchronous = bool;
    }

    private Integer getInitialCapacity() {
        return this.initialCapacity;
    }

    private void setInitialCapacity(Integer i) {
        this.initialCapacity = i;
    }

    private SubscriptionAttributes getInterestPolicy() {
        return this.interestPolicy;
    }

    private void setInterestPolicy(SubscriptionAttributes attributes) {
        this.interestPolicy = attributes;
    }

    private Class getKeyConstraint() {
        return this.keyConstraint;
    }

    private void setKeyConstraint(Class cls) {
        this.keyConstraint = cls;
    }

    private Float getLoadFactor() {
        return this.loadFactor;
    }

    private void setLoadFactor(Float f) {
        this.loadFactor = f;
    }

    private Boolean getLockGrantor() {
        return this.lockGrantor;
    }

    private void setLockGrantor(Boolean bool) {
        this.lockGrantor = bool;
    }

    private MembershipAttributes getMembershipAttributes() {
        return this.membershipAttributes;
    }

    private void setMembershipAttributes(MembershipAttributes attributes) {
        this.membershipAttributes = attributes;
    }

    private Boolean getMulticastEnabled() {
        if (this.multicastEnabled == null) {
            String gemfire = System.getProperty("gemfireName");
            if (gemfire == null) {
                String s = "This VM is not configured for a distributed system: missing property gemfireName";
                throw new HydraRuntimeException(s);
            }
            this.multicastEnabled = TestConfig.getInstance().getGemFireDescription(gemfire).getEnableMcast();
        }
        return this.multicastEnabled;
    }

    private void setMulticastEnabled(Boolean bool) {
        this.multicastEnabled = bool;
    }

    private String getPartitionDescriptionName() {
        return this.partitionDescriptionName;
    }

    private void setPartitionDescriptionName(String str) {
        this.partitionDescriptionName = str;
    }

    public PartitionDescription getPartitionDescription() {
        return this.partitionDescription;
    }

    private void setPartitionDescription(PartitionDescription pd) {
        this.partitionDescription = pd;
    }

    private String getPoolDescriptionName() {
        return this.poolDescriptionName;
    }

    private void setPoolDescriptionName(String str) {
        this.poolDescriptionName = str;
    }

    public PoolDescription getPoolDescription() {
        return this.poolDescription;
    }

    private void setPoolDescription(PoolDescription pd) {
        this.poolDescription = pd;
    }

    private ExpirationAttributes getRegionIdleTimeout() {
        return this.regionIdleTimeout;
    }

    private void setRegionIdleTimeout(ExpirationAttributes attributes) {
        this.regionIdleTimeout = attributes;
    }

    public String getRegionName() {
        return this.regionName;
    }

    private void setRegionName(String str) {
        this.regionName = str;
    }

    private ExpirationAttributes getRegionTimeToLive() {
        return this.regionTimeToLive;
    }

    private void setRegionTimeToLive(ExpirationAttributes attributes) {
        this.regionTimeToLive = attributes;
    }

    private Scope getScope() {
        return this.scope;
    }

    private void setScope(Scope aScope) {
        this.scope = aScope;
    }

    private Boolean getStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    private void setStatisticsEnabled(Boolean bool) {
        this.statisticsEnabled = bool;
    }

    private Class getValueConstraint() {
        return this.valueConstraint;
    }

    private void setValueConstraint(Class cls) {
        this.valueConstraint = cls;
    }

    public void configure(AttributesFactory f, boolean instantiate) {
        this.configure("DefaultRegion", f, instantiate);
    }

    protected void configure(String regionName, AttributesFactory f, boolean instantiate) {
        List<AsyncEventQueueDescription> aeqds = this.getAsyncEventQueueDescriptions();
        if (aeqds != null) {
            for (AsyncEventQueueDescription aeqd : aeqds) {
                f.addAsyncEventQueueId(aeqd.getName());
            }
        }
        f.setCacheLoader(this.getCacheLoaderInstance(instantiate));
        f.setCacheWriter(this.getCacheWriterInstance(instantiate));
        f.initCacheListeners(this.getCacheListenerInstances(instantiate));
        f.setCloningEnabled(this.getCloningEnabled().booleanValue());
        if (this.getCompressor() != null) {
            f.setCompressor(this.getCompressorInstance(instantiate));
        }
        f.setConcurrencyChecksEnabled(this.getConcurrencyChecksEnabled().booleanValue());
        f.setConcurrencyLevel(this.getConcurrencyLevel().intValue());
        f.setCustomEntryIdleTimeout(this.getCustomEntryIdleTimeoutInstance());
        f.setCustomEntryTimeToLive(this.getCustomEntryTimeToLiveInstance());
        f.setDataPolicy(this.getDataPolicy());
        if (this.getDiskStoreDescription() != null) {
            f.setDiskStoreName(this.getDiskStoreDescription().getName());
        }
        f.setDiskSynchronous(this.getDiskSynchronous().booleanValue());
        f.setEnableAsyncConflation(this.getEnableAsyncConflation().booleanValue());
        f.setEnableGateway(this.getEnableGateway().booleanValue());
        f.setEnableOffHeapMemory(this.getEnableOffHeapMemory().booleanValue());
        f.setEnableSubscriptionConflation(this.getEnableSubscriptionConflation().booleanValue());
        f.setEntryIdleTimeout(this.getEntryIdleTimeout());
        f.setEntryTimeToLive(this.getEntryTimeToLive());
        f.setEvictionAttributes(this.getEvictionAttributes());
        List<GatewaySenderDescription> gsds = this.getGatewaySenderDescriptions();
        if (gsds != null) {
            for (GatewaySenderDescription gsd : gsds) {
                Set<String> serIds = GatewaySenderHelper.getSerialGatewaySenderIds(gsd.getName());
                for (String serId : serIds) {
                    f.addGatewaySenderId(serId);
                }
                Set<String> parIds = GatewaySenderHelper.getParallelGatewaySenderIds(gsd.getName());
                for (String parId : parIds) {
                    f.addGatewaySenderId(parId);
                }
            }
        }
        if (this.getHDFSStoreDescription() != null) {
            f.setHDFSStoreName(this.getHDFSStoreDescription().getName());
        }
        f.setHDFSWriteOnly(this.getHDFSWriteOnly().booleanValue());
        f.setIgnoreJTA(this.getIgnoreJTA().booleanValue());
        f.setIndexMaintenanceSynchronous(this.getIndexMaintenanceSynchronous().booleanValue());
        f.setInitialCapacity(this.getInitialCapacity().intValue());
        f.setSubscriptionAttributes(this.getInterestPolicy());
        f.setKeyConstraint(this.getKeyConstraint());
        f.setLoadFactor(this.getLoadFactor().floatValue());
        f.setLockGrantor(this.getLockGrantor().booleanValue());
        f.setMembershipAttributes(this.getMembershipAttributes());
        f.setMulticastEnabled(this.getMulticastEnabled().booleanValue());
        if (this.getPartitionDescription() != null) {
            f.setPartitionAttributes(this.getPartitionDescription().getPartitionAttributes(this.regionName));
        }
        if (this.getPoolDescription() != null) {
            f.setPoolName(this.getPoolDescription().getName());
        }
        f.setRegionIdleTimeout(this.getRegionIdleTimeout());
        f.setRegionTimeToLive(this.getRegionTimeToLive());
        if (!RegionDescription.isPartitioned(this.getDataPolicy())) {
            f.setScope(this.getScope());
        }
        f.setStatisticsEnabled(this.getStatisticsEnabled().booleanValue());
        f.setValueConstraint(this.getValueConstraint());
    }

    protected static synchronized String regionAttributesToString(RegionAttributes r) {
        StringBuffer buf = new StringBuffer();
        buf.append("\n  asyncEventQueues: " + new TreeSet(r.getAsyncEventQueueIds()));
        buf.append("\n  cacheListeners: " + RegionDescription.cacheListenersFor(r.getCacheListeners()));
        buf.append("\n  cacheLoader: " + RegionDescription.cacheLoaderFor(r.getCacheLoader()));
        buf.append("\n  cacheWriter: " + RegionDescription.cacheWriterFor(r.getCacheWriter()));
        buf.append("\n  cloningEnabled: " + r.getCloningEnabled());
        buf.append("\n  compressor: " + RegionDescription.compressorFor(r.getCompressor()));
        buf.append("\n  concurrencyChecksEnabled: " + r.getConcurrencyChecksEnabled());
        buf.append("\n  concurrencyLevel: " + r.getConcurrencyLevel());
        buf.append("\n  customEntryIdleTimeout: " + RegionDescription.customExpiryFor(r.getCustomEntryIdleTimeout()));
        buf.append("\n  customEntryTimeToLive: " + RegionDescription.customExpiryFor(r.getCustomEntryTimeToLive()));
        buf.append("\n  dataPolicy: " + r.getDataPolicy());
        buf.append("\n  diskStoreName: " + r.getDiskStoreName());
        buf.append("\n  diskSynchronous: " + r.isDiskSynchronous());
        buf.append("\n  enableAsyncConflation: " + r.getEnableAsyncConflation());
        buf.append("\n  enableGateway: " + r.getEnableGateway());
        buf.append("\n  enableOffHeapMemory: " + r.getEnableOffHeapMemory());
        buf.append("\n  enableSubscriptionConflation: " + r.getEnableSubscriptionConflation());
        buf.append("\n  entryIdleTimeout: " + r.getEntryIdleTimeout());
        buf.append("\n  entryTimeToLive: " + r.getEntryTimeToLive());
        buf.append("\n  evictionAttributes: " + r.getEvictionAttributes());
        buf.append("\n  gatewaySenders: " + new TreeSet(r.getGatewaySenderIds()));
        buf.append("\n  hdfsStoreName: " + r.getHDFSStoreName());
        buf.append("\n  hdfsWriteOnly: " + r.getHDFSWriteOnly());
        buf.append("\n  ignoreJTA: " + r.getIgnoreJTA());
        buf.append("\n  indexMaintenanceSynchronous: " + r.getIndexMaintenanceSynchronous());
        buf.append("\n  initialCapacity: " + r.getInitialCapacity());
        buf.append("\n  interestPolicy: " + r.getSubscriptionAttributes());
        buf.append("\n  keyConstraint: " + r.getKeyConstraint());
        buf.append("\n  loadFactor: " + r.getLoadFactor());
        buf.append("\n  lockGrantor: " + r.isLockGrantor());
        buf.append("\n  membershipAttributes: " + r.getMembershipAttributes());
        buf.append("\n  multicastEnabled: " + r.getMulticastEnabled());
        buf.append("\n  partitionAttributes: " + PartitionDescription.partitionAttributesToString(r.getPartitionAttributes()));
        buf.append("\n  poolName: " + r.getPoolName());
        buf.append("\n  regionIdleTimeout: " + r.getRegionIdleTimeout());
        buf.append("\n  regionTimeToLive: " + r.getRegionTimeToLive());
        buf.append("\n  scope: " + r.getScope());
        buf.append("\n  statisticsEnabled: " + r.getStatisticsEnabled());
        buf.append("\n  valueConstraint: " + r.getValueConstraint());
        return buf.toString();
    }

    protected static synchronized String regionAttributesToStringPartial(RegionAttributes r) {
        StringBuffer buf = new StringBuffer();
        buf.append("\n  cacheListeners: " + RegionDescription.cacheListenersFor(r.getCacheListeners()));
        buf.append("\n  cacheLoader: " + RegionDescription.cacheLoaderFor(r.getCacheLoader()));
        buf.append("\n  cacheWriter: " + RegionDescription.cacheWriterFor(r.getCacheWriter()));
        buf.append("\n  cloningEnabled: " + r.getCloningEnabled());
        buf.append("\n  compressor: " + RegionDescription.compressorFor(r.getCompressor()));
        buf.append("\n  concurrencyChecksEnabled: " + r.getConcurrencyChecksEnabled());
        buf.append("\n  concurrencyLevel: " + r.getConcurrencyLevel());
        buf.append("\n  customEntryIdleTimeout: " + RegionDescription.customExpiryFor(r.getCustomEntryIdleTimeout()));
        buf.append("\n  customEntryTimeToLive: " + RegionDescription.customExpiryFor(r.getCustomEntryTimeToLive()));
        buf.append("\n  dataPolicy: " + r.getDataPolicy());
        buf.append("\n  diskSynchronous: " + r.isDiskSynchronous());
        buf.append("\n  enableAsyncConflation: " + r.getEnableAsyncConflation());
        buf.append("\n  enableGateway: " + r.getEnableGateway());
        buf.append("\n  enableOffHeapMemory: " + r.getEnableOffHeapMemory());
        buf.append("\n  enableSubscriptionConflation: " + r.getEnableSubscriptionConflation());
        buf.append("\n  entryIdleTimeout: " + r.getEntryIdleTimeout());
        buf.append("\n  entryTimeToLive: " + r.getEntryTimeToLive());
        buf.append("\n  gatewaySenders: " + new TreeSet(r.getGatewaySenderIds()));
        buf.append("\n  hdfsStoreName: " + r.getHDFSStoreName());
        buf.append("\n  hdfsWriteOnly: " + r.getHDFSWriteOnly());
        buf.append("\n  ignoreJTA: " + r.getIgnoreJTA());
        buf.append("\n  indexMaintenanceSynchronous: " + r.getIndexMaintenanceSynchronous());
        buf.append("\n  initialCapacity: " + r.getInitialCapacity());
        buf.append("\n  interestPolicy: " + r.getSubscriptionAttributes());
        buf.append("\n  keyConstraint: " + r.getKeyConstraint());
        buf.append("\n  loadFactor: " + r.getLoadFactor());
        buf.append("\n  lockGrantor: " + r.isLockGrantor());
        buf.append("\n  membershipAttributes: " + r.getMembershipAttributes());
        buf.append("\n  multicastEnabled: " + r.getMulticastEnabled());
        buf.append("\n  partitionAttributes: " + PartitionDescription.partitionAttributesToString(r.getPartitionAttributes()));
        buf.append("\n  poolName: " + r.getPoolName());
        buf.append("\n  regionIdleTimeout: " + r.getRegionIdleTimeout());
        buf.append("\n  regionTimeToLive: " + r.getRegionTimeToLive());
        buf.append("\n  scope: " + r.getScope());
        buf.append("\n  statisticsEnabled: " + r.getStatisticsEnabled());
        buf.append("\n  valueConstraint: " + r.getValueConstraint());
        return buf.toString();
    }

    private static String compressorFor(Compressor compressor) {
        return compressor == null ? null : compressor.getClass().getName();
    }

    private static List cacheListenersFor(CacheListener[] listeners) {
        ArrayList<String> classnames = new ArrayList<String>();
        for (int i = 0; i < listeners.length; ++i) {
            classnames.add(listeners[i].getClass().getName());
        }
        return classnames;
    }

    private static String cacheLoaderFor(CacheLoader loader) {
        if (loader == null) {
            return null;
        }
        return loader.getClass().getName();
    }

    private static String cacheWriterFor(CacheWriter writer) {
        if (writer == null) {
            return null;
        }
        return writer.getClass().getName();
    }

    private static String customExpiryFor(CustomExpiry expiry) {
        if (expiry == null) {
            return null;
        }
        return expiry.getClass().getName();
    }

    @Override
    public SortedMap toSortedMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        String header = this.getClass().getName() + "." + this.getName() + ".";
        map.put(header + "asyncEventQueueNames", this.getAsyncEventQueueNames());
        map.put(header + "cacheListeners", this.getCacheListeners());
        map.put(header + "cacheListenersSingleton", this.getCacheListenersSingleton());
        map.put(header + "cacheLoader", this.getCacheLoader());
        map.put(header + "cacheLoaderSingleton", this.getCacheLoaderSingleton());
        map.put(header + "cacheWriter", this.getCacheWriter());
        map.put(header + "cacheWriterSingleton", this.getCacheWriterSingleton());
        map.put(header + "concurrencyChecksEnabled", this.getConcurrencyChecksEnabled());
        map.put(header + "cloningEnabled", this.getCloningEnabled());
        map.put(header + "compressor", this.getCompressor());
        map.put(header + "compressorSingleton", this.getCompressorSingleton());
        map.put(header + "concurrencyLevel", this.getConcurrencyLevel());
        map.put(header + "customEntryIdleTimeout", this.getCustomEntryIdleTimeout());
        map.put(header + "customEntryTimeToLive", this.getCustomEntryTimeToLive());
        map.put(header + "dataPolicy", this.getDataPolicy());
        map.put(header + "diskStoreName", this.getDiskStoreName());
        map.put(header + "diskSynchronous", this.getDiskSynchronous());
        map.put(header + "enableAsyncConflation", this.getEnableAsyncConflation());
        map.put(header + "enableGateway", this.getEnableGateway());
        map.put(header + "enableOffHeapMemory", this.getEnableOffHeapMemory());
        map.put(header + "enableSubscriptionConflation", this.getEnableSubscriptionConflation());
        map.put(header + "entryIdleTimeout", this.getEntryIdleTimeout());
        map.put(header + "entryTimeToLive", this.getEntryTimeToLive());
        map.put(header + "evictionAttributes", this.getEvictionAttributes());
        map.put(header + "gatewaySenderNames", this.getGatewaySenderNames());
        map.put(header + "hdfsStoreName", this.getHDFSStoreName());
        map.put(header + "hdfsWriteOnly", this.getHDFSWriteOnly());
        map.put(header + "ignoreJTA", this.getIgnoreJTA());
        map.put(header + "indexMaintenanceSynchronous", this.getIndexMaintenanceSynchronous());
        map.put(header + "initialCapacity", this.getInitialCapacity());
        map.put(header + "interestPolicy", this.getInterestPolicy());
        map.put(header + "keyConstraint", this.getKeyConstraint());
        map.put(header + "loadFactor", this.getLoadFactor());
        map.put(header + "lockGrantor", this.getLockGrantor());
        map.put(header + "membershipAttributes", this.getMembershipAttributes());
        if (this.multicastEnabled == null) {
            map.put(header + "multicastEnabled", "inherited from distributed system");
        } else {
            map.put(header + "multicastEnabled", this.getMulticastEnabled());
        }
        map.put(header + "partitionName", this.getPartitionDescriptionName());
        map.put(header + "poolName", this.getPoolDescriptionName());
        map.put(header + "regionIdleTimeout", this.getRegionIdleTimeout());
        map.put(header + "regionName", this.getRegionName());
        map.put(header + "regionTimeToLive", this.getRegionTimeToLive());
        map.put(header + "scope", this.getScope());
        map.put(header + "statisticsEnabled", this.getStatisticsEnabled());
        map.put(header + "valueConstraint", this.getValueConstraint());
        return map;
    }

    protected static void configure(TestConfig config) {
        ConfigHashtable tab = config.getParameters();
        HydraVector names = tab.vecAt(RegionPrms.names, new HydraVector());
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.elementAt(i);
            RegionDescription rd = RegionDescription.createRegionDescription(name, config, i);
            RegionAttributes ra = RegionDescription.createRegionAttributes(rd);
            RegionDescription.resetRegionDescription(rd, ra);
            config.addRegionDescription(rd);
        }
    }

    private static RegionDescription createRegionDescription(String name, TestConfig config, int index) {
        String s;
        Double d;
        ExpirationAttributes attributes;
        Integer i;
        Boolean bool;
        String str;
        Iterator i2;
        ConfigHashtable tab = config.getParameters();
        RegionDescription rd = new RegionDescription();
        rd.setName(name);
        Long key = RegionPrms.asyncEventQueueNames;
        HydraVector strs = tab.vecAtWild(key, index, null);
        if (strs != null) {
            i2 = strs.iterator();
            while (i2.hasNext()) {
                str = tab.getString(key, i2.next());
                if (str != null && !str.equalsIgnoreCase("none")) continue;
                i2.remove();
            }
            if (strs.size() > 0) {
                rd.setAsyncEventQueueDescriptions(RegionDescription.getAsyncEventQueueDescriptions(strs, key, config));
                rd.setAsyncEventQueueNames(new ArrayList<String>(strs));
            }
        }
        if ((strs = tab.vecAtWild(key = RegionPrms.cacheListeners, index, null)) != null) {
            i2 = strs.iterator();
            while (i2.hasNext()) {
                str = tab.getString(key, i2.next());
                if (str != null && !str.equalsIgnoreCase("none")) continue;
                i2.remove();
            }
            if (strs.size() > 0) {
                rd.setCacheListeners(new ArrayList(strs));
            }
        }
        if ((bool = tab.getBoolean(key = RegionPrms.cacheListenersSingleton, tab.getWild(key, index, null))) == null) {
            rd.setCacheListenersSingleton(Boolean.FALSE);
        } else {
            rd.setCacheListenersSingleton(bool);
        }
        key = RegionPrms.cacheLoader;
        String str2 = tab.getString(key, tab.getWild(key, index, null));
        if (str2 != null && !str2.equalsIgnoreCase("none")) {
            rd.setCacheLoader(RegionDescription.getCacheLoader(key, str2, config));
        }
        if ((bool = tab.getBoolean(key = RegionPrms.cacheLoaderSingleton, tab.getWild(key, index, null))) != null) {
            rd.setCacheLoaderSingleton(bool);
        } else if (rd.getCacheLoader() != null) {
            if (rd.getCacheLoader() instanceof String) {
                rd.setCacheLoaderSingleton(Boolean.FALSE);
            } else {
                rd.setCacheLoaderSingleton(Boolean.TRUE);
            }
        }
        key = RegionPrms.cacheWriter;
        str2 = tab.getString(key, tab.getWild(key, index, null));
        if (str2 != null && !str2.equalsIgnoreCase("none")) {
            rd.setCacheWriter(RegionDescription.getCacheWriter(key, str2, config));
        }
        if ((bool = tab.getBoolean(key = RegionPrms.cacheWriterSingleton, tab.getWild(key, index, null))) != null) {
            rd.setCacheWriterSingleton(bool);
        } else if (rd.getCacheWriter() != null) {
            if (rd.getCacheWriter() instanceof String) {
                rd.setCacheWriterSingleton(Boolean.FALSE);
            } else {
                rd.setCacheWriterSingleton(Boolean.TRUE);
            }
        }
        key = RegionPrms.cloningEnabled;
        bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool != null) {
            rd.setCloningEnabled(bool);
        }
        if ((str2 = tab.getString(key = RegionPrms.compressor, tab.getWild(key, index, null))) != null && !str2.equalsIgnoreCase("none")) {
            rd.setCompressor(str2);
        }
        if ((bool = tab.getBoolean(key = RegionPrms.compressorSingleton, tab.getWild(key, index, null))) == null) {
            rd.setCompressorSingleton(Boolean.FALSE);
        } else {
            rd.setCompressorSingleton(bool);
        }
        key = RegionPrms.concurrencyChecksEnabled;
        bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool != null) {
            rd.setConcurrencyChecksEnabled(bool);
        }
        if ((i = tab.getInteger(key = RegionPrms.concurrencyLevel, tab.getWild(key, index, null))) != null) {
            rd.setConcurrencyLevel(i);
        }
        if ((str2 = tab.getString(key = RegionPrms.customEntryIdleTimeout, tab.getWild(key, index, null))) != null && !str2.equalsIgnoreCase("none")) {
            rd.setCustomEntryIdleTimeout(str2);
        }
        if ((str2 = tab.getString(key = RegionPrms.customEntryTimeToLive, tab.getWild(key, index, null))) != null && !str2.equalsIgnoreCase("none")) {
            rd.setCustomEntryTimeToLive(str2);
        }
        if ((str2 = tab.getString(key = RegionPrms.dataPolicy, tab.getWild(key, index, null))) != null) {
            rd.setDataPolicy(RegionDescription.getDataPolicy(str2, key));
        }
        if ((str2 = tab.getString(key = RegionPrms.diskStoreName, tab.getWild(key, index, null))) != null && !str2.equalsIgnoreCase("none")) {
            rd.setDiskStoreDescription(RegionDescription.getDiskStoreDescription(str2, key, config));
            rd.setDiskStoreName("DiskStoreDescription." + str2);
        }
        if ((bool = tab.getBoolean(key = RegionPrms.diskSynchronous, tab.getWild(key, index, null))) != null) {
            rd.setDiskSynchronous(bool);
        }
        if ((bool = tab.getBoolean(key = RegionPrms.enableAsyncConflation, tab.getWild(key, index, null))) != null) {
            rd.setEnableAsyncConflation(bool);
        }
        if ((bool = tab.getBoolean(key = RegionPrms.enableGateway, tab.getWild(key, index, null))) != null) {
            rd.setEnableGateway(bool);
        }
        if ((bool = tab.getBoolean(key = RegionPrms.enableOffHeapMemory, tab.getWild(key, index, null))) != null) {
            rd.setEnableOffHeapMemory(bool);
        }
        if ((bool = tab.getBoolean(key = RegionPrms.enableSubscriptionConflation, tab.getWild(key, index, null))) != null) {
            rd.setEnableSubscriptionConflation(bool);
        }
        if ((attributes = RegionDescription.getExpirationAttributes(key = RegionPrms.entryIdleTimeout, tab.vecAtWild(key, index, null), tab)) != null) {
            rd.setEntryIdleTimeout(attributes);
        }
        if ((attributes = RegionDescription.getExpirationAttributes(key = RegionPrms.entryTimeToLive, tab.vecAtWild(key, index, null), tab)) != null) {
            rd.setEntryTimeToLive(attributes);
        }
        if ((attributes = RegionDescription.getEvictionAttributes(key = RegionPrms.evictionAttributes, tab.vecAtWild(key, index, null), tab)) != null) {
            rd.setEvictionAttributes((EvictionAttributes)attributes);
        }
        if ((strs = tab.vecAtWild(key = RegionPrms.gatewaySenderNames, index, null)) != null) {
            i2 = strs.iterator();
            while (i2.hasNext()) {
                str = tab.getString(key, i2.next());
                if (str != null && !str.equalsIgnoreCase("none")) continue;
                i2.remove();
            }
            if (strs.size() > 0) {
                rd.setGatewaySenderDescriptions(RegionDescription.getGatewaySenderDescriptions(strs, key, config));
                rd.setGatewaySenderNames(new ArrayList<String>(strs));
            }
        }
        if ((str2 = tab.getString(key = RegionPrms.hdfsStoreName, tab.getWild(key, index, null))) != null && !str2.equalsIgnoreCase("none")) {
            rd.setHDFSStoreDescription(RegionDescription.getHDFSStoreDescription(str2, key, config));
            rd.setHDFSStoreName("HDFSStoreDescription." + str2);
        }
        if ((bool = tab.getBoolean(key = RegionPrms.hdfsWriteOnly, tab.getWild(key, index, null))) != null) {
            rd.setHDFSWriteOnly(bool);
        }
        if ((bool = tab.getBoolean(key = RegionPrms.ignoreJTA, tab.getWild(key, index, null))) != null) {
            rd.setIgnoreJTA(bool);
        }
        if ((bool = tab.getBoolean(key = RegionPrms.indexMaintenanceSynchronous, tab.getWild(key, index, null))) != null) {
            rd.setIndexMaintenanceSynchronous(bool);
        }
        if ((i = tab.getInteger(key = RegionPrms.initialCapacity, tab.getWild(key, index, null))) != null) {
            rd.setInitialCapacity(i);
        }
        if ((str2 = tab.getString(key = RegionPrms.interestPolicy, tab.getWild(key, index, null))) != null) {
            rd.setInterestPolicy(RegionDescription.getSubscriptionAttributes(str2, key));
        }
        if ((str2 = tab.getString(key = RegionPrms.keyConstraint, tab.getWild(key, index, null))) != null && !str2.equalsIgnoreCase("none")) {
            rd.setKeyConstraint(RegionDescription.getClass(key, str2));
        }
        if ((d = tab.getDouble(key = RegionPrms.loadFactor, tab.getWild(key, index, null))) != null) {
            rd.setLoadFactor(Float.valueOf(d.floatValue()));
        }
        if ((bool = tab.getBoolean(key = RegionPrms.lockGrantor, tab.getWild(key, index, null))) != null) {
            rd.setLockGrantor(bool);
        }
        if ((attributes = RegionDescription.getMembershipAttributes(key = RegionPrms.membershipAttributes, tab.vecAtWild(key, index, null), tab)) != null) {
            rd.setMembershipAttributes((MembershipAttributes)attributes);
        }
        if ((str2 = tab.getString(key = RegionPrms.multicastEnabled, tab.getWild(key, index, null))) != null) {
            rd.setMulticastEnabled(RegionDescription.getBooleanFor(str2, key));
        }
        if ((str2 = tab.getString(key = RegionPrms.partitionName, tab.getWild(key, index, null))) != null && !str2.equalsIgnoreCase("none")) {
            rd.setPartitionDescription(RegionDescription.getPartitionDescription(str2, key, config));
            rd.setPartitionDescriptionName("PartitionDescription." + str2);
        }
        if ((str2 = tab.getString(key = RegionPrms.poolName, tab.getWild(key, index, null))) != null && !str2.equalsIgnoreCase("none")) {
            rd.setPoolDescription(RegionDescription.getPoolDescription(str2, key, config));
            rd.setPoolDescriptionName("PoolDescription." + str2);
        }
        if ((attributes = RegionDescription.getExpirationAttributes(key = RegionPrms.regionIdleTimeout, tab.vecAtWild(key, index, null), tab)) != null) {
            rd.setRegionIdleTimeout(attributes);
        }
        if ((str2 = tab.getString(key = RegionPrms.regionName, tab.getWild(key, index, null))) == null) {
            rd.setRegionName("DefaultRegion");
        } else {
            rd.setRegionName(str2);
        }
        key = RegionPrms.regionTimeToLive;
        attributes = RegionDescription.getExpirationAttributes(key, tab.vecAtWild(key, index, null), tab);
        if (attributes != null) {
            rd.setRegionTimeToLive(attributes);
        }
        if ((str2 = tab.getString(key = RegionPrms.scope, tab.getWild(key, index, null))) != null) {
            rd.setScope(RegionDescription.getScope(str2, key));
        }
        if ((bool = tab.getBoolean(key = RegionPrms.statisticsEnabled, tab.getWild(key, index, null))) != null) {
            rd.setStatisticsEnabled(bool);
        }
        if ((str2 = tab.getString(key = RegionPrms.valueConstraint, tab.getWild(key, index, null))) != null && !str2.equalsIgnoreCase("none")) {
            rd.setValueConstraint(RegionDescription.getClass(key, str2));
        }
        String pname = rd.getPartitionDescriptionName();
        DataPolicy policy = rd.getDataPolicy();
        if (pname != null && !RegionDescription.isPartitioned(policy)) {
            s = "Non-partitioned " + BasePrms.nameForKey(RegionPrms.dataPolicy) + " (" + policy + ") cannot be used with " + BasePrms.nameForKey(RegionPrms.partitionName) + " (" + pname + ")";
            throw new HydraRuntimeException(s);
        }
        if (pname != null && policy == null) {
            s = BasePrms.nameForKey(RegionPrms.dataPolicy) + " must be set explicitly to partition the region when using " + BasePrms.nameForKey(RegionPrms.partitionName) + " (" + pname + ")";
            throw new HydraRuntimeException(s);
        }
        if (pname == null && RegionDescription.isPartitioned(policy)) {
            s = BasePrms.nameForKey(RegionPrms.dataPolicy) + " (" + policy + ") requires partition attributes to be set using " + BasePrms.nameForKey(RegionPrms.partitionName);
            throw new HydraRuntimeException(s);
        }
        DataPolicy policy2 = rd.getDataPolicy();
        Scope scope = rd.getScope();
        if (scope != null && RegionDescription.isPartitioned(policy2)) {
            s = BasePrms.nameForKey(RegionPrms.dataPolicy) + " (" + policy2 + ") requires " + BasePrms.nameForKey(RegionPrms.scope) + " (" + scope + ") to be either unset or set to \"" + "default" + "\"";
            throw new HydraRuntimeException(s);
        }
        return rd;
    }

    private static RegionAttributes createRegionAttributes(RegionDescription rd) {
        AttributesFactory f = new AttributesFactory();
        if (rd.cloningEnabled != null) {
            f.setCloningEnabled(rd.getCloningEnabled().booleanValue());
        }
        if (rd.concurrencyChecksEnabled != null) {
            f.setConcurrencyChecksEnabled(rd.getConcurrencyChecksEnabled().booleanValue());
        }
        if (rd.concurrencyLevel != null) {
            f.setConcurrencyLevel(rd.getConcurrencyLevel().intValue());
        }
        if (rd.dataPolicy != null) {
            f.setDataPolicy(rd.getDataPolicy());
        }
        if (rd.diskStoreDescription != null) {
            f.setDiskStoreName(rd.getDiskStoreDescription().getName());
        }
        if (rd.diskSynchronous != null) {
            f.setDiskSynchronous(rd.getDiskSynchronous().booleanValue());
        }
        if (rd.enableAsyncConflation != null) {
            f.setEnableAsyncConflation(rd.getEnableAsyncConflation().booleanValue());
        }
        if (rd.enableGateway != null) {
            f.setEnableGateway(rd.getEnableGateway().booleanValue());
        }
        if (rd.enableOffHeapMemory != null) {
            f.setEnableOffHeapMemory(rd.getEnableOffHeapMemory().booleanValue());
        }
        if (rd.enableSubscriptionConflation != null) {
            f.setEnableSubscriptionConflation(rd.getEnableSubscriptionConflation().booleanValue());
        }
        if (rd.entryIdleTimeout != null) {
            f.setEntryIdleTimeout(rd.getEntryIdleTimeout());
        }
        if (rd.entryTimeToLive != null) {
            f.setEntryTimeToLive(rd.getEntryTimeToLive());
        }
        if (rd.evictionAttributes != null) {
            f.setEvictionAttributes(rd.getEvictionAttributes());
        }
        if (rd.hdfsStoreDescription != null) {
            f.setHDFSStoreName(rd.getHDFSStoreDescription().getName());
        }
        if (rd.hdfsWriteOnly != null) {
            f.setHDFSWriteOnly(rd.getHDFSWriteOnly().booleanValue());
        }
        if (rd.ignoreJTA != null) {
            f.setIgnoreJTA(rd.getIgnoreJTA().booleanValue());
        }
        if (rd.indexMaintenanceSynchronous != null) {
            f.setIndexMaintenanceSynchronous(rd.getIndexMaintenanceSynchronous().booleanValue());
        }
        if (rd.initialCapacity != null) {
            f.setInitialCapacity(rd.getInitialCapacity().intValue());
        }
        if (rd.interestPolicy != null) {
            f.setSubscriptionAttributes(rd.getInterestPolicy());
        }
        if (rd.keyConstraint != null) {
            f.setKeyConstraint(rd.getKeyConstraint());
        }
        if (rd.loadFactor != null) {
            f.setLoadFactor(rd.getLoadFactor().floatValue());
        }
        if (rd.lockGrantor != null) {
            f.setLockGrantor(rd.getLockGrantor().booleanValue());
        }
        if (rd.membershipAttributes != null) {
            f.setMembershipAttributes(rd.getMembershipAttributes());
        }
        if (rd.multicastEnabled != null) {
            f.setMulticastEnabled(rd.getMulticastEnabled().booleanValue());
        }
        if (rd.poolDescription != null) {
            f.setPoolName(rd.getPoolDescription().getName());
        }
        if (rd.regionIdleTimeout != null) {
            f.setRegionIdleTimeout(rd.getRegionIdleTimeout());
        }
        if (rd.regionTimeToLive != null) {
            f.setRegionTimeToLive(rd.getRegionTimeToLive());
        }
        if (rd.scope != null && !RegionDescription.isPartitioned(rd.dataPolicy)) {
            f.setScope(rd.getScope());
        }
        if (rd.statisticsEnabled != null) {
            f.setStatisticsEnabled(rd.getStatisticsEnabled().booleanValue());
        }
        if (rd.valueConstraint != null) {
            f.setValueConstraint(rd.getValueConstraint());
        }
        return f.create();
    }

    private static void resetRegionDescription(RegionDescription rd, RegionAttributes ra) {
        rd.setCloningEnabled(ra.getCloningEnabled());
        rd.setConcurrencyChecksEnabled(ra.getConcurrencyChecksEnabled());
        rd.setConcurrencyLevel(ra.getConcurrencyLevel());
        rd.setDataPolicy(ra.getDataPolicy());
        rd.setDiskSynchronous(ra.isDiskSynchronous());
        rd.setEnableAsyncConflation(ra.getEnableAsyncConflation());
        rd.setEnableGateway(ra.getEnableGateway());
        rd.setEnableOffHeapMemory(ra.getEnableOffHeapMemory());
        rd.setEnableSubscriptionConflation(ra.getEnableSubscriptionConflation());
        rd.setEntryIdleTimeout(ra.getEntryIdleTimeout());
        rd.setEntryTimeToLive(ra.getEntryTimeToLive());
        rd.setEvictionAttributes(ra.getEvictionAttributes());
        rd.setHDFSStoreName(ra.getHDFSStoreName());
        rd.setHDFSWriteOnly(ra.getHDFSWriteOnly());
        rd.setIgnoreJTA(ra.getIgnoreJTA());
        rd.setIndexMaintenanceSynchronous(ra.getIndexMaintenanceSynchronous());
        rd.setInitialCapacity(ra.getInitialCapacity());
        rd.setInterestPolicy(ra.getSubscriptionAttributes());
        rd.setKeyConstraint(ra.getKeyConstraint());
        rd.setLoadFactor(Float.valueOf(ra.getLoadFactor()));
        rd.setLockGrantor(ra.isLockGrantor());
        rd.setMembershipAttributes(ra.getMembershipAttributes());
        if (rd.multicastEnabled != null) {
            rd.setMulticastEnabled(ra.getMulticastEnabled());
        }
        rd.setRegionIdleTimeout(ra.getRegionIdleTimeout());
        rd.setRegionTimeToLive(ra.getRegionTimeToLive());
        rd.setScope(ra.getScope());
        rd.setStatisticsEnabled(ra.getStatisticsEnabled());
        rd.setValueConstraint(ra.getValueConstraint());
    }

    private static String getCompressor(Long key, String val, TestConfig config) {
        return RegionDescription.getCompressorInstance(val).getClass().getName();
    }

    private synchronized Compressor getCompressorInstance(boolean instantiate) {
        String s = this.getCompressor();
        if (s == null) {
            return null;
        }
        if (instantiate && this.getCompressorSingleton().booleanValue()) {
            Object instance = compressorInstances.get(this.getName());
            if (instance == null) {
                Compressor compressor = RegionDescription.getCompressorInstance(s);
                compressorInstances.put(this.getName(), compressor);
                return compressor;
            }
            return (Compressor)instance;
        }
        return RegionDescription.getCompressorInstance(s);
    }

    private static Compressor getCompressorInstance(String classname) {
        Long key = RegionPrms.compressor;
        Object obj = RegionDescription.getInstance(key, classname);
        try {
            return (Compressor)obj;
        }
        catch (ClassCastException e) {
            String s = BasePrms.nameForKey(key) + " does not implement Compressor: " + classname;
            throw new HydraConfigException(s);
        }
    }

    private static List<AsyncEventQueueDescription> getAsyncEventQueueDescriptions(List<String> strs, Long key, TestConfig config) {
        ArrayList<AsyncEventQueueDescription> aeqds = new ArrayList<AsyncEventQueueDescription>();
        for (String str : strs) {
            AsyncEventQueueDescription aeqd = config.getAsyncEventQueueDescription(str);
            if (aeqd == null) {
                String s = BasePrms.nameForKey(key) + " not found in " + BasePrms.nameForKey(AsyncEventQueuePrms.names) + ": " + str;
                throw new HydraConfigException(s);
            }
            aeqds.add(aeqd);
        }
        return aeqds;
    }

    private synchronized CacheListener[] getCacheListenerInstances(boolean instantiate) {
        List classnames = this.getCacheListeners();
        if (classnames == null) {
            return null;
        }
        HashMap<String, CacheListener> instanceMap = (HashMap<String, CacheListener>)cacheListenerInstanceMaps.get(this.getName());
        Long key = RegionPrms.cacheListeners;
        ArrayList<Object> listeners = new ArrayList<Object>();
        for (String classname : classnames) {
            if (instantiate && this.getCacheListenersSingleton().booleanValue()) {
                Object instance;
                if (instanceMap == null) {
                    instanceMap = new HashMap<String, CacheListener>();
                }
                if ((instance = instanceMap.get(classname)) == null) {
                    CacheListener listener = RegionDescription.getAppCacheListenerInstance(classname);
                    instanceMap.put(classname, listener);
                    listeners.add(listener);
                    continue;
                }
                listeners.add(instance);
                continue;
            }
            listeners.add(RegionDescription.getAppCacheListenerInstance(classname));
        }
        CacheListener[] result = new CacheListener[listeners.size()];
        for (int i = 0; i < listeners.size(); ++i) {
            result[i] = (CacheListener)listeners.get(i);
        }
        return result;
    }

    private static CacheListener getAppCacheListenerInstance(String classname) {
        Long key = RegionPrms.cacheListeners;
        Object obj = RegionDescription.getInstance(key, classname);
        try {
            return (CacheListener)obj;
        }
        catch (ClassCastException e) {
            String s = BasePrms.nameForKey(key) + " does not implement CacheListener: " + classname;
            throw new HydraConfigException(s);
        }
    }

    private static String getCacheLoader(Long key, String val, TestConfig config) {
        return RegionDescription.getCacheLoaderInstance(val).getClass().getName();
    }

    private synchronized CacheLoader getCacheLoaderInstance(boolean instantiate) {
        String s = this.getCacheLoader();
        if (s == null) {
            return null;
        }
        if (instantiate && this.getCacheLoaderSingleton().booleanValue()) {
            Object instance = cacheLoaderInstances.get(this.getName());
            if (instance == null) {
                CacheLoader loader = RegionDescription.getCacheLoaderInstance(s);
                cacheLoaderInstances.put(this.getName(), loader);
                return loader;
            }
            return (CacheLoader)instance;
        }
        return RegionDescription.getCacheLoaderInstance(s);
    }

    private static CacheLoader getCacheLoaderInstance(String classname) {
        Long key = RegionPrms.cacheLoader;
        Object obj = RegionDescription.getInstance(key, classname);
        try {
            return (CacheLoader)obj;
        }
        catch (ClassCastException e) {
            String s = BasePrms.nameForKey(key) + " does not implement CacheLoader: " + classname;
            throw new HydraConfigException(s);
        }
    }

    private static String getCacheWriter(Long key, String val, TestConfig config) {
        return RegionDescription.getCacheWriterInstance(val).getClass().getName();
    }

    public synchronized CacheWriter getCacheWriterInstance(boolean instantiate) {
        String s = this.getCacheWriter();
        if (s == null) {
            return null;
        }
        if (instantiate && this.getCacheWriterSingleton().booleanValue()) {
            Object instance = cacheWriterInstances.get(this.getName());
            if (instance == null) {
                CacheWriter writer = RegionDescription.getCacheWriterInstance(s);
                cacheWriterInstances.put(this.getName(), writer);
                return writer;
            }
            return (CacheWriter)instance;
        }
        return RegionDescription.getCacheWriterInstance(s);
    }

    private static CacheWriter getCacheWriterInstance(String classname) {
        Long key = RegionPrms.cacheWriter;
        Object obj = RegionDescription.getInstance(key, classname);
        try {
            return (CacheWriter)obj;
        }
        catch (ClassCastException e) {
            String s = BasePrms.nameForKey(key) + " does not implement CacheWriter: " + classname;
            throw new HydraConfigException(s);
        }
    }

    private synchronized CustomExpiry getCustomEntryIdleTimeoutInstance() {
        String classname = this.getCustomEntryIdleTimeout();
        if (classname == null) {
            return null;
        }
        return RegionDescription.getCustomExpiry(classname, RegionPrms.customEntryIdleTimeout);
    }

    private synchronized CustomExpiry getCustomEntryTimeToLiveInstance() {
        String classname = this.getCustomEntryTimeToLive();
        if (classname == null) {
            return null;
        }
        return RegionDescription.getCustomExpiry(classname, RegionPrms.customEntryTimeToLive);
    }

    private static CustomExpiry getCustomExpiry(String classname, Long key) {
        if (classname.equalsIgnoreCase("none")) {
            return null;
        }
        try {
            return (CustomExpiry)RegionDescription.getInstance(key, classname);
        }
        catch (ClassCastException e) {
            String s = BasePrms.nameForKey(key) + " does not implement CustomExpiry: " + classname;
            throw new HydraConfigException(s);
        }
    }

    private static boolean isPartitioned(DataPolicy policy) {
        return policy != null && policy.toString().contains(PARTITION);
    }

    private static DataPolicy getDataPolicy(String str, Long key) {
        if (str.equalsIgnoreCase("empty")) {
            return DataPolicy.EMPTY;
        }
        if (str.equalsIgnoreCase("normal")) {
            return DataPolicy.NORMAL;
        }
        if (str.equalsIgnoreCase("hdfsPartition") || str.equalsIgnoreCase("hdfsPartitioned") || str.equalsIgnoreCase("hdfs_partition") || str.equalsIgnoreCase("hdfs_partitioned")) {
            return DataPolicy.HDFS_PARTITION;
        }
        if (str.equalsIgnoreCase("hdfsPersistentPartition") || str.equalsIgnoreCase("hdfsPersistentPartitioned") || str.equalsIgnoreCase("hdfs_persistent_partition") || str.equalsIgnoreCase("hdfs_persistent_partitioned")) {
            return DataPolicy.HDFS_PERSISTENT_PARTITION;
        }
        if (str.equalsIgnoreCase("preloaded") || str.equalsIgnoreCase("preload")) {
            return DataPolicy.PRELOADED;
        }
        if (str.equalsIgnoreCase("partition") || str.equalsIgnoreCase("partitioned")) {
            return DataPolicy.PARTITION;
        }
        if (str.equalsIgnoreCase("persistentPartition") || str.equalsIgnoreCase("persistentPartitioned") || str.equalsIgnoreCase("persistent_partition") || str.equalsIgnoreCase("persistent_partitioned")) {
            return DataPolicy.PERSISTENT_PARTITION;
        }
        if (str.equalsIgnoreCase("persistentReplicate") || str.equalsIgnoreCase("persistentReplicated") || str.equalsIgnoreCase("persistent_replicate") || str.equalsIgnoreCase("persistent_replicated")) {
            return DataPolicy.PERSISTENT_REPLICATE;
        }
        if (str.equalsIgnoreCase("replicate") || str.equalsIgnoreCase("replicated")) {
            return DataPolicy.REPLICATE;
        }
        String s = BasePrms.nameForKey(key) + " has illegal value: " + str;
        throw new HydraConfigException(s);
    }

    private static DiskStoreDescription getDiskStoreDescription(String str, Long key, TestConfig config) {
        DiskStoreDescription dsd = config.getDiskStoreDescription(str);
        if (dsd == null) {
            String s = BasePrms.nameForKey(key) + " not found in " + BasePrms.nameForKey(DiskStorePrms.names) + ": " + str;
            throw new HydraConfigException(s);
        }
        return dsd;
    }

    private static EvictionAttributes getEvictionAttributes(Long key, Vector val, ConfigHashtable tab) {
        if (val == null) {
            return null;
        }
        String algorithmStr = tab.getString(key, val.get(0));
        if (algorithmStr == null) {
            return null;
        }
        int algorithm = RegionDescription.getEvictionAlgorithm(algorithmStr, key);
        switch (algorithm) {
            case 0: {
                return null;
            }
            case 1: {
                return RegionDescription.getLRUEntryAttributes(key, val, tab);
            }
            case 2: {
                return RegionDescription.getLRUHeapAttributes(key, val, tab);
            }
            case 3: {
                return RegionDescription.getLRUMemoryAttributes(key, val, tab);
            }
        }
        String s = "Should not happen: " + algorithmStr;
        throw new HydraInternalException(s);
    }

    private static EvictionAttributes getLRUEntryAttributes(Long key, Vector val, ConfigHashtable tab) {
        String actionStr;
        Integer maximum = null;
        EvictionAction action = null;
        if (val.size() > 1) {
            maximum = tab.getInteger(key, val.get(1));
        }
        if (val.size() > 2 && (actionStr = tab.getString(key, val.get(2))) != null) {
            action = RegionDescription.getEvictionAction(actionStr, key);
        }
        if (val.size() > 3) {
            String s = BasePrms.nameForKey(key) + " has too many fields: " + val;
            throw new HydraConfigException(s);
        }
        if (maximum == null && action != null) {
            maximum = EvictionAttributes.createLRUEntryAttributes().getMaximum();
        }
        if (action != null) {
            return EvictionAttributes.createLRUEntryAttributes((int)maximum, action);
        }
        if (maximum != null) {
            return EvictionAttributes.createLRUEntryAttributes((int)maximum);
        }
        return EvictionAttributes.createLRUEntryAttributes();
    }

    private static EvictionAttributes getLRUHeapAttributes(Long key, Vector val, ConfigHashtable tab) {
        String actionStr;
        String sizerStr;
        EvictionAction action = null;
        ObjectSizer sizer = null;
        if (val.size() > 1 && (sizerStr = tab.getString(key, val.get(1))) != null) {
            sizer = RegionDescription.getObjectSizer(sizerStr, key);
        }
        if (val.size() > 2 && (actionStr = tab.getString(key, val.get(2))) != null) {
            action = RegionDescription.getEvictionAction(actionStr, key);
        }
        if (val.size() > 3) {
            String s = BasePrms.nameForKey(key) + " has too many fields: " + val;
            throw new HydraConfigException(s);
        }
        if (action != null) {
            return EvictionAttributes.createLRUHeapAttributes((ObjectSizer)sizer, action);
        }
        if (sizer != null) {
            return EvictionAttributes.createLRUHeapAttributes((ObjectSizer)sizer);
        }
        return EvictionAttributes.createLRUHeapAttributes();
    }

    private static EvictionAttributes getLRUMemoryAttributes(Long key, Vector val, ConfigHashtable tab) {
        String actionStr;
        String sizerStr;
        Integer maximum = null;
        ObjectSizer sizer = null;
        EvictionAction action = null;
        if (val.size() > 1) {
            maximum = tab.getInteger(key, val.get(1));
        }
        if (val.size() > 2 && (sizerStr = tab.getString(key, val.get(2))) != null) {
            sizer = RegionDescription.getObjectSizer(sizerStr, key);
        }
        if (val.size() > 3 && (actionStr = tab.getString(key, val.get(3))) != null) {
            action = RegionDescription.getEvictionAction(actionStr, key);
        }
        if (val.size() > 4) {
            String s = BasePrms.nameForKey(key) + " has too many fields: " + val;
            throw new HydraConfigException(s);
        }
        if (maximum == null && (sizer != null || action != null)) {
            maximum = EvictionAttributes.createLRUMemoryAttributes().getMaximum();
        }
        if (sizer == null && action != null) {
            sizer = EvictionAttributes.createLRUMemoryAttributes().getObjectSizer();
        }
        if (action != null) {
            return EvictionAttributes.createLRUMemoryAttributes((int)maximum, (ObjectSizer)sizer, (EvictionAction)action);
        }
        if (sizer != null) {
            return EvictionAttributes.createLRUMemoryAttributes((int)maximum, (ObjectSizer)sizer);
        }
        if (maximum != null) {
            return EvictionAttributes.createLRUMemoryAttributes((int)maximum);
        }
        return EvictionAttributes.createLRUMemoryAttributes();
    }

    private static int getEvictionAlgorithm(String str, Long key) {
        if (str.equalsIgnoreCase("none")) {
            return 0;
        }
        if (str.equalsIgnoreCase("lru_entry_count") || str.equalsIgnoreCase("lruEntryCount")) {
            return 1;
        }
        if (str.equalsIgnoreCase("lru_heap_percentage") || str.equalsIgnoreCase("lruHeapPercentage")) {
            return 2;
        }
        if (str.equalsIgnoreCase("lru_memory_size") || str.equalsIgnoreCase("lruMemorySize")) {
            return 3;
        }
        String s = BasePrms.nameForKey(key) + " has illegal algorithm: " + str;
        throw new HydraConfigException(s);
    }

    private static EvictionAction getEvictionAction(String str, Long key) {
        if (str.equalsIgnoreCase("local_destroy") || str.equalsIgnoreCase("localDestroy")) {
            return EvictionAction.LOCAL_DESTROY;
        }
        if (str.equalsIgnoreCase("overflow_to_disk") || str.equalsIgnoreCase("overflowToDisk")) {
            return EvictionAction.OVERFLOW_TO_DISK;
        }
        String s = BasePrms.nameForKey(key) + " has illegal action: " + str;
        throw new HydraConfigException(s);
    }

    private static ObjectSizer getObjectSizer(String classname, Long key) {
        if (classname.equalsIgnoreCase("none")) {
            return null;
        }
        try {
            return (ObjectSizer)RegionDescription.getInstance(key, classname);
        }
        catch (ClassCastException e) {
            String s = BasePrms.nameForKey(key) + " object sizer does not implement ObjectSizer: " + classname;
            throw new HydraConfigException(s);
        }
    }

    private static ExpirationAttributes getExpirationAttributes(Long key, Vector val, ConfigHashtable tab) {
        String actionStr;
        if (val == null) {
            return null;
        }
        Integer timeout = null;
        ExpirationAction action = null;
        if (val.size() > 0) {
            if (val.get(0) instanceof String) {
                String timeoutStr = tab.getString(key, val.get(0));
                if (timeoutStr != null) {
                    timeout = RegionDescription.getExpirationTimeout(timeoutStr, key);
                }
            } else {
                timeout = tab.getInteger(key, val.get(0));
            }
        }
        if (val.size() > 1 && (actionStr = tab.getString(key, val.get(1))) != null) {
            action = RegionDescription.getExpirationAction(actionStr, key);
        }
        if (val.size() > 2) {
            String s = BasePrms.nameForKey(key) + " has too many fields: " + val;
            throw new HydraConfigException(s);
        }
        if (timeout == null && action != null) {
            timeout = ExpirationAttributes.DEFAULT.getTimeout();
        }
        if (action != null) {
            return new ExpirationAttributes(timeout.intValue(), action);
        }
        if (timeout != null) {
            return new ExpirationAttributes(timeout.intValue());
        }
        return ExpirationAttributes.DEFAULT;
    }

    private static Integer getExpirationTimeout(String timeout, Long key) {
        if (timeout.equalsIgnoreCase("none")) {
            return 0;
        }
        try {
            return Integer.valueOf(timeout);
        }
        catch (NumberFormatException e) {
            String s = BasePrms.nameForKey(key) + " has illegal type: " + timeout;
            throw new HydraConfigException(s);
        }
    }

    private static ExpirationAction getExpirationAction(String str, Long key) {
        if (str.equalsIgnoreCase("destroy")) {
            return ExpirationAction.DESTROY;
        }
        if (str.equalsIgnoreCase("local_destroy") || str.equalsIgnoreCase("localDestroy")) {
            return ExpirationAction.LOCAL_DESTROY;
        }
        if (str.equalsIgnoreCase("invalidate")) {
            return ExpirationAction.INVALIDATE;
        }
        if (str.equalsIgnoreCase("local_invalidate") || str.equalsIgnoreCase("localInvalidate")) {
            return ExpirationAction.LOCAL_INVALIDATE;
        }
        String s = BasePrms.nameForKey(key) + " has illegal action: " + str;
        throw new HydraConfigException(s);
    }

    private static List<GatewaySenderDescription> getGatewaySenderDescriptions(List<String> strs, Long key, TestConfig config) {
        ArrayList<GatewaySenderDescription> gsds = new ArrayList<GatewaySenderDescription>();
        for (String str : strs) {
            GatewaySenderDescription gsd = config.getGatewaySenderDescription(str);
            if (gsd == null) {
                String s = BasePrms.nameForKey(key) + " not found in " + BasePrms.nameForKey(GatewaySenderPrms.names) + ": " + str;
                throw new HydraConfigException(s);
            }
            gsds.add(gsd);
        }
        return gsds;
    }

    private static HDFSStoreDescription getHDFSStoreDescription(String str, Long key, TestConfig config) {
        HDFSStoreDescription hsd = config.getHDFSStoreDescription(str);
        if (hsd == null) {
            String s = BasePrms.nameForKey(key) + " not found in " + BasePrms.nameForKey(HDFSStorePrms.names) + ": " + str;
            throw new HydraConfigException(s);
        }
        return hsd;
    }

    private static SubscriptionAttributes getSubscriptionAttributes(String str, Long key) {
        InterestPolicy policy = RegionDescription.getInterestPolicy(str, key);
        return new SubscriptionAttributes(policy);
    }

    private static InterestPolicy getInterestPolicy(String str, Long key) {
        if (str.equalsIgnoreCase("all")) {
            return InterestPolicy.ALL;
        }
        if (str.equalsIgnoreCase("cache_content") || str.equalsIgnoreCase("cacheContent")) {
            return InterestPolicy.CACHE_CONTENT;
        }
        String s = BasePrms.nameForKey(key) + " has illegal value: " + str;
        throw new HydraConfigException(s);
    }

    private static MembershipAttributes getMembershipAttributes(Long key, Vector val, ConfigHashtable tab) {
        String resumptionStr;
        String lossStr;
        String rolesStr;
        if (val == null) {
            return null;
        }
        String[] roles = null;
        LossAction loss = null;
        ResumptionAction resumption = null;
        if (val.size() > 0 && (rolesStr = tab.getString(key, val.get(0))) != null) {
            roles = RegionDescription.getRequiredRoles(rolesStr);
        }
        if (val.size() > 1 && (lossStr = tab.getString(key, val.get(1))) != null) {
            loss = RegionDescription.getLossAction(lossStr, key);
        }
        if (val.size() > 2 && (resumptionStr = tab.getString(key, val.get(2))) != null) {
            resumption = RegionDescription.getResumptionAction(resumptionStr, key);
        }
        if (val.size() > 3) {
            String s = BasePrms.nameForKey(key) + " has too many fields: " + val;
            throw new HydraConfigException(s);
        }
        if (loss == null && resumption != null) {
            loss = LossAction.NO_ACCESS;
        }
        if (resumption != null) {
            return new MembershipAttributes(roles, loss, resumption);
        }
        if (loss != null) {
            return new MembershipAttributes(roles, loss, resumption);
        }
        if (roles != null) {
            return new MembershipAttributes(roles);
        }
        return new MembershipAttributes();
    }

    private static String[] getRequiredRoles(String str) {
        if (str.equalsIgnoreCase("none")) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(str, ":", false);
        int numTokens = st.countTokens();
        String[] roles = new String[numTokens];
        for (int i = 0; i < numTokens; ++i) {
            roles[i] = st.nextToken().trim();
        }
        return roles;
    }

    private static LossAction getLossAction(String str, Long key) {
        if (str.equalsIgnoreCase("no_access") || str.equalsIgnoreCase("noAccess")) {
            return LossAction.NO_ACCESS;
        }
        if (str.equalsIgnoreCase("limited_access") || str.equalsIgnoreCase("limitedAccess")) {
            return LossAction.LIMITED_ACCESS;
        }
        if (str.equalsIgnoreCase("full_access") || str.equalsIgnoreCase("fullAccess")) {
            return LossAction.FULL_ACCESS;
        }
        if (str.equalsIgnoreCase("reconnect")) {
            return LossAction.RECONNECT;
        }
        String s = BasePrms.nameForKey(key) + " has illegal loss action: " + str;
        throw new HydraConfigException(s);
    }

    private static ResumptionAction getResumptionAction(String str, Long key) {
        if (str.equalsIgnoreCase("none")) {
            return ResumptionAction.NONE;
        }
        if (str.equalsIgnoreCase("reinitialize")) {
            return ResumptionAction.REINITIALIZE;
        }
        String s = BasePrms.nameForKey(key) + " has illegal resumption action: " + str;
        throw new HydraConfigException(s);
    }

    private static PartitionDescription getPartitionDescription(String str, Long key, TestConfig config) {
        PartitionDescription pd = config.getPartitionDescription(str);
        if (pd == null) {
            String s = BasePrms.nameForKey(key) + " not found in " + BasePrms.nameForKey(PartitionPrms.names) + ": " + str;
            throw new HydraConfigException(s);
        }
        return pd;
    }

    private static PoolDescription getPoolDescription(String str, Long key, TestConfig config) {
        PoolDescription pd = config.getPoolDescription(str);
        if (pd == null) {
            String s = BasePrms.nameForKey(key) + " not found in " + BasePrms.nameForKey(PoolPrms.names) + ": " + str;
            throw new HydraConfigException(s);
        }
        return pd;
    }

    private static Scope getScope(String str, Long key) {
        if (str.equalsIgnoreCase("local")) {
            return Scope.LOCAL;
        }
        if (str.equalsIgnoreCase("global")) {
            return Scope.GLOBAL;
        }
        if (str.equalsIgnoreCase("ack") || str.equalsIgnoreCase("dack") || str.equalsIgnoreCase("d_ack") || str.equalsIgnoreCase("distributedAck") || str.equalsIgnoreCase("distributed_ack")) {
            return Scope.DISTRIBUTED_ACK;
        }
        if (str.equalsIgnoreCase("noAck") || str.equalsIgnoreCase("no_ack") || str.equalsIgnoreCase("dNoAck") || str.equalsIgnoreCase("d_no_ack") || str.equalsIgnoreCase("distributedNoAck") || str.equalsIgnoreCase("distributed_no_ack")) {
            return Scope.DISTRIBUTED_NO_ACK;
        }
        String s = BasePrms.nameForKey(key) + " has illegal value: " + str;
        throw new HydraConfigException(s);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.asyncEventQueueDescriptions = (List)in.readObject();
        this.asyncEventQueueNames = (List)in.readObject();
        this.cacheListeners = (List)in.readObject();
        this.cacheListenersSingleton = (Boolean)in.readObject();
        this.cacheLoader = (String)in.readObject();
        this.cacheLoaderSingleton = (Boolean)in.readObject();
        this.cacheWriter = (String)in.readObject();
        this.cacheWriterSingleton = (Boolean)in.readObject();
        this.cloningEnabled = (Boolean)in.readObject();
        this.compressor = (String)in.readObject();
        this.compressorSingleton = (Boolean)in.readObject();
        this.concurrencyChecksEnabled = (Boolean)in.readObject();
        this.concurrencyLevel = (Integer)in.readObject();
        this.customEntryIdleTimeout = (String)in.readObject();
        this.customEntryTimeToLive = (String)in.readObject();
        this.dataPolicy = this.readDataPolicy(in);
        this.diskStoreName = (String)in.readObject();
        this.diskStoreDescription = (DiskStoreDescription)in.readObject();
        this.diskSynchronous = (Boolean)in.readObject();
        this.enableAsyncConflation = (Boolean)in.readObject();
        this.enableGateway = (Boolean)in.readObject();
        this.enableOffHeapMemory = (Boolean)in.readObject();
        this.enableSubscriptionConflation = (Boolean)in.readObject();
        this.entryIdleTimeout = this.readExpirationAttributes(in);
        this.entryTimeToLive = this.readExpirationAttributes(in);
        this.evictionAttributes = this.readEvictionAttributes(in);
        this.gatewaySenderDescriptions = (List)in.readObject();
        this.gatewaySenderNames = (List)in.readObject();
        this.hdfsStoreName = (String)in.readObject();
        this.hdfsStoreDescription = (HDFSStoreDescription)in.readObject();
        this.hdfsWriteOnly = (Boolean)in.readObject();
        this.ignoreJTA = (Boolean)in.readObject();
        this.indexMaintenanceSynchronous = (Boolean)in.readObject();
        this.initialCapacity = (Integer)in.readObject();
        this.interestPolicy = (SubscriptionAttributes)in.readObject();
        this.keyConstraint = (Class)in.readObject();
        this.loadFactor = (Float)in.readObject();
        this.lockGrantor = (Boolean)in.readObject();
        this.membershipAttributes = (MembershipAttributes)in.readObject();
        this.multicastEnabled = (Boolean)in.readObject();
        this.name = (String)in.readObject();
        this.partitionDescription = (PartitionDescription)in.readObject();
        this.partitionDescriptionName = (String)in.readObject();
        this.poolDescription = (PoolDescription)in.readObject();
        this.poolDescriptionName = (String)in.readObject();
        this.regionIdleTimeout = this.readExpirationAttributes(in);
        this.regionName = (String)in.readObject();
        this.regionTimeToLive = this.readExpirationAttributes(in);
        this.scope = this.readScope(in);
        this.statisticsEnabled = (Boolean)in.readObject();
        this.valueConstraint = (Class)in.readObject();
        RegionAttributes ra = RegionDescription.createRegionAttributes(this);
        RegionDescription.resetRegionDescription(this, ra);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.asyncEventQueueDescriptions);
        out.writeObject(this.asyncEventQueueNames);
        out.writeObject(this.cacheListeners);
        out.writeObject(this.cacheListenersSingleton);
        out.writeObject(this.cacheLoader);
        out.writeObject(this.cacheLoaderSingleton);
        out.writeObject(this.cacheWriter);
        out.writeObject(this.cacheWriterSingleton);
        out.writeObject(this.cloningEnabled);
        out.writeObject(this.compressor);
        out.writeObject(this.compressorSingleton);
        out.writeObject(this.concurrencyChecksEnabled);
        out.writeObject(this.concurrencyLevel);
        out.writeObject(this.customEntryIdleTimeout);
        out.writeObject(this.customEntryTimeToLive);
        out.writeObject(this.dataPolicy.toString());
        out.writeObject(this.diskStoreName);
        out.writeObject(this.diskStoreDescription);
        out.writeObject(this.diskSynchronous);
        out.writeObject(this.enableAsyncConflation);
        out.writeObject(this.enableGateway);
        out.writeObject(this.enableOffHeapMemory);
        out.writeObject(this.enableSubscriptionConflation);
        this.writeExpirationAttributes(this.entryIdleTimeout, out);
        this.writeExpirationAttributes(this.entryTimeToLive, out);
        this.writeEvictionAttributes(this.evictionAttributes, out);
        out.writeObject(this.gatewaySenderDescriptions);
        out.writeObject(this.gatewaySenderNames);
        out.writeObject(this.hdfsStoreName);
        out.writeObject(this.hdfsStoreDescription);
        out.writeObject(this.hdfsWriteOnly);
        out.writeObject(this.ignoreJTA);
        out.writeObject(this.indexMaintenanceSynchronous);
        out.writeObject(this.initialCapacity);
        out.writeObject(this.interestPolicy);
        out.writeObject(this.keyConstraint);
        out.writeObject(this.loadFactor);
        out.writeObject(this.lockGrantor);
        out.writeObject(this.membershipAttributes);
        out.writeObject(this.multicastEnabled);
        out.writeObject(this.name);
        out.writeObject(this.partitionDescription);
        out.writeObject(this.partitionDescriptionName);
        out.writeObject(this.poolDescription);
        out.writeObject(this.poolDescriptionName);
        this.writeExpirationAttributes(this.regionIdleTimeout, out);
        out.writeObject(this.regionName);
        this.writeExpirationAttributes(this.regionTimeToLive, out);
        this.writeScope(this.scope, out);
        out.writeObject(this.statisticsEnabled);
        out.writeObject(this.valueConstraint);
    }

    private DataPolicy readDataPolicy(ObjectInputStream in) throws IOException, ClassNotFoundException {
        String str = (String)in.readObject();
        if (str == null) {
            return null;
        }
        if (str.equals(DataPolicy.EMPTY.toString())) {
            return DataPolicy.EMPTY;
        }
        if (str.equals(DataPolicy.NORMAL.toString())) {
            return DataPolicy.NORMAL;
        }
        if (str.equals(DataPolicy.HDFS_PARTITION.toString())) {
            return DataPolicy.HDFS_PARTITION;
        }
        if (str.equals(DataPolicy.HDFS_PERSISTENT_PARTITION.toString())) {
            return DataPolicy.HDFS_PERSISTENT_PARTITION;
        }
        if (str.equals(DataPolicy.PRELOADED.toString())) {
            return DataPolicy.PRELOADED;
        }
        if (str.equals(DataPolicy.PARTITION.toString())) {
            return DataPolicy.PARTITION;
        }
        if (str.equals(DataPolicy.PERSISTENT_PARTITION.toString())) {
            return DataPolicy.PERSISTENT_PARTITION;
        }
        if (str.equals(DataPolicy.PERSISTENT_REPLICATE.toString())) {
            return DataPolicy.PERSISTENT_REPLICATE;
        }
        if (str.equals(DataPolicy.REPLICATE.toString())) {
            return DataPolicy.REPLICATE;
        }
        String s = BasePrms.nameForKey(RegionPrms.dataPolicy) + " has illegal value: " + str;
        throw new HydraConfigException(s);
    }

    private ExpirationAttributes readExpirationAttributes(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Object obj = in.readObject();
        if (obj == null) {
            return null;
        }
        return new ExpirationAttributes(((Integer)obj).intValue(), (ExpirationAction)in.readObject());
    }

    private void writeExpirationAttributes(ExpirationAttributes attributes, ObjectOutputStream out) throws IOException {
        if (attributes == null) {
            out.writeObject(null);
        } else {
            out.writeObject(attributes.getTimeout());
            out.writeObject(attributes.getAction());
        }
    }

    private EvictionAttributes readEvictionAttributes(ObjectInputStream in) throws IOException, ClassNotFoundException {
        EvictionAlgorithm algorithm = (EvictionAlgorithm)in.readObject();
        if (algorithm == null) {
            return null;
        }
        if (algorithm.isNone()) {
            return null;
        }
        if (algorithm.isLRUEntry()) {
            return EvictionAttributes.createLRUEntryAttributes((int)((Integer)in.readObject()), (EvictionAction)((EvictionAction)in.readObject()));
        }
        if (algorithm.isLRUHeap()) {
            return EvictionAttributes.createLRUHeapAttributes((ObjectSizer)((ObjectSizer)in.readObject()), (EvictionAction)((EvictionAction)in.readObject()));
        }
        if (algorithm.isLRUMemory()) {
            return EvictionAttributes.createLRUMemoryAttributes((int)((Integer)in.readObject()), (ObjectSizer)((ObjectSizer)in.readObject()), (EvictionAction)((EvictionAction)in.readObject()));
        }
        String s = "Unknown eviction algorithm: " + algorithm;
        throw new HydraInternalException(s);
    }

    private void writeEvictionAttributes(EvictionAttributes attributes, ObjectOutputStream out) throws IOException {
        if (attributes == null) {
            out.writeObject(null);
        } else {
            EvictionAlgorithm algorithm = attributes.getAlgorithm();
            out.writeObject(algorithm);
            if (!algorithm.isNone()) {
                if (algorithm.isLRUEntry()) {
                    out.writeObject(attributes.getMaximum());
                    out.writeObject(attributes.getAction());
                } else if (algorithm.isLRUHeap()) {
                    out.writeObject(attributes.getObjectSizer());
                    out.writeObject(attributes.getAction());
                } else if (algorithm.isLRUMemory()) {
                    out.writeObject(attributes.getMaximum());
                    out.writeObject(attributes.getObjectSizer());
                    out.writeObject(attributes.getAction());
                } else {
                    String s = "Unknown eviction algorithm: " + algorithm;
                    throw new HydraInternalException(s);
                }
            }
        }
    }

    private Scope readScope(ObjectInputStream in) throws IOException, ClassNotFoundException {
        String s = (String)in.readObject();
        if (s == null) {
            return null;
        }
        return Scope.fromString((String)s);
    }

    private void writeScope(Scope scope, ObjectOutputStream out) throws IOException {
        if (scope == null) {
            out.writeObject(null);
        } else {
            out.writeObject(scope.toString());
        }
    }
}

