/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.BasePrms;
import hydra.FileUtil;
import hydra.HydraConfigException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RebootPrms
extends BasePrms {
    private static Map<String, String> ConfigurationFileNames;
    private static Map<String, String> BaseHosts;
    public static Long useHardStop;
    public static Long vmMapFileName;

    public static boolean useHardStop() {
        Long key = useHardStop;
        return RebootPrms.tasktab().booleanAt(key, RebootPrms.tab().booleanAt(key, true));
    }

    public static String getVMMapFileName() {
        Long key = vmMapFileName;
        String fn = RebootPrms.tasktab().pathAt(key, RebootPrms.tab().stringAt(key, null));
        if (fn == null) {
            String s = BasePrms.nameForKey(key) + " is a required parameter";
            throw new HydraConfigException(s);
        }
        return fn;
    }

    private static List<String> getVMMapFileContents() {
        String fn = RebootPrms.getVMMapFileName();
        try {
            return FileUtil.getTextAsList(fn);
        }
        catch (FileNotFoundException e) {
            String s = BasePrms.nameForKey(vmMapFileName) + " cannot be loaded: " + fn;
            throw new HydraConfigException(s, e);
        }
        catch (IOException e) {
            String s = BasePrms.nameForKey(vmMapFileName) + " cannot be loaded: " + fn;
            throw new HydraConfigException(s, e);
        }
    }

    public static synchronized String getBaseHost(String vm) {
        String baseHost;
        if (BaseHosts == null) {
            BaseHosts = new HashMap<String, String>();
            List<String> lines = RebootPrms.getVMMapFileContents();
            for (String line : lines) {
                String[] tokens = line.split(" ");
                if (tokens.length != 3) {
                    String s = BasePrms.nameForKey(vmMapFileName) + " has a malformed line: " + line;
                    throw new HydraConfigException(s);
                }
                BaseHosts.put(tokens[0], tokens[1]);
            }
        }
        if ((baseHost = BaseHosts.get(vm)) == null) {
            String s = BasePrms.nameForKey(vmMapFileName) + " does not contain " + vm;
            throw new HydraConfigException(s);
        }
        return baseHost;
    }

    public static synchronized String getConfigurationFileName(String vm) {
        if (ConfigurationFileNames == null) {
            ConfigurationFileNames = new HashMap<String, String>();
            List<String> lines = RebootPrms.getVMMapFileContents();
            for (String line : lines) {
                String[] tokens = line.split(" ");
                if (tokens.length != 3) {
                    String s = BasePrms.nameForKey(vmMapFileName) + " has a malformed line: " + line;
                    throw new HydraConfigException(s);
                }
                ConfigurationFileNames.put(tokens[0], tokens[2]);
            }
        }
        return ConfigurationFileNames.get(vm);
    }

    static {
        RebootPrms.setValues(RebootPrms.class);
    }
}

