/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import java.io.IOException;
import java.net.BindException;
import java.net.ConnectException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.rmi.server.RMISocketFactory;

public class RMIHydraSocketFactory
extends RMISocketFactory {
    private static final int INITIAL_RETRY_COUNT = 120;
    private static final long THROTTLE_PERIOD = 1000L;

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        int retryCount = 120;
        while (true) {
            --retryCount;
            try {
                return new Socket(host, port);
            }
            catch (SocketException se) {
                boolean reattempt;
                String msg = se.getMessage();
                boolean bl = reattempt = se instanceof BindException || se instanceof ConnectException || msg != null && msg.contains("Invalid argument: listen failed");
                if (!reattempt || retryCount <= 0) {
                    throw se;
                }
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException ie) {
                    retryCount = 0;
                    Thread.currentThread().interrupt();
                    continue;
                }
            }
            break;
        }
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        return new ServerSocket(port, 255);
    }
}

