/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.internal.AvailablePort;
import hydra.HostHelper;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.ProcessMgr;
import hydra.RemoteTestModule;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.SocketException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PortHelper {
    public static final String ADDRESS_ALREADY_IN_USE = "Address already in use";
    public static final String UNRECOGNIZED_SOCKET = "Unrecognized Windows Sockets error: 0: JVM_Bind";
    public static final long MAX_RETRY_MS = 120000L;
    public static final long THROTTLE_MS = 1000L;
    private static Map<String, List<Integer>> ReservedPorts = new HashMap<String, List<Integer>>();

    public static int getRandomPort() {
        String host = HostHelper.getLocalHost();
        InetAddress addr = HostHelper.getIPAddress();
        int port = -1;
        boolean reserved = false;
        while (!reserved) {
            port = AvailablePort.getRandomAvailablePort((int)0, (InetAddress)addr);
            if (RemoteTestModule.Master == null) {
                reserved = PortHelper.reservePort(host, port);
                continue;
            }
            try {
                reserved = RemoteTestModule.Master.reservePort(host, port);
            }
            catch (RemoteException e) {
                String s = "Unable to contact master to reserve port";
                throw new HydraRuntimeException(s, e);
            }
        }
        return port;
    }

    public static synchronized boolean reservePort(String host, int port) {
        List<Integer> ports = ReservedPorts.get(host);
        if (ports == null) {
            ports = new ArrayList<Integer>();
            ReservedPorts.put(host, ports);
        }
        if (ports.contains(port)) {
            return false;
        }
        ports.add(port);
        return true;
    }

    public static boolean retrySocketBind(IOException e, long startTimeMs) {
        ProcessMgr.logNetworkStatistics();
        if (System.currentTimeMillis() - startTimeMs < 120000L && PortHelper.addressAlreadyInUse(e)) {
            try {
                Thread.sleep(1000L);
                Log.getLogWriter().warning("Allowing retry after IOException");
                return true;
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
        return false;
    }

    public static boolean addressAlreadyInUse(Throwable t) {
        if (t == null) {
            throw new IllegalArgumentException("Exception cannot be null");
        }
        for (Throwable root = t; root != null; root = root.getCause()) {
            if (root instanceof BindException && root.getMessage() != null && root.getMessage().contains(ADDRESS_ALREADY_IN_USE)) {
                Log.getLogWriter().warning("Got BindException: Address already in use");
                return true;
            }
            if (!(root instanceof SocketException) || root.getMessage() == null || !root.getMessage().contains(UNRECOGNIZED_SOCKET)) continue;
            Log.getLogWriter().warning("Got SocketException: Unrecognized Windows Sockets error: 0: JVM_Bind");
            return true;
        }
        return false;
    }
}

