/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import java.io.Serializable;

public class NumStats
implements Serializable {
    double min = Double.MAX_VALUE;
    double max = Double.MIN_VALUE;
    double total = 0.0;
    long count = 0L;

    public void add(double arg) {
        if (arg < this.min) {
            this.min = arg;
        }
        if (arg > this.max) {
            this.max = arg;
        }
        this.total += arg;
        ++this.count;
    }

    public void add(int arg) {
        this.add((double)arg);
    }

    public void add(long arg) {
        this.add((double)arg);
    }

    public double min() {
        return this.min;
    }

    public double max() {
        return this.max;
    }

    public double mean() {
        return this.total / (double)this.count;
    }

    public String printStatsAsTimes() {
        if (this.count == 0L) {
            return null;
        }
        return "Number of elapsed times: " + this.count + "\nMin:  " + (float)this.min + " ms\nMax:  " + (float)this.max + " ms\nMean: " + (float)this.mean() + " ms";
    }

    public static void main(String[] args) {
        NumStats stats = new NumStats();
        for (int i = 0; i <= 100; ++i) {
            stats.add(i);
        }
        System.out.println(stats.printStatsAsTimes());
    }
}

