/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.JUnitTestSetup;
import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.LocalLogWriter;
import com.gemstone.gemfire.internal.util.StopWatch;
import hydra.ClientRecord;
import hydra.DeadlockDetection;
import hydra.HostHelper;
import hydra.HydraConfigException;
import hydra.JUnitTestSuite;
import hydra.JUnitTestTimedOutException;
import hydra.Log;
import hydra.ProcessMgr;
import hydra.RemoteTestModule;
import hydra.TestTask;
import hydra.TestTaskResult;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;
import org.apache.tools.ant.taskdefs.optional.junit.XMLJUnitResultFormatter;
import swarm.Swarm;

public class JUnitTestTask
extends TestTask {
    public static final String XML_REPORTS_DIR = "../xml-reports";
    private static final PrintStream ERR = new PrintStream(new FileOutputStream(FileDescriptor.err));
    private static final String JUNIT_ANT = "org.apache.tools.ant.taskdefs.optional.junit.";
    private static String fromTestClass = System.getProperty("dunitFromTestClass");
    private static String uptoTestClass = System.getProperty("dunitUptoTestClass");
    private Map tests = new LinkedHashMap();
    private String lastClassName;
    protected String testInProgress;
    protected String lastPass;
    protected String lastFail;
    private static Pattern pattern = Pattern.compile("\\w+\\((.*)\\)");

    public JUnitTestTask() {
        this.setReceiver(this.getClass().getName());
        this.setSelector("foolHydra");
    }

    void addTestClass(String className) {
        if (this.tests.containsKey(className)) {
            String s = "Duplicate class name: " + className;
            throw new HydraConfigException(s);
        }
        this.tests.put(className, new ArrayList());
        this.lastClassName = className;
    }

    void addTestMethod(String methodName) {
        if (this.lastClassName == null) {
            String s = "Test method before test class: " + methodName;
            throw new HydraConfigException(s);
        }
        List methods = (List)this.tests.get(this.lastClassName);
        if (methods.contains(methodName)) {
            String s = "Duplicate method: " + methodName;
            throw new HydraConfigException(s);
        }
        methods.add(methodName);
    }

    public static void foolHydra() {
        String s = "I pity the fool that messes with Hydra!";
        throw new IllegalStateException(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TestTaskResult execute() {
        Writer w;
        long beginTime = System.currentTimeMillis();
        StringBuffer errorMessages = new StringBuffer();
        StringBuffer failureMessages = new StringBuffer();
        String logicalHostName = RemoteTestModule.getMyLogicalHost();
        try {
            w = new FileWriter("dunit-progress-" + logicalHostName + ".txt", true);
        }
        catch (IOException ex) {
            w = new PrintWriter(System.out, true);
        }
        LocalLogWriter log = new LocalLogWriter(Integer.MIN_VALUE, new PrintWriter(w, true));
        try {
            w = new FileWriter("dunit-passed-" + logicalHostName + ".txt", true);
        }
        catch (IOException ex) {
            w = new PrintWriter(System.out, true);
        }
        LocalLogWriter passed = new LocalLogWriter(Integer.MIN_VALUE, new PrintWriter(w, true));
        GemFireResultFormatter resultFormatter = new GemFireResultFormatter((LogWriter)log, (LogWriter)passed, errorMessages, failureMessages);
        boolean wasSuccessful = true;
        for (String className : this.getTestClasses()) {
            if (fromTestClass != null && fromTestClass.length() > 0) {
                if (!className.contains(fromTestClass)) {
                    log.info("======== Skipping unit test: " + className);
                    continue;
                }
                fromTestClass = null;
            }
            if (uptoTestClass != null && uptoTestClass.length() > 0) {
                if (uptoTestClass.equals("skip-now-on")) {
                    log.info("======== Skipping unit test: " + className);
                    continue;
                }
                if (className.contains(uptoTestClass)) {
                    uptoTestClass = "skip-now-on";
                }
            }
            try {
                Class<?> c = Class.forName(className);
                String xmlFileName = "TEST-" + c.getName() + ".xml";
                File xmlResultDir = new File((String)null, XML_REPORTS_DIR);
                xmlResultDir.mkdir();
                File xmlFile = new File(xmlResultDir, xmlFileName);
                OutputStream xmlOut = System.out;
                try {
                    xmlOut = new FileOutputStream(xmlFile);
                }
                catch (IOException e) {
                    log.error("Failed to create xml FileOutputStream", (Throwable)e);
                }
                XMLJUnitResultFormatter xmlFormatter = new XMLJUnitResultFormatter();
                xmlFormatter.setOutput(xmlOut);
                TestResult result = new TestResult();
                result.addListener((TestListener)resultFormatter);
                result.addListener((TestListener)xmlFormatter);
                result.addListener((TestListener)Swarm.getUnitTestObserver());
                boolean requiresSpecialSetUpTearDownHook = this.hasCaseMethod(c);
                JUnitTestSuite suite = new JUnitTestSuite();
                if (requiresSpecialSetUpTearDownHook) {
                    Test newTest = JUnitTestSetup.createJUnitTestSetup(c);
                    suite.addTest(newTest);
                } else {
                    suite.addTestSuite(c);
                }
                Enumeration en = suite.tests();
                int count = 0;
                while (en.hasMoreElements()) {
                    en.nextElement();
                    ++count;
                }
                System.out.println("XXX: START SUITE " + c.getName() + " size:" + count);
                JUnitTest test = new JUnitTest(c.getName());
                xmlFormatter.startTestSuite(test);
                boolean timedOut = false;
                StopWatch timer = new StopWatch(true);
                try {
                    long s = System.nanoTime();
                    timedOut = this.runTestSuite(suite, result, failureMessages, (LogWriter)log);
                    long e = System.nanoTime();
                    long timeMs = (e - s) / 1000000L;
                    System.out.println("XXX: DONE SUITE " + c.getName() + " size:" + count + " TOOK:" + timeMs);
                }
                catch (Throwable throwable) {
                    test.setRunTime(timer.elapsedTimeMillis());
                    test.setCounts((long)result.runCount(), (long)result.failureCount(), (long)result.errorCount());
                    wasSuccessful = wasSuccessful && result.failureCount() == 0 && result.errorCount() == 0;
                    xmlFormatter.endTestSuite(test);
                    if (!timedOut) {
                        throw throwable;
                    }
                    break;
                }
                test.setRunTime(timer.elapsedTimeMillis());
                test.setCounts((long)result.runCount(), (long)result.failureCount(), (long)result.errorCount());
                wasSuccessful = wasSuccessful && result.failureCount() == 0 && result.errorCount() == 0;
                xmlFormatter.endTestSuite(test);
                if (!timedOut) continue;
                break;
            }
            catch (ClassNotFoundException ex) {
                errorMessages.append("Could not find class ");
                errorMessages.append(className);
                errorMessages.append("\n");
            }
        }
        long elapsedTime = System.currentTimeMillis() - beginTime;
        String messages = failureMessages + "\n" + errorMessages;
        Assert.assertTrue((wasSuccessful || messages.length() > 0 ? 1 : 0) != 0);
        if (this.lastPass != null) {
            passed.info("TEST " + this.lastPass + " PASSED");
        }
        return new JUnitTestTaskResult(messages, elapsedTime);
    }

    private boolean runTestSuite(TestSuite suite, TestResult result, StringBuffer failureMessages, LogWriter log) {
        try {
            suite.run(result);
            return false;
        }
        catch (JUnitTestTimedOutException ex) {
            failureMessages.append('\n').append(ex.getMessage()).append('\n');
            this.lastPass = null;
            this.dumpStacks(3);
            File dir = new File("failures");
            dir.mkdir();
            try {
                File file = new File(dir, "HungDUnitTest.txt");
                file.createNewFile();
                FileWriter fw = new FileWriter(file, true);
                PrintWriter pw = new PrintWriter((Writer)fw, true);
                pw.println("DUnit test: " + ex.getMessage() + " HUNG, killing dunit without running the remaining tests");
                pw.flush();
                pw.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            log.info("TIMEDOUT " + ex.getMessage());
            DeadlockDetection.detectDeadlocks(null);
            this.nukeVms();
            return true;
        }
    }

    protected static String getClassName(Test test) {
        String desc = test.toString();
        Matcher matcher = pattern.matcher(desc);
        String className = matcher.matches() ? matcher.group(1) : desc;
        return className;
    }

    protected static void reportFailure(Test test, String message) {
        try {
            File dir = new File("failures");
            dir.mkdir();
            String className = JUnitTestTask.getClassName(test);
            File testRes = new File(dir, className + ".txt");
            testRes.createNewFile();
            FileWriter fw = new FileWriter(testRes, true);
            PrintWriter pw = new PrintWriter((Writer)fw, true);
            pw.println(message);
            pw.flush();
            pw.close();
        }
        catch (IOException ex) {
            String s = "Couldn't log failure in " + test + ": " + message;
            Log.getLogWriter().severe(s, (Throwable)ex);
        }
    }

    private void dumpStacks(int numTimes) {
        this.dumpStacks();
        for (int i = 1; i < numTimes; ++i) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.dumpStacks();
        }
    }

    private void dumpStacks() {
        if (HostHelper.isWindows()) {
            ProcessMgr.fgexec("cmd.exe /c dumprun.bat", 600);
        } else {
            ProcessMgr.fgexec("/bin/bash dumprun.sh", 600);
        }
    }

    private void nukeVms() {
        if (HostHelper.isWindows()) {
            ProcessMgr.fgexec("cmd.exe /c nukerun.bat", 600);
        } else {
            ProcessMgr.fgexec("/bin/bash nukerun.sh", 600);
        }
    }

    @Override
    public void logHangResult(ClientRecord client, String msg) {
        try {
            File dir = new File("failures");
            dir.mkdir();
            File file = new File(dir, "HungDUnitTest.txt");
            file.createNewFile();
            FileWriter fw = new FileWriter(file, true);
            PrintWriter pw = new PrintWriter((Writer)fw, true);
            pw.println("DUnit test " + this.testInProgress + " HUNG");
            pw.flush();
            pw.close();
        }
        catch (IOException ex) {
            String s = "Couldn't log hung DUnit test in " + this.testInProgress + ": " + this.testInProgress;
            Log.getLogWriter().severe(s, (Throwable)ex);
        }
        super.logHangResult(client, msg);
    }

    public Set getTestClasses() {
        return Collections.unmodifiableSet(this.tests.keySet());
    }

    private boolean hasCaseMethod(Class theClass) {
        boolean flag = false;
        Method[] methods = theClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals("caseSetUp") && !methods[i].getName().equals("caseTearDown")) continue;
            int mods = methods[i].getModifiers();
            Class<?> returnType = methods[i].getReturnType();
            Class<?>[] args = methods[i].getParameterTypes();
            if (Modifier.isPublic(mods) && Modifier.isStatic(mods) && args.length == 0) {
                flag = true;
                continue;
            }
            Log.getLogWriter().severe("method \"" + methods[i].toString() + "\", junit expects public static void  caseSetUp|caseTearDown()");
        }
        return flag;
    }

    class GemFireResultFormatter
    implements TestListener {
        private final LogWriter log;
        private final LogWriter passed;
        private final StringBuffer errorMessages;
        private final StringBuffer failureMessages;
        private long startTime;

        GemFireResultFormatter(LogWriter log, LogWriter passed, StringBuffer errorMessages, StringBuffer failureMessages) {
            this.log = log;
            this.passed = passed;
            this.errorMessages = errorMessages;
            this.failureMessages = failureMessages;
        }

        public void startTest(Test test) {
            this.startTime = System.currentTimeMillis();
            String s = "START " + test;
            Log.getLogWriter().info(s);
            this.log.info(s);
            JUnitTestTask.this.testInProgress = test.toString();
        }

        public void endTest(Test test) {
            long delta = System.currentTimeMillis() - this.startTime;
            String s = "END " + test + " (took " + delta + "ms)";
            Log.getLogWriter().info(s);
            this.log.info(s);
            JUnitTestTask.this.testInProgress = null;
            String className = JUnitTestTask.getClassName(test);
            if (className.equals(JUnitTestTask.this.lastFail)) {
                return;
            }
            if (JUnitTestTask.this.lastPass == null) {
                JUnitTestTask.this.lastPass = className;
            } else if (!JUnitTestTask.this.lastPass.equals(className)) {
                this.passed.info("TEST " + JUnitTestTask.this.lastPass + " PASSED");
                JUnitTestTask.this.lastPass = className;
            }
        }

        public void addError(Test test, Throwable t) {
            StringBuffer sb = new StringBuffer();
            sb.append(test.toString());
            sb.append("\n");
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter((Writer)sw, true));
            sb.append(sw.toString());
            this.errorMessages.append(sb);
            this.log.severe("\nTEST " + test + " ERROR", t);
            Log.getLogWriter().severe("ERROR IN " + test, t);
            JUnitTestTask.reportFailure(test, sb.toString());
            JUnitTestTask.this.lastFail = JUnitTestTask.getClassName(test);
        }

        public void addFailure(Test test, AssertionFailedError t) {
            StringBuffer sb = new StringBuffer();
            sb.append(test.toString());
            sb.append("\n");
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter((Writer)sw, true));
            sb.append(sw.toString());
            this.failureMessages.append(sb);
            this.log.severe("\nTEST " + test + " FAILURE", (Throwable)t);
            Log.getLogWriter().severe("FAILURE IN " + test, (Throwable)t);
            JUnitTestTask.reportFailure(test, sb.toString());
            JUnitTestTask.this.lastFail = JUnitTestTask.getClassName(test);
        }
    }

    static class JUnitTestTaskResult
    extends TestTaskResult {
        JUnitTestTaskResult(String messages, long elapsedTime) {
            super(elapsedTime);
            if (messages.trim().length() == 0) {
                this.errorStatus = false;
                this.result = "Successfully ran JUnit tests";
            } else {
                this.errorStatus = true;
                this.result = "Unsuccessfully ran JUnit tests";
                this.errorString = messages.toString();
            }
        }
    }
}

