/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.LogWriter;
import hydra.DistributedSystemHelper;
import hydra.GemFireDescription;
import hydra.HostHelper;
import hydra.JMXManagerBlackboard;
import hydra.Log;
import hydra.PortHelper;
import hydra.RemoteTestModule;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class JMXManagerHelper {
    protected static final int DEFAULT_JMX_MANAGER_PORT = 0;
    protected static final int DEFAULT_JMX_MANAGER_HTTP_PORT = 0;
    private static Endpoint TheJMXManagerEndpoint;
    private static LogWriter log;

    protected static synchronized Endpoint getEndpoint() {
        if (TheJMXManagerEndpoint == null) {
            Integer vmid = new Integer(RemoteTestModule.getMyVmid());
            TheJMXManagerEndpoint = (Endpoint)JMXManagerBlackboard.getInstance().getSharedMap().get(vmid);
        }
        return TheJMXManagerEndpoint;
    }

    public static synchronized List<Endpoint> getEndpoints() {
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        endpoints.addAll(JMXManagerBlackboard.getInstance().getSharedMap().getMap().values());
        return endpoints;
    }

    public static synchronized List getSystemEndpoints() {
        return JMXManagerHelper.getEndpoints(DistributedSystemHelper.getDistributedSystemName());
    }

    public static synchronized List getEndpoints(String distributedSystemName) {
        ArrayList<Endpoint> jmxManagerEndpoints = new ArrayList<Endpoint>();
        for (Endpoint endpoint : JMXManagerHelper.getEndpoints()) {
            if (!endpoint.getDistributedSystemName().equals(distributedSystemName)) continue;
            jmxManagerEndpoints.add(endpoint);
        }
        return jmxManagerEndpoints;
    }

    protected static synchronized Endpoint getEndpoint(boolean generatePort, boolean generateHttpPort) {
        Endpoint endpoint = JMXManagerHelper.getEndpoint();
        if (endpoint == null) {
            endpoint = JMXManagerHelper.generateEndpoint(generatePort, generateHttpPort);
        }
        return endpoint;
    }

    private static Endpoint generateEndpoint(boolean generatePort, boolean generateHttpPort) {
        JMXManagerHelper.log("Generating JMX manager endpoint");
        Integer vmid = new Integer(RemoteTestModule.getMyVmid());
        String name = RemoteTestModule.getMyClientName();
        String host = HostHelper.getCanonicalHostName();
        String addr = HostHelper.getHostAddress();
        int port = generatePort ? PortHelper.getRandomPort() : 0;
        int httpPort = generateHttpPort ? PortHelper.getRandomPort() : 0;
        GemFireDescription gfd = DistributedSystemHelper.getGemFireDescription();
        String ds = gfd.getDistributedSystem();
        Endpoint endpoint = new Endpoint(name, vmid, host, addr, port, httpPort, ds);
        JMXManagerHelper.log("Generated JMX manager endpoint: " + endpoint);
        JMXManagerBlackboard.getInstance().getSharedMap().put(vmid, endpoint);
        TheJMXManagerEndpoint = endpoint;
        return endpoint;
    }

    private static synchronized void log(String s) {
        if (log == null) {
            log = Log.getLogWriter();
        }
        if (log.infoEnabled()) {
            log.info(s);
        }
    }

    public static class Endpoint
    implements Serializable {
        String name;
        String host;
        String addr;
        String ds;
        int vmid;
        int port;
        int httpPort;

        public Endpoint(String name, int vmid, String host, String addr, int port, int httpPort, String ds) {
            if (name == null) {
                throw new IllegalArgumentException("name cannot be null");
            }
            if (host == null) {
                throw new IllegalArgumentException("host cannot be null");
            }
            if (addr == null) {
                throw new IllegalArgumentException("addr cannot be null");
            }
            if (ds == null) {
                throw new IllegalArgumentException("ds cannot be null");
            }
            this.name = name;
            this.vmid = vmid;
            this.host = host;
            this.addr = addr;
            this.port = port;
            this.httpPort = httpPort;
            this.ds = ds;
        }

        public String getName() {
            return this.name;
        }

        public int getVmid() {
            return this.vmid;
        }

        public String getHost() {
            return this.host;
        }

        public String getAddress() {
            return this.addr;
        }

        public int getPort() {
            return this.port;
        }

        public int getHttpPort() {
            return this.httpPort;
        }

        public String getDistributedSystemName() {
            return this.ds;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Endpoint) {
                Endpoint endpoint = (Endpoint)obj;
                return endpoint.getName().equals(this.getName()) && endpoint.getVmid() == this.getVmid() && endpoint.getHost().equals(this.getHost()) && endpoint.getAddress().equals(this.getAddress()) && endpoint.getPort() == this.getPort() && endpoint.getHttpPort() == this.getHttpPort() && endpoint.getDistributedSystemName().equals(this.getDistributedSystemName());
            }
            return false;
        }

        public int hashCode() {
            return this.port;
        }

        public String toString() {
            return this.host + ":" + this.port + ":" + this.httpPort + "(" + this.ds + ":vm_" + this.vmid + "_" + this.name + ")";
        }
    }
}

