/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.HadoopDescription;
import hydra.HadoopInfo;
import hydra.HadoopRecord;
import hydra.HydraInternalException;
import hydra.Nuker;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HadoopMgr {
    private static Map<String, HadoopRecord> HadoopRecords = new HashMap<String, HadoopRecord>();

    public static synchronized void removeHadoop(HadoopInfo info) throws RemoteException {
        HadoopRecord hr = HadoopRecords.get(info.getNodeDescription().getName());
        HadoopMgr.removeHadoop(info.getHadoopDescription(), info.getNodeDescription(), hr.getPID(), hr.getSecure());
    }

    public static synchronized void recordHadoop(HadoopDescription hdd, HadoopDescription.NodeDescription nd, int pid, boolean secure) throws RemoteException {
        HadoopMgr.recordPID(hdd, nd, pid, secure);
        Nuker.getInstance().recordHDFSPIDNoDumps(nd.getHostDescription(), pid, secure);
    }

    public static synchronized void removeHadoop(HadoopDescription hdd, HadoopDescription.NodeDescription nd, int pid, boolean secure) throws RemoteException {
        HadoopMgr.removePID(hdd, nd, pid, secure);
        Nuker.getInstance().removeHDFSPIDNoDumps(nd.getHostDescription(), pid, secure);
    }

    private static synchronized void recordPID(HadoopDescription hdd, HadoopDescription.NodeDescription nd, int pid, boolean secure) {
        HadoopRecord hr = HadoopRecords.get(nd.getName());
        if (hr == null) {
            hr = new HadoopRecord(hdd, nd, pid, secure);
            HadoopRecords.put(nd.getName(), hr);
        } else {
            hr.setPID(pid);
        }
    }

    private static synchronized void removePID(HadoopDescription hdd, HadoopDescription.NodeDescription nd, int pid, boolean secure) {
        HadoopRecord hr = HadoopRecords.get(nd.getName());
        if (hr == null) {
            String s = "No hadoop record found for " + nd.getName();
            throw new HydraInternalException(s);
        }
        hr.unsetPID(pid);
    }

    protected static synchronized List<HadoopInfo> getHadoopInfos(String host, boolean liveOnly) {
        ArrayList<HadoopInfo> infos = new ArrayList<HadoopInfo>();
        for (HadoopRecord hr : HadoopRecords.values()) {
            if (!hr.getNodeDescription().getHostName().equals(host)) continue;
            if (liveOnly) {
                if (!hr.isLive()) continue;
                infos.add(new HadoopInfo(hr.getHadoopDescription(), hr.getNodeDescription()));
                continue;
            }
            infos.add(new HadoopInfo(hr.getHadoopDescription(), hr.getNodeDescription()));
        }
        return infos;
    }
}

