/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.cache.hdfs.HDFSEventQueueAttributes;
import com.gemstone.gemfire.cache.hdfs.HDFSEventQueueAttributesFactory;
import com.gemstone.gemfire.cache.hdfs.HDFSStore;
import com.gemstone.gemfire.cache.hdfs.HDFSStoreFactory;
import hydra.AbstractDescription;
import hydra.BasePrms;
import hydra.ConfigHashtable;
import hydra.DiskStoreDescription;
import hydra.DiskStorePrms;
import hydra.EnvHelper;
import hydra.FileUtil;
import hydra.HDFSStorePrms;
import hydra.HadoopDescription;
import hydra.HadoopPrms;
import hydra.HostDescription;
import hydra.HydraConfigException;
import hydra.HydraVector;
import hydra.Nuker;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.SortedMap;
import java.util.TreeMap;

public class HDFSStoreDescription
extends AbstractDescription
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private Boolean autoCompaction;
    private Boolean autoMajorCompaction;
    private Integer batchSizeMB;
    private Integer batchTimeInterval;
    private Float blockCacheSize;
    private String compactionStrategy;
    private DiskStoreDescription diskStoreDescription;
    private String diskStoreName;
    private Boolean diskSynchronous;
    private Integer fileRolloverInterval;
    private String hadoopName;
    private HadoopDescription hadoopDescription;
    private String hdfsClientConfigFile;
    private String homeDir;
    private Integer majorCompactionIntervalMins;
    private Integer majorCompactionMaxThreads;
    private Integer maxFileSize;
    private Integer maxInputFileCount;
    private Integer maxInputFileSizeMB;
    private Integer maxThreads;
    private Integer maximumQueueMemory;
    private Integer minInputFileCount;
    private Integer oldFilesCleanupIntervalMins;
    private Boolean persistent;

    public String getName() {
        return this.name;
    }

    private void setName(String str) {
        this.name = str;
    }

    public Boolean getAutoCompaction() {
        return this.autoCompaction;
    }

    private void setAutoCompaction(Boolean bool) {
        this.autoCompaction = bool;
    }

    public Boolean getAutoMajorCompaction() {
        return this.autoMajorCompaction;
    }

    private void setAutoMajorCompaction(Boolean bool) {
        this.autoMajorCompaction = bool;
    }

    public Integer getBatchSizeMB() {
        return this.batchSizeMB;
    }

    private void setBatchSizeMB(Integer i) {
        this.batchSizeMB = i;
    }

    public Integer getBatchTimeInterval() {
        return this.batchTimeInterval;
    }

    private void setBatchTimeInterval(Integer i) {
        this.batchTimeInterval = i;
    }

    public Float getBlockCacheSize() {
        return this.blockCacheSize;
    }

    private void setBlockCacheSize(Float f) {
        this.blockCacheSize = f;
    }

    public String getCompactionStrategy() {
        return this.compactionStrategy;
    }

    private void setCompactionStrategy(String str) {
        this.compactionStrategy = str;
    }

    public String getDiskStoreName() {
        return this.diskStoreName;
    }

    private void setDiskStoreName(String str) {
        this.diskStoreName = str;
    }

    public DiskStoreDescription getDiskStoreDescription() {
        return this.diskStoreDescription;
    }

    private void setDiskStoreDescription(DiskStoreDescription dsd) {
        this.diskStoreDescription = dsd;
    }

    public Boolean getDiskSynchronous() {
        return this.diskSynchronous;
    }

    private void setDiskSynchronous(Boolean bool) {
        this.diskSynchronous = bool;
    }

    public Integer getFileRolloverInterval() {
        return this.fileRolloverInterval;
    }

    private void setFileRolloverInterval(Integer i) {
        this.fileRolloverInterval = i;
    }

    public String getHadoopName() {
        return this.hadoopName;
    }

    private void setHadoopName(String str) {
        this.hadoopName = str;
    }

    public HadoopDescription getHadoopDescription() {
        return this.hadoopDescription;
    }

    private void setHadoopDescription(HadoopDescription hd) {
        this.hadoopDescription = hd;
    }

    public String getHDFSClientConfigFile() {
        return this.hdfsClientConfigFile;
    }

    private void setHDFSClientConfigFile(String str) {
        this.hdfsClientConfigFile = str;
    }

    public String getHomeDir() {
        return this.homeDir;
    }

    private void setHomeDir(String str) {
        this.homeDir = str;
    }

    public Integer getMajorCompactionIntervalMins() {
        return this.majorCompactionIntervalMins;
    }

    private void setMajorCompactionIntervalMins(Integer i) {
        this.majorCompactionIntervalMins = i;
    }

    public Integer getMajorCompactionMaxThreads() {
        return this.majorCompactionMaxThreads;
    }

    private void setMajorCompactionMaxThreads(Integer i) {
        this.majorCompactionMaxThreads = i;
    }

    public Integer getMaxFileSize() {
        return this.maxFileSize;
    }

    private void setMaxFileSize(Integer i) {
        this.maxFileSize = i;
    }

    public Integer getMaxInputFileCount() {
        return this.maxInputFileCount;
    }

    private void setMaxInputFileCount(Integer i) {
        this.maxInputFileCount = i;
    }

    public Integer getMaxInputFileSizeMB() {
        return this.maxInputFileSizeMB;
    }

    private void setMaxInputFileSizeMB(Integer i) {
        this.maxInputFileSizeMB = i;
    }

    public Integer getMaxThreads() {
        return this.maxThreads;
    }

    private void setMaxThreads(Integer i) {
        this.maxThreads = i;
    }

    public Integer getMaximumQueueMemory() {
        return this.maximumQueueMemory;
    }

    private void setMaximumQueueMemory(Integer i) {
        this.maximumQueueMemory = i;
    }

    public Integer getMinInputFileCount() {
        return this.minInputFileCount;
    }

    private void setMinInputFileCount(Integer i) {
        this.minInputFileCount = i;
    }

    public Integer getOldFilesCleanupIntervalMins() {
        return this.oldFilesCleanupIntervalMins;
    }

    private void setOldFilesCleanupIntervalMins(Integer i) {
        this.oldFilesCleanupIntervalMins = i;
    }

    public Boolean getPersistent() {
        return this.persistent;
    }

    private void setPersistent(Boolean bool) {
        this.persistent = bool;
    }

    protected void configure(HDFSStoreFactory f) {
        if (this.getBlockCacheSize() != null) {
            f.setBlockCacheSize(this.getBlockCacheSize().floatValue());
        }
        f.setFileRolloverInterval(this.getFileRolloverInterval().intValue());
        if (this.getHDFSClientConfigFile() != null) {
            String clientName = RemoteTestModule.getMyClientName();
            HostDescription hd = TestConfig.getInstance().getClientDescription(clientName).getVmDescription().getHostDescription();
            String fn = EnvHelper.expandEnvVars(this.getHDFSClientConfigFile(), hd);
            f.setHDFSClientConfigFile(fn);
        }
        f.setHomeDir(this.getHomeDir());
        f.setMaxFileSize(this.getMaxFileSize().intValue());
        f.setNameNodeURL(this.getHadoopDescription().getNameNodeURL());
        HDFSStoreFactory.HDFSCompactionConfigFactory cf = f.createCompactionConfigFactory(this.getCompactionStrategy());
        cf.setAutoCompaction(this.getAutoCompaction().booleanValue());
        cf.setAutoMajorCompaction(this.getAutoMajorCompaction().booleanValue());
        cf.setMajorCompactionIntervalMins(this.getMajorCompactionIntervalMins().intValue());
        cf.setMajorCompactionMaxThreads(this.getMajorCompactionMaxThreads().intValue());
        cf.setMaxThreads(this.getMaxThreads().intValue());
        cf.setMaxInputFileCount(this.getMaxInputFileCount().intValue());
        cf.setMaxInputFileSizeMB(this.getMaxInputFileSizeMB().intValue());
        cf.setMinInputFileCount(this.getMinInputFileCount().intValue());
        cf.setOldFilesCleanupIntervalMins(this.getOldFilesCleanupIntervalMins().intValue());
        f.setHDFSCompactionConfig(cf.create());
        HDFSEventQueueAttributesFactory qf = new HDFSEventQueueAttributesFactory();
        qf.setBatchSizeMB(this.getBatchSizeMB().intValue());
        qf.setBatchTimeInterval(this.getBatchTimeInterval().intValue());
        if (this.getDiskStoreDescription() != null) {
            qf.setDiskStoreName(this.getDiskStoreDescription().getName());
        }
        qf.setDiskSynchronous(this.getDiskSynchronous().booleanValue());
        qf.setMaximumQueueMemory(this.getMaximumQueueMemory().intValue());
        qf.setPersistent(this.getPersistent().booleanValue());
        HDFSEventQueueAttributes qatts = qf.create();
        f.setHDFSEventQueueAttributes(qatts);
    }

    protected static synchronized String hdfsStoreToString(HDFSStore h) {
        return HDFSStoreDescription.hdfsStoreToString(h.getName(), h);
    }

    protected static synchronized String hdfsStoreToString(String hdfsStoreName, HDFSStore h) {
        HDFSEventQueueAttributes q = h.getHDFSEventQueueAttributes();
        HDFSStore.HDFSCompactionConfig c = h.getHDFSCompactionConfig();
        StringBuffer buf = new StringBuffer();
        buf.append("\n  hdfsStoreName: " + hdfsStoreName);
        buf.append("\n  autoCompaction: " + c.getAutoCompaction());
        buf.append("\n  autoMajorCompaction: " + c.getAutoMajorCompaction());
        buf.append("\n  batchSizeMB: " + q.getBatchSizeMB());
        buf.append("\n  batchTimeInterval: " + q.getBatchTimeInterval());
        buf.append("\n  blockCacheSize: " + h.getBlockCacheSize());
        buf.append("\n  compactionStrategy: " + c.getCompactionStrategy());
        buf.append("\n  diskStoreName: " + q.getDiskStoreName());
        buf.append("\n  diskSynchronous: " + q.isDiskSynchronous());
        buf.append("\n  fileRolloverInterval: " + h.getFileRolloverInterval());
        buf.append("\n  hdfsClientConfigFile: " + h.getHDFSClientConfigFile());
        buf.append("\n  homeDir: " + h.getHomeDir());
        buf.append("\n  majorCompactionIntervalMins: " + c.getMajorCompactionIntervalMins());
        buf.append("\n  majorCompactionMaxThreads: " + c.getMajorCompactionMaxThreads());
        buf.append("\n  maxFileSize: " + h.getMaxFileSize());
        buf.append("\n  maxInputFileCount: " + c.getMaxInputFileCount());
        buf.append("\n  maxInputFileSizeMB: " + c.getMaxInputFileSizeMB());
        buf.append("\n  maxThreads: " + c.getMaxThreads());
        buf.append("\n  maximumQueueMemory: " + q.getMaximumQueueMemory());
        buf.append("\n  minInputFileCount: " + c.getMinInputFileCount());
        buf.append("\n  oldFilesCleanupIntervalMins: " + c.getOldFilesCleanupIntervalMins());
        buf.append("\n  nameNodeURL: " + h.getNameNodeURL());
        buf.append("\n  persistent: " + q.isPersistent());
        return buf.toString();
    }

    protected static boolean equals(HDFSStore h1, HDFSStore h2) {
        HDFSEventQueueAttributes hq1 = h1.getHDFSEventQueueAttributes();
        HDFSEventQueueAttributes hq2 = h2.getHDFSEventQueueAttributes();
        HDFSStore.HDFSCompactionConfig hc1 = h1.getHDFSCompactionConfig();
        HDFSStore.HDFSCompactionConfig hc2 = h2.getHDFSCompactionConfig();
        if (!(hc1.getAutoCompaction() == hc2.getAutoCompaction() && hc1.getAutoMajorCompaction() == hc2.getAutoMajorCompaction() && hq1.getBatchSizeMB() == hq2.getBatchSizeMB() && hq1.getBatchTimeInterval() == hq2.getBatchTimeInterval() && h1.getBlockCacheSize() == h2.getBlockCacheSize() && hc1.getCompactionStrategy().equals(hc2.getCompactionStrategy()) && hq1.getDiskStoreName().equals(hq2.getDiskStoreName()) && hq1.isDiskSynchronous() == hq2.isDiskSynchronous() && h1.getFileRolloverInterval() == h2.getFileRolloverInterval() && h1.getHomeDir().equals(h2.getHomeDir()) && hc1.getMajorCompactionIntervalMins() == hc2.getMajorCompactionIntervalMins() && hc1.getMajorCompactionMaxThreads() == hc2.getMajorCompactionMaxThreads() && hc1.getMaxThreads() == hc2.getMaxThreads() && h1.getMaxFileSize() == h2.getMaxFileSize() && hc1.getMaxInputFileCount() == hc2.getMaxInputFileCount() && hc1.getMaxInputFileSizeMB() == hc2.getMaxInputFileSizeMB() && hc1.getMinInputFileCount() == hc2.getMinInputFileCount() && hq1.getMaximumQueueMemory() == hq2.getMaximumQueueMemory() && h1.getNameNodeURL().equals(h2.getNameNodeURL()) && hc1.getOldFilesCleanupIntervalMins() == hc2.getOldFilesCleanupIntervalMins() && hq1.isPersistent() == hq2.isPersistent())) {
            return false;
        }
        if (h1.getHDFSClientConfigFile() == null && h2.getHDFSClientConfigFile() != null) {
            return false;
        }
        if (h1.getHDFSClientConfigFile() != null && h2.getHDFSClientConfigFile() == null) {
            return false;
        }
        return h1.getHDFSClientConfigFile() == null || h2.getHDFSClientConfigFile() == null || h1.getHDFSClientConfigFile().equals(h2.getHDFSClientConfigFile());
    }

    @Override
    public SortedMap toSortedMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        String header = this.getClass().getName() + "." + this.getName() + ".";
        map.put(header + "autoCompaction", this.getAutoCompaction());
        map.put(header + "autoMajorCompaction", this.getAutoMajorCompaction());
        map.put(header + "batchSizeMB", this.getBatchSizeMB());
        map.put(header + "batchTimeInterval", this.getBatchTimeInterval());
        map.put(header + "blockCacheSize", this.getBlockCacheSize());
        map.put(header + "compactionStrategy", this.getCompactionStrategy());
        map.put(header + "diskStoreName", this.getDiskStoreName());
        map.put(header + "diskSynchronous", this.getDiskSynchronous());
        map.put(header + "fileRolloverInterval", this.getFileRolloverInterval());
        map.put(header + "hadoopName", this.getHadoopName());
        map.put(header + "hdfsClientConfigFile", this.getHDFSClientConfigFile());
        map.put(header + "homeDir", this.getHomeDir());
        map.put(header + "majorCompactionIntervalMins", this.getMajorCompactionIntervalMins());
        map.put(header + "majorCompactionMaxThreads", this.getMajorCompactionMaxThreads());
        map.put(header + "maxFileSize", this.getMaxFileSize());
        map.put(header + "maxInputFileCount", this.getMaxInputFileCount());
        map.put(header + "maxInputFileSizeMB", this.getMaxInputFileSizeMB());
        map.put(header + "maxThreads", this.getMaxThreads());
        map.put(header + "maximumQueueMemory", this.getMaximumQueueMemory());
        map.put(header + "minInputFileCount", this.getMinInputFileCount());
        map.put(header + "persistent", this.getPersistent());
        map.put(header + "oldFilesCleanupIntervalMins", this.getOldFilesCleanupIntervalMins());
        return map;
    }

    protected static void configure(TestConfig config) {
        ConfigHashtable tab = config.getParameters();
        HydraVector names = tab.vecAt(HDFSStorePrms.names, new HydraVector());
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.elementAt(i);
            HDFSStoreDescription hsd = HDFSStoreDescription.createHDFSStoreDescription(name, config, i);
            config.addHDFSStoreDescription(hsd);
        }
    }

    private static HDFSStoreDescription createHDFSStoreDescription(String name, TestConfig config, int index) {
        ConfigHashtable tab = config.getParameters();
        HDFSStoreDescription hsd = new HDFSStoreDescription();
        hsd.setName(name);
        Long key = HDFSStorePrms.autoCompaction;
        Boolean bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            bool = true;
        }
        hsd.setAutoCompaction(bool);
        key = HDFSStorePrms.autoMajorCompaction;
        bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            bool = true;
        }
        hsd.setAutoMajorCompaction(bool);
        key = HDFSStorePrms.batchSizeMB;
        Integer i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 32;
        }
        hsd.setBatchSizeMB(i);
        key = HDFSStorePrms.batchTimeInterval;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 60000;
        }
        hsd.setBatchTimeInterval(i);
        key = HDFSStorePrms.blockCacheSize;
        Double d = tab.getDouble(key, tab.getWild(key, index, null));
        Float f = Float.valueOf(d == null ? 10.0f : Float.valueOf(d.floatValue()).floatValue());
        hsd.setBlockCacheSize(f);
        key = HDFSStorePrms.compactionStrategy;
        String str = tab.getString(key, tab.getWild(key, index, null));
        if (str == null) {
            str = "size-oriented";
        }
        hsd.setCompactionStrategy(str);
        key = HDFSStorePrms.diskStoreName;
        str = tab.getString(key, tab.getWild(key, index, null));
        if (str != null && !str.equalsIgnoreCase("none")) {
            hsd.setDiskStoreDescription(HDFSStoreDescription.getDiskStoreDescription(str, key, config));
            hsd.setDiskStoreName("DiskStoreDescription." + str);
        }
        if ((bool = tab.getBoolean(key = HDFSStorePrms.diskSynchronous, tab.getWild(key, index, null))) == null) {
            bool = true;
        }
        hsd.setDiskSynchronous(bool);
        key = HDFSStorePrms.fileRolloverInterval;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 3600;
        }
        hsd.setFileRolloverInterval(i);
        key = HDFSStorePrms.hadoopName;
        str = tab.getString(key, tab.getWild(key, index, null));
        if (str == null) {
            String s = BasePrms.nameForKey(key) + " is a required parameter";
            throw new HydraConfigException(s);
        }
        hsd.setHadoopDescription(HDFSStoreDescription.getHadoopDescription(str, key, config));
        hsd.setHadoopName("HadoopDescription." + str);
        key = HDFSStorePrms.hdfsClientConfigFile;
        str = tab.getString(key, tab.getWild(key, index, null));
        if (str != null) {
            hsd.setHDFSClientConfigFile(str);
        }
        if ((str = tab.getString(key = HDFSStorePrms.homeDir, tab.getWild(key, index, null))) == null) {
            String userDir = config.getMasterDescription().getVmDescription().getHostDescription().getUserDir();
            str = FileUtil.filenameFor(userDir);
        }
        hsd.setHomeDir(str);
        key = HDFSStorePrms.majorCompactionIntervalMins;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 720;
        }
        hsd.setMajorCompactionIntervalMins(i);
        key = HDFSStorePrms.majorCompactionMaxThreads;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 2;
        }
        hsd.setMajorCompactionMaxThreads(i);
        key = HDFSStorePrms.maxFileSize;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 256;
        }
        hsd.setMaxFileSize(i);
        key = HDFSStorePrms.maxInputFileCount;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 10;
        }
        hsd.setMaxInputFileCount(i);
        key = HDFSStorePrms.maxInputFileSizeMB;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 512;
        }
        hsd.setMaxInputFileSizeMB(i);
        key = HDFSStorePrms.maxThreads;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 10;
        }
        hsd.setMaxThreads(i);
        key = HDFSStorePrms.maximumQueueMemory;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 100;
        }
        hsd.setMaximumQueueMemory(i);
        key = HDFSStorePrms.minInputFileCount;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 4;
        }
        hsd.setMinInputFileCount(i);
        key = HDFSStorePrms.oldFilesCleanupIntervalMins;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 30;
        }
        hsd.setOldFilesCleanupIntervalMins(i);
        key = HDFSStorePrms.persistent;
        bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            bool = false;
        }
        hsd.setPersistent(bool);
        HadoopDescription hdd = hsd.getHadoopDescription();
        if (hdd.useExistingCluster()) {
            boolean moveHadoopData = Boolean.getBoolean("moveHadoopData");
            Nuker.getInstance().recordHDFSDir(hdd.getHadoopDist(), hdd.getNameNodeURL(), moveHadoopData);
        }
        return hsd;
    }

    private static DiskStoreDescription getDiskStoreDescription(String str, Long key, TestConfig config) {
        DiskStoreDescription dsd = config.getDiskStoreDescription(str);
        if (dsd == null) {
            String s = BasePrms.nameForKey(key) + " not found in " + BasePrms.nameForKey(DiskStorePrms.names) + ": " + str;
            throw new HydraConfigException(s);
        }
        return dsd;
    }

    private static HadoopDescription getHadoopDescription(String str, Long key, TestConfig config) {
        HadoopDescription hd = config.getHadoopDescription(str);
        if (hd == null) {
            String s = BasePrms.nameForKey(key) + " not found in " + BasePrms.nameForKey(HadoopPrms.names) + ": " + str;
            throw new HydraConfigException(s);
        }
        return hd;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.autoCompaction = (Boolean)in.readObject();
        this.autoMajorCompaction = (Boolean)in.readObject();
        this.batchSizeMB = (Integer)in.readObject();
        this.batchTimeInterval = (Integer)in.readObject();
        this.blockCacheSize = (Float)in.readObject();
        this.compactionStrategy = (String)in.readObject();
        this.diskStoreDescription = (DiskStoreDescription)in.readObject();
        this.diskStoreName = (String)in.readObject();
        this.diskSynchronous = (Boolean)in.readObject();
        this.fileRolloverInterval = (Integer)in.readObject();
        this.hadoopDescription = (HadoopDescription)in.readObject();
        this.hadoopName = (String)in.readObject();
        this.hdfsClientConfigFile = (String)in.readObject();
        this.homeDir = (String)in.readObject();
        this.majorCompactionIntervalMins = (Integer)in.readObject();
        this.majorCompactionMaxThreads = (Integer)in.readObject();
        this.maxFileSize = (Integer)in.readObject();
        this.maxInputFileCount = (Integer)in.readObject();
        this.maxInputFileSizeMB = (Integer)in.readObject();
        this.maxThreads = (Integer)in.readObject();
        this.maximumQueueMemory = (Integer)in.readObject();
        this.minInputFileCount = (Integer)in.readObject();
        this.name = (String)in.readObject();
        this.oldFilesCleanupIntervalMins = (Integer)in.readObject();
        this.persistent = (Boolean)in.readObject();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.autoCompaction);
        out.writeObject(this.autoMajorCompaction);
        out.writeObject(this.batchSizeMB);
        out.writeObject(this.batchTimeInterval);
        out.writeObject(this.blockCacheSize);
        out.writeObject(this.compactionStrategy);
        out.writeObject(this.diskStoreDescription);
        out.writeObject(this.diskStoreName);
        out.writeObject(this.diskSynchronous);
        out.writeObject(this.fileRolloverInterval);
        out.writeObject(this.hadoopDescription);
        out.writeObject(this.hadoopName);
        out.writeObject(this.hdfsClientConfigFile);
        out.writeObject(this.homeDir);
        out.writeObject(this.majorCompactionIntervalMins);
        out.writeObject(this.majorCompactionMaxThreads);
        out.writeObject(this.maxFileSize);
        out.writeObject(this.maxInputFileCount);
        out.writeObject(this.maxInputFileSizeMB);
        out.writeObject(this.maxThreads);
        out.writeObject(this.maximumQueueMemory);
        out.writeObject(this.minInputFileCount);
        out.writeObject(this.name);
        out.writeObject(this.oldFilesCleanupIntervalMins);
        out.writeObject(this.persistent);
    }
}

