/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.cache.util.Gateway;
import com.gemstone.gemfire.cache.util.GatewayHub;
import hydra.AbstractDescription;
import hydra.BasePrms;
import hydra.ConfigHashtable;
import hydra.GatewayDescription;
import hydra.GatewayHubPrms;
import hydra.HydraConfigException;
import hydra.HydraVector;
import hydra.Log;
import hydra.TestConfig;
import java.io.Serializable;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

public class GatewayHubDescription
extends AbstractDescription
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private Boolean acceptGatewayConnections;
    private Boolean asynchronousGatewayDistributionEnabled;
    private Boolean haEnabled;
    private Integer maximumTimeBetweenPings;
    private Integer socketBufferSize;
    private String startupPolicy;

    public String getName() {
        return this.name;
    }

    private void setName(String str) {
        this.name = str;
    }

    protected Boolean getAcceptGatewayConnections() {
        return this.acceptGatewayConnections;
    }

    private void setAcceptGatewayConnections(Boolean bool) {
        this.acceptGatewayConnections = bool;
    }

    private Boolean getAsynchronousGatewayDistributionEnabled() {
        return this.asynchronousGatewayDistributionEnabled;
    }

    private void setAsynchronousGatewayDistributionEnabled(Boolean bool) {
        this.asynchronousGatewayDistributionEnabled = bool;
    }

    protected void setAsynchronousGatewayDistributionEnabledProperty() {
        Boolean sval = this.getAsynchronousGatewayDistributionEnabled();
        if (sval != null) {
            String p = "gemfire.asynchronous-gateway-distribution-enabled";
            String pval = System.getProperty(p);
            if (pval != null && Boolean.getBoolean(p) != sval) {
                Log.getLogWriter().warning("Overriding -D" + p + " with " + sval);
            }
            System.setProperty(p, String.valueOf(sval));
        }
    }

    protected Boolean getHAEnabled() {
        return this.haEnabled;
    }

    private void setHAEnabled(Boolean bool) {
        this.haEnabled = bool;
    }

    private Integer getMaximumTimeBetweenPings() {
        return this.maximumTimeBetweenPings;
    }

    private void setMaximumTimeBetweenPings(Integer i) {
        this.maximumTimeBetweenPings = i;
    }

    private Integer getSocketBufferSize() {
        return this.socketBufferSize;
    }

    private void setSocketBufferSize(Integer i) {
        this.socketBufferSize = i;
    }

    private String getStartupPolicy() {
        return this.startupPolicy;
    }

    private void setStartupPolicy(String s) {
        this.startupPolicy = s;
    }

    protected void configure(GatewayHub gh) {
        gh.setMaximumTimeBetweenPings(this.getMaximumTimeBetweenPings().intValue());
        gh.setSocketBufferSize(this.getSocketBufferSize().intValue());
        gh.setStartupPolicy(this.getStartupPolicy());
    }

    protected static synchronized String gatewayHubToString(GatewayHub gh) {
        StringBuffer buf = new StringBuffer();
        boolean async = Boolean.getBoolean("gemfire.asynchronous-gateway-distribution-enabled");
        buf.append("\nGatewayHub (").append(async ? "Asynchronous " : "Synchronous ");
        try {
            buf.append(gh.isPrimary() ? " Primary" : "Secondary ");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        buf.append(")");
        buf.append("\n  id: " + gh.getId());
        buf.append("\n  port: " + gh.getPort());
        buf.append("\n  maximumTimeBetweenPings: " + gh.getMaximumTimeBetweenPings());
        buf.append("\n  socketBufferSize: " + gh.getSocketBufferSize());
        buf.append("\n  startupPolicy: " + gh.getStartupPolicy());
        List gateways = gh.getGateways();
        if (gateways != null) {
            for (Gateway gateway : gateways) {
                buf.append("\nGateway");
                buf.append(GatewayDescription.gatewayToString(gateway));
            }
        }
        return buf.toString();
    }

    @Override
    public SortedMap toSortedMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        String header = this.getClass().getName() + "." + this.getName() + ".";
        map.put(header + "acceptGatewayConnections", this.getAcceptGatewayConnections());
        if (this.getAsynchronousGatewayDistributionEnabled() == null) {
            map.put(header + "asynchronousGatewayDistributionEnabled", "-Dgemfire.asynchronous-gateway-distribution-enabled");
        } else {
            map.put(header + "asynchronousGatewayDistributionEnabled", this.getAsynchronousGatewayDistributionEnabled());
        }
        map.put(header + "haEnabled", this.getHAEnabled());
        map.put(header + "maximumTimeBetweenPings", this.getMaximumTimeBetweenPings());
        map.put(header + "socketBufferSize", this.getSocketBufferSize());
        map.put(header + "startupPolicy", this.getStartupPolicy());
        return map;
    }

    protected static void configure(TestConfig config) {
        ConfigHashtable tab = config.getParameters();
        HydraVector names = tab.vecAt(GatewayHubPrms.names, new HydraVector());
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.elementAt(i);
            GatewayHubDescription ghd = GatewayHubDescription.createGatewayHubDescription(name, tab, i);
            config.addGatewayHubDescription(ghd);
        }
    }

    private static GatewayHubDescription createGatewayHubDescription(String name, ConfigHashtable tab, int index) {
        GatewayHubDescription ghd = new GatewayHubDescription();
        ghd.setName(name);
        Long key = GatewayHubPrms.acceptGatewayConnections;
        Boolean bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            ghd.setAcceptGatewayConnections(Boolean.TRUE);
        } else {
            ghd.setAcceptGatewayConnections(bool);
        }
        key = GatewayHubPrms.asynchronousGatewayDistributionEnabled;
        bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool != null) {
            ghd.setAsynchronousGatewayDistributionEnabled(bool);
        }
        if ((bool = tab.getBoolean(key = GatewayHubPrms.haEnabled, tab.getWild(key, index, null))) == null) {
            ghd.setHAEnabled(Boolean.TRUE);
        } else {
            ghd.setHAEnabled(bool);
        }
        key = GatewayHubPrms.maximumTimeBetweenPings;
        Integer i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = new Integer(60000);
        }
        ghd.setMaximumTimeBetweenPings(i);
        key = GatewayHubPrms.socketBufferSize;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = new Integer(32768);
        }
        ghd.setSocketBufferSize(i);
        key = GatewayHubPrms.startupPolicy;
        String str = tab.getString(key, tab.getWild(key, index, null));
        str = str == null ? "none" : GatewayHubDescription.getStartupPolicy(str, key);
        ghd.setStartupPolicy(str);
        return ghd;
    }

    private static String getStartupPolicy(String str, Long key) {
        if (str.equalsIgnoreCase("none")) {
            return "none";
        }
        if (str.equalsIgnoreCase("primary")) {
            return "primary";
        }
        if (str.equalsIgnoreCase("secondary")) {
            return "secondary";
        }
        String s = BasePrms.nameForKey(key) + " has illegal value: " + str;
        throw new HydraConfigException(s);
    }
}

