/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.cache.FixedPartitionAttributes;
import hydra.DistributedSystemHelper;
import hydra.FixedPartitionBlackboard;
import hydra.FixedPartitionDescription;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.RemoteTestModule;
import java.util.ArrayList;
import java.util.List;

public class FixedPartitionHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized List<FixedPartitionAttributes> assignRoundRobin(String regionName, FixedPartitionDescription fpd, int redundantCopies) {
        List<FixedPartitionAttributes> choice = null;
        String dsName = DistributedSystemHelper.getDistributedSystemName();
        String bbName = dsName + "." + regionName;
        FixedPartitionBlackboard bb = FixedPartitionBlackboard.getInstance(bbName);
        int vmid = RemoteTestModule.getMyVmid();
        choice = (List<FixedPartitionAttributes>)bb.getSharedMap().get(vmid);
        if (choice == null) {
            block8: {
                try {
                    bb.getSharedLock().lock();
                    List<List<FixedPartitionAttributes>> choices = (List<List<FixedPartitionAttributes>>)bb.getSharedMap().get("choices");
                    if (choices == null) {
                        choices = FixedPartitionHelper.generateRoundRobinChoices(fpd, redundantCopies);
                        bb.getSharedMap().put("choices", choices);
                        if (Log.getLogWriter().fineEnabled()) {
                            Log.getLogWriter().fine("assignRoundRobin: put in bb=" + bbName + " choices=" + choices);
                        }
                    }
                    if (choices.size() > 0) {
                        choice = choices.remove(0);
                        bb.getSharedMap().put("choices", choices);
                        break block8;
                    }
                    String s = "Too many JVMs called assignRoundRobin for " + regionName + " " + fpd;
                    throw new HydraRuntimeException(s);
                }
                finally {
                    bb.getSharedLock().unlock();
                }
            }
            bb.getSharedMap().put(vmid, choice);
            if (Log.getLogWriter().fineEnabled()) {
                Log.getLogWriter().fine("assignRoundRobin: put in bb=" + bbName + " vmid=" + vmid + " choice=" + choice);
            }
        }
        return choice;
    }

    private static List<List<FixedPartitionAttributes>> generateRoundRobinChoices(FixedPartitionDescription fpd, int redundantCopies) {
        int i;
        List<String> partitionNames = fpd.getPartitionNames();
        List<Integer> partitionBuckets = fpd.getPartitionBuckets();
        ArrayList<FixedPartitionAttributes> fpas = new ArrayList<FixedPartitionAttributes>();
        for (i = 0; i < partitionNames.size(); ++i) {
            FixedPartitionAttributes fpa = FixedPartitionAttributes.createFixedPartition((String)partitionNames.get(i), (boolean)true, (int)partitionBuckets.get(i));
            fpas.add(fpa);
        }
        for (i = 0; i < redundantCopies; ++i) {
            for (int j = 0; j < partitionNames.size(); ++j) {
                FixedPartitionAttributes fpa = FixedPartitionAttributes.createFixedPartition((String)partitionNames.get(j), (boolean)false, (int)partitionBuckets.get(j));
                fpas.add(fpa);
            }
        }
        if (Log.getLogWriter().fineEnabled()) {
            Log.getLogWriter().fine("generateRoundRobinChoices: fpas=" + fpas);
        }
        ArrayList<List<FixedPartitionAttributes>> ll = new ArrayList<List<FixedPartitionAttributes>>();
        for (int i2 = 0; i2 < fpd.getDatastores(); ++i2) {
            ArrayList l = new ArrayList();
            ll.add(l);
        }
        boolean assigned = true;
        while (fpas.size() > 0 && assigned) {
            assigned = false;
            block5: for (int i3 = 0; i3 < ll.size(); ++i3) {
                List l = (List)ll.get(i3);
                for (FixedPartitionAttributes fpa : fpas) {
                    if (FixedPartitionHelper.containsPartitionName(l, (FixedPartitionAttributes)fpas.get(0))) continue;
                    l.add(fpas.remove(0));
                    assigned = true;
                    continue block5;
                }
            }
        }
        if (Log.getLogWriter().fineEnabled()) {
            Log.getLogWriter().fine("generateRoundRobinChoices: choices for all datastores=" + ll);
        }
        if (fpas.size() > 0) {
            String s = "Unable to assign these FPAs: " + fpas + " to " + ll;
            throw new HydraRuntimeException(s);
        }
        return ll;
    }

    private static boolean containsPartitionName(List<FixedPartitionAttributes> fpas, FixedPartitionAttributes cfpa) {
        for (FixedPartitionAttributes fpa : fpas) {
            if (!fpa.getPartitionName().equals(cfpa.getPartitionName())) continue;
            return true;
        }
        return false;
    }
}

