/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.internal.Connection;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.client.internal.ServerRegionProxy;
import com.gemstone.gemfire.internal.NanoTimer;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerTestUtil;
import hydra.BridgeHelper;
import hydra.EdgeBlackboard;
import hydra.HostHelper;
import hydra.HydraRuntimeException;
import hydra.HydraThreadLocal;
import hydra.Log;
import hydra.RemoteTestModule;
import hydra.blackboard.SharedCounters;
import hydra.blackboard.SharedLock;
import hydra.blackboard.SharedMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class EdgeHelper {
    private static HydraThreadLocal localconnections = new HydraThreadLocal();

    public static List getSameEndpoints(int numEndpoints, String distributedSystemName) {
        List allEndpoints = EdgeHelper.getAllEndpoints(distributedSystemName);
        if (Log.getLogWriter().fineEnabled()) {
            Log.getLogWriter().fine("All available endpoints: " + allEndpoints);
        }
        if (numEndpoints > allEndpoints.size()) {
            EdgeHelper.error(numEndpoints, allEndpoints, distributedSystemName);
        }
        CacheServerTestUtil.disableShufflingOfEndpoints();
        List sameEndpoints = numEndpoints == -1 ? allEndpoints : allEndpoints.subList(0, numEndpoints);
        return new ArrayList(sameEndpoints);
    }

    public static List getRoundRobinEndpoints(int numEndpoints, String distributedSystemName) {
        List allEndpoints = EdgeHelper.getAllEndpoints(distributedSystemName);
        if (Log.getLogWriter().fineEnabled()) {
            Log.getLogWriter().fine("All available endpoints: " + allEndpoints);
        }
        return EdgeHelper.getRoundRobinEndpoints(numEndpoints, allEndpoints, distributedSystemName);
    }

    public static List getRoundRobinRemoteHostEndpoints(int numEndpoints, String distributedSystemName) {
        List remoteEndpoints = EdgeHelper.getAllEndpoints(distributedSystemName);
        if (Log.getLogWriter().fineEnabled()) {
            Log.getLogWriter().fine("All available endpoints: " + remoteEndpoints);
        }
        String localhost = HostHelper.getLocalHost();
        Iterator i = remoteEndpoints.iterator();
        while (i.hasNext()) {
            BridgeHelper.Endpoint endpoint = (BridgeHelper.Endpoint)i.next();
            if (!endpoint.getHost().equals(localhost)) continue;
            i.remove();
        }
        if (Log.getLogWriter().fineEnabled()) {
            Log.getLogWriter().fine("Remote host endpoints: " + remoteEndpoints);
        }
        return EdgeHelper.getRoundRobinEndpoints(numEndpoints, remoteEndpoints, distributedSystemName);
    }

    public static List getRoundRobinLocalHostEndpoints(int numEndpoints, String distributedSystemName) {
        List localEndpoints = EdgeHelper.getAllEndpoints(distributedSystemName);
        if (Log.getLogWriter().fineEnabled()) {
            Log.getLogWriter().fine("All available endpoints: " + localEndpoints);
        }
        String localhost = HostHelper.getLocalHost();
        Iterator i = localEndpoints.iterator();
        while (i.hasNext()) {
            BridgeHelper.Endpoint endpoint = (BridgeHelper.Endpoint)i.next();
            if (endpoint.getHost().equals(localhost)) continue;
            i.remove();
        }
        if (Log.getLogWriter().fineEnabled()) {
            Log.getLogWriter().fine("Local host endpoints: " + localEndpoints);
        }
        return EdgeHelper.getRoundRobinEndpoints(numEndpoints, localEndpoints, distributedSystemName);
    }

    private static List getRoundRobinEndpoints(int numEndpoints, List endpoints, String distributedSystemName) {
        if (numEndpoints == -1 && endpoints.size() == 0) {
            return new ArrayList();
        }
        if (numEndpoints > endpoints.size()) {
            EdgeHelper.error(numEndpoints, endpoints, distributedSystemName);
        }
        CacheServerTestUtil.disableShufflingOfEndpoints();
        int startIndex = EdgeHelper.getRoundRobinStartIndex(endpoints.size(), distributedSystemName);
        Collections.rotate(endpoints, startIndex);
        if (Log.getLogWriter().fineEnabled()) {
            Log.getLogWriter().fine("Round robin endpoints: " + endpoints);
        }
        List roundRobinEndpoints = numEndpoints == -1 ? endpoints : endpoints.subList(0, numEndpoints);
        return new ArrayList(roundRobinEndpoints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getRoundRobinStartIndex(int numEndpoints, String distributedSystemName) {
        int startIndex = -1;
        if (distributedSystemName == null) {
            startIndex = (int)EdgeBlackboard.getInstance().getSharedCounters().incrementAndRead(EdgeBlackboard.startIndex);
        } else {
            SharedMap map = EdgeBlackboard.getInstance().getSharedMap();
            String key = "StartIndex_" + distributedSystemName;
            SharedLock lock = EdgeBlackboard.getInstance().getSharedLock();
            try {
                lock.lock();
                Integer index = (Integer)map.get(key);
                startIndex = index == null ? 1 : index + 1;
                map.put(key, startIndex);
            }
            finally {
                lock.unlock();
            }
        }
        return startIndex % numEndpoints;
    }

    public static List getRandomEndpoints(int numEndpoints, String distributedSystemName) {
        List allEndpoints = EdgeHelper.getAllEndpoints(distributedSystemName);
        if (numEndpoints > allEndpoints.size()) {
            EdgeHelper.error(numEndpoints, allEndpoints, distributedSystemName);
        }
        int n = numEndpoints == -1 ? allEndpoints.size() : numEndpoints;
        Random rng = new Random(NanoTimer.getTime());
        ArrayList randomEndpoints = new ArrayList();
        for (int i = 0; i < n; ++i) {
            int index = rng.nextInt(allEndpoints.size());
            randomEndpoints.add(allEndpoints.remove(index));
        }
        return randomEndpoints;
    }

    public static List getRoundRobinEndpointsInWanHctSite(int numEndpoints, String distributedSystemName) {
        List allEndpoints = EdgeHelper.getAllEndpoints(distributedSystemName);
        int wanSite = EdgeHelper.toWanSite(RemoteTestModule.getMyClientName());
        List endpoints = EdgeHelper.getAllEndpointsInWanHctSite(wanSite, numEndpoints, allEndpoints, distributedSystemName);
        if (numEndpoints == -1 && endpoints.size() == 0) {
            return new ArrayList();
        }
        CacheServerTestUtil.disableShufflingOfEndpoints();
        SharedCounters sc = EdgeBlackboard.getInstance().getSharedCounters();
        long tmp = -1L;
        switch (wanSite) {
            case 1: {
                tmp = sc.incrementAndRead(EdgeBlackboard.startIndex1);
                break;
            }
            case 2: {
                tmp = sc.incrementAndRead(EdgeBlackboard.startIndex2);
                break;
            }
            case 3: {
                tmp = sc.incrementAndRead(EdgeBlackboard.startIndex3);
                break;
            }
            case 4: {
                tmp = sc.incrementAndRead(EdgeBlackboard.startIndex4);
                break;
            }
            case 5: {
                tmp = sc.incrementAndRead(EdgeBlackboard.startIndex5);
                break;
            }
            case 6: {
                tmp = sc.incrementAndRead(EdgeBlackboard.startIndex6);
                break;
            }
            case 7: {
                tmp = sc.incrementAndRead(EdgeBlackboard.startIndex7);
                break;
            }
            case 8: {
                tmp = sc.incrementAndRead(EdgeBlackboard.startIndex8);
                break;
            }
            case 9: {
                tmp = sc.incrementAndRead(EdgeBlackboard.startIndex9);
                break;
            }
            case 10: {
                tmp = sc.incrementAndRead(EdgeBlackboard.startIndex10);
                break;
            }
            case 11: {
                tmp = sc.incrementAndRead(EdgeBlackboard.startIndex11);
                break;
            }
            case 12: {
                tmp = sc.incrementAndRead(EdgeBlackboard.startIndex12);
                break;
            }
            case 13: {
                tmp = sc.incrementAndRead(EdgeBlackboard.startIndex13);
                break;
            }
            case 14: {
                tmp = sc.incrementAndRead(EdgeBlackboard.startIndex14);
                break;
            }
            case 15: {
                tmp = sc.incrementAndRead(EdgeBlackboard.startIndex15);
                break;
            }
            case 16: {
                tmp = sc.incrementAndRead(EdgeBlackboard.startIndex16);
                break;
            }
            case 17: {
                tmp = sc.incrementAndRead(EdgeBlackboard.startIndex17);
                break;
            }
            case 18: {
                tmp = sc.incrementAndRead(EdgeBlackboard.startIndex18);
                break;
            }
            case 19: {
                tmp = sc.incrementAndRead(EdgeBlackboard.startIndex19);
                break;
            }
            case 20: {
                tmp = sc.incrementAndRead(EdgeBlackboard.startIndex20);
                break;
            }
            default: {
                String s = "Too many WAN sites: " + wanSite;
                throw new UnsupportedOperationException(s);
            }
        }
        int startIndex = (int)tmp % endpoints.size();
        Collections.rotate(endpoints, startIndex);
        if (Log.getLogWriter().fineEnabled()) {
            Log.getLogWriter().fine("Round robin endpoints for WAN site " + wanSite + ": " + endpoints);
        }
        List roundRobinEndpoints = numEndpoints == -1 ? endpoints : endpoints.subList(0, numEndpoints);
        return new ArrayList(roundRobinEndpoints);
    }

    public static List getRandomEndpointsInWanHctSite(int numEndpoints, String distributedSystemName) {
        List allEndpoints = EdgeHelper.getAllEndpoints(distributedSystemName);
        int wanSite = EdgeHelper.toWanSite(RemoteTestModule.getMyClientName());
        List matchingEndpoints = EdgeHelper.getAllEndpointsInWanHctSite(wanSite, numEndpoints, allEndpoints, distributedSystemName);
        int n = numEndpoints == -1 ? matchingEndpoints.size() : numEndpoints;
        Random rng = new Random(NanoTimer.getTime());
        ArrayList randomEndpoints = new ArrayList();
        for (int i = 0; i < n; ++i) {
            int index = rng.nextInt(matchingEndpoints.size());
            randomEndpoints.add(matchingEndpoints.remove(index));
        }
        return randomEndpoints;
    }

    private static List getAllEndpoints(String distributedSystemName) {
        return distributedSystemName == null ? BridgeHelper.getEndpoints() : BridgeHelper.getEndpoints(distributedSystemName);
    }

    private static List getAllEndpointsInWanHctSite(int wanSite, int numEndpoints, List allEndpoints, String distributedSystemName) {
        ArrayList<BridgeHelper.Endpoint> matchingEndpoints = new ArrayList<BridgeHelper.Endpoint>();
        for (BridgeHelper.Endpoint endpoint : allEndpoints) {
            if (EdgeHelper.toWanSite(endpoint.getName()) != wanSite) continue;
            matchingEndpoints.add(endpoint);
        }
        if (Log.getLogWriter().fineEnabled()) {
            Log.getLogWriter().fine("All endpoints in WAN site " + wanSite + ": " + matchingEndpoints);
        }
        if (numEndpoints > matchingEndpoints.size()) {
            EdgeHelper.wanerror(numEndpoints, matchingEndpoints, wanSite, distributedSystemName);
        }
        return matchingEndpoints;
    }

    public static int toWanSite(String clientName) {
        String site = clientName.substring(clientName.indexOf("_") + 1, clientName.lastIndexOf("_"));
        try {
            return Integer.parseInt(site);
        }
        catch (NumberFormatException e) {
            String s = clientName + " is not in the form <name>_<wanSiteNumber>_<itemNumber>";
            throw new HydraRuntimeException(s, e);
        }
    }

    public static String endpointsToString(List endpoints) {
        if (endpoints == null || endpoints.size() == 0) {
            String s = "No endpoints found";
            throw new HydraRuntimeException(s);
        }
        String str = "";
        for (BridgeHelper.Endpoint endpoint : endpoints) {
            if (str.length() > 0) {
                str = str + ",";
            }
            str = str + endpoint;
        }
        return str;
    }

    private static void error(int numEndpoints, List endpoints, String distributedSystemName) {
        String s = null;
        s = distributedSystemName == null ? "Cannot find " + numEndpoints + " endpoints, there are only " + endpoints.size() + ": " + endpoints : "Cannot find " + numEndpoints + " endpoints in " + distributedSystemName + ", there are only " + endpoints.size() + ": " + endpoints;
        throw new HydraRuntimeException(s);
    }

    private static void wanerror(int numEndpoints, List endpoints, int wanSite, String distributedSystemName) {
        String s = null;
        s = distributedSystemName == null ? "Cannot find " + numEndpoints + " endpoints in WAN site " + wanSite + ", there are only " + endpoints.size() + ": " + endpoints : "Cannot find " + numEndpoints + " endpoints in " + distributedSystemName + " in WAN site " + wanSite + ", there are only " + endpoints.size() + ": " + endpoints;
        throw new HydraRuntimeException(s);
    }

    public static void addThreadLocalConnection(Region r) {
        PoolImpl pool;
        LocalRegion lr = (LocalRegion)r;
        ServerRegionProxy proxy = lr.getServerProxy();
        if (proxy != null && (pool = (PoolImpl)proxy.getPool()) != null && pool.getThreadLocalConnections()) {
            EdgeHelper.saveThreadLocalConnection((Pool)pool);
        }
    }

    public static void removeThreadLocalConnection(Region r) {
        PoolImpl pool;
        LocalRegion lr = (LocalRegion)r;
        ServerRegionProxy proxy = lr.getServerProxy();
        if (proxy != null && (pool = (PoolImpl)proxy.getPool()) != null) {
            EdgeHelper.getConnectionsMap().remove(pool);
        }
    }

    public static void restoreThreadLocalConnections() {
        Map connections = EdgeHelper.getConnectionsMap();
        for (Object obj : connections.keySet()) {
            Object c = connections.get(obj);
            if (c == null || !(obj instanceof Pool)) continue;
            EdgeHelper.restoreThreadLocalConnection(obj, c);
        }
    }

    public static synchronized void saveThreadLocalConnections() {
        Map connections = EdgeHelper.getConnectionsMap();
        for (Pool pool : connections.keySet()) {
            EdgeHelper.saveThreadLocalConnection(pool);
        }
    }

    private static void restoreThreadLocalConnection(Object pool, Object c) {
        ((PoolImpl)pool).setThreadLocalConnection((Connection)c);
        if (Log.getLogWriter().fineEnabled()) {
            Log.getLogWriter().fine("Restored connection for: " + pool + " to: " + c);
        }
    }

    private static void saveThreadLocalConnection(Pool pool) {
        Connection c = ((PoolImpl)pool).getThreadLocalConnection();
        EdgeHelper.getConnectionsMap().put(pool, c);
        if (Log.getLogWriter().fineEnabled()) {
            Log.getLogWriter().fine("Saved connection for: " + pool + " as: " + c);
        }
    }

    private static Map getConnectionsMap() {
        HashMap connections = (HashMap)localconnections.get();
        if (connections == null) {
            connections = new HashMap();
            EdgeHelper.setConnectionsMap(connections);
        }
        return connections;
    }

    private static void setConnectionsMap(Map connections) {
        localconnections.set(connections);
    }
}

