/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.admin.AdminDistributedSystem;
import com.gemstone.gemfire.admin.AdminDistributedSystemFactory;
import com.gemstone.gemfire.admin.DistributedSystemConfig;
import com.gemstone.gemfire.admin.internal.AdminDistributedSystemImpl;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.Locator;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import hydra.AdminDescription;
import hydra.AdminPrms;
import hydra.BasePrms;
import hydra.CacheHelper;
import hydra.Contact;
import hydra.DistributedSystemBlackboard;
import hydra.EnvHelper;
import hydra.FileUtil;
import hydra.GemFireDescription;
import hydra.GemFireLocatorAgentRecord;
import hydra.GemFireVersionHelper;
import hydra.HostHelper;
import hydra.HydraConfigException;
import hydra.HydraInternalException;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.PortHelper;
import hydra.Prms;
import hydra.ProcessMgr;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

public class DistributedSystemHelper {
    public static final String DISCOVERY_FILE_NAME = "discovery.dat";
    private static Properties TheDistributedSystemProperties;
    private static String TheAdminConfig;
    private static Endpoint TheLocatorEndpoint;
    private static String TheLocatorConfig;
    private static LogWriter log;

    public static DistributedSystem connect() {
        DistributedSystemHelper.log("Connecting to distributed system");
        return DistributedSystemHelper._connect(null);
    }

    public static DistributedSystem connectWithXml(String cacheXmlFile) {
        if (cacheXmlFile == null) {
            throw new IllegalArgumentException("cacheXmlFile cannot be null");
        }
        DistributedSystemHelper.log("Connecting to distributed system using XML: " + cacheXmlFile);
        return DistributedSystemHelper._connect(cacheXmlFile);
    }

    private static synchronized DistributedSystem _connect(String cacheXmlFile) {
        DistributedSystem distributedSystem;
        String fn = null;
        if (cacheXmlFile != null) {
            fn = FileUtil.absoluteFilenameFor(EnvHelper.expandEnvVars(cacheXmlFile));
        }
        if ((distributedSystem = DistributedSystemHelper.getDistributedSystem()) == null) {
            Properties p = DistributedSystemHelper.getDistributedSystemProperties(fn);
            DistributedSystemHelper.log("Connecting to distributed system: " + DistributedSystemHelper.prettyprint(p));
            distributedSystem = DistributedSystem.connect((Properties)p);
            DistributedSystemHelper.log("Connected to distributed system");
            TheDistributedSystemProperties = p;
        } else {
            if (TheDistributedSystemProperties == null) {
                String s = "Distributed system was already connected without DistributedSystemHelper using an unknown, and possibly different, configuration";
                throw new HydraRuntimeException(s);
            }
            Properties p = DistributedSystemHelper.getDistributedSystemProperties(fn);
            if (!TheDistributedSystemProperties.equals(p)) {
                String s = "Distributed system already exists using properties " + TheDistributedSystemProperties + ", cannot also use " + p;
                throw new HydraRuntimeException(s);
            }
            DistributedSystemHelper.log("Already connected to distributed system");
        }
        return distributedSystem;
    }

    public static synchronized DistributedSystem getDistributedSystem() {
        return InternalDistributedSystem.getAnyInstance();
    }

    public static synchronized String getDistributedSystemName() {
        return DistributedSystemHelper.getGemFireDescription().getDistributedSystem();
    }

    public static synchronized Integer getDistributedSystemId() {
        return DistributedSystemHelper.getGemFireDescription().getDistributedSystemId();
    }

    public static synchronized void disconnect() {
        DistributedSystem distributedSystem = DistributedSystemHelper.getDistributedSystem();
        if (distributedSystem != null) {
            DistributedSystemHelper.log("Disconnecting from the distributed system: " + distributedSystem.getName());
            CacheHelper.TheCacheConfig = null;
            distributedSystem.disconnect();
            DistributedSystemHelper.log("Disconnected from the distributed system");
            TheLocatorConfig = null;
            TheDistributedSystemProperties = null;
        }
    }

    public static synchronized void cleanupAfterAutoDisconnect() {
        DistributedSystemHelper.log("Cleaning up after distributed system auto-disconnect");
        CacheHelper.TheCacheConfig = null;
        TheLocatorConfig = null;
        TheDistributedSystemProperties = null;
        DistributedSystemHelper.log("Cleaned up after distributed system auto-disconnect");
    }

    public static synchronized AdminDistributedSystem connectAdmin(String adminConfig) {
        DistributedSystemConfig dsConfig = DistributedSystemHelper.configureAdmin(adminConfig);
        AdminDistributedSystem ads = DistributedSystemHelper.createAdmin(dsConfig);
        DistributedSystemHelper.connectAdmin(ads);
        return ads;
    }

    public static synchronized AdminDistributedSystem createAdmin(String adminConfig) {
        DistributedSystemConfig dsConfig = DistributedSystemHelper.configureAdmin(adminConfig);
        return DistributedSystemHelper.createAdmin(dsConfig);
    }

    public static synchronized DistributedSystemConfig configureAdmin(String adminConfig) {
        DistributedSystemConfig dsConfig = null;
        if (TheAdminConfig == null) {
            DistributedSystemHelper.log("Configuring admin distributed system from config: " + adminConfig);
            AdminDescription ad = DistributedSystemHelper.getAdminDescription(adminConfig);
            AdminDistributedSystemFactory.setEnableAdministrationOnly((boolean)true);
            dsConfig = AdminDistributedSystemFactory.defineDistributedSystem();
            ad.configure(dsConfig);
            DistributedSystemHelper.log("Configured admin distributed system: " + AdminDescription.adminToString(dsConfig));
            TheAdminConfig = adminConfig;
        } else if (!TheAdminConfig.equals(adminConfig)) {
            String s = "Admin distributed system already configured using logical admin configuration named " + TheAdminConfig + ", cannot also use " + adminConfig;
            throw new HydraRuntimeException(s);
        }
        return dsConfig;
    }

    public static synchronized AdminDistributedSystem createAdmin(DistributedSystemConfig dsConfig) {
        AdminDistributedSystem ads = DistributedSystemHelper.getAdminDistributedSystem();
        if (ads == null) {
            DistributedSystemHelper.log("Creating admin distributed system from config: " + AdminDescription.adminToString(dsConfig));
            ads = AdminDistributedSystemFactory.getDistributedSystem((DistributedSystemConfig)dsConfig);
            DistributedSystemHelper.log("Created admin distributed system: " + DistributedSystemHelper.adminToString(ads));
        } else if (TheAdminConfig == null && ads != null) {
            String s = "Admin distributed system was already created without DistributedSystemHelper using an unknown, and possibly different, configuration";
            throw new HydraRuntimeException(s);
        }
        return ads;
    }

    public static synchronized void connectAdmin(AdminDistributedSystem ads) {
        AdminDistributedSystem connectedSystem = DistributedSystemHelper.getAdminDistributedSystem();
        if (connectedSystem == null) {
            DistributedSystemHelper.log("Connecting admin distributed system: |" + ads + "|");
            ads.connect();
            DistributedSystemHelper.log("Connected admin distributed system: " + ads + " " + DistributedSystemHelper.adminToString(ads));
        }
    }

    public static synchronized AdminDistributedSystem getAdminDistributedSystem() {
        return AdminDistributedSystemImpl.getConnectedInstance();
    }

    public static synchronized void disconnectAdmin() {
        AdminDistributedSystem ads = DistributedSystemHelper.getAdminDistributedSystem();
        if (ads != null) {
            DistributedSystemHelper.log("Disconnecting admin distributed system: " + ads + " " + DistributedSystemHelper.adminToString(ads));
            ads.disconnect();
            DistributedSystemHelper.log("Disconnected admin distributed system: " + ads);
            AdminDistributedSystemFactory.setEnableAdministrationOnly((boolean)false);
            TheAdminConfig = null;
        }
    }

    public static String adminToString(AdminDistributedSystem ads) {
        if (ads == null) {
            String s = "admin distributed system cannot be null";
            throw new IllegalArgumentException(s);
        }
        return AdminDescription.adminToString(ads.getConfig());
    }

    public static int getDistributedSystemId(String distributedSystemName) {
        for (GemFireDescription gfd : TestConfig.getInstance().getGemFireDescriptions().values()) {
            if (!gfd.getDistributedSystem().equals(distributedSystemName)) continue;
            return gfd.getDistributedSystemId();
        }
        String s = "Distributed system not found: " + distributedSystemName;
        throw new HydraRuntimeException(s);
    }

    public static String getDistributedSystemName(int distributedSystemId) {
        for (GemFireDescription gfd : TestConfig.getInstance().getGemFireDescriptions().values()) {
            if (gfd.getDistributedSystemId() != distributedSystemId) continue;
            return gfd.getDistributedSystem();
        }
        String s = "Distributed system not found: " + distributedSystemId;
        throw new HydraRuntimeException(s);
    }

    public static Set getMembers() {
        return GemFireVersionHelper.getMembers(DistributedSystemHelper._getDM());
    }

    public static Set getAdminMembers() {
        DM dm = DistributedSystemHelper._getDM();
        if (dm instanceof DistributionManager) {
            return new HashSet(((DistributionManager)dm).getAdminMemberSet());
        }
        return new HashSet();
    }

    private static DM _getDM() {
        DistributedSystem distributedSystem = DistributedSystemHelper.getDistributedSystem();
        if (distributedSystem == null) {
            String s = "This VM is not connected to a distributed system";
            throw new HydraRuntimeException(s);
        }
        return ((InternalDistributedSystem)distributedSystem).getDistributionManager();
    }

    public static Properties getDistributedSystemProperties(String cacheXmlFile) {
        GemFireDescription gfd = DistributedSystemHelper.getGemFireDescription();
        return DistributedSystemHelper.getDistributedSystemProperties(gfd, cacheXmlFile);
    }

    private static synchronized Properties getDistributedSystemProperties(GemFireDescription gfd, String cacheXmlFile) {
        DistributedSystemHelper.log("Looking up distributed system properties");
        Properties p = gfd.getDistributedSystemProperties();
        if (cacheXmlFile != null) {
            p.setProperty("cache-xml-file", cacheXmlFile);
        }
        if (TheLocatorConfig != null) {
            p.setProperty("start-locator", TheLocatorConfig);
            GemFireVersionHelper.setDistributedSystemId(p, gfd.getDistributedSystemId());
        }
        DistributedSystemHelper.log("Looked up distributed system properties: " + DistributedSystemHelper.prettyprint(p));
        return p;
    }

    private static String prettyprint(Properties p) {
        ArrayList<?> l = Collections.list(p.propertyNames());
        TreeSet set = new TreeSet(l);
        StringBuffer buf = new StringBuffer();
        for (String key : set) {
            String val = p.getProperty(key);
            buf.append("\n  " + key + "=" + val);
        }
        return buf.toString();
    }

    public static AdminDescription getAdminDescription(String adminConfig) {
        if (adminConfig == null) {
            throw new IllegalArgumentException("adminConfig cannot be null");
        }
        DistributedSystemHelper.log("Looking up admin config: " + adminConfig);
        AdminDescription ad = TestConfig.getInstance().getAdminDescription(adminConfig);
        if (ad == null) {
            String s = adminConfig + " not found in " + BasePrms.nameForKey(AdminPrms.names);
            throw new HydraRuntimeException(s);
        }
        DistributedSystemHelper.log("Looked up admin config:\n" + ad);
        return ad;
    }

    public static GemFireDescription getGemFireDescription() {
        DistributedSystemHelper.log("Looking for system property: gemfireName");
        String gemfireConfig = System.getProperty("gemfireName");
        if (gemfireConfig == null) {
            String s = "This VM is not configured for a distributed system: missing property gemfireName";
            throw new HydraRuntimeException(s);
        }
        DistributedSystemHelper.log("Looking up gemfire config: " + gemfireConfig);
        GemFireDescription gfd = TestConfig.getInstance().getGemFireDescription(gemfireConfig);
        String targetHost = gfd.getHostDescription().getHostName();
        if (!HostHelper.isLocalHost(targetHost)) {
            String s = gemfireConfig + " is on remote host " + targetHost;
            throw new HydraConfigException(s);
        }
        DistributedSystemHelper.log("Looked up gemfire config:\n" + gfd);
        return gfd;
    }

    public static synchronized void createLocator() {
        if (TestConfig.tab().booleanAt(Prms.manageLocatorAgents)) {
            String s = "Locators are being managed by the hydra master controller.  Set " + BasePrms.nameForKey(Prms.manageLocatorAgents) + "=false to use hydra-client-managed locators.";
            throw new HydraConfigException(s);
        }
        Locator locator = DistributedSystemHelper.getLocator();
        Endpoint endpoint = DistributedSystemHelper.findEndpoint();
        if (locator == null) {
            if (endpoint == null) {
                DistributedSystemHelper.generateEndpoint();
            }
        } else if (endpoint == null) {
            String s = "Locator was already started without DistributedSystemHelper using an unknown port";
            throw new HydraRuntimeException(s);
        }
    }

    public static synchronized Locator startLocatorAndDS() {
        return DistributedSystemHelper._startLocatorAndDS(false);
    }

    public static synchronized Locator startLocatorAndAdminDS() {
        return DistributedSystemHelper._startLocatorAndDS(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static synchronized Locator _startLocatorAndDS(boolean adminOnly) {
        Endpoint endpoint = DistributedSystemHelper.findEndpoint();
        if (endpoint == null) {
            String s = "Locator has not been created yet";
            throw new HydraRuntimeException(s);
        }
        Locator locator = DistributedSystemHelper.getLocator();
        GemFireDescription gfd = DistributedSystemHelper.getGemFireDescription();
        Properties p = DistributedSystemHelper.getDistributedSystemProperties(gfd, null);
        GemFireVersionHelper.setDistributedSystemId(p, gfd.getDistributedSystemId());
        int port = endpoint.getPort();
        String locatorConfig = endpoint.getLocatorProperty();
        if (locator == null) {
            DistributedSystem ds = DistributedSystemHelper.getDistributedSystem();
            if (ds == null) {
                File log = new File(p.getProperty("log-file"));
                DistributedSystemHelper.log("Starting locator and admin distributed system");
                try {
                    boolean gfxdLocator = false;
                    try {
                        Class<?> fabAPI = Class.forName("com.pivotal.gemfirexd.FabricServiceManager");
                        Object gfxdLoc = fabAPI.getMethod("getFabricLocatorInstance", new Class[0]).invoke(null, new Object[0]);
                        String locDir = log.getParent();
                        if (locDir != null && locDir.length() > 0) {
                            p.setProperty("sys-disk-dir", locDir);
                        }
                        if ("fine".equals(p.getProperty("log-level"))) {
                            p.remove("log-level");
                        }
                        Class.forName("com.pivotal.gemfirexd.FabricLocator").getMethod("start", String.class, Integer.TYPE, Properties.class).invoke(gfxdLoc, endpoint.getAddress(), port, p);
                        gfxdLocator = true;
                    }
                    catch (InvocationTargetException ite) {
                        DistributedSystemHelper.log("Failed to start GemFireXD locator due to " + ite, ite);
                    }
                    catch (Exception ite) {
                        // empty catch block
                    }
                    if (gfxdLocator) {
                        DistributedSystemHelper.log("Started GemFireXD locator \"" + endpoint.getId() + "\" with properties: " + DistributedSystemHelper.prettyprint(p));
                    } else if (adminOnly) {
                        DistributedSystemHelper.log("Starting locator \"" + locatorConfig + "\" and connecting to admin-only distributed system: " + DistributedSystemHelper.prettyprint(p));
                        locator = Locator.startLocatorAndDS((int)port, (File)log, null, (Properties)p, (boolean)endpoint.isPeerLocator(), (boolean)endpoint.isServerLocator(), (String)null);
                    } else {
                        p.setProperty("start-locator", locatorConfig);
                        DistributedSystemHelper.log("Starting locator \"" + locatorConfig + "\" and connecting to non-admin distributed system: " + DistributedSystemHelper.prettyprint(p));
                        DistributedSystem.connect((Properties)p);
                        locator = DistributedSystemHelper.getLocator();
                    }
                }
                catch (IOException e) {
                    try {
                        ProcessMgr.logNetworkStatistics();
                    }
                    finally {
                        String s = "Problem starting locator " + endpoint + " using port " + port + " with properties " + p;
                        throw new HydraRuntimeException(s, e);
                    }
                }
                DistributedSystemHelper.log("Started locator: " + locator);
                TheDistributedSystemProperties = p;
                if (adminOnly) return locator;
                TheLocatorConfig = locatorConfig;
                return locator;
            }
            String s = "This VM is already connected to a distributed system. Too late to start a locator";
            throw new HydraRuntimeException(s);
        }
        if (TheDistributedSystemProperties == null) {
            String s = "Locator was already started without DistributedSystemHelper using an unknown, and possibly different, configuration";
            throw new HydraRuntimeException(s);
        }
        if (TheDistributedSystemProperties.equals(p)) return locator;
        String s = "Already connected to distributed system using properties " + TheDistributedSystemProperties + ", cannot also use " + p;
        throw new HydraRuntimeException(s);
    }

    public static synchronized Locator getLocator() {
        List locators = Locator.getLocators();
        if (locators == null || locators.size() == 0) {
            return null;
        }
        if (locators.size() == 1) {
            return (Locator)locators.iterator().next();
        }
        String s = "Too many locators in this VM: " + locators;
        throw new UnsupportedOperationException(s);
    }

    public static synchronized void stopLocator() {
        Locator locator = DistributedSystemHelper.getLocator();
        if (locator != null) {
            DistributedSystemHelper.log("Stopping locator: " + DistributedSystemHelper.locatorToString(locator));
            locator.stop();
            TheDistributedSystemProperties = null;
            TheLocatorConfig = null;
            DistributedSystemHelper.log("Stopped locator: " + DistributedSystemHelper.locatorToString(locator));
        }
    }

    public static String locatorToString(Locator locator) {
        return locator.toString();
    }

    public static synchronized List getEndpoints() {
        ArrayList<Endpoint> peerLocatorEndpoints = new ArrayList<Endpoint>();
        Collection endpoints = DistributedSystemBlackboard.getInstance().getSharedMap().getMap().values();
        for (Endpoint endpoint : endpoints) {
            if (!endpoint.isPeerLocator()) continue;
            peerLocatorEndpoints.add(endpoint);
        }
        return peerLocatorEndpoints;
    }

    public static synchronized List getSystemEndpoints() {
        return DistributedSystemHelper.getEndpoints(DistributedSystemHelper.getDistributedSystemName());
    }

    public static synchronized List getEndpoints(String distributedSystemName) {
        ArrayList<Endpoint> peerLocatorEndpoints = new ArrayList<Endpoint>();
        for (Endpoint endpoint : DistributedSystemHelper.getEndpoints()) {
            if (!endpoint.getDistributedSystemName().equals(distributedSystemName)) continue;
            peerLocatorEndpoints.add(endpoint);
        }
        return peerLocatorEndpoints;
    }

    public static synchronized List getContacts() {
        ArrayList<Endpoint> serverLocatorEndpoints = new ArrayList<Endpoint>();
        Collection endpoints = DistributedSystemBlackboard.getInstance().getSharedMap().getMap().values();
        for (Endpoint endpoint : endpoints) {
            if (!endpoint.isServerLocator()) continue;
            serverLocatorEndpoints.add(endpoint);
        }
        return serverLocatorEndpoints;
    }

    public static synchronized List getSystemContacts() {
        return DistributedSystemHelper.getContacts(DistributedSystemHelper.getDistributedSystemName());
    }

    public static synchronized List getContacts(String distributedSystemName) {
        ArrayList<Endpoint> serverLocatorEndpoints = new ArrayList<Endpoint>();
        for (Endpoint endpoint : DistributedSystemHelper.getContacts()) {
            if (!endpoint.getDistributedSystemName().equals(distributedSystemName)) continue;
            serverLocatorEndpoints.add(endpoint);
        }
        return serverLocatorEndpoints;
    }

    public static synchronized List<String> getContacts(List<String> distributedSystemNames) {
        ArrayList<String> serverLocatorEndpoints = new ArrayList<String>();
        for (String distributedSystemName : distributedSystemNames) {
            serverLocatorEndpoints.addAll(DistributedSystemHelper.getContacts(distributedSystemName));
        }
        return serverLocatorEndpoints;
    }

    public static String endpointsToString(List endpoints) {
        String locatorStr = "";
        if (endpoints != null) {
            for (Endpoint endpoint : endpoints) {
                if (locatorStr.length() > 0) {
                    locatorStr = locatorStr + ",";
                }
                locatorStr = locatorStr + DistributedSystemHelper.endpointToString(endpoint);
            }
        }
        return locatorStr;
    }

    public static String endpointToString(Endpoint endpoint) {
        return endpoint == null ? "" : endpoint.getId();
    }

    private static synchronized Endpoint findEndpoint() {
        if (TheLocatorEndpoint == null) {
            Integer vmid = new Integer(RemoteTestModule.getMyVmid());
            TheLocatorEndpoint = (Endpoint)DistributedSystemBlackboard.getInstance().getSharedMap().get(vmid);
        }
        return TheLocatorEndpoint;
    }

    private static synchronized Endpoint generateEndpoint() {
        Endpoint endpoint = DistributedSystemHelper.findEndpoint();
        if (endpoint == null) {
            DistributedSystemHelper.log("Generating locator endpoint");
            Integer vmid = new Integer(RemoteTestModule.getMyVmid());
            String name = RemoteTestModule.getMyClientName();
            String host = HostHelper.getCanonicalHostName();
            String addr = HostHelper.getHostAddress();
            int port = PortHelper.getRandomPort();
            String id = addr + "[" + port + "]";
            GemFireDescription gfd = DistributedSystemHelper.getGemFireDescription();
            String ds = gfd.getDistributedSystem();
            endpoint = new Endpoint(id, name, vmid, host, addr, port, ds, gfd.isPeerLocator(), gfd.isServerLocator());
            DistributedSystemHelper.log("Generated locator endpoint: " + endpoint);
            DistributedSystemBlackboard.getInstance().getSharedMap().put(vmid, endpoint);
            try {
                RemoteTestModule.Master.recordLocator(endpoint);
            }
            catch (RemoteException e) {
                String s = "While recording locator endpoint";
                throw new HydraRuntimeException(s, e);
            }
        }
        TheLocatorEndpoint = endpoint;
        return endpoint;
    }

    private static synchronized void log(String s) {
        DistributedSystemHelper.log(s, null);
    }

    private static synchronized void log(String s, Throwable t) {
        if (log == null) {
            log = Log.getLogWriter();
        }
        if (log.infoEnabled()) {
            log.info(s, t);
        }
    }

    public static class Endpoint
    implements Contact,
    Serializable {
        String id;
        String name;
        String host;
        String addr;
        String ds;
        int vmid;
        int port;
        boolean isPeerLocator;
        boolean isServerLocator;

        protected Endpoint(GemFireLocatorAgentRecord lar) {
            if (lar == null) {
                throw new HydraInternalException("lar is null");
            }
            this.id = lar.getHostAddress() + "[" + lar.getPort() + "]";
            this.name = "locatoragent";
            this.vmid = lar.getProcessId();
            this.host = lar.getHostName();
            this.addr = lar.getHostAddress();
            this.port = lar.getPort();
            this.ds = lar.getDistributedSystem();
            this.isPeerLocator = true;
            this.isServerLocator = lar.isServerLocator();
        }

        public Endpoint(String id, String name, int vmid, String host, String addr, int port, String ds, boolean isPeerLocator, boolean isServerLocator) {
            if (id == null) {
                throw new IllegalArgumentException("id cannot be null");
            }
            if (name == null) {
                throw new IllegalArgumentException("name cannot be null");
            }
            if (host == null) {
                throw new IllegalArgumentException("host cannot be null");
            }
            if (addr == null) {
                throw new IllegalArgumentException("addr cannot be null");
            }
            if (ds == null) {
                throw new IllegalArgumentException("ds cannot be null");
            }
            this.id = id;
            this.name = name;
            this.vmid = vmid;
            this.host = host;
            this.addr = addr;
            this.port = port;
            this.ds = ds;
            this.isPeerLocator = isPeerLocator;
            this.isServerLocator = isServerLocator;
        }

        public String getId() {
            return this.id;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public int getVmid() {
            return this.vmid;
        }

        @Override
        public String getHost() {
            return this.host;
        }

        @Override
        public String getAddress() {
            return this.addr;
        }

        @Override
        public int getPort() {
            return this.port;
        }

        public String getDistributedSystemName() {
            return this.ds;
        }

        public boolean isPeerLocator() {
            return this.isPeerLocator;
        }

        public boolean isServerLocator() {
            return this.isServerLocator;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Endpoint) {
                Endpoint endpoint = (Endpoint)obj;
                return endpoint.getId().equals(this.getId()) && endpoint.getName().equals(this.getName()) && endpoint.getVmid() == this.getVmid() && endpoint.getHost().equals(this.getHost()) && endpoint.getAddress().equals(this.getAddress()) && endpoint.getPort() == this.getPort() && endpoint.getDistributedSystemName().equals(this.getDistributedSystemName()) && endpoint.isPeerLocator() == this.isPeerLocator() && endpoint.isServerLocator() == this.isServerLocator();
            }
            return false;
        }

        public int hashCode() {
            return this.port;
        }

        public String getLocatorProperty() {
            return this.addr + "[" + this.port + "],peer=" + this.isPeerLocator + ",server=" + this.isServerLocator;
        }

        public void record() {
            String data = this.id + "," + this.ds + "," + this.host + "," + this.addr + "," + this.port;
            FileUtil.appendToFile(DistributedSystemHelper.DISCOVERY_FILE_NAME, data + "\n");
        }

        public String toString() {
            if (this.name.equals("locatoragent")) {
                return this.id + "(locator_" + this.ds + "_" + this.vmid + ")";
            }
            return this.id + "(" + this.ds + ":vm_" + this.vmid + "_" + this.name + "_" + this.host + ")";
        }
    }
}

