/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.DiskStoreFactory;
import hydra.BasePrms;
import hydra.CacheHelper;
import hydra.DiskStoreDescription;
import hydra.DiskStorePrms;
import hydra.HydraInternalException;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.TestConfig;

public class DiskStoreHelper {
    private static LogWriter log;

    public static synchronized DiskStore createDiskStore(String diskStoreConfig) {
        DiskStoreFactory factory = DiskStoreHelper.getDiskStoreFactory(diskStoreConfig);
        return DiskStoreHelper.createDiskStore(diskStoreConfig, factory);
    }

    public static synchronized DiskStore createDiskStore(String diskStoreName, DiskStoreFactory factory) {
        if (diskStoreName == null) {
            throw new IllegalArgumentException("diskStoreName cannot be null");
        }
        if (factory == null) {
            throw new IllegalArgumentException("factory cannot be null");
        }
        DiskStore diskStore = CacheHelper.getCache().findDiskStore(diskStoreName);
        if (diskStore == null) {
            DiskStoreHelper.log("Creating disk store named: " + diskStoreName + " with attributes " + DiskStoreHelper.diskStoreFactoryToString(diskStoreName, factory));
            try {
                diskStore = factory.create(diskStoreName);
            }
            catch (IllegalStateException e) {
                throw new HydraInternalException("Should not happen", e);
            }
            DiskStoreHelper.log("Created disk store named: " + diskStoreName);
        } else if (!DiskStoreDescription.equals(factory, diskStore)) {
            String desired = DiskStoreHelper.diskStoreFactoryToString(diskStoreName, factory);
            String existing = DiskStoreHelper.diskStoreToString(diskStore);
            String s = "DiskStore " + diskStoreName + " already exists with different attributes\n  DESIRED = " + desired + "\n  EXISTING = " + existing;
            throw new HydraRuntimeException(s);
        }
        return diskStore;
    }

    public static synchronized DiskStore getDiskStore(String diskStoreName) {
        if (diskStoreName == null) {
            throw new IllegalArgumentException("diskStoreName cannot be null");
        }
        return CacheHelper.getCache().findDiskStore(diskStoreName);
    }

    public static String diskStoreToString(DiskStore diskStore) {
        if (diskStore == null) {
            throw new IllegalArgumentException("disk store cannot be null");
        }
        return DiskStoreDescription.diskStoreToString(diskStore);
    }

    public static DiskStoreFactory getDiskStoreFactory(String diskStoreConfig) {
        DiskStoreDescription dsd = DiskStoreHelper.getDiskStoreDescription(diskStoreConfig);
        DiskStoreFactory factory = CacheHelper.getCache().createDiskStoreFactory();
        DiskStoreHelper.log("Configuring disk store factory for config: " + diskStoreConfig);
        dsd.configure(factory);
        DiskStoreHelper.log("Configured disk store factory: " + factory);
        return factory;
    }

    private static String diskStoreFactoryToString(String diskStoreName, DiskStoreFactory factory) {
        if (diskStoreName == null) {
            throw new IllegalArgumentException("diskStoreName cannot be null");
        }
        if (factory == null) {
            throw new IllegalArgumentException("factory cannot be null");
        }
        return DiskStoreDescription.diskStoreFactoryToString(diskStoreName, factory);
    }

    public static DiskStoreDescription getDiskStoreDescription(String diskStoreConfig) {
        if (diskStoreConfig == null) {
            throw new IllegalArgumentException("diskStoreConfig cannot be null");
        }
        DiskStoreHelper.log("Looking up disk store config: " + diskStoreConfig);
        DiskStoreDescription dsd = TestConfig.getInstance().getDiskStoreDescription(diskStoreConfig);
        if (dsd == null) {
            String s = diskStoreConfig + " not found in " + BasePrms.nameForKey(DiskStorePrms.names);
            throw new HydraRuntimeException(s);
        }
        DiskStoreHelper.log("Looked up disk store config:\n" + dsd);
        return dsd;
    }

    private static synchronized void log(String s) {
        if (log == null) {
            log = Log.getLogWriter();
        }
        if (log.infoEnabled()) {
            log.info(s);
        }
    }
}

