/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.DiskStoreFactory;
import com.gemstone.gemfire.internal.cache.DiskStoreAttributes;
import com.gemstone.gemfire.internal.cache.DiskStoreFactoryImpl;
import hydra.AbstractDescription;
import hydra.BasePrms;
import hydra.ConfigHashtable;
import hydra.DiskStorePrms;
import hydra.DistributedSystemHelper;
import hydra.FileUtil;
import hydra.GemFireDescription;
import hydra.HostDescription;
import hydra.HydraConfigException;
import hydra.HydraRuntimeException;
import hydra.HydraVector;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;

public class DiskStoreDescription
extends AbstractDescription
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private Boolean allowForceCompaction;
    private Boolean autoCompact;
    private Integer compactionThreshold;
    private Map<String, List> diskDirBases;
    private Integer diskDirNum;
    private int[] diskDirSizes;
    private transient File[] diskDirs;
    private Long maxOplogSize;
    private Integer queueSize;
    private Long timeInterval;
    private Integer writeBufferSize;

    public String getName() {
        return this.name;
    }

    private void setName(String str) {
        this.name = str;
    }

    private Boolean getAllowForceCompaction() {
        return this.allowForceCompaction;
    }

    private void setAllowForceCompaction(Boolean bool) {
        this.allowForceCompaction = bool;
    }

    private Boolean getAutoCompact() {
        return this.autoCompact;
    }

    private void setAutoCompact(Boolean bool) {
        this.autoCompact = bool;
    }

    private Integer getCompactionThreshold() {
        return this.compactionThreshold;
    }

    private void setCompactionThreshold(Integer i) {
        this.compactionThreshold = i;
    }

    private Integer getDiskDirNum() {
        return this.diskDirNum;
    }

    private void setDiskDirNum(Integer i) {
        this.diskDirNum = i;
    }

    public synchronized File[] getDiskDirs() {
        if (this.diskDirs == null) {
            if (this.diskDirNum == 0) {
                File[] dirs = new File[]{};
                this.diskDirs = dirs;
            } else {
                GemFireDescription gfd = DistributedSystemHelper.getGemFireDescription();
                List<String> bases = this.getDiskDirBases(gfd);
                File[] dirs = new File[this.diskDirNum.intValue()];
                for (int i = 0; i < dirs.length; ++i) {
                    String path = bases.get(i % bases.size());
                    dirs[i] = new File(path + File.separator + "vm_" + RemoteTestModule.getMyVmid() + "_" + RemoteTestModule.getMyClientName() + "_disk_" + (i + 1));
                    try {
                        FileUtil.mkdir(dirs[i]);
                        HostDescription hd = gfd.getHostDescription();
                        String dir = dirs[i].toString();
                        try {
                            RemoteTestModule.Master.recordDir(hd, gfd.getName(), dir);
                            continue;
                        }
                        catch (RemoteException e) {
                            String s = "Unable to access master to record directory: " + dir;
                            throw new HydraRuntimeException(s, e);
                        }
                    }
                    catch (VirtualMachineError e) {
                        SystemFailure.initiateFailure((Error)e);
                        throw e;
                    }
                    catch (Error e) {
                        String s = "Unable to create directory: " + dirs[i];
                        throw new HydraRuntimeException(s);
                    }
                }
                this.diskDirs = dirs;
            }
        }
        return this.diskDirs;
    }

    private void setDiskDirs(File[] dirs) {
        this.diskDirs = dirs;
    }

    private Map<String, List> getDiskDirBases() {
        return this.diskDirBases;
    }

    private List<String> getDiskDirBases(GemFireDescription gfd) {
        Map<String, List> diskDirBases = this.getDiskDirBases();
        ArrayList<String> basesForHost = null;
        if (diskDirBases != null) {
            String hostName = gfd.getHostDescription().getHostName();
            basesForHost = this.getDiskDirBases().get(hostName);
        }
        String sysdir = gfd.getSystemDirectoryStr();
        if (basesForHost == null || basesForHost.size() == 0) {
            String path = new File(sysdir).getParent();
            basesForHost = new ArrayList<String>();
            basesForHost.add(path);
        } else {
            String testDir = new File(sysdir).getParentFile().getName();
            ArrayList<String> newBasesForHost = new ArrayList<String>();
            for (String baseForHost : basesForHost) {
                String path = baseForHost + "/" + testDir;
                newBasesForHost.add(path);
            }
            basesForHost = newBasesForHost;
        }
        return basesForHost;
    }

    private void setDiskDirBases(Map<String, List> bases) {
        this.diskDirBases = bases;
    }

    private int[] getDiskDirSizes() {
        return this.diskDirSizes;
    }

    private void setDiskDirSizes(int[] sizes) {
        this.diskDirSizes = sizes;
    }

    private Long getMaxOplogSize() {
        return this.maxOplogSize;
    }

    private void setMaxOplogSize(Long l) {
        this.maxOplogSize = l;
    }

    private Integer getQueueSize() {
        return this.queueSize;
    }

    private void setQueueSize(Integer i) {
        this.queueSize = i;
    }

    private Long getTimeInterval() {
        return this.timeInterval;
    }

    private void setTimeInterval(Long l) {
        this.timeInterval = l;
    }

    private Integer getWriteBufferSize() {
        return this.writeBufferSize;
    }

    private void setWriteBufferSize(Integer i) {
        this.writeBufferSize = i;
    }

    public void configure(DiskStoreFactory f) {
        f.setAllowForceCompaction(this.getAllowForceCompaction().booleanValue());
        f.setAutoCompact(this.getAutoCompact().booleanValue());
        f.setCompactionThreshold(this.getCompactionThreshold().intValue());
        f.setDiskDirsAndSizes(this.getDiskDirs(), this.getDiskDirSizes());
        f.setMaxOplogSize(this.getMaxOplogSize().longValue());
        f.setQueueSize(this.getQueueSize().intValue());
        f.setTimeInterval(this.getTimeInterval().longValue());
        f.setWriteBufferSize(this.getWriteBufferSize().intValue());
    }

    protected static synchronized String diskStoreToString(DiskStore d) {
        return DiskStoreDescription.diskStoreToString(d.getName(), d);
    }

    private static synchronized String diskStoreToString(String diskStoreName, DiskStore d) {
        StringBuffer buf = new StringBuffer();
        buf.append("\n  diskStoreName: " + diskStoreName);
        buf.append("\n  allowForceCompaction: " + d.getAllowForceCompaction());
        buf.append("\n  autoCompact: " + d.getAutoCompact());
        buf.append("\n  compactionThreshold: " + d.getCompactionThreshold());
        buf.append("\n  diskDirSizes: " + DiskStoreDescription.asList(d.getDiskDirSizes()));
        buf.append("\n  diskDirs: " + Arrays.asList(d.getDiskDirs()));
        buf.append("\n  maxOplogSize: " + d.getMaxOplogSize());
        buf.append("\n  queueSize: " + d.getQueueSize());
        buf.append("\n  timeInterval: " + d.getTimeInterval());
        buf.append("\n  writeBufferSize: " + d.getWriteBufferSize());
        return buf.toString();
    }

    protected static synchronized String diskStoreFactoryToString(String diskStoreName, DiskStoreFactory f) {
        DiskStoreAttributes da = ((DiskStoreFactoryImpl)f).getDiskStoreAttributes();
        return DiskStoreDescription.diskStoreToString(diskStoreName, (DiskStore)da);
    }

    protected static boolean equals(DiskStoreFactory f, DiskStore d) {
        int i;
        DiskStoreAttributes da = ((DiskStoreFactoryImpl)f).getDiskStoreAttributes();
        if (da.getAllowForceCompaction() != d.getAllowForceCompaction() || da.getAutoCompact() != d.getAutoCompact() || da.getCompactionThreshold() != d.getCompactionThreshold() || da.getMaxOplogSize() != d.getMaxOplogSize() || da.getQueueSize() != d.getQueueSize() || da.getTimeInterval() != d.getTimeInterval() || da.getWriteBufferSize() != d.getWriteBufferSize()) {
            return false;
        }
        if (da.getDiskDirSizes().length != d.getDiskDirSizes().length) {
            return false;
        }
        for (i = 0; i < da.getDiskDirSizes().length; ++i) {
            if (da.getDiskDirSizes()[i] == d.getDiskDirSizes()[i]) continue;
            return false;
        }
        if (da.getDiskDirs().length != d.getDiskDirs().length) {
            return false;
        }
        for (i = 0; i < da.getDiskDirs().length; ++i) {
            if (da.getDiskDirs()[i].equals(d.getDiskDirs()[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public SortedMap toSortedMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        String header = this.getClass().getName() + "." + this.getName() + ".";
        map.put(header + "allowForceCompaction", this.getAllowForceCompaction());
        map.put(header + "autoCompact", this.getAutoCompact());
        map.put(header + "compactionThreshold", this.getCompactionThreshold());
        map.put(header + "diskDirBases", this.getDiskDirBases());
        map.put(header + "diskDirNum", this.getDiskDirNum());
        map.put(header + "diskDirSizes", DiskStoreDescription.asList(this.getDiskDirSizes()));
        if (this.diskDirNum == 0) {
            map.put(header + "diskDirs", "[]");
        } else {
            map.put(header + "diskDirs", "autogenerated: same path as system directory");
        }
        map.put(header + "maxOplogSize", this.getMaxOplogSize());
        map.put(header + "queueSize", this.getQueueSize());
        map.put(header + "timeInterval", this.getTimeInterval());
        map.put(header + "writeBufferSize", this.getWriteBufferSize());
        return map;
    }

    protected static void configure(TestConfig config) {
        ConfigHashtable tab = config.getParameters();
        HydraVector names = tab.vecAt(DiskStorePrms.names, new HydraVector());
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.elementAt(i);
            DiskStoreDescription dsd = DiskStoreDescription.createDiskStoreDescription(name, config, i);
            config.addDiskStoreDescription(dsd);
        }
    }

    private static DiskStoreDescription createDiskStoreDescription(String name, TestConfig config, int index) {
        Map<String, List> bases;
        ConfigHashtable tab = config.getParameters();
        DiskStoreDescription dsd = new DiskStoreDescription();
        dsd.setName(name);
        Long key = DiskStorePrms.allowForceCompaction;
        Boolean bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            bool = false;
        }
        dsd.setAllowForceCompaction(bool);
        key = DiskStorePrms.autoCompact;
        bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            bool = true;
        }
        dsd.setAutoCompact(bool);
        key = DiskStorePrms.compactionThreshold;
        Integer i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 50;
        }
        dsd.setCompactionThreshold(i);
        key = DiskStorePrms.diskDirNum;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 1;
        }
        dsd.setDiskDirNum(DiskStoreDescription.getDiskDirNum(i, key));
        Long key2 = DiskStorePrms.diskDirBaseMapFileName;
        String str = tab.getString(key2, tab.getWild(key2, index, null));
        if (str == null) {
            key2 = DiskStorePrms.diskDirBases;
            bases = DiskStoreDescription.getDiskDirBases(key2, tab.vecAtWild(key2, index, null));
        } else {
            bases = DiskStoreDescription.getDiskDirBases(key2, str);
        }
        dsd.setDiskDirBases(bases);
        key = DiskStorePrms.diskDirSizes;
        int[] sizes = DiskStoreDescription.getDiskDirSizes(key, tab.vecAtWild(key, index, null), tab, dsd.getDiskDirNum());
        dsd.setDiskDirSizes(sizes);
        key = DiskStorePrms.maxOplogSize;
        Long l = tab.getLong(key, tab.getWild(key, index, null));
        if (l == null) {
            l = DiskStoreFactory.DEFAULT_MAX_OPLOG_SIZE;
        }
        dsd.setMaxOplogSize(l);
        key = DiskStorePrms.queueSize;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 0;
        }
        dsd.setQueueSize(i);
        key = DiskStorePrms.timeInterval;
        l = tab.getLong(key, tab.getWild(key, index, null));
        if (l == null) {
            l = 1000L;
        }
        dsd.setTimeInterval(l);
        key = DiskStorePrms.writeBufferSize;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 32768;
        }
        dsd.setWriteBufferSize(i);
        return dsd;
    }

    private static Integer getDiskDirNum(Integer val, Long key) {
        return val == null ? Integer.valueOf(1) : DiskStoreDescription.getNonnegativeIntegerFor(val, key);
    }

    private static Map<String, List> getDiskDirBases(Long key, String str) {
        try {
            List<String> tokens = FileUtil.getTextAsTokens(str);
            return DiskStoreDescription.getDiskDirBases(key, new Vector<String>(tokens));
        }
        catch (IOException e) {
            String s = "Problem reading " + BasePrms.nameForKey(key) + ": " + str;
            throw new HydraConfigException(s, e);
        }
    }

    private static Map<String, List> getDiskDirBases(Long key, Vector<String> val) {
        if (val == null || val.size() == 0) {
            return null;
        }
        TreeMap<String, List> bases = new TreeMap<String, List>();
        String currentHost = null;
        ArrayList<String> currentBases = null;
        for (String token : val) {
            if (token.indexOf("/") == -1 && token.indexOf("\\") == -1) {
                currentHost = token;
                currentBases = new ArrayList<String>();
                bases.put(currentHost, currentBases);
                continue;
            }
            currentBases = (ArrayList<String>)bases.get(currentHost);
            if (currentBases == null) {
                String s = BasePrms.nameForKey(key) + " missing host for: " + token;
                throw new HydraConfigException(s);
            }
            currentBases.add(token);
        }
        return bases;
    }

    private static int[] getDiskDirSizes(Long key, Vector val, ConfigHashtable tab, Integer diskDirNum) {
        int[] sizes = new int[diskDirNum.intValue()];
        for (int i = 0; i < sizes.length; ++i) {
            Integer size;
            sizes[i] = val == null ? Integer.MAX_VALUE : ((size = tab.getInteger(key, ConfigHashtable.getWild(val, i, null))) == null ? Integer.MAX_VALUE : size);
        }
        return sizes;
    }
}

