/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.AbstractDescription;
import hydra.BasePrms;
import hydra.HydraConfigException;
import hydra.HydraInternalException;
import hydra.TestConfig;

public class ConfigPrms
extends BasePrms {
    public static Long cacheConfig;
    public static Long clientCacheConfig;
    public static Long regionConfig;
    public static Long clientRegionConfig;
    public static Long bridgeConfig;
    public static Long gatewayReceiverConfig;
    public static Long gatewaySenderConfig;
    public static Long asyncEventQueueConfig;
    public static Long gatewayConfig;
    public static Long gatewayHubConfig;
    public static Long diskStoreConfig;
    public static Long poolConfig;
    public static Long adminConfig;
    public static Long agentConfig;
    public static Long hadoopConfig;
    public static Long hdfsStoreConfig;

    public static String getCacheConfig() {
        return ConfigPrms.getString(cacheConfig);
    }

    public static String getClientCacheConfig() {
        return ConfigPrms.getString(clientCacheConfig);
    }

    public static String getRegionConfig() {
        return ConfigPrms.getString(regionConfig);
    }

    public static String getClientRegionConfig() {
        return ConfigPrms.getString(clientRegionConfig);
    }

    public static String getBridgeConfig() {
        return ConfigPrms.getString(bridgeConfig);
    }

    public static String getGatewayReceiverConfig() {
        return ConfigPrms.getString(gatewayReceiverConfig);
    }

    public static String getGatewaySenderConfig() {
        return ConfigPrms.getString(gatewaySenderConfig);
    }

    public static String getAsyncEventQueueConfig() {
        return ConfigPrms.getString(asyncEventQueueConfig);
    }

    public static String getGatewayConfig() {
        return ConfigPrms.getString(gatewayConfig);
    }

    public static String getGatewayHubConfig() {
        return ConfigPrms.getString(gatewayHubConfig);
    }

    public static String getDiskStoreConfig() {
        return ConfigPrms.getString(diskStoreConfig);
    }

    public static String getPoolConfig() {
        return ConfigPrms.getString(poolConfig);
    }

    public static String getAdminConfig() {
        return ConfigPrms.getString(adminConfig);
    }

    public static String getAgentConfig() {
        return ConfigPrms.getString(agentConfig);
    }

    public static String getHadoopConfig() {
        return ConfigPrms.getString(hadoopConfig);
    }

    public static String getHDFSStoreConfig() {
        return ConfigPrms.getString(hdfsStoreConfig);
    }

    public static String getString(Long key) {
        AbstractDescription description;
        String val = ConfigPrms.tasktab().stringAt(key, ConfigPrms.tab().stringAt(key, null));
        if (val == null) {
            return null;
        }
        if (key == cacheConfig) {
            description = TestConfig.getInstance().getCacheDescription(val);
        } else if (key == clientCacheConfig) {
            description = TestConfig.getInstance().getClientCacheDescription(val);
        } else if (key == regionConfig) {
            description = TestConfig.getInstance().getRegionDescription(val);
        } else if (key == clientRegionConfig) {
            description = TestConfig.getInstance().getClientRegionDescription(val);
        } else if (key == bridgeConfig) {
            description = TestConfig.getInstance().getBridgeDescription(val);
        } else if (key == gatewayReceiverConfig) {
            description = TestConfig.getInstance().getGatewayReceiverDescription(val);
        } else if (key == gatewaySenderConfig) {
            description = TestConfig.getInstance().getGatewaySenderDescription(val);
        } else if (key == asyncEventQueueConfig) {
            description = TestConfig.getInstance().getAsyncEventQueueDescription(val);
        } else if (key == gatewayConfig) {
            description = TestConfig.getInstance().getGatewayDescription(val);
        } else if (key == gatewayHubConfig) {
            description = TestConfig.getInstance().getGatewayHubDescription(val);
        } else if (key == diskStoreConfig) {
            description = TestConfig.getInstance().getDiskStoreDescription(val);
        } else if (key == poolConfig) {
            description = TestConfig.getInstance().getPoolDescription(val);
        } else if (key == adminConfig) {
            description = TestConfig.getInstance().getAdminDescription(val);
        } else if (key == agentConfig) {
            description = TestConfig.getInstance().getAgentDescription(val);
        } else if (key == hadoopConfig) {
            description = TestConfig.getInstance().getHadoopDescription(val);
        } else if (key == hdfsStoreConfig) {
            description = TestConfig.getInstance().getHDFSStoreDescription(val);
        } else {
            throw new HydraInternalException("Unknown key: " + ConfigPrms.nameForKey(key));
        }
        if (description == null) {
            String s = "Description for configuration name \"" + ConfigPrms.nameForKey(key) + "\" not found: " + val;
            throw new HydraConfigException(s);
        }
        return val;
    }

    public static void main(String[] args) {
        ConfigPrms.dumpKeys();
    }

    static {
        ConfigPrms.setValues(ConfigPrms.class);
    }
}

