/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.BridgeHelper;
import hydra.HydraInternalException;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.io.Serializable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Pattern;

public class ClientVmInfo
implements Serializable {
    private Integer vmid;
    private String clientName;
    private String logicalHost;

    protected ClientVmInfo() {
        try {
            this.setVmid(new Integer(RemoteTestModule.MyVmid));
            this.setClientName(RemoteTestModule.MyClientName);
            this.setLogicalHost(RemoteTestModule.MyLogicalHost);
        }
        catch (IllegalArgumentException e) {
            throw new HydraInternalException("Bad RTM settings", e);
        }
    }

    public ClientVmInfo(int vmid) {
        this.setVmid(new Integer(vmid));
    }

    public ClientVmInfo(Integer vmid, String clientName, String logicalHost) {
        this.setVmid(vmid);
        this.setClientName(clientName);
        this.setLogicalHost(logicalHost);
    }

    public ClientVmInfo(BridgeHelper.Endpoint endpoint) {
        if (endpoint == null) {
            throw new IllegalArgumentException("endpoint cannot be null");
        }
        this.setVmid(new Integer(endpoint.getVmid()));
        this.setClientName(endpoint.getName());
    }

    public Integer getVmid() {
        return this.vmid;
    }

    protected void setVmid(Integer vmid) {
        this.vmid = vmid;
    }

    public String getClientName() {
        return this.clientName;
    }

    protected void setClientName(String clientName) {
        this.clientName = clientName;
        if (clientName != null && !this.clientNameIsValid()) {
            String s = "Client name " + clientName + " not found";
            throw new IllegalArgumentException(s);
        }
    }

    private boolean clientNameIsValid() {
        Vector clientNames = TestConfig.getInstance().getClientNames();
        Iterator i = clientNames.iterator();
        while (i.hasNext()) {
            if (!this.clientNameMatches((String)i.next())) continue;
            return true;
        }
        return false;
    }

    protected boolean clientNameMatches(String aClientName) {
        Pattern pattern;
        if (this.clientName.equals(aClientName)) {
            return true;
        }
        return this.clientName.indexOf("*") != -1 && (pattern = this.patternFor(this.clientName)).matcher(aClientName).matches();
    }

    private Pattern patternFor(String s) {
        String result = new String();
        StringTokenizer tokenizer = new StringTokenizer(s, "*", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("*")) {
                result = result + ".";
            }
            result = result + token;
        }
        return Pattern.compile(result);
    }

    public String getLogicalHost() {
        return this.logicalHost;
    }

    protected void setLogicalHost(String logicalHost) {
        if (logicalHost != null && !TestConfig.getInstance().getHostNames().contains(logicalHost)) {
            String s = "Host name " + logicalHost + " not found";
            throw new IllegalArgumentException(s);
        }
        this.logicalHost = logicalHost;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("vm_");
        if (this.vmid == null) {
            buf.append("*");
        } else {
            buf.append(this.vmid);
        }
        buf.append("_");
        if (this.clientName == null) {
            buf.append("*");
        } else {
            buf.append(this.clientName);
        }
        buf.append("_");
        if (this.logicalHost == null) {
            buf.append("*");
        } else {
            buf.append(this.logicalHost);
        }
        return buf.toString();
    }
}

