/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.server.CacheServer;
import hydra.BasePrms;
import hydra.BridgeBlackboard;
import hydra.BridgeDescription;
import hydra.BridgePrms;
import hydra.BridgeVersionHelper;
import hydra.CacheHelper;
import hydra.Contact;
import hydra.DistributedSystemHelper;
import hydra.HostHelper;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.PortHelper;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BridgeHelper {
    private static String TheBridgeConfig;
    private static LogWriter log;

    public static synchronized CacheServer startBridgeServer(String bridgeConfig) {
        CacheServer bridge = BridgeHelper.createBridgeServer(bridgeConfig);
        BridgeHelper.startBridgeServer();
        return bridge;
    }

    public static synchronized CacheServer createBridgeServer(String bridgeConfig) {
        CacheServer bridge = BridgeHelper.getBridgeServer();
        if (bridge == null) {
            BridgeDescription bd = BridgeHelper.getBridgeDescription(bridgeConfig);
            BridgeHelper.log("Adding bridge server to cache");
            bridge = CacheFactory.getAnyInstance().addCacheServer();
            BridgeHelper.log("Determining bridge server port");
            int port = BridgeHelper.getEndpoint(bd.getGroups()).getPort();
            BridgeHelper.log("Configuring bridge server with port: " + port);
            bd.configure(bridge, port);
            BridgeHelper.log("Configured bridge server: " + BridgeHelper.bridgeServerToString(bridge));
            TheBridgeConfig = bridgeConfig;
        } else {
            if (TheBridgeConfig == null) {
                String s = "Bridge server was already created without BridgeHelper using an unknown, and possibly different, configuration";
                throw new HydraRuntimeException(s);
            }
            if (!TheBridgeConfig.equals(bridgeConfig)) {
                String s = "Bridge server already exists using logical bridge server configuration named " + TheBridgeConfig + ", cannot also use " + bridgeConfig;
                throw new HydraRuntimeException(s);
            }
        }
        return bridge;
    }

    public static synchronized CacheServer startBridgeServer() {
        CacheServer bridge = BridgeHelper.getBridgeServer();
        if (bridge == null) {
            String s = "Bridge server has not been created yet";
            throw new HydraRuntimeException(s);
        }
        if (!bridge.isRunning()) {
            BridgeHelper.log("Starting bridge server: " + BridgeHelper.bridgeServerToString(bridge));
            BridgeVersionHelper.createDiskStore(bridge);
            long startTimeMs = System.currentTimeMillis();
            while (true) {
                try {
                    bridge.start();
                    BridgeHelper.log("Started bridge server: " + BridgeHelper.bridgeServerToString(bridge));
                }
                catch (IOException e) {
                    if (PortHelper.retrySocketBind(e, startTimeMs)) continue;
                    String s = "Problem starting bridge" + BridgeHelper.bridgeServerToString(bridge);
                    throw new HydraRuntimeException(s, e);
                }
                break;
            }
        }
        return bridge;
    }

    public static synchronized CacheServer getBridgeServer() {
        Cache cache = CacheHelper.getCache();
        if (cache == null) {
            return null;
        }
        List bridges = cache.getCacheServers();
        if (bridges == null || bridges.size() == 0) {
            return null;
        }
        if (bridges.size() == 1) {
            return (CacheServer)bridges.iterator().next();
        }
        throw new UnsupportedOperationException("Multiple bridge servers");
    }

    public static synchronized void stopBridgeServer() {
        CacheServer bridge = BridgeHelper.getBridgeServer();
        if (bridge != null && bridge.isRunning()) {
            BridgeHelper.log("Stopping bridge server: " + BridgeHelper.bridgeServerToString(bridge));
            bridge.stop();
            BridgeHelper.log("Stopped bridge server: " + BridgeHelper.bridgeServerToString(bridge));
        }
    }

    public static String bridgeServerToString(CacheServer bridge) {
        return BridgeDescription.bridgeServerToString(bridge);
    }

    public static BridgeDescription getBridgeDescription(String bridgeConfig) {
        if (bridgeConfig == null) {
            throw new IllegalArgumentException("bridgeConfig cannot be null");
        }
        BridgeHelper.log("Looking up bridge server config: " + bridgeConfig);
        BridgeDescription bd = TestConfig.getInstance().getBridgeDescription(bridgeConfig);
        if (bd == null) {
            String s = bridgeConfig + " not found in " + BasePrms.nameForKey(BridgePrms.names);
            throw new HydraRuntimeException(s);
        }
        BridgeHelper.log("Looked up bridge server config:\n" + bd);
        return bd;
    }

    public static synchronized List<Endpoint> getEndpoints() {
        return new ArrayList<Endpoint>(BridgeBlackboard.getInstance().getSharedMap().getMap().values());
    }

    public static synchronized List getEndpoints(String distributedSystemName) {
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        for (Endpoint endpoint : BridgeHelper.getEndpoints()) {
            if (!endpoint.getDistributedSystemName().equals(distributedSystemName)) continue;
            endpoints.add(endpoint);
        }
        return endpoints;
    }

    public static synchronized List getEndpointsInGroup(String distributedSystemName, String group) {
        if (group == null) {
            String s = "Group cannot be null";
            throw new IllegalArgumentException(s);
        }
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        for (Endpoint endpoint : BridgeHelper.getEndpoints()) {
            if (!endpoint.getDistributedSystemName().equals(distributedSystemName) || !endpoint.getGroups().contains(group)) continue;
            endpoints.add(endpoint);
        }
        return endpoints;
    }

    public static synchronized List getRemoteEndpoints() {
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        int myVmid = RemoteTestModule.getMyVmid();
        for (Endpoint endpoint : BridgeHelper.getEndpoints()) {
            if (endpoint.getVmid() == myVmid) continue;
            endpoints.add(endpoint);
        }
        return endpoints;
    }

    public static synchronized List getRemoteEndpoints(String distributedSystem) {
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        int myVmid = RemoteTestModule.getMyVmid();
        for (Endpoint endpoint : BridgeHelper.getEndpoints()) {
            if (endpoint.getVmid() == myVmid || !endpoint.getDistributedSystemName().equals(distributedSystem)) continue;
            endpoints.add(endpoint);
        }
        return endpoints;
    }

    protected static synchronized Endpoint getEndpoint(String[] groups) {
        int vmid = RemoteTestModule.getMyVmid();
        Endpoint endpoint = (Endpoint)BridgeBlackboard.getInstance().getSharedMap().get(vmid);
        if (endpoint == null) {
            int port = PortHelper.getRandomPort();
            endpoint = BridgeHelper.generateEndpoint(vmid, port, groups);
        }
        return endpoint;
    }

    protected static synchronized Endpoint getEndpoint(int port, String[] groups) {
        int vmid = RemoteTestModule.getMyVmid();
        Endpoint endpoint = (Endpoint)BridgeBlackboard.getInstance().getSharedMap().get(vmid);
        if (endpoint == null) {
            endpoint = BridgeHelper.generateEndpoint(vmid, port, groups);
        }
        return endpoint;
    }

    private static synchronized Endpoint generateEndpoint(int vmid, int port, String[] groups) {
        String name = RemoteTestModule.getMyClientName();
        String host = HostHelper.getLocalHost();
        String addr = HostHelper.getHostAddress();
        String ds = DistributedSystemHelper.getDistributedSystemName();
        Endpoint endpoint = new Endpoint(name, vmid, host, addr, port, ds, Arrays.asList(groups));
        BridgeBlackboard.getInstance().getSharedMap().put(vmid, endpoint);
        BridgeHelper.log("Generated bridge server endpoint: " + endpoint + " in ds: " + ds + " with groups: " + endpoint.getGroups());
        return endpoint;
    }

    private static synchronized void log(String s) {
        if (log == null) {
            log = Log.getLogWriter();
        }
        if (log.infoEnabled()) {
            log.info(s);
        }
    }

    public static class Endpoint
    implements Contact,
    Serializable {
        String id;
        String name;
        String host;
        String addr;
        String ds;
        int vmid;
        int port;
        List<String> groups;

        public Endpoint(String name, int vmid, String host, String addr, int port, String ds, List<String> groups) {
            if (name == null) {
                throw new IllegalArgumentException("name cannot be null");
            }
            if (host == null) {
                throw new IllegalArgumentException("host cannot be null");
            }
            if (addr == null) {
                throw new IllegalArgumentException("addr cannot be null");
            }
            if (ds == null) {
                throw new IllegalArgumentException("ds cannot be null");
            }
            this.name = name;
            this.vmid = vmid;
            this.host = host;
            this.addr = addr;
            this.port = port;
            this.ds = ds;
            this.groups = groups;
            this.id = "vm_" + this.vmid + "_" + this.name + "_" + this.host;
        }

        public String getId() {
            return this.id;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public int getVmid() {
            return this.vmid;
        }

        @Override
        public String getHost() {
            return this.host;
        }

        @Override
        public String getAddress() {
            return this.addr;
        }

        @Override
        public int getPort() {
            return this.port;
        }

        public String getDistributedSystemName() {
            return this.ds;
        }

        public List<String> getGroups() {
            return this.groups;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Endpoint) {
                Endpoint endpoint = (Endpoint)obj;
                return endpoint.getName().equals(this.getName()) && endpoint.getVmid() == this.getVmid() && endpoint.getHost().equals(this.getHost()) && endpoint.getAddress().equals(this.getAddress()) && endpoint.getPort() == this.getPort() && endpoint.getDistributedSystemName() == this.getDistributedSystemName();
            }
            return false;
        }

        public int hashCode() {
            return this.port;
        }

        public String toString() {
            return this.id + "=" + this.addr + ":" + this.port;
        }
    }
}

