/*
 * Decompiled with CFR 0.152.
 */
package hct.multiDS;

import com.gemstone.gemfire.cache.Region;
import hct.multiDS.MultiDSPrms;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.ConfigPrms;
import hydra.Log;
import hydra.RegionHelper;
import java.util.Set;
import util.TestException;

public class MultiDSClient {
    public static void openCacheTask() {
        CacheHelper.createCache(ConfigPrms.getCacheConfig());
        String bridgeConfig = ConfigPrms.getBridgeConfig();
        if (bridgeConfig != null) {
            BridgeHelper.startBridgeServer(bridgeConfig);
        }
    }

    public static void createRegionTask() {
        String regionConfig = ConfigPrms.getRegionConfig();
        String regionName = MultiDSPrms.getRegionName();
        RegionHelper.createRegion(regionName, regionConfig);
    }

    public static void closeCacheTask() {
        CacheHelper.closeCache();
    }

    public static void putDataTask() {
        String regionName = MultiDSPrms.getRegionName();
        int numKeys = MultiDSPrms.getNumKeys();
        Region region = RegionHelper.getRegion(regionName);
        Log.getLogWriter().info("Putting " + numKeys + " keys into region " + regionName + ":\n" + RegionHelper.regionAttributesToString(region.getAttributes()));
        for (int i = 0; i < numKeys; ++i) {
            String key = regionName + i;
            region.put((Object)key, (Object)new Integer(i));
            if (!Log.getLogWriter().fineEnabled()) continue;
            Log.getLogWriter().fine("Put " + key + "=" + i);
        }
    }

    public static void validateDataTask() {
        String regionName = MultiDSPrms.getRegionName();
        int numKeys = MultiDSPrms.getNumKeys();
        Region region = RegionHelper.getRegion(regionName);
        Log.getLogWriter().info("Validating " + numKeys + " entries in region " + regionName + ":\n" + RegionHelper.regionAttributesToString(region.getAttributes()));
        Set keys = region.keys();
        if (keys.size() != numKeys) {
            String s = "Expected " + numKeys + " but found " + keys.size();
            throw new TestException(s);
        }
        for (int i = 0; i < numKeys; ++i) {
            String key = regionName + i;
            Integer val = (Integer)region.get((Object)key);
            if (val == null) {
                String s = "Missing entry at key=" + key;
                throw new TestException(s);
            }
            if (val != i) {
                String s = "Wrong entry at key=" + key + " value=" + val;
                throw new TestException(s);
            }
            if (!Log.getLogWriter().fineEnabled()) continue;
            Log.getLogWriter().fine("Validated " + key + "=" + i);
        }
    }
}

