/*
 * Decompiled with CFR 0.152.
 */
package hct.ha;

import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.distributed.DistributedSystem;
import hct.ha.HAClientQueue;
import hct.ha.HAClientQueueBB;
import hct.ha.Validator;
import hydra.DistributedSystemHelper;
import hydra.Log;
import hydra.blackboard.SharedMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import util.TestException;
import util.TestHelper;

public class HAFailoverClientListener
extends CacheListenerAdapter {
    private static final Map latestValues = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCreate(EntryEvent event) {
        Map map = latestValues;
        synchronized (map) {
            Long value;
            ++Validator.createCount;
            String key = (String)event.getKey();
            if (key.equals("last_key")) {
                HAClientQueue.lastKeyReceived = true;
                Log.getLogWriter().info("'last_key' received at client");
            }
            if ((value = (Long)event.getNewValue()) == null) {
                HAFailoverClientListener.throwException("value in afterCreate cannot be null: key = " + key);
                return;
            }
            if (value != 0L) {
                this.validateNewValue(key, value);
            }
            latestValues.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterUpdate(EntryEvent event) {
        Map map = latestValues;
        synchronized (map) {
            ++Validator.updateCount;
            String key = (String)event.getKey();
            Long newValue = (Long)event.getNewValue();
            Long oldValue = (Long)event.getOldValue();
            if (newValue == null) {
                HAFailoverClientListener.throwException("newValue in afterUpdate cannot be null: key = " + key);
                return;
            }
            if (oldValue == null) {
                this.validateNewValue(key, newValue);
            } else {
                long diff = newValue - oldValue;
                if (diff != 1L) {
                    HAFailoverClientListener.throwException("difference expected in newValue and oldValue is less than  1, but was not for key = " + key + " & newVal = " + newValue + " oldValue = " + oldValue);
                    return;
                }
            }
            latestValues.put(key, newValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterInvalidate(EntryEvent event) {
        Map map = latestValues;
        synchronized (map) {
            ++Validator.invalidateCount;
            String key = (String)event.getKey();
            Long oldValue = (Long)event.getOldValue();
            if (oldValue != null) {
                latestValues.put(key, oldValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterDestroy(EntryEvent event) {
        Map map = latestValues;
        synchronized (map) {
            ++Validator.destroyCount;
            String key = (String)event.getKey();
            Long value = (Long)event.getOldValue();
            if (value != null) {
                latestValues.put(key, value);
            }
        }
    }

    private void validateNewValue(String key, Long newValue) {
        Long oldValue = (Long)latestValues.get(key);
        if (oldValue == null) {
            HAFailoverClientListener.throwException("oldValue in latestValues cannot be null: key = " + key + " & newVal = " + newValue);
            return;
        }
        long diff = newValue - oldValue;
        if (diff > 1L) {
            HAFailoverClientListener.throwException("difference expected in newValue and oldValue to be less than 1, but is was " + diff + " for key = " + key + " & newVal = " + newValue);
            return;
        }
    }

    public static void throwException(String reason) {
        ArrayList reasonArray = null;
        DistributedSystem ds = DistributedSystemHelper.getDistributedSystem();
        String clientName = "CLIENT_" + ds.getName();
        SharedMap shMap = HAClientQueueBB.getBB().getSharedMap();
        reasonArray = !shMap.containsKey(clientName) ? new ArrayList() : (ArrayList)shMap.get(clientName);
        reasonArray.add(reason);
        shMap.put(clientName, reasonArray);
        long counter = HAClientQueueBB.getBB().getSharedCounters().incrementAndRead(HAClientQueueBB.NUM_EXCEPTION);
        Log.getLogWriter().info("Exception : " + counter + "\n" + TestHelper.getStackTrace(new TestException(reason)));
    }
}

