/*
 * Decompiled with CFR 0.152.
 */
package hct.ha;

import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import hct.ha.Feeder;
import hct.ha.HAClientQueue;
import hct.ha.HAClientQueueBB;
import hydra.Log;
import java.util.HashMap;
import java.util.Map;

public class HAClientInvalidatesListener
extends CacheListenerAdapter {
    private final Map latestValues = new HashMap();
    private final Map latestKeyForAThread = new HashMap();

    public void afterInvalidate(EntryEvent event) {
        String key = (String)event.getKey();
        if (key.equals("last_key")) {
            HAClientQueue.lastKeyReceived = true;
            Log.getLogWriter().info("'last_key' received at client");
        }
        this.validateKeySequenceForAThread((String)event.getKey());
    }

    boolean validateKeySequenceForAThread(String key) {
        try {
            if (!"last_key".equals(key)) {
                String threadID = key.substring(key.indexOf("_") + 1, key.lastIndexOf("_"));
                Long sequenceID = Long.valueOf(key.substring(key.lastIndexOf("_") + 1));
                if (sequenceID != 0L ? !this.validateIncrementByOne(threadID, sequenceID, this.latestKeyForAThread) : this.latestKeyForAThread.containsKey(threadID) && !this.validateIncrementByOne(threadID, new Long(Feeder.PUT_KEY_RANGE), this.latestKeyForAThread)) {
                    return false;
                }
                this.latestKeyForAThread.put(threadID, sequenceID);
            }
        }
        catch (IndexOutOfBoundsException ioobe) {
            HAClientInvalidatesListener.throwException("IndexOutOfBoundsException while decoding the key: " + key + " to get threadID or sequenceID");
            return false;
        }
        catch (NumberFormatException nfe) {
            HAClientInvalidatesListener.throwException("NumberFormatException while decoding the key: " + key + " to get threadID or sequenceID");
            return false;
        }
        return true;
    }

    private boolean validateIncrementByOne(String key, Long newValue, Map map) {
        Long oldValue = (Long)map.get(key);
        if (oldValue == null) {
            HAClientInvalidatesListener.throwException("oldValue in map cannot be null: key = " + key + " & newVal = " + newValue);
            return false;
        }
        long diff = newValue - oldValue;
        if (diff != 1L) {
            HAClientInvalidatesListener.throwException("difference expected in newValue and oldValue is 1, but was " + diff + " for key = " + key + " & newVal = " + newValue);
            return false;
        }
        return true;
    }

    public static void throwException(String reason) {
        long exceptionNumber = HAClientQueueBB.getBB().getSharedCounters().incrementAndRead(HAClientQueueBB.NUM_EXCEPTION);
        HAClientQueueBB.getBB().getSharedMap().put(new Long(exceptionNumber), reason);
    }
}

