/*
 * Decompiled with CFR 0.152.
 */
package hct.backwardCompatibility;

import com.gemstone.gemfire.cache.ConflictException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.TransactionDataNodeHasDepartedException;
import com.gemstone.gemfire.cache.TransactionDataRebalancedException;
import com.gemstone.gemfire.cache.TransactionException;
import com.gemstone.gemfire.cache.TransactionInDoubtException;
import hct.backwardCompatibility.BackwardCompatibilityPrms;
import hct.backwardCompatibility.BackwardCompatibilityTest;
import hydra.Log;
import hydra.TestConfig;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;
import util.TxHelper;

public class BackwardCompatibilityVersionHelper {
    protected void doEntryOperations(BackwardCompatibilityTest testInstance, Region aRegion) {
        Log.getLogWriter().info("In doEntryOperations with " + aRegion.getFullPath());
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec, Long.MAX_VALUE);
        Long minTaskGranularityMS = minTaskGranularitySec == Long.MAX_VALUE ? Long.valueOf(Long.MAX_VALUE) : Long.valueOf(minTaskGranularitySec * 1000L);
        int numOpsPerTask = BackwardCompatibilityPrms.numOpsPerTask();
        boolean useTransactions = BackwardCompatibilityPrms.useTransactions();
        Log.getLogWriter().info("minTaskGranularitySec " + minTaskGranularitySec + ", minTaskGranularityMS " + minTaskGranularityMS + ", numOpsPerTask " + numOpsPerTask + ", useTransactions " + useTransactions);
        long startTime = System.currentTimeMillis();
        int numOps = 0;
        boolean rolledback = false;
        if (useTransactions) {
            TxHelper.begin();
        }
        do {
            try {
                testInstance.doRandomOp(aRegion);
            }
            catch (TransactionDataNodeHasDepartedException e) {
                if (!useTransactions) {
                    throw new TestException("Unexpected TransactionDataNodeHasDepartedException " + TestHelper.getStackTrace(e));
                }
                Log.getLogWriter().info("Caught TransactionDataNodeHasDepartedException.  Expected with concurrent execution, continuing test.");
                Log.getLogWriter().info("Rolling back transaction.");
                try {
                    rolledback = true;
                    TxHelper.rollback();
                    Log.getLogWriter().info("Done Rolling back Transaction");
                }
                catch (TransactionException te) {
                    Log.getLogWriter().info("Caught exception " + (Object)((Object)te) + " on rollback() after catching TransactionDataNodeHasDeparted during tx ops.  Expected, continuing test.");
                }
            }
            catch (TransactionDataRebalancedException e) {
                if (!useTransactions) {
                    throw new TestException("Unexpected Exception " + (Object)((Object)e) + ". " + TestHelper.getStackTrace(e));
                }
                Log.getLogWriter().info("Caught Exception " + (Object)((Object)e) + ".  Expected with concurrent execution, continuing test.");
                Log.getLogWriter().info("Rolling back transaction.");
                rolledback = true;
                TxHelper.rollback();
                Log.getLogWriter().info("Done Rolling back Transaction");
            }
            Log.getLogWriter().info("Completed op " + ++numOps + " for this task");
        } while (System.currentTimeMillis() - startTime < minTaskGranularityMS && numOps < numOpsPerTask);
        if (useTransactions && !rolledback) {
            int n = 0;
            int commitPercentage = BackwardCompatibilityPrms.getCommitPercentage();
            n = TestConfig.tab().getRandGen().nextInt(1, 100);
            if (n <= commitPercentage) {
                try {
                    TxHelper.commit();
                }
                catch (TransactionDataNodeHasDepartedException e) {
                    Log.getLogWriter().info("Caught TransactionDataNodeHasDepartedException.  Expected with concurrent execution, continuing test.");
                }
                catch (TransactionInDoubtException e) {
                    Log.getLogWriter().info("Caught TransactionInDoubtException.  Expected with concurrent execution, continuing test.");
                }
                catch (ConflictException e) {
                    Log.getLogWriter().info("ConflictException " + (Object)((Object)e) + " expected, continuing test");
                }
            } else {
                TxHelper.rollback();
            }
        }
        Log.getLogWriter().info("Done in doEntryOperations with " + aRegion.getFullPath());
    }
}

