/*
 * Decompiled with CFR 0.152.
 */
package event;

import com.gemstone.gemfire.cache.Region;
import event.EventBB;
import event.WBCLEventBB;
import event.WBCLEventTest;
import hydra.Log;
import hydra.blackboard.SharedCounters;
import util.TestHelper;

public class SerialWBCLEventTest
extends WBCLEventTest {
    public static synchronized void HydraTask_initialize() {
        if (eventTest == null) {
            eventTest = new SerialWBCLEventTest();
            ((SerialWBCLEventTest)eventTest).initialize();
        }
    }

    public static synchronized void HydraTask_endTask() {
        eventTest = new SerialWBCLEventTest();
        ((SerialWBCLEventTest)eventTest).initialize();
        ((SerialWBCLEventTest)eventTest).checkEventCounters();
    }

    @Override
    protected void addObject(Region aRegion, boolean aBoolean) {
        super.addObject(aRegion, aBoolean);
        if (!this.useTransactions) {
            this.checkEventCounters();
        }
    }

    @Override
    protected void invalidateObject(Region aRegion, boolean isLocalInvalidate) {
        super.invalidateObject(aRegion, isLocalInvalidate);
        if (!this.useTransactions) {
            this.checkEventCounters();
        }
    }

    @Override
    protected void destroyObject(Region aRegion, boolean isLocalDestroy) {
        super.destroyObject(aRegion, isLocalDestroy);
        if (!this.useTransactions) {
            this.checkEventCounters();
        }
    }

    @Override
    protected void updateObject(Region aRegion) {
        super.updateObject(aRegion);
        if (!this.useTransactions) {
            this.checkEventCounters();
        }
    }

    @Override
    protected void putIfAbsent(Region aRegion, boolean aBoolean) {
        super.putIfAbsent(aRegion, aBoolean);
        if (!this.useTransactions) {
            this.checkEventCounters();
        }
    }

    @Override
    protected void replace(Region aRegion) {
        super.replace(aRegion);
        if (!this.useTransactions) {
            this.checkEventCounters();
        }
    }

    @Override
    protected void remove(Region aRegion) {
        super.remove(aRegion);
        if (!this.useTransactions) {
            this.checkEventCounters();
        }
    }

    @Override
    protected void checkEventCounters() {
        SharedCounters sc = EventBB.getBB().getSharedCounters();
        long numCreates = sc.read(EventBB.NUM_CREATE);
        long numUpdates = sc.read(EventBB.NUM_UPDATE);
        long numInvalidates = sc.read(EventBB.NUM_INVALIDATE);
        long numDestroys = sc.read(EventBB.NUM_DESTROY);
        TestHelper.waitForCounter(WBCLEventBB.getBB(), "NUM_CREATES", WBCLEventBB.NUM_CREATES, numCreates, true, 30000L, 3000L);
        Log.getLogWriter().info("Successful validation of " + numCreates + " create operations");
        TestHelper.waitForCounter(WBCLEventBB.getBB(), "NUM_UPDATES", WBCLEventBB.NUM_UPDATES, numUpdates, true, 30000L, 3000L);
        Log.getLogWriter().info("Successful validation of " + numUpdates + " update operations");
        TestHelper.waitForCounter(WBCLEventBB.getBB(), "NUM_DESTROYS", WBCLEventBB.NUM_DESTROYS, numDestroys, true, 30000L, 3000L);
        Log.getLogWriter().info("Successful validation of " + numDestroys + " destroy operations");
    }
}

