/*
 * Decompiled with CFR 0.152.
 */
package event;

import com.gemstone.gemfire.cache.AttributesMutator;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import event.EventPrms;
import event.EventTest;
import event.ListenerBB;
import event.ListenerPrms;
import event.MultiListener;
import hydra.Log;
import hydra.TestConfig;
import util.NameFactory;
import util.TestException;

public class ListenerTest
extends EventTest {
    protected static final int ADD_LISTENER = 1;
    protected static final int REMOVE_LISTENER = 2;
    protected static final int INIT_LISTENERS = 3;
    protected static final int SET_LISTENER = 4;

    public static synchronized void HydraTask_initialize() {
        if (eventTest == null) {
            eventTest = new ListenerTest();
            eventTest.initialize();
        }
    }

    @Override
    protected int getNumVMsWithListeners() {
        return 1;
    }

    public static synchronized void HydraTask_exerciseListeners() {
        ((ListenerTest)eventTest).exerciseListeners();
    }

    protected void exerciseListeners() {
        long startTime = System.currentTimeMillis();
        if (this.isSerialExecution) {
            ListenerTest.logExecutionNumber();
        }
        do {
            Region aRegion;
            if ((aRegion = this.getRandomRegion(true)) == null) {
                Log.getLogWriter().info("no regions available, returning");
                return;
            }
            Log.getLogWriter().info("Invoked exerciseListeners for region " + aRegion.getName());
            int listenerOp = this.getListenerOp();
            switch (listenerOp) {
                case 1: {
                    this.addListener(aRegion);
                    break;
                }
                case 2: {
                    this.removeListener(aRegion);
                    break;
                }
                case 3: {
                    this.initListener(aRegion);
                    break;
                }
                case 4: {
                    this.setListener(aRegion);
                    break;
                }
                default: {
                    throw new TestException("Unknown Listener Operation " + listenerOp);
                }
            }
            if (this.isCarefulValidation) {
                this.writeExpectedListenerListToBB(aRegion);
                this.clearInvokedListenerList(aRegion.getName());
            }
            this.doOperation(aRegion);
            if (!this.isCarefulValidation) continue;
            this.compareListenerLists(aRegion.getName());
        } while (System.currentTimeMillis() - startTime < this.minTaskGranularityMS);
    }

    protected void doOperation(Region aRegion) {
        int randInt = TestConfig.tab().getRandGen().nextInt(1, 100);
        if (randInt < 90) {
            this.doEntryOperation(aRegion);
        } else {
            this.doRegionOperation(aRegion);
        }
    }

    protected void doEntryOperation(Region aRegion) {
        int whichOp = this.getOperation(EventPrms.entryOperations, this.isMirrored);
        switch (whichOp) {
            case 1: {
                this.addObject(aRegion, true);
                break;
            }
            case 3: {
                this.invalidateObject(aRegion, false);
                break;
            }
            case 4: {
                this.destroyObject(aRegion, false);
                break;
            }
            case 2: {
                this.updateObject(aRegion);
                break;
            }
            case 5: {
                this.readObject(aRegion);
                break;
            }
            case 6: {
                this.invalidateObject(aRegion, true);
                break;
            }
            case 7: {
                this.destroyObject(aRegion, true);
                break;
            }
            default: {
                throw new TestException("Unknown operation " + whichOp);
            }
        }
    }

    protected void doRegionOperation(Region aRegion) {
        long numRegions = this.getNumNonRootRegions();
        int whichOp = this.getOperation(EventPrms.regionOperations, false);
        if (numRegions == 0L) {
            whichOp = 1;
        } else if (numRegions >= (long)this.maxRegions) {
            whichOp = 4;
        }
        if (aRegion.getParentRegion() == null) {
            whichOp = 1;
        }
        switch (whichOp) {
            case 1: {
                this.addRegion(aRegion);
                break;
            }
            case 4: {
                this.destroyRegion(false, aRegion);
                break;
            }
            case 3: {
                this.invalidateRegion(false, aRegion);
                break;
            }
            case 7: {
                this.destroyRegion(true, aRegion);
                break;
            }
            case 6: {
                this.invalidateRegion(true, aRegion);
                break;
            }
            case 8: {
                this.closeRegion(aRegion);
                break;
            }
            case 9: {
                this.clearRegion(aRegion);
                break;
            }
            default: {
                throw new TestException("Unknown operation " + whichOp);
            }
        }
    }

    protected int getListenerOp() {
        int op = 0;
        String operation = TestConfig.tab().stringAt(ListenerPrms.listenerOperations);
        if (operation.equals("add")) {
            op = 1;
        } else if (operation.equals("remove")) {
            op = 2;
        } else if (operation.equals("init")) {
            op = 3;
        } else if (operation.equals("set")) {
            op = 4;
        } else {
            throw new TestException("Unknown listenerOperation " + operation);
        }
        return op;
    }

    protected CacheListener getNewListener() {
        MultiListener newListener = new MultiListener(NameFactory.getNextListenerName());
        Log.getLogWriter().info("getNewListener() returns listener " + newListener.getName());
        return newListener;
    }

    protected void addListener(Region aRegion) {
        AttributesMutator mutator = aRegion.getAttributesMutator();
        CacheListener newListener = this.getNewListener();
        Log.getLogWriter().info("adding listener " + ((MultiListener)newListener).getName() + " to existing list of " + this.getCacheListenerNames(aRegion));
        mutator.addCacheListener(newListener);
        Log.getLogWriter().info("After adding listener " + ((MultiListener)newListener).getName() + " new list = " + this.getCacheListenerNames(aRegion));
    }

    protected void removeListener(Region aRegion) {
        RegionAttributes ratts = aRegion.getAttributes();
        CacheListener[] assignedListeners = ratts.getCacheListeners();
        if (assignedListeners.length == 0) {
            Log.getLogWriter().info("removeListeners invoked, but no assigned listeners to remove.  Returning.");
            return;
        }
        int randInt = TestConfig.tab().getRandGen().nextInt(0, assignedListeners.length - 1);
        Log.getLogWriter().info("Removing listener " + ((MultiListener)assignedListeners[randInt]).getName() + " from list of assignedCacheListeners " + this.getCacheListenerNames(aRegion));
        AttributesMutator mutator = aRegion.getAttributesMutator();
        mutator.removeCacheListener(assignedListeners[randInt]);
        Log.getLogWriter().info("After removing listener " + ((MultiListener)assignedListeners[randInt]).getName() + " listener list = " + this.getCacheListenerNames(aRegion));
    }

    protected void initListener(Region aRegion) {
        int maxListeners = TestConfig.tab().intAt(ListenerPrms.maxListeners, 10);
        StringBuffer aStr = new StringBuffer();
        int randInt = TestConfig.tab().getRandGen().nextInt(3, maxListeners - 1);
        CacheListener[] newListenerList = new CacheListener[randInt];
        for (int i = 0; i < randInt; ++i) {
            newListenerList[i] = this.getNewListener();
            aStr.append(((MultiListener)newListenerList[i]).getName() + ":");
        }
        Log.getLogWriter().info("Initializing cacheListeners with " + aStr);
        aRegion.getAttributesMutator().initCacheListeners(newListenerList);
        Log.getLogWriter().info("After initCacheListeners, list = " + this.getCacheListenerNames(aRegion));
    }

    protected void setListener(Region aRegion) {
        AttributesMutator mutator = aRegion.getAttributesMutator();
        Log.getLogWriter().info("Clearing existing listenerList of " + this.getCacheListenerNames(aRegion));
        mutator.initCacheListeners(null);
        Log.getLogWriter().info("After init (with null array) list = " + this.getCacheListenerNames(aRegion));
        CacheListener newListener = this.getNewListener();
        Log.getLogWriter().info("setListener calling setCacheListener with " + ((MultiListener)newListener).getName());
        mutator.setCacheListener(newListener);
        Log.getLogWriter().info("After setCacheListener cacheListenerList = " + this.getCacheListenerNames(aRegion));
    }

    protected void writeExpectedListenerListToBB(Region aRegion) {
        String expected = this.getCacheListenerNames(aRegion);
        String clientName = System.getProperty("clientName");
        String key = ListenerBB.ExpectedListeners + clientName + "_" + aRegion.getName();
        ListenerBB.getBB().getSharedMap().put(key, expected);
    }

    protected void compareListenerLists(String regionName) {
        String clientName = System.getProperty("clientName");
        String key = ListenerBB.ExpectedListeners + clientName + "_" + regionName;
        String expected = (String)ListenerBB.getBB().getSharedMap().get(key);
        Log.getLogWriter().info("Expected listener list (" + key + ") = " + expected);
        key = ListenerBB.InvokedListeners + clientName + "_" + regionName;
        String invoked = (String)ListenerBB.getBB().getSharedMap().get(key);
        Log.getLogWriter().info("Invoked listener list (" + key + ") = " + invoked);
        if (invoked.equals("")) {
            return;
        }
        if (!expected.equals(invoked)) {
            StringBuffer aStr = new StringBuffer();
            aStr.append("Listeners may not have been invoked in order expected.\n");
            aStr.append("ExpectedList = " + expected + "\n");
            aStr.append("InvokedList = " + invoked + "\n");
            throw new TestException(aStr.toString());
        }
    }

    protected String getCacheListenerNames(Region aRegion) {
        StringBuffer aStr = new StringBuffer();
        CacheListener[] list = aRegion.getAttributes().getCacheListeners();
        for (int i = 0; i < list.length; ++i) {
            aStr.append(((MultiListener)list[i]).getName() + ":");
        }
        return aStr.toString();
    }

    protected void clearInvokedListenerList(String regionName) {
        String clientName = System.getProperty("clientName");
        String key = ListenerBB.InvokedListeners + clientName + "_" + regionName;
        ListenerBB.getBB().getSharedMap().put(key, "");
    }
}

