/*
 * Decompiled with CFR 0.152.
 */
package event;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.ConflictException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.MirrorType;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionedRegionStorageException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.cache.RegionRoleException;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.distributed.DistributedLockService;
import com.gemstone.gemfire.distributed.DistributedSystem;
import event.ETListener;
import event.EventBB;
import event.EventPrms;
import event.ListenerTest;
import hydra.ClientPrms;
import hydra.DistributedSystemHelper;
import hydra.GemFirePrms;
import hydra.HydraVector;
import hydra.Log;
import hydra.ProcessMgr;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import util.BaseValueHolder;
import util.CacheBB;
import util.CacheDefPrms;
import util.CacheDefinition;
import util.CacheUtil;
import util.DeclarativeGenerator;
import util.EventCountersBB;
import util.NameBB;
import util.NameFactory;
import util.OperationCountersBB;
import util.RandomValues;
import util.RegionDefinition;
import util.StopStartPrms;
import util.StopStartVMs;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;
import util.TxHelper;
import util.ValueHolder;
import util.WriterCountersBB;

public class EventTest {
    protected static EventTest eventTest;
    protected static final int ADD_OPERATION = 1;
    protected static final int UPDATE_OPERATION = 2;
    protected static final int INVALIDATE_OPERATION = 3;
    protected static final int DESTROY_OPERATION = 4;
    protected static final int READ_OPERATION = 5;
    protected static final int LOCAL_INVALIDATE_OPERATION = 6;
    protected static final int LOCAL_DESTROY_OPERATION = 7;
    protected static final int REGION_CLOSE_OPERATION = 8;
    protected static final int CLEAR_OPERATION = 9;
    protected static final int PUT_IF_ABSENT_OPERATION = 10;
    protected static final int REMOVE_OPERATION = 11;
    protected static final int REPLACE_OPERATION = 12;
    protected static final int PUTALL_OPERATION = 13;
    protected boolean useTransactions;
    protected boolean isSerialExecution;
    public boolean isCarefulValidation = false;
    public boolean listenerInstalled = false;
    public static final int MILLIS_TO_WAIT = 60000;
    protected int numVMs;
    protected long minTaskGranularitySec;
    protected long minTaskGranularityMS;
    protected RandomValues randomValues = null;
    protected boolean useEvictionController;
    protected int maxObjects;
    protected int maxRegions;
    protected DistributedLockService distLockService;
    protected boolean isMirrored;
    protected boolean isListenerTest;
    protected boolean useCounters;
    protected int lowerThreshold;
    protected int upperThreshold;
    public String regionName;
    protected Random rand = new Random();
    protected static final String createCallbackPrefix = "Create event originated in pid ";
    protected static final String updateCallbackPrefix = "Update event originated in pid ";
    protected static final String invalidateCallbackPrefix = "Invalidate event originated in pid ";
    protected static final String destroyCallbackPrefix = "Destroy event originated in pid ";
    protected static final String regionInvalidateCallbackPrefix = "Region invalidate event originated in pid ";
    protected static final String regionDestroyCallbackPrefix = "Region destroy event originated in pid ";
    protected static final String memberIdString = " memberId=";
    protected static final String VmIDStr = "VmId_";
    protected static String LOCK_SERVICE_NAME;
    protected static String LOCK_NAME;
    protected static final String PR_NAME_PREFIX = "ParReg_";

    public static synchronized void HydraTask_initialize() {
        if (eventTest == null) {
            eventTest = new EventTest();
            eventTest.initialize();
        }
    }

    protected void initialize() {
        this.createRootRegions();
        Region aRegion = (Region)CacheUtil.createCache().rootRegions().iterator().next();
        this.useTransactions = EventPrms.useTransactions();
        this.isSerialExecution = EventBB.isSerialExecution();
        this.isCarefulValidation = this.isCarefulValidation || this.isSerialExecution;
        this.numVMs = 0;
        HydraVector gemFireNamesVec = TestConfig.tab().vecAt(GemFirePrms.names);
        HydraVector numVMsVec = TestConfig.tab().vecAt(ClientPrms.vmQuantities);
        if (gemFireNamesVec.size() == numVMsVec.size()) {
            for (int i = 0; i < numVMsVec.size(); ++i) {
                this.numVMs += new Integer((String)numVMsVec.elementAt(i)).intValue();
            }
        } else {
            this.numVMs = new Integer((String)numVMsVec.elementAt(0)) * gemFireNamesVec.size();
        }
        Log.getLogWriter().info("numVMs is " + this.numVMs);
        this.minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        this.minTaskGranularityMS = this.minTaskGranularitySec * 1000L;
        this.maxRegions = TestConfig.tab().intAt(EventPrms.maxRegions, -1);
        this.maxObjects = TestConfig.tab().intAt(EventPrms.maxObjects, -1);
        this.randomValues = new RandomValues();
        this.isListenerTest = this instanceof ListenerTest;
        this.useCounters = !this.isListenerTest;
        String clientName = System.getProperty("clientName");
        EventBB.getBB().getSharedMap().put(EventBB.CURRENT_REGION_NAMES, new ArrayList());
        EventTest.createLockService();
        EventBB.getBB().printSharedCounters();
        EventCountersBB.getBB().printSharedCounters();
        OperationCountersBB.getBB().printSharedCounters();
        WriterCountersBB.getBB().printSharedCounters();
    }

    static synchronized void createLockService() {
        if (EventTest.eventTest.distLockService == null) {
            Log.getLogWriter().info("Creating lock service " + LOCK_SERVICE_NAME);
            EventTest.eventTest.distLockService = DistributedLockService.create((String)LOCK_SERVICE_NAME, (DistributedSystem)DistributedSystemHelper.getDistributedSystem());
            Log.getLogWriter().info("Created lock service " + LOCK_SERVICE_NAME);
        }
    }

    public static void HydraTask_doEntryOperations() {
        Region rootRegion = CacheUtil.getCache().getRegion(EventTest.eventTest.regionName);
        eventTest.doEntryOperations(rootRegion);
    }

    public static void HydraTask_doRegionOperations() {
        eventTest.doRegionOperations();
    }

    public static void HydraTask_addToRegion() {
        eventTest.addToRegion();
    }

    public static void HydraTask_stopStartVMs() {
        int numVMsToStop = TestConfig.tab().intAt(StopStartPrms.numVMsToStop);
        Object[] tmpArr = StopStartVMs.getOtherVMsWithExclude(numVMsToStop, "locator");
        List vmList = (List)tmpArr[0];
        List stopModeList = (List)tmpArr[1];
        StopStartVMs.stopStartVMs(vmList, stopModeList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void doEntryOperations(Region aRegion) {
        startTime = System.currentTimeMillis();
        if (this.isSerialExecution) {
            EventTest.logExecutionNumber();
        }
        haveALock = false;
        isMirrored = false;
        dataPolicy = aRegion.getAttributes().getDataPolicy();
        if (dataPolicy == null) {
            mt = aRegion.getAttributes().getMirrorType();
            isMirrored = mt.isMirrored();
        } else {
            isMirrored = dataPolicy.withReplication();
        }
        if (this.useTransactions) {
            TxHelper.begin();
        }
        this.lowerThreshold = TestConfig.tab().intAt(EventPrms.lowerThreshold, -1);
        this.upperThreshold = TestConfig.tab().intAt(EventPrms.upperThreshold, 0x7FFFFFFF);
        Log.getLogWriter().info("lowerThreshold " + this.lowerThreshold + ", upperThreshold " + this.upperThreshold);
        block18: do {
            TestHelper.checkForEventError(EventBB.getBB());
            useRandomLocks = TestConfig.tab().booleanAt(EventPrms.useRandomLocks);
            if (useRandomLocks) {
                Log.getLogWriter().info("Trying to get distributed lock " + EventTest.LOCK_NAME + "...");
                haveALock = this.distLockService.lock((Object)EventTest.LOCK_NAME, -1L, -1L);
                Log.getLogWriter().info("Returned from trying to get distributed lock " + EventTest.LOCK_NAME + ", lock acquired is " + haveALock);
                if (haveALock) {
                    Log.getLogWriter().info("Obtained distributed lock " + EventTest.LOCK_NAME);
                }
            }
            try {
                whichOp = this.getOperation(EventPrms.entryOperations, isMirrored);
                size = aRegion.size();
                if (size >= this.upperThreshold) {
                    whichOp = this.getOperation(EventPrms.upperThresholdOperations, isMirrored);
                } else if (size <= this.lowerThreshold) {
                    whichOp = this.getOperation(EventPrms.lowerThresholdOperations, isMirrored);
                }
                switch (whichOp) {
                    case 1: {
                        this.addObject(aRegion, true);
                        ** break;
lbl38:
                        // 1 sources

                        continue block18;
                    }
                    case 3: {
                        this.invalidateObject(aRegion, false);
                        ** break;
lbl42:
                        // 1 sources

                        continue block18;
                    }
                    case 4: {
                        this.destroyObject(aRegion, false);
                        ** break;
lbl46:
                        // 1 sources

                        continue block18;
                    }
                    case 2: {
                        this.updateObject(aRegion);
                        ** break;
lbl50:
                        // 1 sources

                        continue block18;
                    }
                    case 5: {
                        this.readObject(aRegion);
                        ** break;
lbl54:
                        // 1 sources

                        continue block18;
                    }
                    case 6: {
                        this.invalidateObject(aRegion, true);
                        ** break;
lbl58:
                        // 1 sources

                        continue block18;
                    }
                    case 7: {
                        this.destroyObject(aRegion, true);
                        ** break;
lbl62:
                        // 1 sources

                        continue block18;
                    }
                    case 10: {
                        this.putIfAbsent(aRegion, true);
                        ** break;
lbl66:
                        // 1 sources

                        continue block18;
                    }
                    case 11: {
                        this.remove(aRegion);
                        ** break;
lbl70:
                        // 1 sources

                        continue block18;
                    }
                    case 12: {
                        this.replace(aRegion);
                        ** break;
lbl74:
                        // 1 sources

                        continue block18;
                    }
                    case 13: {
                        this.updateObjects(aRegion);
                        ** break;
lbl78:
                        // 1 sources

                        continue block18;
                    }
                    default: {
                        throw new TestException("Unknown operation " + whichOp);
                    }
                }
            }
            finally {
                if (haveALock) {
                    haveALock = false;
                    this.distLockService.unlock((Object)EventTest.LOCK_NAME);
                    Log.getLogWriter().info("Released distributed lock " + EventTest.LOCK_NAME);
                }
            }
        } while (System.currentTimeMillis() - startTime < this.minTaskGranularityMS);
        if (this.useTransactions) {
            n = 0;
            commitPercentage = EventPrms.getCommitPercentage();
            if (!this.isSerialExecution) {
                n = TestConfig.tab().getRandGen().nextInt(1, 100);
            }
            if (n <= commitPercentage) {
                try {
                    TxHelper.commit();
                }
                catch (ConflictException e) {
                    if (this.isSerialExecution) {
                        throw new TestException("Unexpected conflict Exception " + TestHelper.getStackTrace(e));
                    }
                    Log.getLogWriter().info("ConflictException " + (Object)e + " expected, continuing test");
                }
            } else {
                TxHelper.rollback();
            }
            if (this.isSerialExecution) {
                this.checkEventCounters();
            }
        }
    }

    protected void addObject(Region aRegion, boolean logAddition) {
        String name = NameFactory.getNextPositiveObjectName();
        Object anObj = this.getObjectToAdd(name);
        String callback = createCallbackPrefix + ProcessMgr.getProcessId() + memberIdString + DistributedSystemHelper.getDistributedSystem().getDistributedMember();
        if (logAddition) {
            Log.getLogWriter().info("addObject: calling put for name " + name + ", object " + TestHelper.toString(anObj) + " callback is " + callback + ", region is " + aRegion.getFullPath());
        }
        try {
            aRegion.put((Object)name, anObj, (Object)callback);
        }
        catch (RegionDestroyedException e) {
            this.handleRegionDestroyedException(aRegion, e);
        }
        catch (RegionRoleException e) {
            throw e;
        }
        catch (PartitionedRegionStorageException e) {
            if (this.isSerialExecution) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            Log.getLogWriter().info("Caught expected exception " + e.getMessage() + ";continuing test");
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        long numPut = EventBB.incrementCounter("EventBB.NUM_CREATE", EventBB.NUM_CREATE);
    }

    protected void putIfAbsent(Region aRegion, boolean logAddition) {
        Iterator it;
        Set aSet;
        String name = null;
        boolean expectSuccess = true;
        int randInt = TestConfig.tab().getRandGen().nextInt(1, 100);
        if (randInt <= 25 && (aSet = aRegion.keySet()).size() > 0 && (it = aSet.iterator()).hasNext()) {
            name = (String)it.next();
            expectSuccess = false;
        }
        if (name == null) {
            name = NameFactory.getNextPositiveObjectName();
        }
        Object anObj = this.getObjectToAdd(name);
        if (logAddition) {
            Log.getLogWriter().info("putIfAbsent: calling putIfAbsent for name " + name + ", object " + TestHelper.toString(anObj) + ", region is " + aRegion.getFullPath() + ".  ExpectSuccess = " + expectSuccess);
        }
        Object prevVal = null;
        try {
            prevVal = aRegion.putIfAbsent((Object)name, anObj);
        }
        catch (RegionDestroyedException e) {
            this.handleRegionDestroyedException(aRegion, e);
        }
        catch (RegionRoleException e) {
            throw e;
        }
        catch (PartitionedRegionStorageException e) {
            if (this.isSerialExecution) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            Log.getLogWriter().info("Caught expected exception " + e.getMessage() + ";continuing test");
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        if (expectSuccess ? this.isCarefulValidation && prevVal != null : this.isCarefulValidation && prevVal == null) {
            throw new TestException(TestHelper.getStackTrace());
        }
        if (prevVal == null) {
            long l = EventBB.incrementCounter("EventBB.NUM_CREATE", EventBB.NUM_CREATE);
        }
    }

    protected void invalidateObject(Region aRegion, boolean isLocalInvalidate) {
        Set aSet = aRegion.keys();
        if (aSet.size() == 0) {
            Log.getLogWriter().info("invalidateObject: No names in region");
            return;
        }
        Iterator it = aSet.iterator();
        Object name = null;
        if (!it.hasNext()) {
            Log.getLogWriter().info("invalidateObject: Unable to get name from region");
            return;
        }
        name = it.next();
        boolean containsValue = aRegion.containsValueForKey(name);
        boolean alreadyInvalidated = !containsValue;
        Log.getLogWriter().info("containsValue for " + name + ": " + containsValue);
        Log.getLogWriter().info("alreadyInvalidated for " + name + ": " + alreadyInvalidated);
        try {
            String callback = invalidateCallbackPrefix + ProcessMgr.getProcessId() + memberIdString + DistributedSystemHelper.getDistributedSystem().getDistributedMember();
            if (isLocalInvalidate) {
                Log.getLogWriter().info("invalidateObject: local invalidate for " + name + " callback is " + callback);
                aRegion.localInvalidate(name, (Object)callback);
                Log.getLogWriter().info("invalidateObject: done with local invalidate for " + name);
                if (!alreadyInvalidated) {
                    long l = EventBB.incrementCounter("EventBB.NUM_LOCAL_INVALIDATE", EventBB.NUM_LOCAL_INVALIDATE);
                }
            } else {
                Log.getLogWriter().info("invalidateObject: invalidating name " + name + " callback is " + callback);
                aRegion.invalidate(name, (Object)callback);
                Log.getLogWriter().info("invalidateObject: done invalidating name " + name);
                if (!alreadyInvalidated) {
                    long l = EventBB.incrementCounter("EventBB.NUM_INVALIDATE", EventBB.NUM_INVALIDATE);
                }
            }
            if (this.isCarefulValidation) {
                this.verifyObjectInvalidated(aRegion, name);
            }
        }
        catch (EntryNotFoundException e) {
            if (this.isCarefulValidation) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
            return;
        }
    }

    protected void destroyObject(Region aRegion, boolean isLocalDestroy) {
        Set aSet = aRegion.keys();
        Iterator iter = aSet.iterator();
        if (!iter.hasNext()) {
            Log.getLogWriter().info("destroyObject: No names in region");
            return;
        }
        try {
            Object name = iter.next();
            this.destroyObject(aRegion, name, isLocalDestroy);
        }
        catch (NoSuchElementException e) {
            throw new TestException("Bug 30171 detected: " + TestHelper.getStackTrace(e));
        }
    }

    private void destroyObject(Region aRegion, Object name, boolean isLocalDestroy) {
        try {
            String callback = destroyCallbackPrefix + ProcessMgr.getProcessId() + memberIdString + DistributedSystemHelper.getDistributedSystem().getDistributedMember();
            if (isLocalDestroy) {
                Log.getLogWriter().info("destroyObject: local destroy for " + name + " callback is " + callback);
                aRegion.localDestroy(name, (Object)callback);
                Log.getLogWriter().info("destroyObject: done with local destroy for " + name);
                long l = EventBB.incrementCounter("EventBB.NUM_LOCAL_DESTROY", EventBB.NUM_LOCAL_DESTROY);
            } else {
                Log.getLogWriter().info("destroyObject: destroying name " + name + " callback is " + callback);
                aRegion.destroy(name, (Object)callback);
                Log.getLogWriter().info("destroyObject: done destroying name " + name);
                long l = EventBB.incrementCounter("EventBB.NUM_DESTROY", EventBB.NUM_DESTROY);
            }
        }
        catch (EntryNotFoundException e) {
            if (this.isCarefulValidation) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
            return;
        }
    }

    protected void remove(Region aRegion) {
        Set aSet = aRegion.keys();
        Iterator iter = aSet.iterator();
        if (!iter.hasNext()) {
            Log.getLogWriter().info("remove: No names in region");
            return;
        }
        try {
            Object name = iter.next();
            Object oldVal = aRegion.get(name);
            if (oldVal == null) {
                if (this.isCarefulValidation) {
                    throw new TestException(TestHelper.getStackTrace());
                }
                Log.getLogWriter().info("remove: oldVal is null, expected with concurrentExecution, continuing test ...");
            }
            this.remove(aRegion, name, oldVal);
        }
        catch (NoSuchElementException e) {
            throw new TestException("Bug 30171 detected: " + TestHelper.getStackTrace(e));
        }
    }

    private void remove(Region aRegion, Object name, Object oldVal) {
        boolean removed;
        boolean expectSuccess = true;
        try {
            Object conditionValue = oldVal;
            BaseValueHolder diffVal = null;
            int randInt = TestConfig.tab().getRandGen().nextInt(1, 100);
            if (oldVal instanceof BaseValueHolder && randInt <= 25) {
                int modVal = 0;
                diffVal = (BaseValueHolder)this.getUpdateObject((String)name);
                if (diffVal.getModVal() != null) {
                    modVal = diffVal.getModVal() + 1;
                }
                diffVal.modVal = new Integer(modVal);
                conditionValue = diffVal;
                expectSuccess = false;
                Log.getLogWriter().info("remove: causing remove condition to fail by overriding " + name + " with previous value " + oldVal + " with " + diffVal + ".  ExpectSuccess = " + expectSuccess);
                if (oldVal.equals(diffVal)) {
                    throw new TestException("Test issue: oldVal " + oldVal + " is expected to be different from " + diffVal + ", but .equals() was true");
                }
            }
            Log.getLogWriter().info("remove: removing " + name + " with conditionValue " + conditionValue + ".  ExpectSuccess = " + expectSuccess);
            removed = aRegion.remove(name, conditionValue);
            Log.getLogWriter().info("remove: done removing " + name + " removed = " + removed);
            if (removed) {
                long l = EventBB.incrementCounter("EventBB.NUM_DESTROY", EventBB.NUM_DESTROY);
            }
        }
        catch (EntryNotFoundException e) {
            if (this.isCarefulValidation) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
            return;
        }
        if (this.isCarefulValidation && (expectSuccess ? !removed : removed)) {
            throw new TestException(TestHelper.getStackTrace());
        }
    }

    protected void updateObject(Region aRegion) {
        Set aSet = aRegion.keys();
        Iterator iter = aSet.iterator();
        if (!iter.hasNext()) {
            Log.getLogWriter().info("updateObject: No names in region");
            return;
        }
        Object name = iter.next();
        this.updateObject(aRegion, name);
    }

    protected void updateObject(Region aRegion, Object name) {
        Object anObj = null;
        try {
            anObj = aRegion.get(name);
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        Object newObj = this.getUpdateObject((String)name);
        try {
            String callback = updateCallbackPrefix + ProcessMgr.getProcessId() + memberIdString + DistributedSystemHelper.getDistributedSystem().getDistributedMember();
            Log.getLogWriter().info("updateObject: replacing name " + name + " with " + TestHelper.toString(newObj) + "; old value is " + TestHelper.toString(anObj) + ", callback is " + callback);
            aRegion.put(name, newObj, (Object)callback);
            Log.getLogWriter().info("Done with call to put (update)");
        }
        catch (RegionRoleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        long numUpdate = EventBB.incrementCounter("EventBB.NUM_UPDATE", EventBB.NUM_UPDATE);
    }

    protected void updateObjects(Region aRegion) {
        long numObjects = TestConfig.tab().longAt(EventPrms.numPutAllObjects, 20L);
        this.updateObjects(aRegion, numObjects);
    }

    protected void updateObjects(Region aRegion, long numObjects) {
        Set aSet = aRegion.keySet();
        long keysToAdd = -1L;
        if (aSet == null || aRegion.isEmpty()) {
            keysToAdd = numObjects;
        } else if ((long)aSet.size() < numObjects) {
            keysToAdd = numObjects - (long)aSet.size();
        }
        int i = 0;
        while ((long)i < keysToAdd) {
            this.addObject(aRegion, true);
            ++i;
        }
        HashMap aMap = new HashMap();
        Iterator iter = aSet.iterator();
        int i2 = 0;
        while ((long)i2 < numObjects) {
            Object key = iter.next();
            aMap.put(key, this.getUpdateObject((String)key));
            ++i2;
        }
        this.updateAllObjects(aRegion, aMap);
    }

    protected void updateAllObjects(Region aRegion, Map aMap) {
        try {
            Log.getLogWriter().info("Calling putAll (updateAll) with an Object map of size: " + aMap.size());
            aRegion.putAll(aMap);
            Log.getLogWriter().info("Done with call to putAll (updateAll) for " + aMap.size() + "objects");
        }
        catch (RegionRoleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        long numUpdate = EventBB.add("EventBB.NUM_UPDATE", EventBB.NUM_UPDATE, aMap.size());
    }

    protected void replace(Region aRegion) {
        Set aSet = aRegion.keys();
        Iterator iter = aSet.iterator();
        if (!iter.hasNext()) {
            Log.getLogWriter().info("replace: No names in region");
            return;
        }
        Object name = iter.next();
        this.replace(aRegion, name);
    }

    protected void replace(Region aRegion, Object name) {
        Object anObj = null;
        Object prevVal = null;
        boolean replaced = false;
        try {
            anObj = aRegion.get(name);
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        if (anObj == null) {
            if (this.isCarefulValidation) {
                throw new TestException(TestHelper.getStackTrace());
            }
            Log.getLogWriter().info("replace: currentValue is null, expected in concurrent tests, continuing ...");
            return;
        }
        Object newObj = this.getUpdateObject((String)name);
        boolean expectSuccess = true;
        try {
            int randInt = TestConfig.tab().getRandGen().nextInt(0, 100);
            if (randInt < 50) {
                if (randInt <= 10) {
                    anObj = this.getUpdateObject((String)name);
                    expectSuccess = false;
                }
                Log.getLogWriter().info("replace: replacing name " + name + " with " + TestHelper.toString(newObj) + "; old value is " + TestHelper.toString(anObj) + ".  ExpectSuccess = " + expectSuccess);
                replaced = aRegion.replace(name, anObj, newObj);
            } else {
                if (randInt <= 10) {
                    name = NameFactory.getNextPositiveObjectName();
                    expectSuccess = false;
                }
                Log.getLogWriter().info("replace: replacing name " + name + " with " + TestHelper.toString(newObj) + ".  ExpectSuccess = " + expectSuccess);
                prevVal = aRegion.replace(name, newObj);
                if (prevVal != null) {
                    replaced = true;
                }
            }
            Log.getLogWriter().info("Done with call to replace");
        }
        catch (RegionRoleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        if (replaced) {
            long l = EventBB.incrementCounter("EventBB.NUM_UPDATE", EventBB.NUM_UPDATE);
        }
    }

    protected void readObject(Region aRegion) {
        Set aSet = aRegion.keys();
        if (aSet.size() == 0) {
            Log.getLogWriter().info("readObject: No names in region");
            return;
        }
        long maxNames = NameFactory.getPositiveNameCounter();
        if (maxNames <= 0L) {
            Log.getLogWriter().info("readObject: max positive name counter is " + maxNames);
            return;
        }
        String name = NameFactory.getObjectNameForCounter(TestConfig.tab().getRandGen().nextInt(1, (int)maxNames));
        Log.getLogWriter().info("readObject: getting name " + name);
        try {
            Object anObj = aRegion.get((Object)name);
            Log.getLogWriter().info("readObject: got value for name " + name + ": " + TestHelper.toString(anObj));
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    protected void doRegionOperations() {
        long startTime = System.currentTimeMillis();
        if (this.isSerialExecution) {
            EventTest.logExecutionNumber();
        }
        TestHelper.checkForEventError(EventBB.getBB());
        if (this.useTransactions) {
            TxHelper.begin();
        }
        do {
            long numRegions = this.getNumNonRootRegions();
            int whichOp = this.getOperation(EventPrms.regionOperations, false);
            if (numRegions == 0L) {
                whichOp = 1;
            } else if (numRegions >= (long)this.maxRegions) {
                whichOp = 4;
            }
            switch (whichOp) {
                case 1: {
                    this.addRegion();
                    break;
                }
                case 4: {
                    this.destroyRegion(false);
                    break;
                }
                case 3: {
                    this.invalidateRegion(false);
                    break;
                }
                case 7: {
                    this.destroyRegion(true);
                    break;
                }
                case 6: {
                    this.invalidateRegion(true);
                    break;
                }
                case 8: {
                    this.closeRegion();
                    break;
                }
                case 9: {
                    this.clearRegion();
                    break;
                }
                default: {
                    throw new TestException("Unknown operation " + whichOp);
                }
            }
        } while (System.currentTimeMillis() - startTime < this.minTaskGranularityMS);
        if (this.useTransactions) {
            int n = 0;
            int commitPercentage = EventPrms.getCommitPercentage();
            if (!this.isSerialExecution) {
                n = TestConfig.tab().getRandGen().nextInt(1, 100);
            }
            if (n <= commitPercentage) {
                try {
                    TxHelper.commit();
                }
                catch (ConflictException e) {
                    if (this.isSerialExecution) {
                        throw new TestException("Unexpected conflict Exception " + TestHelper.getStackTrace(e));
                    }
                    Log.getLogWriter().info("ConflictException " + (Object)((Object)e) + " expected, continuing test");
                }
            } else {
                TxHelper.rollback();
            }
            if (this.isSerialExecution) {
                this.checkEventCounters();
            }
        }
        EventBB.getBB().printSharedCounters();
        NameBB.getBB().printSharedCounters();
    }

    protected void addRegion() {
        this.addRegion(this.getRandomRegion(true));
    }

    protected void addRegion(Region parentRegion) {
        boolean parentIsPartitioned = false;
        Region newRegion = null;
        String regionName = NameFactory.getNextRegionName();
        try {
            RegionAttributes parentAttr = parentRegion.getAttributes();
            AttributesFactory factory = new AttributesFactory(parentAttr);
            factory.initCacheListeners(parentAttr.getCacheListeners());
            parentIsPartitioned = parentAttr.getPartitionAttributes() != null;
            PartitionAttributes prAttr = null;
            if (TestConfig.tab().getRandGen().nextInt(1, 100) <= 30) {
                Object[] tmp = this.getPartitionAttributes();
                if (tmp != null) {
                    DataPolicy dp = (DataPolicy)tmp[0];
                    prAttr = (PartitionAttributes)tmp[1];
                    Log.getLogWriter().info("Setting dataPolicy " + dp + " in factory " + factory + " that has attributes " + factory.create());
                    if (!parentAttr.getDataPolicy().equals(dp)) {
                        factory.setDataPolicy(DataPolicy.DEFAULT);
                        factory.setDataPolicy(dp);
                    }
                }
                factory.setEntryIdleTimeout(new ExpirationAttributes(0));
                factory.setEntryTimeToLive(new ExpirationAttributes(0));
            }
            factory.setPartitionAttributes(prAttr);
            Log.getLogWriter().info("Creating attributes from " + TestHelper.regionAttributesToString(parentAttr) + " and partition attributes " + prAttr);
            RegionAttributes regAttr = factory.createRegionAttributes();
            if (prAttr != null) {
                regionName = PR_NAME_PREFIX + regionName;
            }
            Log.getLogWriter().info("Creating a new subregion of: " + TestHelper.regionToString(parentRegion, false) + " with name " + regionName);
            newRegion = parentRegion.createSubregion(regionName, regAttr);
            Log.getLogWriter().info("Created new region: " + TestHelper.regionToString(newRegion, true));
            if (parentIsPartitioned) {
                throw new TestException("Successfully created a subregion of " + TestHelper.regionToString(parentRegion, true) + ", but subregions of partitioned regions are not supported. Subregion created is " + TestHelper.regionToString(newRegion, true));
            }
            String parentFullPath = parentRegion.getFullPath();
            String subRegionFullPath = newRegion.getFullPath();
            if (subRegionFullPath.indexOf(parentFullPath) < 0) {
                throw new TestException("getFullPath() of new subregion " + subRegionFullPath + " does not include its parent name " + parentFullPath);
            }
        }
        catch (RegionDestroyedException e) {
            this.handleRegionDestroyedException(parentRegion, e);
            return;
        }
        catch (CacheException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (UnsupportedOperationException e) {
            if (parentIsPartitioned) {
                Log.getLogWriter().info("Caught " + e + "; expected exception, continuing test");
                return;
            }
            throw new TestException(TestHelper.getStackTrace(e));
        }
        int initRegionNumObjects = TestConfig.tab().intAt(EventPrms.initRegionNumObjects);
        for (int i = 1; i <= initRegionNumObjects; ++i) {
            this.addObject(newRegion, false);
        }
        Log.getLogWriter().info("Added " + initRegionNumObjects + " to " + TestHelper.regionToString(newRegion, false));
        if (this.isCarefulValidation) {
            EventBB.incrementCounter("EventBB.NUM_REGION_CREATE", EventBB.NUM_REGION_CREATE);
        }
    }

    protected int invalidateRegion(boolean isLocalInvalidate) {
        int numRegions = this.invalidateRegion(isLocalInvalidate, this.getRandomRegion(false));
        return numRegions;
    }

    protected int invalidateRegion(boolean isLocalInvalidate, Region aRegion) {
        if (aRegion == null) {
            Log.getLogWriter().info("invalidateRegion, not causing invalidate event because no regions exist other than roots");
            return 0;
        }
        Log.getLogWriter().info("In invalidateRegion, region is " + TestHelper.regionsToString(aRegion, false));
        String regionName = TestHelper.regionToString(aRegion, false);
        int numRegions = 0;
        try {
            numRegions = aRegion.subregions(true).size() + 1;
        }
        catch (RegionDestroyedException e) {
            if (this.isCarefulValidation) {
                throw new TestException("Unexpected " + TestHelper.getStackTrace(e));
            }
            Log.getLogWriter().info("Not invalidating " + aRegion.getFullPath() + ", got " + (Object)((Object)e) + " while getting number of subregions; continuing test");
        }
        long[] beforeCounter = new long[]{EventCountersBB.getBB().getSharedCounters().read(EventCountersBB.numAfterRegionInvalidateEvents_isNotExp), OperationCountersBB.getBB().getSharedCounters().read(OperationCountersBB.numAfterRegionInvalidateEvents_isNotExp)};
        try {
            long l;
            String callback = regionInvalidateCallbackPrefix + ProcessMgr.getProcessId() + memberIdString + DistributedSystemHelper.getDistributedSystem().getDistributedMember();
            if (isLocalInvalidate) {
                Log.getLogWriter().info("local invalidate for " + regionName + " callback is " + callback);
                aRegion.invalidateRegion((Object)callback);
                Log.getLogWriter().info("Done with local invalidate for " + regionName);
                l = EventBB.add("EventBB.NUM_LOCAL_REGION_INVALIDATE", EventBB.NUM_LOCAL_REGION_INVALIDATE, numRegions);
            } else {
                Log.getLogWriter().info("Invalidating " + regionName + " callback is " + callback);
                aRegion.invalidateRegion((Object)callback);
                Log.getLogWriter().info("Done invalidating " + regionName);
                l = EventBB.add("EventBB.NUM_REGION_INVALIDATE", EventBB.NUM_REGION_INVALIDATE, numRegions);
            }
        }
        catch (RegionDestroyedException e) {
            this.handleRegionDestroyedException(aRegion, e);
            return numRegions;
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        if (this.isCarefulValidation) {
            HashSet<Region> aSet = new HashSet<Region>(aRegion.subregions(true));
            aSet.add(aRegion);
            for (Region thisRegion : aSet) {
                for (Object key : thisRegion.keys()) {
                    this.verifyObjectInvalidated(thisRegion, key);
                }
            }
            if (this.useCounters || this.listenerInstalled) {
                long expectedCounter = beforeCounter[0] + (long)(numRegions * this.getNumVMsWithListeners());
                TestHelper.waitForCounter(EventCountersBB.getBB(), "numAfterRegionInvalidateEvents_isNotExp", EventCountersBB.numAfterRegionInvalidateEvents_isNotExp, expectedCounter, true, 60000L);
                expectedCounter = beforeCounter[1] + (long)(numRegions * this.getNumVMsWithListeners());
                TestHelper.waitForCounter(OperationCountersBB.getBB(), "numAfterRegionInvalidateOperationss_isNotExp", OperationCountersBB.numAfterRegionInvalidateEvents_isNotExp, expectedCounter, true, 60000L);
                this.checkEventCounters();
            }
        }
        return numRegions;
    }

    protected int closeRegion() {
        Region aRegion = this.getRandomRegion(false);
        if (aRegion == null) {
            Log.getLogWriter().info("closeRegion, not causing close event bcause no regions exist other than roots");
            return 0;
        }
        return this.closeRegion(aRegion);
    }

    protected int closeRegion(Region aRegion) {
        String regionName = TestHelper.regionToString(aRegion, false);
        Log.getLogWriter().info("In closeRegion, region is " + regionName);
        long[] beforeCounter = new long[]{EventCountersBB.getBB().getSharedCounters().read(EventCountersBB.numAfterRegionDestroyEvents_isNotExp), OperationCountersBB.getBB().getSharedCounters().read(OperationCountersBB.numAfterRegionDestroyEvents_isNotExp)};
        Set regionSet = null;
        int numRegions = 0;
        if (this.isCarefulValidation) {
            regionSet = aRegion.subregions(true);
            numRegions = regionSet.size() + 1;
            Log.getLogWriter().info("numRegions being closed is " + numRegions + " " + TestHelper.regionsToString(aRegion, false));
        }
        try {
            Log.getLogWriter().info("Closing region " + regionName);
            aRegion.close();
            Log.getLogWriter().info("Done closing " + regionName);
            if (this.isCarefulValidation) {
                EventBB.add("EventBB.NUM_CLOSE", EventBB.NUM_CLOSE, numRegions);
            }
        }
        catch (RegionDestroyedException e) {
            this.handleRegionDestroyedException(aRegion, e);
            return numRegions;
        }
        StringBuffer errStr = new StringBuffer();
        if (this.isCarefulValidation) {
            HashSet<Region> newSet = new HashSet<Region>(regionSet);
            newSet.add(aRegion);
            for (Region thisRegion : regionSet) {
                boolean isDestroyed = thisRegion.isDestroyed();
                if (!isDestroyed) {
                    errStr.append("Unexpected " + thisRegion + ".isDestroyed() returned " + isDestroyed);
                }
                try {
                    Iterator it2 = thisRegion.keys().iterator();
                    errStr.append("Successfully was able to get keys() of destroyed region\n");
                }
                catch (RegionDestroyedException regionDestroyedException) {}
            }
            if (this.useCounters) {
                this.checkEventCounters();
            }
        }
        if (errStr.length() > 0) {
            throw new TestException(errStr.toString());
        }
        return numRegions;
    }

    protected int destroyRegion(boolean isLocalDestroy) {
        Region aRegion = this.getRandomRegion(false);
        if (aRegion == null) {
            Log.getLogWriter().info("destroyRegion, not causing destroy event bcause no regions exist other than roots");
            return 0;
        }
        return this.destroyRegion(isLocalDestroy, aRegion);
    }

    protected int destroyRegion(boolean isLocalDestroy, Region aRegion) {
        String regionName = TestHelper.regionToString(aRegion, false);
        Log.getLogWriter().info("In destroyRegion, region is " + regionName);
        long[] beforeCounter = new long[]{EventCountersBB.getBB().getSharedCounters().read(EventCountersBB.numAfterRegionDestroyEvents_isNotExp), OperationCountersBB.getBB().getSharedCounters().read(OperationCountersBB.numAfterRegionDestroyEvents_isNotExp), WriterCountersBB.getBB().getSharedCounters().read(WriterCountersBB.numBeforeRegionDestroyEvents_isNotExp)};
        Set regionSet = null;
        int numRegions = 0;
        if (this.isCarefulValidation) {
            regionSet = aRegion.subregions(true);
            numRegions = regionSet.size() + 1;
            Log.getLogWriter().info("numRegions being destroyed is " + numRegions + " " + TestHelper.regionsToString(aRegion, false));
        }
        try {
            String callback = regionDestroyCallbackPrefix + ProcessMgr.getProcessId() + memberIdString + DistributedSystemHelper.getDistributedSystem().getDistributedMember();
            if (isLocalDestroy) {
                Log.getLogWriter().info("local destroy for region " + regionName + " callback is " + callback);
                aRegion.localDestroyRegion((Object)callback);
                Log.getLogWriter().info("Done with local destroy for " + regionName);
                if (this.isCarefulValidation) {
                    EventBB.add("EventBB.NUM_LOCAL_REGION_DESTROY", EventBB.NUM_LOCAL_REGION_DESTROY, numRegions);
                    EventBB.add("EventBB.NUM_CLOSE", EventBB.NUM_CLOSE, numRegions);
                }
            } else {
                Log.getLogWriter().info("destroying region " + regionName + " callback is " + callback);
                aRegion.destroyRegion((Object)callback);
                Log.getLogWriter().info("Done destroying " + regionName);
                if (this.isCarefulValidation) {
                    EventBB.add("EventBB.NUM_REGION_DESTROY", EventBB.NUM_REGION_DESTROY, numRegions);
                    EventBB.add("EventBB.NUM_CLOSE", EventBB.NUM_CLOSE, numRegions);
                }
            }
        }
        catch (RegionDestroyedException e) {
            this.handleRegionDestroyedException(aRegion, e);
            return numRegions;
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        StringBuffer errStr = new StringBuffer();
        if (this.isCarefulValidation) {
            HashSet<Region> newSet = new HashSet<Region>(regionSet);
            newSet.add(aRegion);
            for (Region thisRegion : regionSet) {
                boolean isDestroyed = thisRegion.isDestroyed();
                if (!isDestroyed) {
                    errStr.append("Unexpected " + thisRegion + ".isDestroyed() returned " + isDestroyed);
                }
                try {
                    Iterator it2 = thisRegion.keys().iterator();
                    errStr.append("Successfully was able to get keys() of destroyed region\n");
                }
                catch (RegionDestroyedException regionDestroyedException) {}
            }
            if (this.useCounters || this.listenerInstalled) {
                long expectedCounter = beforeCounter[0] + (long)(numRegions * this.getNumVMsWithListeners());
                TestHelper.waitForCounter(EventCountersBB.getBB(), "numAfterRegionDestroyEvents_isNotExp", EventCountersBB.numAfterRegionDestroyEvents_isNotExp, expectedCounter, true, 60000L);
                expectedCounter = beforeCounter[1] + (long)(numRegions * this.getNumVMsWithListeners());
                TestHelper.waitForCounter(OperationCountersBB.getBB(), "numAfterRegionDestroyEvents_isNotExp", OperationCountersBB.numAfterRegionDestroyEvents_isNotExp, expectedCounter, true, 60000L);
                expectedCounter = beforeCounter[2] + (long)numRegions;
                TestHelper.waitForCounter(WriterCountersBB.getBB(), "numBeforeRegionDestroyEvents_isNotExp", WriterCountersBB.numBeforeRegionDestroyEvents_isNotExp, expectedCounter, true, 60000L);
                this.checkEventCounters();
            }
        }
        if (errStr.length() > 0) {
            throw new TestException(errStr.toString());
        }
        return numRegions;
    }

    protected int clearRegion() {
        Region aRegion = this.getRandomRegion(false);
        if (aRegion == null) {
            Log.getLogWriter().info("clearRegion, not causing clear event because no regions exist other than roots");
            return 0;
        }
        int numRegions = this.clearRegion(aRegion);
        return numRegions;
    }

    protected int clearRegion(Region aRegion) {
        String regionName = TestHelper.regionToString(aRegion, false);
        Log.getLogWriter().info("In clearRegion, region is " + regionName);
        long[] beforeCounter = new long[]{EventCountersBB.getBB().getSharedCounters().read(EventCountersBB.numAfterClearEvents_isNotExp), OperationCountersBB.getBB().getSharedCounters().read(OperationCountersBB.numAfterClearEvents_isNotExp), WriterCountersBB.getBB().getSharedCounters().read(WriterCountersBB.numBeforeRegionClearEvents_isNotExp)};
        int numRegions = 0;
        if (this.isCarefulValidation) {
            // empty if block
        }
        try {
            Log.getLogWriter().info("clearing region " + regionName);
            aRegion.clear();
            Log.getLogWriter().info("Done clearing " + regionName);
            long l = EventBB.add("EventBB.NUM_CLEAR", EventBB.NUM_CLEAR, numRegions);
        }
        catch (RegionDestroyedException e) {
            this.handleRegionDestroyedException(aRegion, e);
            return numRegions;
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        if (this.isCarefulValidation) {
            if (!aRegion.isEmpty()) {
                throw new TestException("The region was not found empty after clear");
            }
            if (this.useCounters || this.listenerInstalled) {
                long expectedCounter = beforeCounter[0] + (long)(numRegions * this.getNumVMsWithListeners());
                TestHelper.waitForCounter(EventCountersBB.getBB(), "numAfterClearEvents_isNotExp", EventCountersBB.numAfterClearEvents_isNotExp, expectedCounter, true, 60000L);
                expectedCounter = beforeCounter[1] + (long)(numRegions * this.getNumVMsWithListeners());
                TestHelper.waitForCounter(OperationCountersBB.getBB(), "numAfterClearEvents_isNotExp", OperationCountersBB.numAfterClearEvents_isNotExp, expectedCounter, true, 60000L);
                expectedCounter = beforeCounter[2] + (long)numRegions;
                TestHelper.waitForCounter(WriterCountersBB.getBB(), "numBeforeClearEvents_isNotExp", WriterCountersBB.numBeforeRegionClearEvents_isNotExp, expectedCounter, true, 60000L);
                this.checkEventCounters();
            }
        }
        return numRegions;
    }

    protected void addToRegion() {
        long startTime = System.currentTimeMillis();
        if (this.isSerialExecution) {
            EventTest.logExecutionNumber();
        }
        TestHelper.checkForEventError(EventBB.getBB());
        Log.getLogWriter().info("Faulting in available regions...");
        this.faultInNewRegions();
        Log.getLogWriter().info("Done faulting in available regions.");
        do {
            Region aRegion;
            if ((aRegion = this.getRandomRegion(false)) == null) continue;
            this.addObject(aRegion, true);
        } while (System.currentTimeMillis() - startTime < this.minTaskGranularityMS);
    }

    protected int faultInNewRegions() {
        int numCreated = 0;
        StringBuffer logStr = new StringBuffer();
        long startTime = System.currentTimeMillis();
        Region rootRegion = CacheUtil.getCache().getRegion(this.regionName);
        Log.getLogWriter().info("Before faulting in: " + TestHelper.regionsToString(rootRegion, false));
        RegionAttributes attr = rootRegion.getAttributes();
        List aList = (List)EventBB.getBB().getSharedMap().get(EventBB.CURRENT_REGION_NAMES);
        block0: for (int i = 0; i < aList.size(); ++i) {
            String currRegionName = (String)aList.get(i);
            Region previousRegion = null;
            StringTokenizer st = new StringTokenizer(currRegionName, "/", false);
            while (st.hasMoreTokens()) {
                String singleRegionName = st.nextToken();
                if (singleRegionName.equals(this.regionName)) {
                    previousRegion = rootRegion;
                    continue;
                }
                Object[] tmp = this.faultInRegion(previousRegion, singleRegionName, attr);
                previousRegion = (Region)tmp[0];
                logStr.append(tmp[1]);
                boolean created = (Boolean)tmp[2];
                if (created) {
                    ++numCreated;
                }
                if (previousRegion != null) continue;
                continue block0;
            }
        }
        long endTime = System.currentTimeMillis();
        long duration = endTime - startTime;
        EventBB.getBB().getSharedCounters().setIfLarger(EventBB.MAX_FAULT_IN_REGIONS_MILLIS, duration);
        Log.getLogWriter().info("Done faulting in new regions, " + logStr.toString());
        Log.getLogWriter().info("Done faulting in new regions, elapsed time " + TestHelper.millisToString(duration) + ", all regions: " + TestHelper.regionsToString(rootRegion, false));
        return numCreated;
    }

    protected Object[] faultInRegion(Region parentRegion, String newRegionName, RegionAttributes attr) {
        boolean verbose = false;
        try {
            Region newRegion;
            if (verbose) {
                String s = "In faultInRegion: Attempting to get or create " + newRegionName + " as a subregion of " + TestHelper.regionToString(parentRegion, false);
                Log.getLogWriter().info(s);
            }
            if ((newRegion = CacheUtil.getCache().getRegion(parentRegion.getFullPath() + "/" + newRegionName)) == null) {
                boolean newRegionIsPartitioned = newRegionName.startsWith(PR_NAME_PREFIX);
                if (newRegionIsPartitioned) {
                    AttributesFactory factory = new AttributesFactory(attr);
                    Object[] tmp = this.getPartitionAttributes();
                    DataPolicy dp = (DataPolicy)tmp[0];
                    PartitionAttributes prAttr = (PartitionAttributes)tmp[1];
                    factory.setDataPolicy(dp);
                    factory.setPartitionAttributes(prAttr);
                    factory.setEntryIdleTimeout(new ExpirationAttributes(0));
                    factory.setEntryTimeToLive(new ExpirationAttributes(0));
                    attr = factory.createRegionAttributes();
                }
                if (verbose) {
                    Log.getLogWriter().info("In faultInRegion: Creating " + newRegionName + " with attributes " + TestHelper.regionAttributesToString(attr));
                }
                newRegion = parentRegion.createSubregion(newRegionName, attr);
                if (verbose) {
                    Log.getLogWriter().info("In faultInRegion: Created " + TestHelper.regionToString(newRegion, false));
                }
            } else if (verbose) {
                Log.getLogWriter().info("In faultInRegion: Got " + TestHelper.regionToString(newRegion, false));
            }
            return new Object[]{newRegion, "Faulted in new region " + TestHelper.regionToString(newRegion, false) + "\n", new Boolean(true)};
        }
        catch (RegionExistsException e) {
            if (verbose) {
                String s = "In faultInRegion: Region " + newRegionName + " already exists as a subregion of " + TestHelper.regionToString(parentRegion, false) + "; continuing";
                Log.getLogWriter().info(s);
            }
            try {
                return new Object[]{parentRegion.getSubregion(newRegionName), "Region " + newRegionName + " already exists\n", new Boolean(false)};
            }
            catch (RegionDestroyedException anExcept) {
                if (!this.isCarefulValidation) {
                    if (verbose) {
                        String s = "In faultInRegion: Region " + newRegionName + " has been destroyed ; continuing";
                        Log.getLogWriter().info(s);
                    }
                    return new Object[]{null, "Region " + newRegionName + " has been destroyed\n", new Boolean(false)};
                }
                throw new TestException(TestHelper.getStackTrace(anExcept));
            }
        }
        catch (RegionDestroyedException e) {
            if (verbose) {
                Log.getLogWriter().info("In faultInRegion: Region " + newRegionName + " has been destroyed; continuing");
            }
            return new Object[]{null, "Region " + newRegionName + " has been destroyed\n", new Boolean(false)};
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    protected void checkEventCounters() {
        throw new TestException("checkEventCounters must be implemented in a subclass");
    }

    protected Object getObjectToAdd(String name) {
        ValueHolder anObj = new ValueHolder(name, this.randomValues);
        return anObj;
    }

    protected Object getUpdateObject(String name) {
        Region rootRegion = CacheUtil.getCache().getRegion(this.regionName);
        BaseValueHolder anObj = null;
        BaseValueHolder newObj = null;
        try {
            anObj = (BaseValueHolder)rootRegion.get((Object)name);
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        newObj = anObj == null ? new ValueHolder(name, this.randomValues) : anObj.getAlternateValueHolder(this.randomValues);
        return newObj;
    }

    protected CacheListener getCacheListener() {
        this.listenerInstalled = true;
        return new ETListener(this.isCarefulValidation);
    }

    protected Object[] getPartitionAttributes() {
        return null;
    }

    protected int getNumVMsWithListeners() {
        throw new TestException("getNumVMsWithListeners must be implemented in a subclass");
    }

    protected void createRootRegions() {
        MirrorType mt;
        RegionDefinition regDef = RegionDefinition.createRegionDefinition();
        this.regionName = regDef.getRegionName();
        List listeners = regDef.getCacheListeners();
        if (listeners != null && listeners.size() == 0) {
            CacheListener listener = eventTest.getCacheListener();
            regDef.addCacheListener(listener.getClass().getName());
        }
        String key = VmIDStr + RemoteTestModule.getMyVmid();
        String xmlFile = key + ".xml";
        CacheDefinition cacheDef = CacheDefinition.createCacheDefinition(CacheDefPrms.cacheSpecs, "cache1");
        DeclarativeGenerator.createDeclarativeXml(key + ".xml", cacheDef, regDef, true);
        CacheUtil.createRegion(cacheDef, regDef, xmlFile);
        this.isMirrored = false;
        DataPolicy dataPolicy = regDef.getDataPolicy();
        this.isMirrored = dataPolicy == null ? ((mt = regDef.getMirroring()) == null ? false : mt.isMirrored()) : dataPolicy.withReplication();
    }

    public static void HydraTask_printBB() throws Throwable {
        CacheBB.getBB().print();
        EventBB.getBB().print();
        EventCountersBB.getBB().print();
        OperationCountersBB.getBB().print();
        WriterCountersBB.getBB().print();
        TestHelper.checkForEventError(EventBB.getBB());
    }

    public static void HydraTask_iterate() throws Throwable {
        RegionDefinition regDef = RegionDefinition.createRegionDefinition();
        regDef.setEntryIdleTimeoutSec(null);
        regDef.setEntryIdleTimeoutAction(null);
        regDef.setEntryTTLSec(null);
        regDef.setEntryTTLAction(null);
        regDef.createRootRegion(CacheUtil.createCache(), regDef.getRegionName(), null, null, null);
        CacheBB.getBB().print();
        EventBB.getBB().print();
        EventCountersBB.getBB().print();
        OperationCountersBB.getBB().print();
        WriterCountersBB.getBB().print();
        TestHelper.checkForEventError(EventBB.getBB());
    }

    public static void HydraTask_endTask() throws Throwable {
        TestHelper.checkForEventError(EventBB.getBB());
        CacheBB.getBB().print();
        EventBB.getBB().print();
        EventCountersBB.getBB().print();
        OperationCountersBB.getBB().print();
        WriterCountersBB.getBB().print();
        eventTest = new EventTest();
        eventTest.initialize();
        StringBuffer errStr = new StringBuffer();
        try {
            eventTest.checkEventCounters();
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Throwable e) {
            Log.getLogWriter().info(e.toString());
            errStr.append(e.toString());
        }
        if (errStr.length() > 0) {
            throw new TestException(errStr.toString());
        }
        TestHelper.checkForEventError(EventBB.getBB());
    }

    protected Object[] iterateRegion(Region aRegion, boolean allowZeroKeys, boolean allowZeroNonNullValues) {
        StringBuffer errStr = new StringBuffer();
        Set keys = aRegion.keys();
        Log.getLogWriter().info("For " + TestHelper.regionToString(aRegion, false) + ", found " + keys.size() + " keys");
        int numKeys = keys.size();
        if (numKeys == 0 && !allowZeroKeys) {
            errStr.append("Region " + TestHelper.regionToString(aRegion, false) + " has " + numKeys + " keys\n");
        }
        int valueCount = 0;
        for (Object key : keys) {
            String valueHolderValue;
            Object value;
            try {
                value = aRegion.get(key);
            }
            catch (CacheLoaderException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (TimeoutException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            Log.getLogWriter().info("Checking key " + key + ", value " + value);
            if (value == null) continue;
            ++valueCount;
            BaseValueHolder vh = (BaseValueHolder)value;
            String nameValue = "" + NameFactory.getCounterForName(key);
            if (nameValue.equals(valueHolderValue = "" + vh.myValue)) continue;
            String aStr = "Expected counter of key/value to match, key: " + key + ", value: " + vh.toString();
            Log.getLogWriter().info(aStr);
            errStr.append(aStr + "\n");
        }
        if (valueCount == 0 && !allowZeroNonNullValues) {
            errStr.append("Region " + TestHelper.regionToString(aRegion, false) + " has " + valueCount + " non-null values\n");
        }
        return new Object[]{new Integer(numKeys), new Integer(valueCount), errStr.toString()};
    }

    protected int getOperation(Long whichPrm, boolean disallowLocalEntryOps) {
        long limit = 60000L;
        long startTime = System.currentTimeMillis();
        int op = 0;
        do {
            String operation;
            if ((operation = TestConfig.tab().stringAt(whichPrm)).equals("add")) {
                op = 1;
            } else if (operation.equals("update")) {
                op = 2;
            } else if (operation.equals("invalidate")) {
                op = 3;
            } else if (operation.equals("destroy")) {
                op = 4;
            } else if (operation.equals("read")) {
                op = 5;
            } else if (operation.equals("localInvalidate")) {
                op = 6;
            } else if (operation.equals("localDestroy")) {
                op = 7;
            } else if (operation.equals("close")) {
                op = 8;
            } else if (operation.equals("clear")) {
                op = 9;
            } else if (operation.equals("putIfAbsent")) {
                op = 10;
            } else if (operation.equals("remove")) {
                op = 11;
            } else if (operation.equals("replace")) {
                op = 12;
            } else if (operation.equals("putAll")) {
                op = 13;
            } else {
                throw new TestException("Unknown entry operation: " + operation);
            }
            if (System.currentTimeMillis() - startTime <= limit) continue;
            throw new TestException("Could not find an operation in " + limit + " millis; disallowLocalEntryOps is " + true + "; check that the operations list has allowable choices");
        } while (disallowLocalEntryOps && (op == 6 || op == 7));
        return op;
    }

    protected static void logExecutionNumber() {
        long exeNum = EventBB.getBB().getSharedCounters().incrementAndRead(EventBB.EXECUTION_NUMBER);
        Log.getLogWriter().info("Beginning task with execution number " + exeNum);
    }

    protected void writeMyRegionNames() {
        this.writeMyRegionNames(null);
    }

    protected void writeMyRegionNames(Region excludeRegion) {
        String excludeRegionName = "";
        if (excludeRegion != null) {
            excludeRegionName = TestHelper.regionToString(excludeRegion, false);
        }
        Region rootRegion = CacheUtil.getCache().getRegion(this.regionName);
        Log.getLogWriter().info("In writeMyRegionNames: getting regions to write...");
        StringBuffer logStr = new StringBuffer();
        Set regionSet = rootRegion.subregions(true);
        Iterator it = regionSet.iterator();
        ArrayList<String> aList = new ArrayList<String>();
        while (it.hasNext()) {
            Region aRegion = (Region)it.next();
            String regionName = aRegion.getFullPath();
            if (regionName.equals(excludeRegionName)) continue;
            aList.add(regionName);
            logStr.append("   " + TestHelper.regionToString(aRegion, false) + "\n");
        }
        logStr.insert(0, "In writeMyRegionNames: writing " + aList.size() + " regions to blackboard with name " + EventBB.CURRENT_REGION_NAMES + "\n");
        Log.getLogWriter().info(logStr.toString());
        long start = System.currentTimeMillis();
        EventBB.getBB().getSharedMap().put(EventBB.CURRENT_REGION_NAMES, aList);
        long end = System.currentTimeMillis();
        long duration = end - start;
        EventBB.getBB().getSharedCounters().setIfLarger(EventBB.MAX_WRITE_CURR_REGION_NAMES_MILLIS, duration);
        EventBB.getBB().getSharedCounters().setIfLarger(EventBB.MAX_NUM_WRITE_CURR_REGION_NAMES, aList.size());
        Log.getLogWriter().info("In writeMyRegionNames: time to write " + aList.size() + " region names is " + TestHelper.millisToString(end - start));
    }

    protected Region getRandomRegion(boolean allowRootRegion) {
        Set rootRegions = CacheUtil.getCache().rootRegions();
        int randInt = TestConfig.tab().getRandGen().nextInt(0, rootRegions.size() - 1);
        Object[] regionList = rootRegions.toArray();
        Region rootRegion = (Region)regionList[randInt];
        Set subregionsSet = rootRegion.subregions(true);
        if (subregionsSet.size() == 0) {
            if (allowRootRegion) {
                return rootRegion;
            }
            return null;
        }
        ArrayList<Object> aList = null;
        try {
            Object[] array = subregionsSet.toArray();
            aList = new ArrayList<Object>(array.length);
            for (int i = 0; i < array.length; ++i) {
                aList.add(array[i]);
            }
        }
        catch (NoSuchElementException e) {
            throw new TestException("Bug 30171 detected: " + TestHelper.getStackTrace(e));
        }
        if (allowRootRegion) {
            aList.add(rootRegion);
        }
        if (aList.size() == 0) {
            return null;
        }
        randInt = TestConfig.tab().getRandGen().nextInt(0, aList.size() - 1);
        Region aRegion = (Region)aList.get(randInt);
        if (aRegion == null) {
            throw new TestException("Bug 30171 detected: aRegion is null");
        }
        return aRegion;
    }

    protected void handleRegionDestroyedException(Region aRegion, RegionDestroyedException anException) {
        if (this.isCarefulValidation) {
            throw new TestException(TestHelper.getStackTrace(anException));
        }
        if (!anException.getRegionFullPath().equals(aRegion.getFullPath())) {
            TestException te = new TestException("Got a RegionDestroyedException when operating on region " + TestHelper.regionToString(aRegion, false) + ", but the region destroyed is '" + anException.getRegionFullPath() + "'");
            te.initCause(anException);
            throw te;
        }
        boolean isDestroyed = aRegion.isDestroyed();
        if (!isDestroyed) {
            throw new TestException("Bug 30645 or 34383 (likely): isDestroyed returned " + isDestroyed + " for region " + TestHelper.regionToString(aRegion, false) + ", but a region destroyed exception was thrown: " + TestHelper.getStackTrace(anException));
        }
        Log.getLogWriter().info("Got " + RegionDestroyedException.class.getName() + " on " + TestHelper.regionToString(aRegion, false) + "; exception expected, continuing test");
    }

    protected int getNumNames(Region aRegion, boolean hasValueOnly) {
        int count = 0;
        StringBuffer aStr = new StringBuffer();
        aStr.append("Names in " + TestHelper.regionToString(aRegion, false) + " and its subregions:\n");
        HashSet<Region> aSet = new HashSet<Region>(aRegion.subregions(true));
        aSet.add(aRegion);
        for (Region thisRegion : aSet) {
            for (Object key : thisRegion.keys()) {
                boolean containsValue = thisRegion.containsValueForKey(key);
                if (!hasValueOnly || hasValueOnly && containsValue) {
                    ++count;
                }
                aStr.append("   " + key + " in " + TestHelper.regionToString(thisRegion, false) + " (containsValueForKey: " + containsValue + ")\n");
            }
        }
        Log.getLogWriter().info(aStr.toString());
        return count;
    }

    protected long getNumNonRootRegions() {
        Set rootRegions = CacheUtil.getCache().rootRegions();
        long numRegions = 0L;
        for (Region aRegion : rootRegions) {
            numRegions += (long)aRegion.subregions(true).size();
        }
        Log.getLogWriter().info("Num non-root regions is " + numRegions + ", num root region is " + rootRegions.size());
        return numRegions;
    }

    protected void verifyObjectInvalidated(Region aRegion, Object key) {
        boolean containsValueForKey;
        StringBuffer errStr = new StringBuffer();
        boolean containsKey = aRegion.containsKey(key);
        if (!containsKey) {
            errStr.append("Unexpected containsKey " + containsKey + " for key " + key + " in region " + TestHelper.regionToString(aRegion, false) + "\n");
        }
        if (containsValueForKey = aRegion.containsValueForKey(key)) {
            errStr.append("Unexpected containsValueForKey " + containsValueForKey + " for key " + key + " in region " + TestHelper.regionToString(aRegion, false) + "\n");
        }
        if (aRegion.getAttributes().getPartitionAttributes() == null) {
            Object entryValue;
            Object entryKey;
            Region.Entry entry = aRegion.getEntry(key);
            if (entry == null) {
                errStr.append("getEntry for key " + key + " in region " + TestHelper.regionToString(aRegion, false) + " returned null\n");
            }
            if (!(entryKey = entry.getKey()).equals(key)) {
                errStr.append("getEntry.getKey() " + entryKey + " does not equal key " + key + " in region " + TestHelper.regionToString(aRegion, false) + "\n");
            }
            if ((entryValue = entry.getValue()) != null) {
                errStr.append("Expected getEntry.getValue() " + TestHelper.toString(entryValue) + " to be null.\n");
            }
            if (errStr.length() > 0) {
                throw new TestException(errStr.toString());
            }
        }
    }

    protected void verifyObjectDestroyed(Region aRegion, Object key) {
        boolean containsValueForKey;
        StringBuffer errStr = new StringBuffer();
        boolean containsKey = aRegion.containsKey(key);
        if (containsKey) {
            errStr.append("Unexpected containsKey " + containsKey + " for key " + key + " in region " + TestHelper.regionToString(aRegion, false) + "\n");
        }
        if (containsValueForKey = aRegion.containsValueForKey(key)) {
            errStr.append("Unexpected containsValueForKey " + containsValueForKey + " for key " + key + " in region " + TestHelper.regionToString(aRegion, false) + "\n");
        }
        if (aRegion.getAttributes().getPartitionAttributes() != null) {
            Region.Entry entry = aRegion.getEntry(key);
            if (entry != null) {
                errStr.append("getEntry for key " + key + " in region " + TestHelper.regionToString(aRegion, false) + " returned was non-null; getKey is " + entry.getKey() + ", value is " + TestHelper.toString(entry.getValue()) + "\n");
            }
            if (errStr.length() > 0) {
                throw new TestException(errStr.toString());
            }
        }
    }

    static {
        LOCK_SERVICE_NAME = "MyLockService";
        LOCK_NAME = "MyLock";
    }
}

